/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.JinxPriority;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.util.log.LogSupport;

public class PacketHistory {
    private HistoryEntry[] history;
    private int size;
    private int oldest = -1;
    private int latest = -1;

    public PacketHistory() {
        this(64);
    }

    public PacketHistory(int size) {
        this.size = size;
        this.history = new HistoryEntry[size];
        int i = 0;
        while (i < size) {
            this.history[i++] = new HistoryEntry();
        }
    }

    public void add(PacketEvent e, byte id, short left, byte chnl, byte cmd) {
        this.add(e.getSourceAddress(), e.getDestinationAddress(), e.getGroupID(), e.getPriority(), e.getContent().getSize(), id, left, chnl, cmd);
    }

    public void add(short from, short to, short grp, byte pri, int len, byte id, short left, byte chnl, byte cmd) {
        if (++this.latest == this.size) {
            this.latest = 0;
        }
        this.history[this.latest].set(from, to, grp, pri, len, id, left, chnl, cmd);
        if (this.latest == this.oldest) {
            if (++this.oldest == this.size) {
                this.oldest = 0;
            }
        } else if (this.oldest < 0) {
            this.oldest = this.latest;
        }
    }

    public void dump() {
        if (this.latest < 0) {
            return;
        }
        if (this.latest < this.oldest) {
            int i;
            for (i = this.oldest; i < this.size; ++i) {
                LogSupport.message((String)("    " + this.history[i]));
            }
            for (i = 0; i <= this.latest; ++i) {
                LogSupport.message((String)("    " + this.history[i]));
            }
        } else {
            for (int i = this.oldest; i <= this.latest; ++i) {
                LogSupport.message((String)("    " + this.history[i]));
            }
        }
    }

    static class HistoryEntry {
        public short from;
        public short to;
        public short grp;
        public byte pri;
        public int len;
        public byte id;
        public short left;
        public byte chnl;
        public byte cmd;

        HistoryEntry() {
        }

        public void set(short from, short to, short grp, byte pri, int len, byte id, short left, byte chnl, byte cmd) {
            this.from = from;
            this.to = to;
            this.grp = grp;
            this.pri = pri;
            this.len = len;
            this.id = id;
            this.left = left;
            this.chnl = chnl;
            this.cmd = cmd;
        }

        public String toString() {
            return this.from + "->" + this.to + "(" + JinxPriority.getPriorityName(this.pri) + "," + this.grp + ")[" + this.id + "/" + this.left + "] channel " + this.chnl + ", cmd " + this.cmd + ", " + this.len + " bytes";
        }
    }
}

