/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.JinxProtocolChnl;
import com.elluminate.jinx.NotableEventEvent;
import com.elluminate.jinx.NotableEventListener;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DefaultProtocolResponder
implements ProtocolResponder {
    private JinxProtocol protocol = null;
    private String cName = null;
    protected Connection connection;
    protected LinkedList<Channel> channels = new LinkedList();
    private ChannelListener chnListener = null;
    private ChannelDataListener dataListener = null;
    private List<NotableEventListener> notableListeners = null;
    private Object listenerLock = new Object();

    public DefaultProtocolResponder(JinxProtocol proto) {
        this.protocol = proto;
    }

    public DefaultProtocolResponder(String channelName) {
        this.cName = channelName;
    }

    protected ClientList getClientList() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getClientList();
    }

    protected void setChannelListener(ChannelListener lst) {
        this.chnListener = lst;
    }

    protected void setChannelDataListener(ChannelDataListener lst) {
        this.dataListener = lst;
    }

    @Override
    public void join(Connection connection, String channel) {
        this.connection = connection;
        if (this.cName != null) {
            try {
                Channel chnl = connection.acquireChannel(this.cName, (byte)2, this.chnListener, this.dataListener);
                this.channels.add(chnl);
            }
            catch (JinxChannelException ex) {
                LogSupport.exception((Object)this, (String)"join", (Throwable)ex, (boolean)true);
            }
        } else if (this.protocol != null) {
            for (JinxProtocolChnl info : this.protocol.getChannels()) {
                try {
                    Channel chnl = connection.acquireChannel(info.getName(), info.getPriority(), this.chnListener, this.dataListener);
                    this.channels.add(chnl);
                    chnl.setProtocol(this.protocol);
                }
                catch (JinxChannelException ex) {
                    LogSupport.exception((Object)this, (String)"join", (Throwable)ex, (boolean)true);
                }
            }
        }
    }

    @Override
    public void leave(String channel) {
        for (Channel chnl : this.channels) {
            this.connection.releaseChannel(chnl);
        }
        this.channels.clear();
    }

    public Channel getChannel(String cName) {
        if (cName == null) {
            return null;
        }
        for (Channel chnl : this.channels) {
            if (!cName.equals(chnl.getName())) continue;
            return chnl;
        }
        return null;
    }

    public Channel getChannel() {
        if (this.channels.isEmpty()) {
            return null;
        }
        return this.channels.getFirst();
    }

    public void sendDataOnChannel(String cName, ChannelDataEvent data) {
        Channel chnl = this.getChannel(cName);
        if (chnl == null) {
            throw new IllegalArgumentException("Channel not found: " + cName);
        }
        chnl.onChannelData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotableEventListener(NotableEventListener l) {
        if (l == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<NotableEventListener> neoList;
            if (this.notableListeners != null) {
                if (this.notableListeners.contains(l)) {
                    return;
                }
                neoList = new ArrayList(this.notableListeners.size() + 1);
                neoList.addAll(this.notableListeners);
            } else {
                neoList = new ArrayList<NotableEventListener>();
            }
            neoList.add(l);
            this.notableListeners = neoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotableEventListener(NotableEventListener l) {
        if (l == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.notableListeners != null) {
                if (!this.notableListeners.contains(l)) {
                    return;
                }
                ArrayList<NotableEventListener> neoList = new ArrayList<NotableEventListener>(this.notableListeners);
                neoList.remove(l);
                this.notableListeners = neoList;
            }
        }
    }

    protected void fireNotableEventListeners(String category, Object data) {
        this.fireNotableEventListeners(this, category, data);
    }

    protected void fireNotableEventListeners(Object src, String category, Object data) {
        NotableEventEvent ev = null;
        List<NotableEventListener> listeners = this.notableListeners;
        if (listeners == null) {
            return;
        }
        for (NotableEventListener nel : listeners) {
            try {
                if (ev == null) {
                    ev = new NotableEventEvent(src, category, data);
                }
                nel.takeNote(ev);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireNotableEventListeners", (Throwable)t, (boolean)true);
            }
        }
    }
}

