/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.MessageListener;
import com.elluminate.jinx.Transceiver;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;

public abstract class Connector
implements MessageListener {
    private Map<Byte, MessageListener> mListener = new HashMap<Byte, MessageListener>();
    private List<ConnectionListener> cListener = new ArrayList<ConnectionListener>();
    private Object connectionLock = new Object();

    public abstract void disconnect();

    public abstract short getAddress();

    public abstract short getGroupID();

    public abstract void setGroupID(short var1);

    public abstract String getName();

    public abstract long getConnectedMillis();

    public abstract boolean isEnabled();

    public Object getMessageLock() {
        return this.mListener;
    }

    public int getMaxXmitSpeed() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(byte channel, MessageListener lst) throws TooManyListenersException {
        Byte key = Bytes.get(channel);
        Map<Byte, MessageListener> map = this.mListener;
        synchronized (map) {
            if (this.mListener.containsKey(key)) {
                throw new TooManyListenersException("Only one message listener per channel for a Connector: " + channel + ", name: " + this.getName() + ", address: " + this.getAddress());
            }
            this.mListener.put(key, lst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(byte channel, MessageListener lst) {
        Byte key = Bytes.get(channel);
        Map<Byte, MessageListener> map = this.mListener;
        synchronized (map) {
            if (this.mListener.containsKey(key)) {
                this.mListener.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOnMessage(MessageEvent message) {
        Byte key = Bytes.get(message.getChannel());
        if (DebugFlags.MESSAGES.show()) {
            LogSupport.message((String)("Recv chnl=" + key + ", from=" + message.getSourceAddress() + ", size=" + message.getContent().getSize() + ", cmd=" + message.getCommand()));
        }
        Map<Byte, MessageListener> map = this.mListener;
        synchronized (map) {
            MessageListener lst = this.mListener.get(key);
            if (lst != null) {
                try {
                    long delta = System.currentTimeMillis();
                    lst.onMessage(message);
                    if (DebugFlags.DELAYS.show() && (delta = System.currentTimeMillis() - delta) > 100L) {
                        LogSupport.error((String)(lst + " took " + delta + "ms to process " + message));
                    }
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"fireOnMessage", (Throwable)t, (boolean)true, (String)("sending " + message.toString()));
                }
            }
            message.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOnTranmitStatus(TransmitStatusEvent event) {
        Byte key = Bytes.get(event.getChannel());
        Map<Byte, MessageListener> map = this.mListener;
        synchronized (map) {
            MessageListener lst = this.mListener.get(key);
            if (lst != null) {
                try {
                    lst.onTransmitStatus(event);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"fireOnTransmitStatus", (Throwable)ex, (boolean)true);
                }
            }
        }
    }

    @Override
    public abstract void onMessage(MessageEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener lst) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (!this.cListener.contains(lst)) {
                ArrayList<ConnectionListener> copy = new ArrayList<ConnectionListener>(this.cListener);
                copy.add(lst);
                this.cListener = copy;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener lst) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.cListener.contains(lst)) {
                ArrayList<ConnectionListener> copy = new ArrayList<ConnectionListener>(this.cListener);
                copy.remove(lst);
                this.cListener = copy;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireConnectionStatusChanged(short addr, String name, byte what, byte prev, byte why, Transceiver tx) {
        ConnectionEvent e = new ConnectionEvent(this, addr, name, what, prev, why, tx);
        Map<Byte, MessageListener> map = this.mListener;
        synchronized (map) {
            for (ConnectionListener l : this.cListener) {
                try {
                    l.connectionStatusChanged(e);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"fireConnectionStatusChanged", (Throwable)ex, (boolean)true);
                }
            }
        }
    }
}

