/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;

public class ConnectionClass {
    public static final ConnectionClass DIALUP_28K;
    public static final ConnectionClass DIALUP_33K;
    public static final ConnectionClass DIALUP_56K;
    public static final ConnectionClass ISDN;
    public static final ConnectionClass WIRELESS;
    public static final ConnectionClass BROADBAND;
    public static final ConnectionClass LAN;
    public static final ConnectionClass[] values;
    private String name;
    private String menu;
    private int xmit;
    private int recv;
    private int base;

    private ConnectionClass(String name, int xmit, int recv, int base) {
        this.name = this.stripMnemonic(name);
        this.menu = name;
        this.xmit = xmit;
        this.recv = recv;
        this.base = base;
    }

    public int getRecvBandwidth() {
        return this.recv;
    }

    public int getXmitBandwidth() {
        return this.xmit;
    }

    public int getBaseBandwidth() {
        return this.base;
    }

    public String toString() {
        return this.name;
    }

    public String getMenuText() {
        return this.menu;
    }

    public static ConnectionClass getConnectionClass(String name) {
        return ConnectionClass.getConnectionClass(name, false);
    }

    public static ConnectionClass getConnectionClass(String name, boolean server) {
        try {
            int base = Integer.parseInt(name);
            if (server) {
                return ConnectionClass.getServerConnectionClass(base);
            }
            return ConnectionClass.getConnectionClass(base);
        }
        catch (NumberFormatException ex) {
            for (int i = 0; i < values.length; ++i) {
                if (!name.equals(values[i].toString())) continue;
                return values[i];
            }
            return null;
        }
    }

    public static ConnectionClass getConnectionClass(int base) {
        for (int i = 0; i < values.length; ++i) {
            int dLower;
            if (base > values[i].getBaseBandwidth()) continue;
            if (i == 0) {
                return values[i];
            }
            int dUpper = values[i].getBaseBandwidth() - base;
            if (dUpper < (dLower = base - values[i - 1].getBaseBandwidth())) {
                return values[i];
            }
            return values[i - 1];
        }
        return values[values.length - 1];
    }

    public static ConnectionClass getServerConnectionClass(int base) {
        return new ConnectionClass("" + base, base, base, base);
    }

    private String stripMnemonic(String str) {
        StringBuffer buf = null;
        int idx = 0;
        int last = 0;
        while ((idx = str.indexOf(38, last)) >= 0) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(str.substring(last, idx));
            last = idx + 1;
        }
        if (buf == null) {
            return str;
        }
        buf.append(str.substring(last));
        return buf.toString();
    }

    static {
        values = new ConnectionClass[7];
        I18n i18n = I18n.create((Object)new Object(){});
        DIALUP_28K = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_DIALUP28_8), 25000, 25000, 28800);
        DIALUP_33K = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_DIALUP33_6), 30000, 30000, 33600);
        DIALUP_56K = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_DIALUP56), 30000, 52000, 56000);
        ISDN = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_ISDN), 60000, 60000, 64000);
        WIRELESS = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_WIRELESS), 250000, 250000, 300000);
        BROADBAND = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_BROADBAND), 500000, 750000, 1000000);
        LAN = new ConnectionClass(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONCLASS_LAN), 2000000, 2000000, 10000000);
        ConnectionClass.values[0] = DIALUP_28K;
        ConnectionClass.values[1] = DIALUP_33K;
        ConnectionClass.values[2] = DIALUP_56K;
        ConnectionClass.values[3] = ISDN;
        ConnectionClass.values[4] = WIRELESS;
        ConnectionClass.values[5] = BROADBAND;
        ConnectionClass.values[6] = LAN;
    }
}

