/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelController;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientManager;
import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.Connector;
import com.elluminate.jinx.ControlProtocol;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.MessageListener;
import com.elluminate.jinx.NewChannelEvent;
import com.elluminate.jinx.NewChannelListener;
import com.elluminate.jinx.PropertyChangeSet;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;

public abstract class Connection
extends ControlProtocol
implements MessageListener,
ConnectionListener {
    protected Connector connector = null;
    private LinkedList<Channel> channels = new LinkedList();
    protected ClientList clients = new ClientList(this);
    protected ClientManager clientMgr = this.clients.getManager();
    List<ConnectionListener> cListeners = new ArrayList<ConnectionListener>();
    List<NewChannelListener> ncListeners = new ArrayList<NewChannelListener>();
    List<ClientGroupListener> grpListeners = new ArrayList<ClientGroupListener>();
    Object listenerLock = new Object();
    DebugFlag trace = DebugFlag.get((String)(DebugFlags.PROTOCOL.getName() + ".control"));
    ConferenceName cName = null;
    protected long sessionTimeBase;
    protected long connectionOffset;

    public Type getConnectionType() {
        return Type.OTHER;
    }

    public short getAddress() {
        if (this.connector == null) {
            return -32767;
        }
        return this.connector.getAddress();
    }

    public short getGroupID() {
        if (this.connector == null) {
            return -32767;
        }
        return this.connector.getGroupID();
    }

    public Object getMessageLock() {
        if (this.connector == null) {
            return this.trace;
        }
        return this.connector.getMessageLock();
    }

    public int getMaxXmitSpeed() {
        if (this.connector == null) {
            return 0;
        }
        return this.connector.getMaxXmitSpeed();
    }

    public boolean isConnected() {
        if (this.connector == null) {
            return false;
        }
        return this.connector.isEnabled();
    }

    public long getConnectedMillis() {
        if (this.connector == null) {
            return 0L;
        }
        return this.connector.getConnectedMillis();
    }

    public long getSessionTimeBase() {
        if (this.connector == null) {
            return 0L;
        }
        return this.sessionTimeBase;
    }

    public long getSessionTime() {
        if (this.connector == null) {
            return 0L;
        }
        return this.sessionTimeBase + this.connectionOffset + this.getConnectedMillis();
    }

    public ClientList getClientList() {
        return this.clients;
    }

    protected void setConferenceName(ConferenceName cName) {
        this.cName = cName;
    }

    public ConferenceName getConferenceName() {
        return this.cName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener lst) {
        Debug.lockEnter((Object)this, (String)"addConnectionListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.cListeners.contains(lst)) {
                ArrayList<ConnectionListener> copy = new ArrayList<ConnectionListener>(this.cListeners);
                copy.add(lst);
                this.cListeners = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"addConnectionListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener lst) {
        Debug.lockEnter((Object)this, (String)"removeConnectionListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ConnectionListener> copy = new ArrayList<ConnectionListener>(this.cListeners);
            copy.remove(lst);
            this.cListeners = copy;
        }
        Debug.lockLeave((Object)this, (String)"removeConnectionListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    protected void fireConnectionEvent(ConnectionEvent e) {
        for (ConnectionListener l : this.cListeners) {
            try {
                l.connectionStatusChanged(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireConnectionStatusChanged", (Throwable)ex, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewChannelListener(NewChannelListener lst) {
        boolean notify = false;
        Debug.lockEnter((Object)this, (String)"addNewChannelListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.ncListeners.contains(lst)) {
                ArrayList<NewChannelListener> copy = new ArrayList<NewChannelListener>(this.ncListeners);
                notify = copy.isEmpty();
                copy.add(lst);
                this.ncListeners = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"addNewChannelListener", (String)"listenerLock", (Object)this.listenerLock);
        if (notify) {
            this.setNewChannelNotify(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNewChannelListener(NewChannelListener lst) {
        boolean clear = false;
        Debug.lockEnter((Object)this, (String)"removeNewChannelListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<NewChannelListener> copy = new ArrayList<NewChannelListener>(this.ncListeners);
            boolean removed = copy.remove(lst);
            clear = removed && copy.isEmpty();
            this.ncListeners = copy;
        }
        Debug.lockLeave((Object)this, (String)"removeNewChannelListener", (String)"listenerLock", (Object)this.listenerLock);
        if (clear) {
            this.setNewChannelNotify(false);
        }
    }

    protected void fireNewChannelEvent(String chnl) {
        NewChannelEvent e = new NewChannelEvent(this, chnl);
        for (NewChannelListener l : this.ncListeners) {
            try {
                l.channelCreated(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireNewChannelEvent", (Throwable)ex, (boolean)true);
            }
        }
    }

    protected void setNewChannelNotify(boolean on) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientGroupListener(ClientGroupListener lst) {
        Debug.lockEnter((Object)this, (String)"addClientGroupListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.grpListeners.contains(lst)) {
                ArrayList<ClientGroupListener> copy = new ArrayList<ClientGroupListener>(this.grpListeners);
                copy.add(lst);
                this.grpListeners = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"addClientGroupListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientGroupListener(ClientGroupListener lst) {
        Debug.lockEnter((Object)this, (String)"removeClientGroupListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ClientGroupListener> copy = new ArrayList<ClientGroupListener>(this.grpListeners);
            copy.remove(lst);
            this.grpListeners = copy;
        }
        Debug.lockLeave((Object)this, (String)"removeClientGroupListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    void fireCreateGroup(ClientGroup grp) {
        ClientGroupEvent event = new ClientGroupEvent(this, grp);
        for (ClientGroupListener lst : this.grpListeners) {
            try {
                lst.clientGroupCreated(event);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireCreateGroup", (Throwable)t, (boolean)true);
            }
        }
    }

    void fireDeleteGroup(ClientGroup grp) {
        ClientGroupEvent event = new ClientGroupEvent(this, grp);
        for (ClientGroupListener lst : this.grpListeners) {
            try {
                lst.clientGroupDeleted(event);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireDeleteGroup", (Throwable)t, (boolean)true);
            }
        }
    }

    void fireRenameGroup(ClientGroup grp, String old) {
        ClientGroupEvent event = new ClientGroupEvent(this, grp, old);
        for (ClientGroupListener lst : this.grpListeners) {
            try {
                lst.clientGroupRenamed(event);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireRenameGroup", (Throwable)t, (boolean)true);
            }
        }
    }

    void fireJoinGroup(ClientInfo who, ClientGroup from, ClientGroup to) {
        ClientGroupEvent event = new ClientGroupEvent(this, who, from, to);
        for (ClientGroupListener lst : this.grpListeners) {
            try {
                lst.clientGroupChanged(event);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireJoinGroup", (Throwable)ex, (boolean)true);
            }
        }
    }

    protected void fireMessage(MessageEvent e) {
        try {
            if (this.isConnected()) {
                this.traceMessage("xmit", e);
                this.connector.onMessage(e);
            } else {
                e.dispose();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireMessage", (Throwable)ex, (boolean)true);
        }
    }

    protected void traceMessage(String prefix, MessageEvent e) {
        if (this.trace.show() || DebugFlags.PROTOCOL.show()) {
            String from;
            String to;
            ProtocolBuffer buf = e.getContent();
            DataInputStream str = buf.readPayload();
            short addr = e.getDestinationAddress();
            switch (addr) {
                case -1: {
                    to = " to All";
                    break;
                }
                case -2: {
                    to = " to Others";
                    break;
                }
                case 0: {
                    to = " to Server";
                    break;
                }
                default: {
                    to = " to " + addr;
                }
            }
            addr = e.getSourceAddress();
            switch (addr) {
                case -32767: {
                    from = "";
                    break;
                }
                case 0: {
                    from = " from Server";
                    break;
                }
                default: {
                    from = " from " + addr;
                }
            }
            LogSupport.message((Object)this, (String)"fireMessage", (String)(prefix + from + to + " on control: " + this.messageToString(e.getCommand(), str)));
            try {
                str.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel acquireChannel(String name, byte priority, ChannelListener cl, ChannelDataListener dl) throws JinxChannelException {
        Channel channel = this.findChannel(name);
        if (DebugFlags.CHANNELS.show()) {
            LogSupport.message((Object)this, (String)"acquireChannel", (String)("Acquiring channel " + name));
        }
        if (channel != null) {
            throw new JinxChannelException("Channel '" + name + "' already exists.");
        }
        channel = new Channel(name, priority, cl, dl, this);
        Debug.lockEnter((Object)this, (String)"acquireChannel", (String)"channels", this.channels);
        LinkedList<Channel> linkedList = this.channels;
        synchronized (linkedList) {
            this.channels.add(channel);
        }
        Debug.lockLeave((Object)this, (String)"acquireChannel", (String)"channels", this.channels);
        if (this.isConnected()) {
            try {
                this.activateChannel(channel);
            }
            catch (JinxChannelException ex) {
                this.removeChannel(channel);
                throw ex;
            }
        }
        return channel;
    }

    public void releaseChannel(Channel chnl) {
        if (DebugFlags.CHANNELS.show()) {
            LogSupport.message((Object)this, (String)"releaseChannel", (String)("Releasing channel " + chnl.getName()));
        }
        if (this.removeChannel(chnl)) {
            if (this.isConnected()) {
                this.deactivateChannel(chnl);
            }
            if (this.connector != null) {
                chnl.removeMessageListener(this.connector);
                if (chnl.getChannelID() > 0) {
                    this.connector.removeMessageListener(chnl.getChannelID(), chnl);
                }
            }
            chnl.getController().chnlLeave(this.getAddress());
            chnl.getController().chnlDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel findChannel(String name) {
        Channel chnl = null;
        Debug.lockEnter((Object)this, (String)"findChannel", (String)"channels", this.channels);
        LinkedList<Channel> linkedList = this.channels;
        synchronized (linkedList) {
            for (Channel cmp : this.channels) {
                if (!name.equals(cmp.getName())) continue;
                chnl = cmp;
                break;
            }
        }
        Debug.lockLeave((Object)this, (String)"findChannel", (String)"channels", this.channels);
        return chnl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel findChannel(short id) {
        Channel chnl = null;
        Debug.lockEnter((Object)this, (String)"findChannel", (String)"channels", this.channels);
        LinkedList<Channel> linkedList = this.channels;
        synchronized (linkedList) {
            for (Channel cmp : this.channels) {
                if (cmp.getChannelID() != id) continue;
                chnl = cmp;
                break;
            }
        }
        Debug.lockLeave((Object)this, (String)"findChannel", (String)"channels", this.channels);
        return chnl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeChannel(Channel chnl) {
        boolean removed;
        Debug.lockEnter((Object)this, (String)"removeChannel", (String)"channels", this.channels);
        LinkedList<Channel> linkedList = this.channels;
        synchronized (linkedList) {
            removed = this.channels.remove(chnl);
        }
        Debug.lockLeave((Object)this, (String)"removeChannel", (String)"channels", this.channels);
        return removed;
    }

    protected abstract void activateChannel(Channel var1) throws JinxChannelException;

    protected abstract void deactivateChannel(Channel var1);

    protected ChannelController getChannelController(Channel chnl) {
        return chnl.getController();
    }

    void activateAllChannels() throws JinxChannelException {
        for (Channel chnl : this.channels) {
            if (!this.isConnected() || chnl.isUp()) continue;
            this.activateChannel(chnl);
        }
    }

    protected void deactivateAllChannels() {
        boolean done = false;
        while (!done) {
            try {
                for (Channel chnl : this.channels) {
                    if (this.isConnected() && chnl.isUp()) {
                        this.deactivateChannel(chnl);
                    }
                    if (this.connector != null) {
                        chnl.removeMessageListener(this.connector);
                        if (chnl.getChannelID() > 0) {
                            this.connector.removeMessageListener(chnl.getChannelID(), chnl);
                        }
                    }
                    chnl.getController().chnlDown();
                }
                done = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    protected void encodePropertyDef(DataOutputStream str, String name, short id, byte scope, PropertyValue value) {
        try {
            str.writeShort(id);
            str.writeUTF(name);
            str.writeByte(scope);
            value.encode(str);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"encodePropertyDef", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendPropertyDef(DataOutputStream str, ProtocolBuffer buf, short to) {
        try {
            str.writeShort(-1);
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendPropertyDef", (Throwable)ex, (boolean)true);
        }
        this.fireMessage(MessageEvent.getInstance((Object)this, this.getAddress(), to, this.getGroupID(), (byte)1, (byte)0, (byte)33, buf));
    }

    protected boolean decodePropertyDef(DataInputStream str) {
        try {
            short id = str.readShort();
            if (id > 0) {
                String name = str.readUTF();
                byte scope = str.readByte();
                PropertyValue value = PropertyValue.decode(str);
                this.clients.onDefineProperty(name, id, scope, value);
                return true;
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"decodePropertyDef", (Throwable)ex, (boolean)true);
        }
        return false;
    }

    protected void encodeProperty(DataOutputStream str, byte scope, short which, short id, PropertyValue value) {
        try {
            str.writeShort(id);
            str.writeByte(scope);
            if (scope != 1) {
                str.writeShort(which);
            }
            value.encode(str);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"encodeProperty", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendProperty(DataOutputStream str, ProtocolBuffer buf, short to) {
        try {
            str.writeShort(-1);
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendProperty", (Throwable)ex, (boolean)true);
        }
        this.fireMessage(MessageEvent.getInstance((Object)this, this.getAddress(), to, this.getGroupID(), (byte)1, (byte)0, (byte)34, buf));
    }

    public PropertyChangeSet getPropertyChangeSet() {
        return this.getPropertyChangeSet((short)0);
    }

    protected PropertyChangeSet getPropertyChangeSet(short addr) {
        return new PropertyChangeSet(this, addr);
    }

    protected boolean decodeProperty(PropertyChangeSet changeSet, short from, DataInputStream str) {
        try {
            short id = str.readShort();
            if (id > 0) {
                byte scope = str.readByte();
                short which = -32767;
                if (scope != 1) {
                    which = str.readShort();
                }
                PropertyValue value = PropertyValue.decode(str);
                switch (scope) {
                    case 1: {
                        this.clients.onSetProperty(changeSet, id, from, value);
                        break;
                    }
                    case 0: {
                        if (which == -1) {
                            this.clients.getManager().setDftClientProp(changeSet, id, from, value);
                            break;
                        }
                        ClientInfo ci = this.clients.get(which);
                        if (ci == null) break;
                        ci.onSetProperty(changeSet, id, from, value);
                        break;
                    }
                    case 2: {
                        if (which == -1) {
                            this.clients.getManager().setDftGroupProp(changeSet, id, from, value);
                            break;
                        }
                        ClientGroup cg = this.clients.getClientGroup(which);
                        if (cg == null) break;
                        cg.onSetProperty(changeSet, id, from, value);
                        break;
                    }
                    default: {
                        LogSupport.error((Object)this, (String)"decodeProperty", (String)("Invalid property scope - " + scope + ", id=" + id));
                        return false;
                    }
                }
                return true;
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"decodeSetProperty", (Throwable)ex, (boolean)true);
        }
        return false;
    }

    protected void resetProperties() {
        this.clients.resetProperties();
    }

    void setWatch(byte chnlID, boolean enable) {
        ProtocolBuffer buf = ProtocolBuffer.getInstance();
        DataOutputStream str = buf.addPayload();
        try {
            str.writeByte(chnlID);
            str.writeBoolean(enable);
            str.close();
            this.fireMessage(MessageEvent.getInstance((Object)this, this.getAddress(), (short)0, this.getGroupID(), (byte)1, (byte)0, (byte)8, buf));
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"setWatch", (Throwable)ex, (boolean)true);
        }
    }

    public static enum Type {
        ONLINE_CLIENT,
        PLAYBACK_CLIENT,
        GENERIC_CLIENT,
        SERVER,
        OTHER;

    }
}

