/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import java.util.HashMap;

public class ClientStats {
    private static final int TCP_OVERHEAD = 40;
    private long connectedTime = -1L;
    private long elapsed = -1L;
    private long bytesOut = 0L;
    private long bytesIn = 0L;
    private long bytesTcp = 0L;
    private long packetsOut = 0L;
    private long packetsIn = 0L;
    private long packetsTcp = 0L;
    private long prevElapsed = 0L;
    private long prevBytesOut = 0L;
    private long prevBytesIn = 0L;
    private long prevBytesTcp = 0L;
    private long prevPacketsOut = 0L;
    private long prevPacketsIn = 0L;
    private long prevPacketsTcp = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        ClientStats clientStats = this;
        synchronized (clientStats) {
            if (this.elapsed < 0L && this.connectedTime < 0L) {
                this.connectedTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ClientStats clientStats = this;
        synchronized (clientStats) {
            if (this.elapsed < 0L && this.connectedTime >= 0L) {
                this.elapsed = System.currentTimeMillis() - this.connectedTime;
                this.connectedTime = -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElapsedTime() {
        ClientStats clientStats = this;
        synchronized (clientStats) {
            if (this.elapsed >= 0L) {
                return this.elapsed;
            }
            return System.currentTimeMillis() - this.connectedTime;
        }
    }

    void read(int n) {
        this.bytesIn += (long)n;
        ++this.packetsIn;
    }

    void write(int n) {
        this.bytesOut += (long)n;
        ++this.packetsOut;
    }

    void send() {
        this.bytesTcp += 40L;
        ++this.packetsTcp;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesTcp() {
        return this.bytesTcp;
    }

    public long getPacketsOut() {
        return this.packetsOut;
    }

    public long getPacketsIn() {
        return this.packetsIn;
    }

    public long getPacketsTcp() {
        return this.packetsTcp;
    }

    public void accumulate(ClientStats child) {
        long t = child.getElapsedTime();
        long bo = child.bytesOut;
        long bi = child.bytesIn;
        long bt = child.bytesTcp;
        long po = child.packetsOut;
        long pi = child.packetsIn;
        long pt = child.packetsTcp;
        this.elapsed += t - child.prevElapsed;
        this.bytesIn += bi - child.prevBytesIn;
        this.bytesOut += bo - child.prevBytesOut;
        this.bytesTcp += bt - child.prevBytesTcp;
        this.packetsIn += pi - child.prevPacketsIn;
        this.packetsOut += po - child.prevPacketsOut;
        this.packetsTcp += pt - child.prevPacketsTcp;
        child.prevElapsed = t;
        child.prevBytesIn = bi;
        child.prevBytesOut = bo;
        child.prevBytesTcp = bt;
        child.prevPacketsIn = pi;
        child.prevPacketsOut = po;
        child.prevPacketsTcp = pt;
    }

    public String toString() {
        long elapsed = this.getElapsedTime() / 1000L;
        long kbIn = this.getBytesIn() / 1024L;
        long kbOut = this.getBytesOut() / 1024L;
        int h = (int)(elapsed / 3600L);
        int m = (int)(elapsed / 60L) % 60;
        int s = (int)(elapsed % 60L);
        String time = (h > 0 ? h + ":" : "") + m / 10 + m % 10 + ":" + s / 10 + s % 10;
        return "elapsed " + time + "  sent " + kbOut + "kb in " + this.getPacketsOut() + " packets,  recv " + kbIn + "kb in " + this.getPacketsIn() + " packets";
    }

    public void toArgs(HashMap<String, String> args) {
        args.put("elapsed", Long.toString(this.getElapsedTime() / 1000L));
        args.put("kbIn", Long.toString(this.getBytesIn() / 1024L));
        args.put("kbOut", Long.toString(this.getBytesOut() / 1024L));
        args.put("pktIn", Long.toString(this.getPacketsIn()));
        args.put("pktOut", Long.toString(this.getPacketsOut()));
    }
}

