/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.ClientManager;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.DefaultPropertyStore;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.PropertyAccessController;
import com.elluminate.jinx.PropertyChangeSet;
import com.elluminate.jinx.PropertyStore;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.Debug;
import com.elluminate.util.ShortList;
import com.elluminate.util.StringComparator;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ClientList
extends PropertyStore
implements Iterable<ClientInfo> {
    public static final short DEFAULT_OWNER = -1;
    private Comparator<String> comparator = new StringComparator(false, 1);
    private Connection connection = null;
    private TreeMap<String, ClientInfo> byName = new TreeMap(this.comparator);
    private HashMap<Short, ClientInfo> byAddr = new HashMap();
    private TreeMap<String, ClientInfo> visible = new TreeMap(this.comparator);
    private HashMap<String, String> display = new HashMap();
    private HashMap<String, String> revDisp = new HashMap();
    private ClientInfo me = null;
    private DefaultPropertyStore defaultClientProps;
    private DefaultPropertyStore defaultGroupProps;
    private HashMap<String, Byte> scopeMap = new HashMap();
    private HashMap<Short, ClientGroup> groups = new HashMap();
    private Object groupLock = new Object();
    private ArrayList<ClientListener> listeners = new ArrayList();
    private Object listenerLock = new Object();

    public ClientList() {
        super(new Connection(){

            @Override
            public void connectionStatusChanged(ConnectionEvent e) {
            }

            @Override
            public void onMessage(MessageEvent e) {
            }

            @Override
            public void onTransmitStatus(TransmitStatusEvent e) {
            }

            @Override
            public void deactivateChannel(Channel c) {
            }

            @Override
            public void activateChannel(Channel c) {
            }
        });
        this.connection = super.getConnection();
        this.defaultClientProps = new DefaultPropertyStore(this.connection, 0);
        this.defaultGroupProps = new DefaultPropertyStore(this.connection, 2);
    }

    public ClientList(Connection connection) {
        super(connection);
        this.connection = connection;
        this.defaultClientProps = new DefaultPropertyStore(connection, 0);
        this.defaultGroupProps = new DefaultPropertyStore(connection, 2);
    }

    public String toString() {
        return "ClientList: " + this.byName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(ClientListener lst) {
        Debug.lockEnter((Object)this, (String)"addClientListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ClientListener> newListeners = new ArrayList<ClientListener>(this.listeners);
            if (!newListeners.contains(lst)) {
                newListeners.add(lst);
                this.listeners = newListeners;
            }
        }
        Debug.lockLeave((Object)this, (String)"addClientListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(ClientListener lst) {
        Debug.lockEnter((Object)this, (String)"removeClientListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ClientListener> newListeners = new ArrayList<ClientListener>(this.listeners);
            if (newListeners.contains(lst)) {
                newListeners.remove(lst);
                this.listeners = newListeners;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeClientListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientListener[] getClientListeners() {
        ClientListener[] array = null;
        Object object = this.listenerLock;
        synchronized (object) {
            array = new ClientListener[this.listeners.size()];
            array = this.listeners.toArray(array);
        }
        return array;
    }

    void fireAddClient(ClientInfo who) {
        ClientEvent e = new ClientEvent(this, who.getAddress(), who.getName(), who.isMe());
        if (DebugFlags.CLIENTS.show()) {
            LogSupport.message((Object)this, (String)"fireAddClient", (String)("Adding " + e));
        }
        for (ClientListener lst : this.listeners) {
            try {
                lst.onAddClient(e);
            }
            catch (Exception ex) {
                LogSupport.message((Object)this, (String)"fireAddClient", (String)("In onAddClient from " + lst));
                LogSupport.exception((Object)this, (String)"fireAddClient", (Throwable)ex, (boolean)true);
            }
        }
    }

    void fireRemoveClient(ClientInfo who) {
        ClientEvent e = new ClientEvent(this, who.getAddress(), who.getName(), who.isMe());
        if (DebugFlags.CLIENTS.show()) {
            LogSupport.message((Object)this, (String)"fireRemoveClient", (String)("Removing " + e));
        }
        for (ClientListener lst : this.listeners) {
            try {
                lst.onRemoveClient(e);
            }
            catch (Exception ex) {
                LogSupport.message((Object)this, (String)"fireRemoveClient", (String)("In onRemoveClient from " + lst));
                LogSupport.exception((Object)this, (String)"fireRemoveClient", (Throwable)ex, (boolean)true);
            }
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    protected ClientManager getManager() {
        return new ClientManager(){

            @Override
            public void clientClear() {
                ClientList.this.clear();
            }

            @Override
            public void clientAdd(String nm, String disp, short addr, short grp) {
                ClientList.this.add(nm, disp, addr, grp);
            }

            @Override
            public void clientReserve(String nm, short addr, short grp) {
                ClientList.this.reserve(nm, null, addr, grp);
            }

            @Override
            public void clientCommit(short addr) {
                ClientList.this.commit(addr);
            }

            @Override
            public void clientRemove(short addr) {
                ClientList.this.remove(addr);
            }

            @Override
            public void groupCreate(short id, String nm, boolean tmp) {
                ClientList.this.createGroup(id, nm, tmp);
            }

            @Override
            public void groupDelete(short id) {
                ClientList.this.deleteGroup(id);
            }

            @Override
            public void groupRename(short id, String nm) {
                ClientList.this.renameGroup(id, nm);
            }

            @Override
            public void groupJoin(short id, short addr) {
                ClientList.this.joinGroup(id, addr);
            }

            @Override
            public void clientSendPropertyDefs(short addr) {
                ClientList.this.sendPropertyDefs(addr);
            }

            @Override
            public void clientSendProperties(short addr) {
                ClientList.this.sendProperties(addr);
            }

            @Override
            public void setDftClientProp(PropertyChangeSet cset, short id, short from, PropertyValue val) {
                ClientList.this.defaultClientProps.onSetProperty(cset, id, from, val);
            }

            @Override
            public void setDftGroupProp(PropertyChangeSet cset, short id, short from, PropertyValue val) {
                ClientList.this.defaultGroupProps.onSetProperty(cset, id, from, val);
            }
        };
    }

    public ClientGroup getClientGroup(short id) {
        ClientGroup grp = this.groups.get(ShortList.get((short)id));
        return grp;
    }

    public ClientGroup getClientGroup(String name) {
        if (name == null) {
            name = "";
        }
        for (ClientGroup grp : this.groups.values()) {
            if (!name.equals(grp.getName())) continue;
            return grp;
        }
        return null;
    }

    public Iterator<ClientGroup> groupIterator() {
        return this.groups.values().iterator();
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGroup(short id, String name, boolean isTransient) {
        ClientGroup newGrp = new ClientGroup(this.connection, id, name, isTransient);
        Debug.lockEnter((Object)this, (String)"createGroup", (String)"groupLock", (Object)this.groupLock);
        try {
            Object object = this.groupLock;
            synchronized (object) {
                Iterator<ClientGroup> i = this.groupIterator();
                while (i.hasNext()) {
                    ClientGroup grp = i.next();
                    if (id == grp.getGroupID()) {
                        throw new IllegalArgumentException("Client group id " + id + " already exists.");
                    }
                    if (!name.equals(grp.getName())) continue;
                    throw new IllegalArgumentException("Client group named '" + name + "' already exists.");
                }
                HashMap<Short, ClientGroup> newGroups = new HashMap<Short, ClientGroup>(this.groups);
                newGroups.put(ShortList.get((short)id), newGrp);
                this.groups = newGroups;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"createGroup", (String)"groupLock", (Object)this.groupLock);
        }
        this.connection.fireCreateGroup(newGrp);
        this.defaultGroupProps.copy(newGrp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGroup(short id) {
        ClientGroup grp = this.getClientGroup(id);
        if (grp != null) {
            for (ClientInfo ci : grp) {
                this.joinGroup((short)0, ci.getAddress());
            }
        }
        grp.resetProperties();
        this.connection.fireDeleteGroup(grp);
        Debug.lockEnter((Object)this, (String)"deleteGroup", (String)"groupLock", (Object)this.groupLock);
        Object object = this.groupLock;
        synchronized (object) {
            HashMap<Short, ClientGroup> groupsCopy = new HashMap<Short, ClientGroup>(this.groups);
            groupsCopy.remove(ShortList.get((short)id));
            this.groups = groupsCopy;
        }
        Debug.lockLeave((Object)this, (String)"deleteGroup", (String)"groupLock", (Object)this.groupLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameGroup(short id, String nm) {
        String old = null;
        ClientGroup grp = null;
        Debug.lockEnter((Object)this, (String)"renameGroup", (String)"groupLock", (Object)this.groupLock);
        try {
            Object object = this.groupLock;
            synchronized (object) {
                grp = this.groups.get(ShortList.get((short)id));
                if (grp == null) {
                    throw new IllegalArgumentException("Group " + id + " does not exist.");
                }
                old = grp.getName();
                for (ClientGroup cg : this.groups.values()) {
                    if (cg == grp || !nm.equals(cg.getName())) continue;
                    throw new IllegalArgumentException("Group '" + nm + "' already exists.");
                }
                grp.setName(nm);
            }
        }
        finally {
            Debug.lockEnter((Object)this, (String)"renameGroup", (String)"groupLock", (Object)this.groupLock);
        }
        this.connection.fireRenameGroup(grp, old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinGroup(short id, short addr) {
        ClientGroup prev;
        ClientGroup grp;
        ClientInfo ci = this.get(addr);
        if (ci == null) {
            return;
        }
        if (ci.getGroupID() == id) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"joinGroup", (String)"groupLock", (Object)this.groupLock);
        Object object = this.groupLock;
        synchronized (object) {
            grp = this.getClientGroup(id);
            prev = this.getClientGroup(ci.getGroupID());
            ci.setGroupID(id);
        }
        Debug.lockLeave((Object)this, (String)"joinGroup", (String)"groupLock", (Object)this.groupLock);
        this.connection.fireJoinGroup(ci, prev, grp);
    }

    private void add(String name, String disp, short addr, short grp) {
        this.reserve(name, disp, addr, grp);
        this.commit(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserve(String name, String disp, short addr, short grp) {
        boolean isMe = false;
        if (DebugFlags.CLIENTS.show()) {
            LogSupport.message((Object)this, (String)"reserve", (String)("Reserving " + name + " on client list"));
        }
        if (addr == this.connection.getAddress()) {
            isMe = true;
        }
        ClientInfo info = new ClientInfo(this.connection, name, addr, isMe);
        info.setGroupID(grp);
        if (disp != null) {
            info.setDisplayName(disp);
        } else if (this.display.containsKey(name)) {
            info.setDisplayName(this.display.get(name));
        }
        Debug.lockEnter((Object)this, (String)"reserve", null, (Object)this);
        ClientList clientList = this;
        synchronized (clientList) {
            HashMap<Short, ClientInfo> byAddrCopy;
            TreeMap<String, ClientInfo> byNameCopy;
            if (isMe) {
                this.me = info;
            }
            HashMap<Short, ClientInfo> hashMap = this.byAddr;
            synchronized (hashMap) {
                byNameCopy = new TreeMap<String, ClientInfo>((SortedMap<String, ClientInfo>)this.byName);
                byAddrCopy = new HashMap<Short, ClientInfo>(this.byAddr);
            }
            byNameCopy.put(name, info);
            byAddrCopy.put(ShortList.get((short)addr), info);
            this.byName = byNameCopy;
            this.byAddr = byAddrCopy;
            if (info.isVisible()) {
                TreeMap<String, ClientInfo> visibleCopy;
                HashMap<Short, ClientInfo> hashMap2 = this.byAddr;
                synchronized (hashMap2) {
                    visibleCopy = new TreeMap<String, ClientInfo>((SortedMap<String, ClientInfo>)this.visible);
                }
                if (disp == null) {
                    String check;
                    String base = info.getDisplayName();
                    int index = 1;
                    disp = base;
                    while ((check = this.revDisp.get(disp)) != null && !check.equals(name)) {
                        disp = base + " #" + ++index;
                        info.setDisplayName(disp);
                    }
                }
                this.display.put(name, disp);
                this.revDisp.put(disp, name);
                visibleCopy.put(disp, info);
                this.visible = visibleCopy;
            }
            info.setState((byte)1);
        }
        Debug.lockLeave((Object)this, (String)"reserve", null, (Object)this);
    }

    private void commit(short addr) {
        ClientInfo ci = this.get(addr);
        if (ci == null) {
            return;
        }
        if (DebugFlags.CLIENTS.show()) {
            LogSupport.message((Object)this, (String)"commit", (String)("Committing " + ci.getName() + " on client list"));
        }
        if (ci.getState() != 1) {
            throw new IllegalStateException("Commit of client " + ci.getName() + " when not in the Reserved state.");
        }
        ci.setState((byte)2);
        this.fireAddClient(ci);
        this.defaultClientProps.copy(ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(short addr) {
        ClientInfo ci = this.get(addr);
        if (ci == null) {
            return;
        }
        String name = ci.getName();
        String vName = ci.getDisplayName();
        if (DebugFlags.CLIENTS.show()) {
            LogSupport.message((Object)this, (String)"remove", (String)("Removing " + name + " from client list."));
        }
        if (this.me == ci) {
            this.clear();
        } else {
            if (ci.getState() == 2) {
                ci.resetProperties();
                this.fireRemoveClient(ci);
            }
            ci.setGroupID((short)-32767);
            Debug.lockEnter((Object)this, (String)"remove", null, (Object)this);
            HashMap<Short, ClientInfo> hashMap = this.byAddr;
            synchronized (hashMap) {
                TreeMap<String, ClientInfo> byNameCopy = new TreeMap<String, ClientInfo>((SortedMap<String, ClientInfo>)this.byName);
                HashMap<Short, ClientInfo> byAddrCopy = new HashMap<Short, ClientInfo>(this.byAddr);
                TreeMap<String, ClientInfo> visibleCopy = new TreeMap<String, ClientInfo>((SortedMap<String, ClientInfo>)this.visible);
                byNameCopy.remove(name);
                byAddrCopy.remove(ShortList.get((short)ci.getAddress()));
                visibleCopy.remove(vName);
                this.byName = byNameCopy;
                this.byAddr = byAddrCopy;
                this.visible = visibleCopy;
            }
            Debug.lockLeave((Object)this, (String)"remove", null, (Object)this);
            ci.setState((byte)3);
        }
    }

    @Override
    public Iterator<ClientInfo> iterator() {
        return this.byName.values().iterator();
    }

    public Iterator<ClientInfo> visibleIterator() {
        return this.visible.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo get(String name) {
        ClientInfo ci;
        Debug.lockEnter((Object)this, (String)"get", null, (Object)this);
        ClientList clientList = this;
        synchronized (clientList) {
            ci = this.byName.get(name);
        }
        Debug.lockLeave((Object)this, (String)"get", null, (Object)this);
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo get(short addr) {
        ClientInfo ci;
        Debug.lockEnter((Object)this, (String)"get", null, (Object)this);
        HashMap<Short, ClientInfo> hashMap = this.byAddr;
        synchronized (hashMap) {
            ci = this.byAddr.get(ShortList.get((short)addr));
        }
        Debug.lockLeave((Object)this, (String)"get", null, (Object)this);
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo getVisible(String name) {
        ClientInfo ci;
        Debug.lockEnter((Object)this, (String)"getVisible", null, (Object)this);
        HashMap<Short, ClientInfo> hashMap = this.byAddr;
        synchronized (hashMap) {
            ci = this.visible.get(name);
        }
        Debug.lockLeave((Object)this, (String)"getVisible", null, (Object)this);
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int count;
        Debug.lockEnter((Object)this, (String)"size", null, (Object)this);
        ClientList clientList = this;
        synchronized (clientList) {
            count = this.byName.size();
        }
        Debug.lockLeave((Object)this, (String)"size", null, (Object)this);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVisibleSize() {
        int count;
        Debug.lockEnter((Object)this, (String)"getVisibleSize", null, (Object)this);
        HashMap<Short, ClientInfo> hashMap = this.byAddr;
        synchronized (hashMap) {
            count = this.visible.size();
        }
        Debug.lockLeave((Object)this, (String)"getVisibleSize", null, (Object)this);
        return count;
    }

    private void clear() {
        while (!this.groups.isEmpty()) {
            try {
                Short id = this.groups.keySet().iterator().next();
                this.deleteGroup(id);
            }
            catch (Exception ex) {}
        }
        for (ClientInfo ci : this.byName.values()) {
            if (ci.getState() == 2) {
                ci.resetProperties();
                this.fireRemoveClient(ci);
            }
            ci.setState((byte)3);
        }
        this.byName = new TreeMap(this.comparator);
        this.byAddr = new HashMap();
        this.visible = new TreeMap(this.comparator);
        this.groups = new HashMap();
        this.me = null;
    }

    public ClientInfo getMyClient() {
        return this.me;
    }

    public String getMyName() {
        ClientInfo ci = this.me;
        if (ci == null) {
            return null;
        }
        return ci.getName();
    }

    public String getMyDisplayName() {
        ClientInfo ci = this.me;
        if (ci == null) {
            return null;
        }
        return ci.getDisplayName();
    }

    public short getMyAddress() {
        ClientInfo ci = this.me;
        if (ci == null) {
            return -32767;
        }
        return ci.getAddress();
    }

    public ClientGroup getMyGroup() {
        return this.groups.get(ShortList.get((short)this.getMyGroupID()));
    }

    public short getMyGroupID() {
        if (this.me == null) {
            return -32767;
        }
        return this.me.getGroupID();
    }

    public boolean isServer() {
        ClientInfo ci = this.me;
        if (ci == null) {
            return false;
        }
        return ci.isServer();
    }

    public Object getClientPropertyDefault(String prop) {
        if (this.getPropertyScope(prop) != 0) {
            throw new IllegalArgumentException("No shared per-client property '" + prop + "'");
        }
        return this.defaultClientProps.getProperty(prop);
    }

    public void setClientPropertyDefault(String prop, PropertyValue value) {
        if (this.getPropertyScope(prop) != 0) {
            throw new IllegalArgumentException("No shared per-client property '" + prop + "'");
        }
        this.defaultClientProps.setProperty(prop, value);
    }

    public void setClientPropertyDefault(PropertyChangeSet changeSet, String prop, PropertyValue value) {
        if (this.getPropertyScope(prop) != 0) {
            throw new IllegalArgumentException("No shared per-client property '" + prop + "'");
        }
        this.defaultClientProps.setProperty(changeSet, prop, value);
    }

    public Object getGroupPropertyDefault(String prop) {
        if (this.getPropertyScope(prop) != 2) {
            throw new IllegalArgumentException("No shared per-group property '" + prop + "'");
        }
        return this.defaultGroupProps.getProperty(prop);
    }

    public void setGroupPropertyDefault(String prop, PropertyValue value) {
        if (this.getPropertyScope(prop) != 2) {
            throw new IllegalArgumentException("No shared per-group property '" + prop + "'");
        }
        this.defaultGroupProps.setProperty(prop, value);
    }

    public void setGroupPropertyDefault(PropertyChangeSet changeSet, String prop, PropertyValue value) {
        if (this.getPropertyScope(prop) != 2) {
            throw new IllegalArgumentException("No shared per-group property '" + prop + "'");
        }
        this.defaultGroupProps.setProperty(changeSet, prop, value);
    }

    public boolean isPropertyDefined(String name) {
        return this.scopeMap.containsKey(name);
    }

    public byte getPropertyScope(String name) {
        Byte scope = this.scopeMap.get(name);
        if (scope != null) {
            return scope;
        }
        throw new IllegalArgumentException("Unknown property '" + name + "'");
    }

    public boolean isPropertyShared(String name) {
        return this.isShared(name) || this.defaultClientProps.isShared(name) || this.defaultGroupProps.isShared(name);
    }

    public short declareSharedProperty(String name, byte scope, PropertyValue defaultValue) {
        short id;
        if (!this.isServer()) {
            throw new IllegalStateException("Shared properties may only be declared on the server.");
        }
        if (this.contains(name) || this.defaultClientProps.contains(name)) {
            throw new IllegalArgumentException("Property " + name + " is already declared.");
        }
        if (!defaultValue.isShareable()) {
            throw new IllegalArgumentException("Default property value for " + name + " is not of a supported type.");
        }
        switch (scope) {
            case 1: {
                id = this.declareSharedProperty(name, defaultValue);
                break;
            }
            case 0: {
                id = this.defaultClientProps.declareSharedProperty(name, defaultValue);
                for (ClientInfo ci : this.byName.values()) {
                    ci.defineSharedProperty(name, id, defaultValue);
                }
                break;
            }
            case 2: {
                id = this.defaultGroupProps.declareSharedProperty(name, defaultValue);
                for (ClientGroup cg : this.groups.values()) {
                    cg.defineSharedProperty(name, id, defaultValue);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
        this.scopeMap.put(name, Bytes.get(scope));
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyAccessController(String name, PropertyAccessController ctl) {
        if (!this.isServer()) {
            throw new IllegalStateException("Shared properties may only have access controllers on the server.");
        }
        if (!this.isPropertyDefined(name)) {
            throw new IllegalArgumentException("Property '" + name + "' is not defined.");
        }
        if (!this.isPropertyShared(name)) {
            throw new IllegalArgumentException("The '" + name + "' property is not shared and may not have an access controller defined for it.");
        }
        switch (this.getPropertyScope(name)) {
            case 1: {
                this.setAccessController(name, ctl);
                break;
            }
            case 0: {
                this.defaultClientProps.setTemplateAccessController(name, ctl);
                HashMap<Short, ClientInfo> hashMap = this.byAddr;
                synchronized (hashMap) {
                    for (ClientInfo ci : this.byAddr.values()) {
                        ci.setAccessController(name, ctl);
                    }
                    break;
                }
            }
            case 2: {
                this.defaultGroupProps.setTemplateAccessController(name, ctl);
                for (ClientGroup cg : this.groups.values()) {
                    cg.setAccessController(name, ctl);
                }
                break;
            }
        }
    }

    public void setPropertyDefaultAccessController(String name, PropertyAccessController ctl) {
        if (!this.isServer()) {
            throw new IllegalStateException("Shared properties may only have access controllers on the server.");
        }
        if (!this.isPropertyDefined(name)) {
            throw new IllegalArgumentException("Property '" + name + "' is not defined.");
        }
        if (!this.isPropertyShared(name)) {
            throw new IllegalArgumentException("The '" + name + "' property is not shared and may not have an access controller defined for it.");
        }
        switch (this.getPropertyScope(name)) {
            case 1: {
                throw new IllegalArgumentException("The global property '" + name + "' does not have a default value, so a default access controller cannot be set.");
            }
            case 0: {
                this.defaultClientProps.setAccessController(name, ctl);
                break;
            }
            case 2: {
                this.defaultGroupProps.setAccessController(name, ctl);
            }
        }
    }

    private void sendPropertyDefs(short to) {
        ProtocolBuffer buf = ProtocolBuffer.getInstance();
        int count = 0;
        try {
            DataOutputStream str = buf.addPayload();
            count += this.encodePropertyDefs(str);
            count += this.defaultClientProps.encodePropertyDefs(str);
            if ((count += this.defaultGroupProps.encodePropertyDefs(str)) > 0) {
                this.connection.sendPropertyDef(str, buf, to);
            } else {
                str.close();
                buf.dispose();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendPropertyDefs", (Throwable)ex, (boolean)true);
        }
    }

    private void sendProperties(short to) {
        ProtocolBuffer buf = ProtocolBuffer.getInstance();
        int count = 0;
        try {
            DataOutputStream str = buf.addPayload();
            for (ClientInfo ci : this) {
                if (ci.getAddress() == to) continue;
                count += ci.encodeProperties(str, this.defaultClientProps);
            }
            Iterator<ClientGroup> i = this.groupIterator();
            while (i.hasNext()) {
                ClientGroup cg = i.next();
                count += cg.encodeProperties(str, this.defaultGroupProps);
            }
            if (count > 0) {
                this.connection.sendProperty(str, buf, to);
            } else {
                str.close();
                buf.dispose();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendProperties", (Throwable)ex, (boolean)true);
        }
    }

    void onDefineProperty(String name, short id, byte scope, PropertyValue value) {
        switch (scope) {
            case 1: {
                this.defineSharedProperty(name, id, value);
                break;
            }
            case 0: {
                for (ClientInfo ci : this) {
                    ci.defineSharedProperty(name, id, value);
                }
                this.defaultClientProps.defineSharedProperty(name, id, value);
                break;
            }
            case 2: {
                Iterator<ClientGroup> i = this.groupIterator();
                while (i.hasNext()) {
                    ClientGroup cg = i.next();
                    cg.defineSharedProperty(name, id, value);
                }
                this.defaultGroupProps.defineSharedProperty(name, id, value);
                break;
            }
            default: {
                LogSupport.error((Object)this, (String)"onDefineProperty", (String)("Invalid property scope " + scope));
                return;
            }
        }
        this.scopeMap.put(name, Bytes.get(scope));
    }

    public void addPropertyChangeListener(byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 1: {
                this.addPropertyChangeListener(lst);
                break;
            }
            case 0: {
                this.addClientPropertyChangeListener(lst);
                break;
            }
            case 2: {
                this.addGroupPropertyChangeListener(lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void addPropertyChangeListener(String prop, byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 1: {
                this.addPropertyChangeListener(prop, lst);
                break;
            }
            case 0: {
                this.addClientPropertyChangeListener(prop, lst);
                break;
            }
            case 2: {
                this.addGroupPropertyChangeListener(prop, lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void removePropertyChangeListener(byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 1: {
                this.removePropertyChangeListener(lst);
                break;
            }
            case 0: {
                this.removeClientPropertyChangeListener(lst);
                break;
            }
            case 2: {
                this.removeGroupPropertyChangeListener(lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void removePropertyChangeListener(String prop, byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 1: {
                this.removePropertyChangeListener(prop, lst);
                break;
            }
            case 0: {
                this.removeClientPropertyChangeListener(prop, lst);
                break;
            }
            case 2: {
                this.removeGroupPropertyChangeListener(prop, lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void addClientPropertyChangeListener(PropertyChangeListener lst) {
        this.defaultClientProps.addTemplatePropertyChangeListener(lst);
        for (ClientInfo ci : this) {
            ci.addPropertyChangeListener(lst);
        }
    }

    public void addClientPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.defaultClientProps.addTemplatePropertyChangeListener(prop, lst);
        for (ClientInfo ci : this) {
            ci.addPropertyChangeListener(prop, lst);
        }
    }

    public void removeClientPropertyChangeListener(PropertyChangeListener lst) {
        this.defaultClientProps.removeTemplatePropertyChangeListener(lst);
        for (ClientInfo ci : this) {
            ci.removePropertyChangeListener(lst);
        }
    }

    public void removeClientPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.defaultClientProps.removeTemplatePropertyChangeListener(prop, lst);
        for (ClientInfo ci : this) {
            ci.removePropertyChangeListener(prop, lst);
        }
    }

    public void addGroupPropertyChangeListener(PropertyChangeListener lst) {
        this.defaultGroupProps.addTemplatePropertyChangeListener(lst);
        Iterator<ClientGroup> i = this.groupIterator();
        while (i.hasNext()) {
            ClientGroup cg = i.next();
            cg.addPropertyChangeListener(lst);
        }
    }

    public void addGroupPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.defaultGroupProps.addTemplatePropertyChangeListener(prop, lst);
        Iterator<ClientGroup> i = this.groupIterator();
        while (i.hasNext()) {
            ClientGroup cg = i.next();
            cg.addPropertyChangeListener(prop, lst);
        }
    }

    public void removeGroupPropertyChangeListener(PropertyChangeListener lst) {
        this.defaultGroupProps.removeTemplatePropertyChangeListener(lst);
        Iterator<ClientGroup> i = this.groupIterator();
        while (i.hasNext()) {
            ClientGroup cg = i.next();
            cg.removePropertyChangeListener(lst);
        }
    }

    public void removeGroupPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.defaultGroupProps.removeTemplatePropertyChangeListener(prop, lst);
        Iterator<ClientGroup> i = this.groupIterator();
        while (i.hasNext()) {
            ClientGroup cg = i.next();
            cg.removePropertyChangeListener(prop, lst);
        }
    }

    public void addDefaultPropertyChangeListener(byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 0: {
                this.defaultClientProps.addPropertyChangeListener(lst);
                break;
            }
            case 2: {
                this.defaultGroupProps.addPropertyChangeListener(lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void addDefaultPropertyChangeListener(String prop, byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 0: {
                this.defaultClientProps.addPropertyChangeListener(prop, lst);
                break;
            }
            case 2: {
                this.defaultGroupProps.addPropertyChangeListener(prop, lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void removeDefaultPropertyChangeListener(byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 0: {
                this.defaultClientProps.removePropertyChangeListener(lst);
                break;
            }
            case 2: {
                this.defaultGroupProps.removePropertyChangeListener(lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public void removeDefaultPropertyChangeListener(String prop, byte scope, PropertyChangeListener lst) {
        switch (scope) {
            case 0: {
                this.defaultClientProps.removePropertyChangeListener(prop, lst);
                break;
            }
            case 2: {
                this.defaultGroupProps.removePropertyChangeListener(prop, lst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property scope: " + scope);
            }
        }
    }

    public byte getPropertyScope(Object src) {
        return ((PropertyStore)src).getScope();
    }

    public short getPropertyOwner(Object src) {
        try {
            ClientInfo ci = (ClientInfo)src;
            return ci.getAddress();
        }
        catch (ClassCastException ccx) {
            return -32767;
        }
    }

    public short getPropertyGroup(Object src) {
        try {
            ClientGroup cg = (ClientGroup)src;
            return cg.getGroupID();
        }
        catch (ClassCastException ccx) {
            return -32767;
        }
    }

    public boolean isDefaultPropertyValue(Object src) {
        return src instanceof DefaultPropertyStore;
    }
}

