/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ChannelController;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.MessageListener;
import com.elluminate.jinx.ParticipantEvent;
import com.elluminate.jinx.ParticipantListener;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.TransmitStatusListener;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public class Channel
implements MessageListener,
ChannelDataListener {
    public static final byte BULK_DATA = -2;
    public static final byte NON_URGENT_DATA = -1;
    public static final byte NORMAL_DATA = 0;
    public static final byte EXPEDITED_DATA = 1;
    public static final byte URGENT_DATA = 2;
    private static ObjectPool runPool = null;
    String name = null;
    byte priority = (byte)2;
    byte id = (byte)-1;
    short address = (short)-32767;
    JinxProtocol protocol = null;
    DebugFlag trace = null;
    MessageListener mListener = null;
    ChannelListener cListener = null;
    ChannelDataListener dListener = null;
    TransmitStatusListener tListener = null;
    ArrayList<ParticipantListener> pListener = new ArrayList();
    Object listenLock = new Object();
    Connection connection = null;

    protected Channel(String name, byte priority, ChannelListener cl, ChannelDataListener dl, Connection con) {
        this.name = name;
        this.priority = priority;
        this.cListener = cl;
        this.dListener = dl;
        this.connection = con;
        this.protocol = null;
        this.trace = DebugFlag.get((String)("jinx.protocol." + name));
    }

    public String getName() {
        return this.name;
    }

    public byte getChannelID() {
        return this.id;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setProtocol(JinxProtocol proto) {
        this.protocol = proto;
    }

    public JinxProtocol getProtocol() {
        return this.protocol;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setSwingDelivery(boolean useSwing) {
        if (useSwing == this.getSwingDelivery()) {
            return;
        }
        runPool = useSwing ? ObjectPool.getInstance(Deliverer.class) : null;
    }

    public boolean getSwingDelivery() {
        return runPool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener lst) throws TooManyListenersException {
        if (this.mListener != null) {
            throw new TooManyListenersException("Only one MessageListener allowed on a Channel");
        }
        Debug.lockEnter((Object)this, (String)"addMessageListener", (String)"listenLock", (Object)this.listenLock);
        Object object = this.listenLock;
        synchronized (object) {
            this.mListener = lst;
        }
        Debug.lockLeave((Object)this, (String)"addMessageListener", (String)"listenLock", (Object)this.listenLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(MessageListener lst) {
        Debug.lockEnter((Object)this, (String)"removeMessageListener", (String)"listenLock", (Object)this.listenLock);
        Object object = this.listenLock;
        synchronized (object) {
            if (this.mListener == lst) {
                this.mListener = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeMessageListener", (String)"listenLock", (Object)this.listenLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransmitStatusListener(TransmitStatusListener lst) throws TooManyListenersException {
        if (this.tListener != null) {
            throw new TooManyListenersException("Only one TransmitStatusListener allowed on a Channel");
        }
        Debug.lockEnter((Object)this, (String)"addTransmitStatusListener", (String)"listenLock", (Object)this.listenLock);
        Object object = this.listenLock;
        synchronized (object) {
            this.tListener = lst;
        }
        Debug.lockLeave((Object)this, (String)"addTransmitStatusListener", (String)"listenLock", (Object)this.listenLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransmitStatusListener(TransmitStatusListener lst) {
        Debug.lockEnter((Object)this, (String)"removeTransmitStatusListener", (String)"listenLock", (Object)this.listenLock);
        Object object = this.listenLock;
        synchronized (object) {
            if (this.tListener == lst) {
                this.tListener = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeTransmitStatusListener", (String)"listenLock", (Object)this.listenLock);
    }

    @Override
    public void onChannelData(ChannelDataEvent event) {
        this.onChannelData(event, (byte)0);
    }

    public void onChannelData(ChannelDataEvent event, byte urgency) {
        short from;
        byte pri = (byte)(this.priority - urgency);
        if (this.id < 0 || this.mListener == null) {
            throw new IllegalStateException("Invalid state - Channel " + this.name + " is down.");
        }
        if (pri < 0) {
            pri = 0;
        }
        if (pri > 4) {
            pri = 4;
        }
        if (this.trace.show() || DebugFlags.PROTOCOL.show()) {
            LogSupport.message((Object)this, (String)"onChannelData", (String)("xmit(" + pri + ") - " + this.showChannelData(event)));
        }
        if ((from = event.getSourceAddress()) == -32767) {
            from = this.address;
        }
        MessageEvent e = MessageEvent.getInstance((Object)this, from, event.getDestinationAddress(), event.getGroupID(this.connection.getGroupID()), pri, this.id, event.getCommand(), event.removeBuffer());
        this.fireOnMessage(e);
        event.dispose();
    }

    public void requestCompletionNotify(short addr) {
        this.requestCompletionNotify(addr, (byte)0, null);
    }

    public void requestCompletionNotify(short addr, Object context) {
        this.requestCompletionNotify(addr, (byte)0, context);
    }

    public void requestCompletionNotify(short addr, byte urgency) {
        this.requestCompletionNotify(addr, urgency, null);
    }

    public void requestCompletionNotify(short addr, byte urgency, Object context) {
        byte pri = (byte)(this.priority - urgency);
        if (this.id < 0 || this.mListener == null) {
            throw new IllegalStateException("Invalid state - Channel " + this.name + " is down.");
        }
        if (addr < 0) {
            throw new IllegalArgumentException("Invalid address " + addr + " for completion notification.");
        }
        if (pri < 0) {
            pri = 0;
        }
        if (pri > 4) {
            pri = 4;
        }
        TransmitStatusEvent e = new TransmitStatusEvent(this, pri, this.address, addr, this.id, context);
        try {
            this.mListener.onTransmitStatus(e);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"requestCompletionNotify", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public void onMessage(MessageEvent msg) {
        ChannelDataEvent e = ChannelDataEvent.getInstance(this, msg.getDestinationAddress(), msg.getSourceAddress(), msg.getGroupID(), this.name, msg.getPriority(), msg.getCommand(), (ProtocolBuffer)msg.getContent().clone());
        this.fireChannelDataEvent(msg.getPriority(), e);
        e.dispose();
    }

    @Override
    public void onTransmitStatus(TransmitStatusEvent event) {
        TransmitStatusListener lst = this.tListener;
        if (lst == null) {
            return;
        }
        try {
            lst.transmitStatusChange(event);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"onTransmitStatus", (Throwable)t, (boolean)true);
        }
    }

    public boolean isUp() {
        return this.id >= 0 && this.mListener != null;
    }

    protected ChannelController getController() {
        return new ChannelController(){

            @Override
            public void chnlUp(short addr, byte id) {
                Channel.this.up(addr, id);
            }

            @Override
            public void chnlDown() {
                Channel.this.down();
            }

            @Override
            public void chnlAbort() {
                Channel.this.abort();
            }

            @Override
            public void chnlJoin(short addr) {
                Channel.this.join(addr);
            }

            @Override
            public void chnlLeave(short addr) {
                Channel.this.leave(addr);
            }
        };
    }

    private void up(short addr, byte id) {
        this.id = id;
        this.address = addr;
        this.fireChannelEvent(1);
        if (!this.pListener.isEmpty()) {
            this.connection.setWatch(id, true);
        }
    }

    private void down() {
        if (this.id > 0) {
            if (!this.pListener.isEmpty()) {
                this.connection.setWatch(this.id, false);
            }
            this.id = (byte)-1;
            this.fireChannelEvent(2);
        }
    }

    private void abort() {
        this.fireChannelEvent(3);
    }

    private void join(short addr) {
        ParticipantEvent pe = new ParticipantEvent(this, this, addr);
        for (ParticipantListener pl : this.pListener) {
            try {
                pl.joinChannel(pe);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"join", (Throwable)ex, (boolean)true);
            }
        }
    }

    private void leave(short addr) {
        ParticipantEvent pe = new ParticipantEvent(this, this, addr);
        for (ParticipantListener pl : this.pListener) {
            try {
                pl.leaveChannel(pe);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"leave", (Throwable)ex, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantListener(ParticipantListener pl) {
        boolean setWatch = false;
        Debug.lockEnter((Object)this, (String)"addParticipantListener", (String)"listenLock", (Object)this.listenLock);
        Object object = this.listenLock;
        synchronized (object) {
            setWatch = this.pListener.isEmpty();
            if (!this.pListener.contains(pl)) {
                ArrayList<ParticipantListener> copy = new ArrayList<ParticipantListener>(this.pListener);
                copy.add(pl);
                this.pListener = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"addParticipantListener", (String)"listenLock", (Object)this.listenLock);
        if (setWatch) {
            this.connection.setWatch(this.id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantListener(ParticipantListener pl) {
        boolean clrWatch = false;
        Debug.lockEnter((Object)this, (String)"removeParticipantListener", (String)"listenLock", (Object)this.listenLock);
        Object object = this.listenLock;
        synchronized (object) {
            if (this.pListener.contains(pl)) {
                ArrayList<ParticipantListener> copy = new ArrayList<ParticipantListener>(this.pListener);
                copy.remove(pl);
                clrWatch = copy.isEmpty();
                this.pListener = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeParticipantListener", (String)"listenLock", (Object)this.listenLock);
        if (clrWatch) {
            this.connection.setWatch(this.id, false);
        }
    }

    private void fireChannelEvent(int action) {
        if (this.cListener == null) {
            return;
        }
        ChannelEvent e = new ChannelEvent(this, this.name, action);
        if (DebugFlags.CHANNELS.show()) {
            LogSupport.message((Object)this, (String)"fireChannelEvent", (String)e.toString());
        }
        if (runPool != null) {
            SwingRunnerSupport.invokeLater((Runnable)new SwingChannelEvent(this.cListener, e));
        } else {
            try {
                this.cListener.channelStateChanged(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireChannelEvent", (Throwable)ex, (boolean)true);
            }
        }
    }

    private void fireChannelDataEvent(byte pri, ChannelDataEvent event) {
        if (this.dListener == null) {
            return;
        }
        if (this.trace.show() || DebugFlags.PROTOCOL.show()) {
            LogSupport.message((Object)this, (String)"fireChannelDataEvent", (String)("recv(" + pri + ") - " + this.showChannelData(event)));
        }
        if (runPool != null) {
            Deliverer runnable = (Deliverer)runPool.alloc();
            runnable.init(this.dListener, event, this);
            SwingRunnerSupport.invokeLater((Runnable)runnable);
        } else {
            try {
                this.dListener.onChannelData(event);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireChannelDataEvent", (Throwable)t, (boolean)true, (String)("processing " + this.showChannelData(event)));
            }
        }
    }

    private void fireOnMessage(MessageEvent event) {
        if (this.mListener == null) {
            event.dispose();
            return;
        }
        try {
            this.mListener.onMessage(event);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireOnMessage", (Throwable)ex, (boolean)true);
        }
    }

    private String showChannelData(ChannelDataEvent e) {
        StringBuffer b = new StringBuffer();
        DataInputStream str = e.read();
        short from = e.getSourceAddress();
        short to = e.getDestinationAddress();
        switch (from) {
            case -32767: {
                break;
            }
            case 0: {
                b.append("from Server");
                break;
            }
            default: {
                b.append("from ");
                b.append(from);
            }
        }
        b.append(" to ");
        switch (to) {
            case -1: {
                b.append("All");
                break;
            }
            case -2: {
                b.append("Others");
                break;
            }
            case 0: {
                b.append("Server");
                break;
            }
            default: {
                b.append(to);
            }
        }
        b.append(" on ");
        b.append(this.name);
        if (this.protocol != null) {
            b.append(": ");
            b.append(this.protocol.messageToString(e.getCommand(), str));
        } else {
            b.append(": cmd=");
            b.append(e.getCommand());
            b.append(",");
            b.append(e.size());
            b.append(" bytes");
        }
        try {
            str.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return b.toString();
    }

    public String toString() {
        return this.name + " channel(p=" + this.priority + ",id=" + this.id + ")";
    }

    static class Deliverer
    extends PooledObject
    implements Runnable {
        private ChannelDataListener l;
        private ChannelDataEvent e;
        private Channel c;

        Deliverer() {
        }

        public void init(ChannelDataListener l, ChannelDataEvent e, Channel c) {
            this.l = l;
            this.e = (ChannelDataEvent)e.clone();
            this.c = c;
        }

        public void poCleanup() {
            this.l = null;
            this.e = null;
            this.c = null;
        }

        @Override
        public void run() {
            try {
                this.l.onChannelData(this.e);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true, (String)("processing " + this.c.showChannelData(this.e)));
            }
            this.e.dispose();
            this.dispose();
        }
    }

    class SwingChannelEvent
    implements Runnable {
        private ChannelListener l;
        private ChannelEvent e;

        public SwingChannelEvent(ChannelListener l, ChannelEvent e) {
            this.l = l;
            this.e = e;
        }

        @Override
        public void run() {
            try {
                this.l.channelStateChanged(this.e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)ex, (boolean)true);
            }
        }
    }
}

