/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.PooledRunnable;
import com.elluminate.util.WorkQueue;

public class ChainedWorkQueue
extends WorkQueue {
    private int sizeDelta = 64;
    private PooledRunnable endMarker = null;
    private PooledRunnable[] queues = null;
    private int frontQueue = 0;
    private int nQueues = 0;
    private int size = -1;

    public ChainedWorkQueue() {
        this.queues = new PooledRunnable[this.sizeDelta];
    }

    public ChainedWorkQueue(int init) {
        this.sizeDelta = init;
        this.queues = new PooledRunnable[this.sizeDelta];
    }

    public void setEndMarker(PooledRunnable a) {
        this.endMarker = a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(PooledRunnable a) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nQueues > 0) {
                if (this.nQueues == this.queues.length) {
                    PooledRunnable[] nq = new PooledRunnable[this.nQueues + this.sizeDelta];
                    for (int i = this.frontQueue; i < this.frontQueue + this.nQueues; ++i) {
                        nq[i % nq.length] = this.queues[i % this.queues.length];
                    }
                    this.queues = nq;
                }
                int q = (this.frontQueue + this.nQueues) % this.queues.length;
                this.queues[q] = a;
                ++this.nQueues;
                this.size = -1;
            } else {
                while (a != this.endMarker) {
                    PooledRunnable n = a.getNext();
                    if (this.startNow(a, false)) {
                        a = n;
                        continue;
                    }
                    this.frontQueue = 0;
                    this.queues[this.frontQueue] = a;
                    this.nQueues = 1;
                    this.size = -1;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getWork() {
        PooledRunnable work = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.nQueues != 0) {
                work = this.queues[this.frontQueue];
                PooledRunnable next = work.getNext();
                if (next != this.endMarker) {
                    this.queues[this.frontQueue] = next;
                } else {
                    this.queues[this.frontQueue] = null;
                    --this.nQueues;
                    this.frontQueue = this.nQueues == 0 ? 0 : (this.frontQueue + 1) % this.queues.length;
                }
                if (this.size > 0) {
                    --this.size;
                }
            }
        }
        return work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int s;
        Object object = this.lock;
        synchronized (object) {
            if (this.size < 0) {
                this.size = 0;
                for (int i = 0; i < this.nQueues; ++i) {
                    int q = (this.frontQueue + i) % this.queues.length;
                    for (PooledRunnable a = this.queues[q]; a != this.endMarker; a = a.getNext()) {
                        ++this.size;
                    }
                }
            }
            s = this.size;
        }
        return s;
    }
}

