/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ByteBlock;
import com.elluminate.jinx.ByteList;
import com.elluminate.util.ObjectPool;

public class BytePool {
    private static final int[] BLOCK_SIZE = new int[]{16, 400};
    public static final byte HEADER = 0;
    public static final byte BODY = 1;
    private ObjectPool pool = null;

    public BytePool(byte type) {
        switch (type) {
            case 0: {
                this.pool = ObjectPool.getInstance(HdrBlock.class);
                break;
            }
            case 1: {
                this.pool = ObjectPool.getInstance(BodyBlock.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid BytePool block type " + type);
            }
        }
    }

    public ByteList getList() {
        return ByteList.getInstance(this.pool.get());
    }

    public ByteList getList(ThreadGroup tGrp) {
        return ByteList.getInstance(this.pool.get(tGrp));
    }

    public static class BodyBlock
    extends ByteBlock {
        public BodyBlock() {
            super(BLOCK_SIZE[1]);
        }
    }

    public static class HdrBlock
    extends ByteBlock {
        public HdrBlock() {
            super(BLOCK_SIZE[0]);
        }
    }
}

