/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ByteList;
import com.elluminate.util.IndirectObjectPool;
import com.elluminate.util.IndirectPoolProxy;
import com.elluminate.util.IndirectPooledObject;
import com.elluminate.util.ObjectPool;
import java.io.IOException;
import java.io.InputStream;

public class ByteListInputStream
extends InputStream
implements IndirectPooledObject {
    private static Object poolLock = new Object();
    private static IndirectObjectPool pool = null;
    private static boolean unpooled = false;
    private ByteList list;
    private int remaining;
    private int remove;
    private int cursor;
    private IndirectPoolProxy proxy;

    public void poInit() {
    }

    public void poCleanup() {
        this.list = null;
    }

    public void poSetProxy(IndirectPoolProxy proxy) {
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteListInputStream alloc() {
        if (unpooled) {
            return new ByteListInputStream();
        }
        if (pool == null) {
            Object object = poolLock;
            synchronized (object) {
                if (!ObjectPool.isEnabled()) {
                    unpooled = true;
                    return new ByteListInputStream();
                }
                if (pool == null) {
                    IndirectObjectPool op;
                    pool = op = new IndirectObjectPool(ByteListInputStream.class);
                }
            }
        }
        return (ByteListInputStream)pool.alloc();
    }

    static ByteListInputStream getInstance(ByteList lst, int length, boolean consume) {
        ByteListInputStream s = ByteListInputStream.alloc();
        s.list = lst;
        s.remaining = length;
        s.cursor = 0;
        s.remove = consume ? length : 0;
        return s;
    }

    @Override
    public int read() throws IOException {
        if (this.list == null) {
            throw new IOException("Stream is closed.");
        }
        int value = this.list.read(this.cursor);
        ++this.cursor;
        --this.remaining;
        return value;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int nBytes = 0;
        if (this.list == null) {
            throw new IOException("Stream is closed.");
        }
        if (this.remaining == 0) {
            return -1;
        }
        nBytes = this.list.read(this.cursor, buf, off, len = Math.min(len, this.remaining));
        if (nBytes > 0) {
            this.cursor += nBytes;
            this.remaining -= nBytes;
        }
        return nBytes;
    }

    @Override
    public void close() {
        if (this.list != null) {
            if (this.remove > 0) {
                this.list.consume(this.remove);
            }
            this.list = null;
            if (this.proxy != null) {
                this.proxy.dispose();
            }
        }
    }

    @Override
    public int available() {
        return this.remaining;
    }

    public ByteList getByteList() {
        return this.list;
    }
}

