/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.AsyncWriteBuffer;
import com.elluminate.jinx.AsyncWriteQueue;
import com.elluminate.jinx.BandwidthLimit;
import com.elluminate.jinx.ControlPacket;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.JinxException;
import com.elluminate.jinx.LogFlags;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.ProtocolIOListener;
import com.elluminate.jinx.TransceiverAdapter;
import com.elluminate.jinx.TransceiverEvent;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.XmitScheduler;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.LightweightTimerQueue;
import com.elluminate.util.PriorityDeadlineQueue;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class AsyncNetworkTransceiver
extends TransceiverAdapter {
    public static final int HEADER_LENGTH = 10;
    public static final byte OP_USER_DATA = 0;
    public static final byte OP_RECEIVE_BANDWIDTH = 1;
    public static final byte OP_PING = 2;
    public static final byte OP_ECHO = 3;
    public static final byte OP_HANGUP = 4;
    public static final int WAIT_TIME = 1000;
    public static final int PING_TIMEOUT = 20000;
    public static final int PING_RETRY_INTERVAL = 5000;
    public static final int DISCONNECT_TIMEOUT = 45000;
    private static final float HALF_DUPLEX_MOD = 0.5f;
    private static final int MAX_BUFFER_SIZE = 1600;
    private static final int MIN_BUFFER_SIZE = 500;
    private static final long PRIORITY_INTERVAL = 2000L;
    public static final int INITIAL_BANDWIDTH = 100000000;
    private static LightweightTimerQueue pingQueue = new LightweightTimerQueue(128, 128, 2, "PingTimer", null);
    private AsyncEndpoint endpoint = null;
    private Object disconnectLock = new Object();
    private boolean disconnecting = false;
    private Recv recv = null;
    private Xmit xmit = null;

    public AsyncNetworkTransceiver(BandwidthLimit[] limits) {
        this.xmit = new Xmit(limits);
        this.recv = new Recv();
    }

    public void connect(AsyncEndpoint ep, short addr, String name, int recv_max, int xmit_max) throws JinxConnectionException {
        this.setAddress(addr);
        this.setName(name);
        this.endpoint = ep;
        this.disconnecting = false;
        this.xmit.setLocalSpeeds(xmit_max, recv_max);
        byte prev = this.setState((byte)1);
        this.fireTransceiverStatusChanged((byte)1, prev, (byte)0);
    }

    @Override
    public void disconnect(byte reason) {
        if (DebugFlags.HANGUP.show()) {
            this.logHangup("disconnect", "locally(" + TransceiverEvent.REASONS[reason] + ")");
        }
        this.hangup(reason);
    }

    @Override
    public void enable() {
        byte prev = this.getState();
        try {
            this.endpoint.setLinger(10);
            this.endpoint.setTcpNoDelay(true);
            this.endpoint.setTimeout(45000);
        }
        catch (IOException iox) {
            try {
                this.fireTransceiverStatusChanged((byte)3, prev, (byte)3);
            }
            catch (Throwable ex2) {
                LogSupport.proxyException((String)this.getConferenceName(), (String)this.getName(), (Object)this, (String)"enable", (Throwable)ex2, (boolean)true);
            }
            this.setState((byte)3);
            return;
        }
        this.xmit.start(this.endpoint);
        this.setState((byte)2);
        try {
            this.fireTransceiverStatusChanged((byte)2, prev, (byte)0);
        }
        catch (JinxConnectionException jcx) {
            LogSupport.proxyException((String)this.getConferenceName(), (String)this.getName(), (Object)this, (String)"enable", (Throwable)jcx, (boolean)true);
        }
        this.recv.start(this.endpoint);
        if (DebugFlags.CIPHER.show()) {
            String cipher = this.endpoint.getCipher();
            if (cipher == null) {
                LogSupport.proxyMessage((String)this.getConferenceName(), (String)this.getName(), (Object)this, (String)"enable", (String)"Channel not enciphered.");
            } else {
                LogSupport.proxyMessage((String)this.getConferenceName(), (String)this.getName(), (Object)this, (String)"enable", (String)("Channel enciphered using '" + cipher + "'"));
            }
        }
    }

    @Override
    public int getMaxXmitSpeed() {
        return this.xmit.getXmitSpeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimedOut() {
        boolean timedOut = false;
        Object object = this.disconnectLock;
        synchronized (object) {
            if (this.disconnecting) {
                timedOut = false;
            } else if (this.recv.getLastMsgInterval() > 45000L) {
                timedOut = true;
                this.disconnecting = true;
            }
        }
        return timedOut;
    }

    @Override
    public void onPacket(PacketEvent event) {
        this.xmit.onDataPacket(event);
    }

    @Override
    public void onTransmitStatus(TransmitStatusEvent event) {
        this.xmit.onTransmitStatus(event);
    }

    public void setConnectionSpeed(int xmit, int recv) {
        this.xmit.setLocalSpeeds(xmit, recv);
    }

    @Override
    public boolean isSecure() {
        AsyncEndpoint ep = this.endpoint;
        if (ep == null) {
            return false;
        }
        return ep.isSecure();
    }

    @Override
    public String getCipher() {
        AsyncEndpoint ep = this.endpoint;
        if (ep == null) {
            return null;
        }
        return ep.getCipher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hangup(byte reason) {
        boolean inProgress = false;
        boolean notify = false;
        byte prev = 3;
        Debug.lockEnter((Object)this, (String)"hangup", (String)"disconnectLock", (Object)this.disconnectLock);
        Object object = this.disconnectLock;
        synchronized (object) {
            inProgress = this.disconnecting;
            this.disconnecting = true;
        }
        Debug.lockLeave((Object)this, (String)"hangup", (String)"disconnectLock", (Object)this.disconnectLock);
        if (inProgress && reason != 4) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"hangup", null, (Object)this);
        object = this;
        synchronized (object) {
            if (this.endpoint != null) {
                notify = true;
                if (reason == 1) {
                    this.xmit.shutdown(new ControlPacket(4));
                } else {
                    this.xmit.shutdown();
                }
                this.endpoint = null;
                prev = this.setState((byte)3);
            }
        }
        Debug.lockLeave((Object)this, (String)"hangup", null, (Object)this);
        if (notify) {
            DisconnectNotifier notifier = new DisconnectNotifier(prev, reason);
            notifier.start();
        }
    }

    private void logDisconnect(String from, Throwable t, String desc) {
        if (this.disconnecting) {
            return;
        }
        if (DebugFlags.DISCONNECTION.show()) {
            InetAddress addr;
            String ip = "unknown";
            String statistics = "";
            if (this.endpoint != null && (addr = this.endpoint.getInetAddress()) != null) {
                ip = addr.toString();
            }
            if (LogFlags.STATS.show()) {
                statistics = " [" + this.stats + "]";
            }
            if (t != null) {
                LogSupport.proxyLog((String)this.getConferenceName(), (String)this.getName(), (Object)this, (String)from, (String)("Disconnecting " + this.getName() + "(" + ip + ") on " + desc + " - " + t + statistics));
            } else {
                LogSupport.proxyLog((String)this.getConferenceName(), (String)this.getName(), (Object)this, (String)from, (String)("Disconnecting " + this.getName() + "(" + ip + ") on " + desc + statistics));
            }
        }
    }

    private void logHangup(String from, String side) {
        if (DebugFlags.HANGUP.show()) {
            InetAddress addr;
            String ip = "unknown";
            String statistics = "";
            if (this.endpoint != null && (addr = this.endpoint.getInetAddress()) != null) {
                ip = addr.toString();
            }
            if (LogFlags.STATS.show()) {
                statistics = " [" + this.stats + "]";
            }
            LogSupport.proxyLog((String)this.getConferenceName(), (String)this.getName(), (String)("User " + this.getName() + "(" + ip + ") has been disconnected " + side + statistics));
        }
    }

    class DisconnectNotifier
    extends Thread {
        private byte previous;
        private byte reason;

        public DisconnectNotifier(byte prev, byte why) {
            this.previous = prev;
            this.reason = why;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AsyncNetworkTransceiver.this.fireTransceiverStatusChanged((byte)3, this.previous, this.reason);
            }
            catch (JinxException ex) {
            }
            catch (Exception ex) {
                LogSupport.proxyException((String)AsyncNetworkTransceiver.this.getConferenceName(), (String)this.getName(), (Object)this, (String)"hangup", (Throwable)ex, (boolean)true);
            }
            AsyncNetworkTransceiver asyncNetworkTransceiver = AsyncNetworkTransceiver.this;
            synchronized (asyncNetworkTransceiver) {
                AsyncNetworkTransceiver.this.setConferenceName(null);
                AsyncNetworkTransceiver.this.setName(null);
                AsyncNetworkTransceiver.this.setAddress((short)-32767);
            }
        }
    }

    class Recv
    extends AsyncIOAdapter
    implements ProtocolIOListener {
        private static final byte READING_HEADER = 1;
        private static final byte READING_CONTENT = 2;
        private AsyncEndpoint ep = null;
        private volatile byte state = 1;
        private byte[] header = new byte[10];
        private short src;
        private short dst;
        private short grp;
        private byte pri;
        private byte op;
        private short len = (short)-1;
        private ProtocolBuffer buf;
        private volatile boolean running = false;
        private long lastMsgTime = System.currentTimeMillis();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(AsyncEndpoint endpoint) {
            this.running = true;
            this.ep = endpoint;
            boolean more = true;
            try {
                while (more) {
                    this.state = 1;
                    if (this.ep.beginReadFully(this.header, (AsyncIOListener)this)) {
                        Recv recv = this;
                        synchronized (recv) {
                            more = this.processHeader();
                            continue;
                        }
                    }
                    more = false;
                }
            }
            catch (IOException iox) {
                AsyncNetworkTransceiver.this.logDisconnect("Reader.readComplete", iox, "input exception");
                AsyncNetworkTransceiver.this.hangup((byte)3);
            }
            catch (Throwable t) {
                AsyncNetworkTransceiver.this.logDisconnect("Reader<init>", t, "abnormal exception");
                AsyncNetworkTransceiver.this.hangup((byte)3);
            }
        }

        public void shutdown() {
            this.running = false;
        }

        public long getLastMsgInterval() {
            return System.currentTimeMillis() - this.lastMsgTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readComplete(AsyncIORequest req) {
            try {
                req.finishRequest();
            }
            catch (IOException iox) {
                AsyncNetworkTransceiver.this.logDisconnect("Reader.readComplete", iox, "input exception");
                AsyncNetworkTransceiver.this.hangup((byte)3);
                return;
            }
            catch (Throwable t) {
                AsyncNetworkTransceiver.this.logDisconnect("Reader.readComplete", t, "abnormal exception");
                AsyncNetworkTransceiver.this.hangup((byte)3);
                return;
            }
            boolean more = true;
            do {
                Recv recv = this;
                synchronized (recv) {
                    switch (this.state) {
                        case 1: {
                            more = this.processHeader();
                            break;
                        }
                        case 2: {
                            more = this.processContent();
                            break;
                        }
                        default: {
                            LogSupport.error((Object)this, (String)"readComplete", (String)("Invalid read state - " + this.state));
                            more = false;
                        }
                    }
                }
                if (!more || !this.running) continue;
                try {
                    this.state = 1;
                    more = this.ep.beginReadFully(this.header, (AsyncIOListener)this);
                }
                catch (IOException iox) {
                    AsyncNetworkTransceiver.this.logDisconnect("Reader.readComplete", iox, "input exception");
                    AsyncNetworkTransceiver.this.hangup((byte)3);
                    return;
                }
            } while (more);
        }

        private boolean processHeader() {
            boolean done = false;
            this.lastMsgTime = System.currentTimeMillis();
            this.src = this.getShort(this.header, 0);
            this.dst = this.getShort(this.header, 2);
            this.grp = this.getShort(this.header, 4);
            this.pri = this.header[6];
            this.op = this.header[7];
            this.len = this.getShort(this.header, 8);
            if (this.len > 0) {
                this.state = (byte)2;
                this.buf = ProtocolBuffer.getInstance();
                int hLen = this.len > 5 ? 5 : 0;
                int cLen = this.len - hLen;
                try {
                    if (this.buf.readFrom(this.ep, hLen, cLen, this)) {
                        done = this.processContent();
                    }
                }
                catch (IOException iox) {
                    AsyncNetworkTransceiver.this.logDisconnect("processHeader", iox, "input exception");
                    AsyncNetworkTransceiver.this.hangup((byte)3);
                }
            } else {
                done = this.processContent();
            }
            return done;
        }

        private boolean processContent() {
            int nBytes = 10 + this.len;
            AsyncNetworkTransceiver.this.stats.read(nBytes);
            switch (this.op) {
                case 0: {
                    this.dispatch();
                    break;
                }
                case 2: {
                    AsyncNetworkTransceiver.this.xmit.onControlPacket(new ControlPacket(3));
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    try {
                        DataInputStream str = this.buf.readPayload();
                        int spd = str.readInt();
                        str.close();
                        AsyncNetworkTransceiver.this.xmit.setPeerRecvSpeed(spd);
                        break;
                    }
                    catch (IOException iox) {
                        AsyncNetworkTransceiver.this.logDisconnect("processContent", iox, "input exception");
                        AsyncNetworkTransceiver.this.hangup((byte)3);
                        return false;
                    }
                }
                case 4: {
                    AsyncNetworkTransceiver.this.logHangup("processContent", "remotely");
                    AsyncNetworkTransceiver.this.hangup((byte)2);
                    return false;
                }
                default: {
                    AsyncNetworkTransceiver tx = AsyncNetworkTransceiver.this;
                    LogSupport.proxyError((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"processContent", (String)("Unknown opcode (" + this.op + ") in received packet. [src=" + this.src + ",dst=" + this.dst + ",grp=" + this.grp + ",pri=" + this.pri + "len=" + this.len + "]"));
                }
            }
            return true;
        }

        private void dispatch() {
            PacketEvent event = PacketEvent.newInstance((Object)AsyncNetworkTransceiver.this, this.src, this.dst, this.grp, this.pri, this.buf);
            this.buf = null;
            AsyncNetworkTransceiver.this.fireOnPacket(event);
        }

        private short getShort(byte[] buf, int off) {
            return (short)(buf[off] << 8 | buf[off + 1] & 0xFF);
        }

        @Override
        public void protocolReadComplete(IOException iox) {
            if (iox != null) {
                AsyncNetworkTransceiver.this.logDisconnect("protocolReadComplete", iox, "input exception");
                AsyncNetworkTransceiver.this.hangup((byte)3);
                return;
            }
            boolean more = this.processContent();
            while (more) {
                try {
                    this.state = 1;
                    more = this.ep.beginReadFully(this.header, (AsyncIOListener)this);
                }
                catch (IOException x) {
                    AsyncNetworkTransceiver.this.logDisconnect("protocolReadComplete", x, "input exception");
                    AsyncNetworkTransceiver.this.hangup((byte)3);
                    more = false;
                }
                if (!more) continue;
                more = this.processHeader();
            }
        }

        @Override
        public void protocolWriteComplete(IOException iox) {
            throw new UnsupportedOperationException();
        }
    }

    class Xmit
    extends AsyncIOAdapter
    implements Runnable,
    AsyncWriteQueue.WriteQueueListener {
        private AsyncEndpoint ep = null;
        private AsyncWriteQueue transmitQueue = null;
        private int bufferSize = 1600;
        private BandwidthLimit[] limits;
        private BandwidthLimit linkLimit;
        private XmitScheduler xmitScheduler = null;
        private PriorityDeadlineQueue queue = null;
        private int myRecvSpeed = 100000000;
        private int myXmitSpeed = 100000000;
        private int hisRecvSpeed = 100000000;
        private float duplexFactor = 1.0f;
        private LightweightTimer pingTimer;
        private volatile boolean waiting = false;
        private volatile boolean shutdownPending = false;
        private Object queueLock = new Object();
        private Object procLock = new Object();

        public Xmit(BandwidthLimit[] parents) {
            this.linkLimit = new BandwidthLimit(100000000L);
            this.updateBufferSize();
            if (parents == null) {
                this.limits = new BandwidthLimit[]{this.linkLimit};
            } else {
                this.limits = new BandwidthLimit[parents.length + 1];
                this.limits[0] = this.linkLimit;
                System.arraycopy(parents, 0, this.limits, 1, parents.length);
            }
            this.xmitScheduler = new XmitScheduler(this, this.limits);
            this.queue = new PriorityDeadlineQueue(4, 2000L);
            this.queue.setDiscardHook(new PriorityDeadlineQueue.DiscardHook(){

                public void itemDiscarded(Object o) {
                    try {
                        ProtocolBuffer b = (ProtocolBuffer)o;
                        b.dispose();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.pingTimer = new LightweightTimer(pingQueue, 1, new Runnable(){

                @Override
                public void run() {
                    Xmit.this.pingCheck();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(AsyncEndpoint endpoint) {
            Object object = this.procLock;
            synchronized (object) {
                this.ep = endpoint;
                if (!this.ep.isFullDuplex()) {
                    this.duplexFactor = 0.5f;
                    this.myRecvSpeed = (int)((float)this.myRecvSpeed * this.duplexFactor);
                    this.myXmitSpeed = (int)((float)this.myXmitSpeed * this.duplexFactor);
                    this.linkLimit.setLimit(Math.min(this.myXmitSpeed, this.hisRecvSpeed));
                    this.updateBufferSize();
                }
                this.waiting = false;
                this.shutdownPending = false;
                this.transmitQueue = new AsyncWriteQueue(this.ep, this);
                this.onControlPacket(new ControlPacket(1, this.myRecvSpeed));
                this.pingTimer.scheduleIn(20000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.procLock;
            synchronized (object) {
                this.pingTimer.cancel();
                this.shutdownPending = true;
                Object object2 = this.queueLock;
                synchronized (object2) {
                    this.queue.clear();
                }
                if (this.transmitQueue.isEmpty()) {
                    this.ep.beginClose(null);
                    this.ep = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown(ControlPacket p) {
            Object object = this.procLock;
            synchronized (object) {
                this.pingTimer.cancel();
                this.shutdownPending = true;
                Object object2 = this.queueLock;
                synchronized (object2) {
                    this.queue.clear();
                }
                AsyncWriteBuffer b = AsyncWriteBuffer.getInstance();
                b.write(p.getBuffer(AsyncNetworkTransceiver.this.getAddress()));
                this.transmitQueue.send(b);
            }
        }

        private void pingCheck() {
            long last = AsyncNetworkTransceiver.this.recv.getLastMsgInterval();
            if (last > 45000L) {
                AsyncNetworkTransceiver.this.hangup((byte)4);
            } else if (last > 20000L) {
                this.onControlPacket(new ControlPacket(2));
                this.pingTimer.scheduleIn(5000L);
            } else {
                long next = 20000L - last;
                this.pingTimer.scheduleIn(next);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onControlPacket(ControlPacket p) {
            if (this.shutdownPending) {
                return;
            }
            Object object = this.queueLock;
            synchronized (object) {
                this.queue.put((byte)0, (Object)p);
            }
            this.startQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataPacket(PacketEvent e) {
            boolean empty;
            if (this.shutdownPending) {
                return;
            }
            byte priority = e.getPriority();
            Object object = this.queueLock;
            synchronized (object) {
                empty = this.queue.put(priority, (Object)e);
            }
            if (empty || priority == 0) {
                this.startQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTransmitStatus(TransmitStatusEvent e) {
            boolean empty;
            if (this.shutdownPending) {
                return;
            }
            byte priority = e.getPriority();
            Object object = this.queueLock;
            synchronized (object) {
                empty = this.queue.put(priority, (Object)e);
            }
            if (empty || priority == 0) {
                this.startQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startQueue() {
            boolean more = true;
            while (more) {
                Object object = this.procLock;
                synchronized (object) {
                    more = this.processQueue("onDataPacket");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processQueue(String by) {
            long now = System.currentTimeMillis();
            AsyncWriteBuffer buf = null;
            if (this.transmitQueue == null) {
                return false;
            }
            if (this.waiting) {
                Object object = this.queueLock;
                synchronized (object) {
                    buf = this.fillBuffer(now, (byte)0);
                }
                if (buf != null) {
                    this.xmitScheduler.immediate(now, buf.size());
                    this.waiting = false;
                }
            } else if (!this.queue.isEmpty()) {
                if (this.queue.getEffectivePriority(now) == 0) {
                    Object object = this.queueLock;
                    synchronized (object) {
                        buf = this.fillBuffer(now, (byte)4);
                    }
                    if (buf != null) {
                        this.xmitScheduler.immediate(now, buf.size());
                    }
                } else {
                    int deadline = (int)(this.queue.getDeadline() - now);
                    Object o = this.queue.getFirst(false);
                    long time = this.xmitScheduler.schedule(this.getSize(o), deadline, by, now);
                    if (time == 0L) {
                        Object object = this.queueLock;
                        synchronized (object) {
                            buf = this.fillBuffer(now, (byte)4);
                        }
                        if (buf != null) {
                            this.xmitScheduler.complete(now, buf.size());
                        }
                    } else {
                        this.waiting = true;
                    }
                }
            }
            if (buf != null) {
                int nBytes = buf.size();
                if (DebugFlags.ASYNC_WRITES.show()) {
                    LogSupport.message((Object)this, (String)"processQueue", (String)("Writing on " + by));
                }
                AsyncNetworkTransceiver.this.stats.write(nBytes);
                this.transmitQueue.send(buf);
                return true;
            }
            return false;
        }

        private int getSize(Object o) {
            int n = 0;
            if (o instanceof PacketEvent) {
                PacketEvent p = (PacketEvent)o;
                n = p.getContent().getSize() + 10;
            } else if (o instanceof ControlPacket) {
                ControlPacket c = (ControlPacket)o;
                n = c.size();
            }
            return n;
        }

        private AsyncWriteBuffer fillBuffer(long now, byte min) {
            if (this.queue.isEmpty() || this.queue.getEffectivePriority(now) > min) {
                return null;
            }
            AsyncWriteBuffer xBuf = AsyncWriteBuffer.getInstance();
            boolean done = false;
            while (!this.queue.isEmpty() && !done) {
                Object o = this.queue.getFirst(false);
                int size = this.getSize(o);
                if (xBuf.size() + size <= this.bufferSize) {
                    ProtocolBuffer buf;
                    if (o instanceof PacketEvent) {
                        PacketEvent e = (PacketEvent)o;
                        buf = e.getContent();
                        int len = buf.getSize();
                        DataOutputStream str = buf.addHeader();
                        try {
                            str.writeShort(e.getSourceAddress());
                            str.writeShort(e.getDestinationAddress());
                            str.writeShort(e.getGroupID());
                            str.writeByte(e.getPriority());
                            str.writeByte(0);
                            str.writeShort(len);
                            str.close();
                            str = buf.addPayload();
                            str.close();
                        }
                        catch (Exception ex) {
                            AsyncNetworkTransceiver tx = AsyncNetworkTransceiver.this;
                            LogSupport.proxyException((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"fillBuffer", (Throwable)ex, (boolean)true);
                            xBuf.dispose();
                            return null;
                        }
                        str = null;
                        xBuf.write(buf);
                        this.queue.remove(o);
                        e.dispose();
                        continue;
                    }
                    if (o instanceof ControlPacket) {
                        ControlPacket p = (ControlPacket)o;
                        buf = p.getBuffer(AsyncNetworkTransceiver.this.getAddress());
                        xBuf.write(buf);
                        this.queue.remove(o);
                        buf.dispose();
                        continue;
                    }
                    if (o instanceof TransmitStatusEvent) {
                        TransmitStatusEvent c = (TransmitStatusEvent)o;
                        c.setTransmitComplete();
                        AsyncNetworkTransceiver.this.fireTransmitComplete(c);
                        this.queue.remove(o);
                        continue;
                    }
                    AsyncNetworkTransceiver tx = AsyncNetworkTransceiver.this;
                    LogSupport.proxyError((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"fillBuffer", (String)("Unexpected object in transmit queue: " + o));
                    done = true;
                    continue;
                }
                done = true;
            }
            if (xBuf != null && xBuf.isEmpty()) {
                xBuf.dispose();
                xBuf = null;
            }
            return xBuf;
        }

        public void setPeerRecvSpeed(int spd) {
            if (spd != this.hisRecvSpeed) {
                this.hisRecvSpeed = spd;
                if (DebugFlags.BANDWIDTH.show()) {
                    AsyncNetworkTransceiver tx = AsyncNetworkTransceiver.this;
                    LogSupport.proxyMessage((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"setPeerRecvSpeeds", (String)("Setting peer recv speed to " + spd + "bps, effective speed: " + Math.min(this.myXmitSpeed, this.hisRecvSpeed)));
                }
                this.linkLimit.setLimit(Math.min(this.myXmitSpeed, this.hisRecvSpeed));
                this.updateBufferSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLocalSpeeds(int xmit, int recv) {
            recv = (int)((float)recv * this.duplexFactor);
            xmit = (int)((float)xmit * this.duplexFactor);
            Xmit xmit2 = this;
            synchronized (xmit2) {
                AsyncNetworkTransceiver tx;
                if (this.myRecvSpeed != recv) {
                    this.myRecvSpeed = recv;
                    if (DebugFlags.BANDWIDTH.show()) {
                        tx = AsyncNetworkTransceiver.this;
                        LogSupport.proxyMessage((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"setLocalSpeeds", (String)("Setting recv speed to " + recv + "bps"));
                    }
                    if (!this.shutdownPending) {
                        this.onControlPacket(new ControlPacket(1, this.myRecvSpeed));
                    }
                }
                if (this.myXmitSpeed != xmit) {
                    this.myXmitSpeed = xmit;
                    if (DebugFlags.BANDWIDTH.show()) {
                        tx = AsyncNetworkTransceiver.this;
                        LogSupport.proxyMessage((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"setLocalSpeeds", (String)("Setting xmit speed to " + xmit + "bps, effective speed: " + Math.min(this.myXmitSpeed, this.hisRecvSpeed)));
                    }
                    this.linkLimit.setLimit(Math.min(this.myXmitSpeed, this.hisRecvSpeed));
                    this.updateBufferSize();
                }
            }
        }

        public int getXmitSpeed() {
            return (int)this.linkLimit.getLimit();
        }

        @Override
        public void writeFailed(AsyncWriteQueue q, IOException iox) {
            AsyncNetworkTransceiver.this.logDisconnect("writeFailed", iox, "outputException");
            AsyncNetworkTransceiver.this.hangup((byte)3);
        }

        @Override
        public void writeIdle(AsyncWriteQueue q) {
            if (this.shutdownPending) {
                AsyncEndpoint endpoint = this.ep;
                this.ep = null;
                if (endpoint != null) {
                    endpoint.beginClose(null);
                }
            }
        }

        private void updateBufferSize() {
            int bSize = (int)(this.linkLimit.getLimit() / 5L / 8L);
            bSize = Math.min(bSize, 1600);
            bSize = Math.max(bSize, 500);
            if (DebugFlags.BANDWIDTH.show()) {
                AsyncNetworkTransceiver tx = AsyncNetworkTransceiver.this;
                LogSupport.proxyMessage((String)tx.getConferenceName(), (String)tx.getName(), (Object)this, (String)"updateBufferSize", (String)("Buffer size for " + AsyncNetworkTransceiver.this.getName() + " set to " + bSize + " bytes."));
            }
            this.bufferSize = bSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean more;
            AsyncWriteBuffer buf = null;
            long now = System.currentTimeMillis();
            Object object = this.procLock;
            synchronized (object) {
                if (!this.waiting) {
                    LogSupport.error((Object)this, (String)"run", (String)"I/O appointment when not in waiting state");
                }
                Object object2 = this.queueLock;
                synchronized (object2) {
                    buf = this.fillBuffer(now, (byte)4);
                }
                if (buf != null) {
                    int nBytes = buf.size();
                    AsyncNetworkTransceiver.this.stats.write(nBytes);
                    this.transmitQueue.send(buf);
                    this.waiting = false;
                }
            }
            do {
                Object object3 = this.procLock;
                synchronized (object3) {
                    more = this.processQueue("appointment");
                }
            } while (more);
        }
    }
}

