/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Appointment;
import com.elluminate.jinx.ChainedWorkQueue;
import com.elluminate.jinx.JinxTuning;
import com.elluminate.util.TimerResolution;
import com.elluminate.util.WorkQueue;
import com.elluminate.util.WorkerPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AppointmentScheduler
extends Thread {
    private static AppointmentScheduler scheduler = new AppointmentScheduler();
    private static final int TIMELINE_SIZE = 8192;
    private static final int TIMELINE_HORIZON = 6144;
    private static final long FUTURE_INTERVAL = 4096L;
    private static volatile boolean done = false;
    private AtomicReferenceArray<Appointment> timeline;
    private AtomicReference<Appointment> future = new AtomicReference<Object>(null);
    private Appointment END_MARKER = new Appointment();
    private long resolution = TimerResolution.get();
    private volatile long futureRescheduleTime = -1L;
    private volatile TimeBase timebase;
    private TimeBase[] timeBasePool = new TimeBase[2];
    private int timeBaseIdx = 0;
    private WorkerPool workerPool;
    private ChainedWorkQueue workQueue;

    protected AppointmentScheduler() {
        super("Appointment Scheduler");
        int i;
        this.setPriority(6);
        Appointment[] init = new Appointment[8192];
        for (i = 0; i < 8192; ++i) {
            init[i] = i < 6144 ? this.END_MARKER : null;
        }
        this.timeline = new AtomicReferenceArray<Appointment>(init);
        for (i = 0; i < 8192; ++i) {
            Appointment x;
            Appointment r = this.timeline.get(i);
            if (r == (x = i < 6144 ? this.END_MARKER : null)) continue;
            System.err.println(i + ": expected " + x + " got " + r);
        }
        this.timeBasePool[0] = new TimeBase();
        this.timeBasePool[1] = new TimeBase();
        this.timebase = this.timeBasePool[0];
        this.workQueue = new ChainedWorkQueue();
        this.workQueue.setEndMarker(this.END_MARKER);
        this.workerPool = new WorkerPool("AppointmentWorker", (WorkQueue)this.workQueue, JinxTuning.IOSchedulerDispatchPoolSize.getIntValue());
        this.setDaemon(true);
        this.start();
    }

    public long schedule(Runnable r, long time) {
        Appointment a = Appointment.getInstance(r, time);
        long at = this.schedule(a);
        if (at == 0L) {
            a.dispose();
        }
        return at;
    }

    @Override
    public void run() {
        long now;
        long last = now = System.currentTimeMillis();
        this.timeBasePool[this.timeBaseIdx].reset(now);
        this.timebase = this.timeBasePool[this.timeBaseIdx];
        while (!done) {
            now = System.currentTimeMillis();
            while (last == now) {
                try {
                    Thread.sleep(this.resolution);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            while (this.timebase.currentTime() < now) {
                Appointment a = this.timebase.inc();
                if (a != this.END_MARKER) {
                    this.workQueue.schedule(a);
                }
                if (this.timebase.atEnd()) {
                    this.timeBaseIdx = this.timeBaseIdx + 1 & 1;
                    this.timeBasePool[this.timeBaseIdx].reset(this.timebase.currentTime());
                    this.timebase = this.timeBasePool[this.timeBaseIdx];
                }
                last = now;
            }
            long t = this.futureRescheduleTime;
            if (t <= 0L || now <= t) continue;
            this.reschedule();
        }
        this.workerPool.shutdown();
    }

    private long schedule(Appointment a) {
        int interval = this.timebase.getInterval(a.getSchedule());
        if (interval < 0) {
            return 0L;
        }
        if (interval == 8192) {
            if (this.futureRescheduleTime < 0L) {
                Appointment next;
                long now = System.currentTimeMillis();
                this.futureRescheduleTime = now + 4096L;
                do {
                    next = this.future.get();
                    a.setNext(next);
                } while (!this.future.compareAndSet(next, a));
            }
        } else {
            Appointment next;
            do {
                if ((next = this.timeline.get(interval)) == null) {
                    return 0L;
                }
                a.setNext(next);
            } while (!this.timeline.compareAndSet(interval, next, a));
        }
        return a.getSchedule();
    }

    private void reschedule() {
        this.futureRescheduleTime = -1L;
        Appointment head = this.future.getAndSet(null);
        while (head != null) {
            Appointment next = (Appointment)head.getNext();
            if (this.schedule(head) == 0L) {
                head.run();
            }
            head = next;
        }
    }

    public static AppointmentScheduler getInstance() {
        return scheduler;
    }

    public static void shutdown() {
        done = true;
    }

    private class TimeBase {
        private volatile long timebase;
        private volatile int now;
        private volatile int horizon;

        private TimeBase() {
        }

        public void reset(long clk) {
            this.timebase = clk;
            this.now = 0;
            this.horizon = 6143;
        }

        public Appointment inc() {
            ++this.horizon;
            int horizonWrapped = this.horizon % 8192;
            if (AppointmentScheduler.this.timeline.getAndSet(horizonWrapped, AppointmentScheduler.this.END_MARKER) != null) {
                throw new RuntimeException("AppointmentScheduler timeline not null at horizon.");
            }
            return AppointmentScheduler.this.timeline.getAndSet(this.now++, null);
        }

        public boolean atEnd() {
            return this.now == 8192;
        }

        public long currentTime() {
            return this.timebase + (long)this.now * AppointmentScheduler.this.resolution;
        }

        public int getInterval(long clock) {
            long delta = (clock - this.timebase) / AppointmentScheduler.this.resolution;
            if (delta <= (long)this.now) {
                return -1;
            }
            if (delta > (long)this.horizon) {
                return 8192;
            }
            return (int)(delta % 8192L);
        }
    }
}

