/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.engine.command;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandNotChairException;
import com.elluminate.engine.CommandNotOnlineException;
import com.elluminate.engine.command.Command;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.provider.ConnectionProvider;
import com.google.inject.Inject;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public abstract class AbstractCommand
extends AbstractUndoableEdit
implements Command {
    private static final long serialVersionUID = 1L;
    private ConnectionProvider cp;
    private UndoableEditSupport undoSupport;
    private Boolean undoable = null;
    private Boolean redoable = null;

    protected AbstractCommand() {
    }

    @Inject
    public void initConnectionProvider(ConnectionProvider cp) {
        this.cp = cp;
    }

    public void setUndoSupport(UndoableEditSupport undoSupport) {
        this.undoSupport = undoSupport;
    }

    @Override
    public final void execute() throws CommandExecutionException {
        this.doexecute();
        if (this.undoSupport != null) {
            this.undoSupport.postEdit(this);
        }
    }

    @Override
    public final boolean canUndo() {
        if (this.undoable == null) {
            try {
                this.getClass().getDeclaredMethod("unexecute", null);
                this.undoable = Boolean.TRUE;
            }
            catch (Exception ex) {
                this.undoable = Boolean.FALSE;
            }
        }
        return this.undoable;
    }

    @Override
    public final void undo() throws CannotUndoException {
        try {
            this.unexecute();
        }
        catch (CommandExecutionException ex) {
            throw new CannotUndoException();
        }
    }

    @Override
    public final boolean canRedo() {
        if (this.redoable == null) {
            try {
                this.getClass().getDeclaredMethod("reexecute", null);
                this.redoable = Boolean.TRUE;
            }
            catch (Exception ex) {
                this.redoable = Boolean.FALSE;
            }
        }
        return this.redoable;
    }

    @Override
    public final void redo() throws CannotRedoException {
        try {
            this.reexecute();
        }
        catch (CommandExecutionException ex) {
            throw new CannotRedoException();
        }
    }

    @Override
    public final String getPresentationName() {
        return this.getLocalizedDescription();
    }

    protected abstract void doexecute() throws CommandExecutionException;

    protected void unexecute() throws CommandExecutionException {
    }

    protected void reexecute() throws CommandExecutionException {
    }

    protected String getLocalizedDescription() {
        return "";
    }

    protected boolean isOnline() {
        Connection c = this.cp.get();
        if (c != null) {
            return c.isConnected();
        }
        return false;
    }

    protected void validateIsOnline() throws CommandNotOnlineException {
        if (!this.isOnline()) {
            throw new CommandNotOnlineException("Not online");
        }
    }

    protected boolean isChair() {
        return true;
    }

    protected void validateIsChair() throws CommandNotChairException {
        if (!this.isChair()) {
            throw new CommandNotChairException("Not a chair");
        }
    }

    protected void validateIsOnlineAndIsChair() throws CommandExecutionException {
        this.validateIsOnline();
        this.validateIsChair();
    }
}

