/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.accessibility.cli;

import com.elluminate.accessibility.cli.AbstractCommandHandler;
import com.elluminate.accessibility.cli.CLICommandUsageException;
import com.elluminate.engine.CommandInstantiationException;
import com.elluminate.engine.CommandNotFoundException;
import com.elluminate.engine.command.Command;
import com.elluminate.util.QuotedStringTokenizer;
import java.util.LinkedHashMap;

public abstract class OptionMapCommandHandler
extends AbstractCommandHandler {
    private Class commandClass;
    private LinkedHashMap<String, Object> optionMap = new LinkedHashMap();

    protected OptionMapCommandHandler(Class commandClass) {
        this.commandClass = commandClass;
    }

    protected void mapOption(String parameter, Object commandOption) {
        this.optionMap.put(parameter, commandOption);
    }

    @Override
    public String getParameterUsage() {
        return OptionMapCommandHandler.joinChoices(this.optionMap.keySet());
    }

    @Override
    public Command prepareCommand(QuotedStringTokenizer args) throws CommandNotFoundException, CommandInstantiationException, CLICommandUsageException {
        if (args.countTokens() != 1) {
            throw new CLICommandUsageException();
        }
        Object opt = this.optionMap.get(args.nextToken().toLowerCase());
        if (opt == null) {
            throw new CLICommandUsageException();
        }
        Command cmd = this.createCommand(this.commandClass);
        this.configureCommand(cmd, opt);
        return cmd;
    }

    protected abstract void configureCommand(Command var1, Object var2);
}

