/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.accessibility.cli;

import com.elluminate.accessibility.cli.CLICommandException;
import com.elluminate.accessibility.cli.CLICommandUsageException;
import com.elluminate.accessibility.cli.CommandHandler;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandInstantiationException;
import com.elluminate.engine.CommandNotChairException;
import com.elluminate.engine.CommandNotFoundException;
import com.elluminate.engine.CommandNotOnlineException;
import com.elluminate.engine.CommandNotPlaybackException;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.engine.command.Command;
import com.elluminate.util.QuotedStringTokenizer;
import java.util.HashMap;

public class AccessibilityInterpreter {
    private ConferencingEngine conferencingEngine;
    private HashMap<String, CommandDescriptor> commands = new HashMap();

    public void registerCommand(String name, Class handler) {
        this.commands.put(name.toLowerCase(), new CommandDescriptor(name, handler));
    }

    public boolean processCommand(String commandLine) throws CLICommandException {
        Command cmd;
        CommandHandler hdlr;
        if (!commandLine.startsWith("/")) {
            return false;
        }
        QuotedStringTokenizer parser = new QuotedStringTokenizer(commandLine.substring(1));
        if (!parser.hasMoreTokens()) {
            return false;
        }
        String commandName = parser.nextToken();
        CommandDescriptor desc = this.commands.get(commandName.toLowerCase());
        if (desc == null) {
            return false;
        }
        try {
            hdlr = (CommandHandler)desc.handler.newInstance();
            hdlr.setConferencingEngine(this.getConferencingEngine());
        }
        catch (InstantiationException ex) {
            return false;
        }
        catch (IllegalAccessException ex) {
            return false;
        }
        try {
            cmd = hdlr.prepareCommand(parser);
        }
        catch (CLICommandUsageException ex) {
            ex.setCommandName(commandName);
            ex.setParameterUsage(hdlr.getParameterUsage());
            throw ex;
        }
        catch (CommandNotFoundException ex) {
            return false;
        }
        catch (CommandInstantiationException ex) {
            return false;
        }
        try {
            cmd.execute();
        }
        catch (CommandNotOnlineException ex) {
            throw new CLICommandException(ex);
        }
        catch (CommandNotChairException ex) {
            throw new CLICommandException(ex);
        }
        catch (CommandNotPlaybackException ex) {
            throw new CLICommandException(ex);
        }
        catch (CommandExecutionException ex) {
            throw new CLICommandException(ex);
        }
        return true;
    }

    public ConferencingEngine getConferencingEngine() {
        return this.conferencingEngine;
    }

    public void setConferencingEngine(ConferencingEngine conferencingEngine) {
        this.conferencingEngine = conferencingEngine;
    }

    private static class CommandDescriptor {
        public String name;
        public Class handler;

        public CommandDescriptor(String name, Class handler) {
            this.name = name;
            this.handler = handler;
        }
    }
}

