/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.moduleloading.states;

import com.elluminate.framework.moduleloading.states.ModulesState;
import com.elluminate.framework.moduleloading.states.StateKey;
import java.util.HashMap;

public class ModulesStateClerk {
    private HashMap<ModulesState.Grouping, Integer> groupingCounts = new HashMap();
    private HashMap<StateKey, ModulesState> states = new HashMap();

    public ModulesStateClerk() {
        this.addLoadState("init");
        this.addLoadState("create");
        this.addLoadState("start");
        this.addLoadState("attach");
        this.addUnloadState("detach");
        this.addUnloadState("stop");
    }

    public ModulesState getState(String name, ModulesState.Status status) {
        return this.states.get(new StateKey(name, status));
    }

    public void addLoadState(String stateName) {
        this.addState(stateName, ModulesState.Grouping.STARTUP);
    }

    public void addUnloadState(String stateName) {
        this.addState(stateName, ModulesState.Grouping.RUNTIME);
    }

    private void addState(String stateName, ModulesState.Grouping grouping) {
        this.addState(stateName, ModulesState.Status.ENTERING, grouping);
        this.addState(stateName, ModulesState.Status.EXITING, grouping);
    }

    private void addState(String name, ModulesState.Status status, ModulesState.Grouping grouping) {
        StateKey key = new StateKey(name, status);
        if (this.checkKeyExists(key, grouping)) {
            return;
        }
        this.states.put(key, new ModulesState(name, status, grouping, this.addAndGetCount(grouping)));
    }

    private boolean checkKeyExists(StateKey key, ModulesState.Grouping grouping) {
        ModulesState state = this.states.get(key);
        if (state == null) {
            return false;
        }
        state.throwExceptionIfInvalidGrouping(grouping);
        return true;
    }

    private int addAndGetCount(ModulesState.Grouping grouping) {
        if (!this.groupingCounts.containsKey((Object)grouping)) {
            this.groupingCounts.put(grouping, 0);
        }
        int newCount = this.groupingCounts.get((Object)grouping) + 1;
        this.groupingCounts.put(grouping, newCount);
        return newCount;
    }
}

