/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.moduleloading.locator;

import com.elluminate.framework.moduleloading.Module;
import com.elluminate.framework.moduleloading.ModuleLocator;
import com.elluminate.util.log.LogSupport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;

public class ClassPathModuleLocator<T extends Module>
implements ModuleLocator<T> {
    protected static final String MODULE_PACKAGES = "module.packages";
    protected static final String MODULE_SUBPACKAGES = "subpackages";
    protected static final String MODULE_LIST = "module.list";
    protected static final String MODULE_UNLOAD_LIST = "unload";
    private Properties props;
    private String[] notLoadedModules;

    public void appendPropertiesLocation(String propsFileLocation) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.appendPropertiesFromClasspath(propsFileLocation, this.props);
    }

    public void setProperties(Properties p) {
        this.props = p;
    }

    public void appendProperties(Properties p) {
        if (this.props == null) {
            this.props = new Properties();
        }
        if (p != null) {
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.mergeProperty(key, p.getProperty(key), this.props);
            }
        }
    }

    protected void appendPropertiesFromClasspath(String propsFileLocation, Properties origProps) {
        if (propsFileLocation == null) {
            throw new IllegalStateException("The location containing the list of modules to load can not be null");
        }
        if (origProps == null) {
            throw new IllegalStateException("The properties file to populate can not be null");
        }
        Properties props = new Properties();
        try {
            if (!propsFileLocation.startsWith("/")) {
                propsFileLocation = "/" + propsFileLocation;
            }
            InputStream is = this.getClass().getResourceAsStream(propsFileLocation);
            props.load(is);
            is.close();
        }
        catch (Exception e) {
            throw new MissingResourceException("Unable to find properties file", null, null);
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.mergeProperty(key, props.getProperty(key), origProps);
        }
    }

    private void mergeProperty(String key, String value, Properties props) {
        if (props.containsKey(key)) {
            props.put(key, props.get(key) + "," + value);
        } else {
            props.put(key, value);
        }
    }

    protected List<Class<T>> findModuleClasses(String[] basePaths, String[] subPackages, String[] modules) {
        ArrayList<Class<T>> moduleClasses = new ArrayList<Class<T>>();
        for (String module : modules) {
            module = module.trim();
            boolean loadModule = true;
            if (this.notLoadedModules != null && this.notLoadedModules.length > 0) {
                for (String unloaded : this.notLoadedModules) {
                    if (!unloaded.equals(module)) continue;
                    loadModule = false;
                    break;
                }
            }
            if (!loadModule) continue;
            for (String pkg : basePaths) {
                Class<T> c = this.findModuleClass(module, pkg = pkg.trim(), subPackages);
                if (c == null) continue;
                moduleClasses.add(c);
            }
        }
        return moduleClasses;
    }

    protected Class<T> findModuleClass(String moduleName, String pkg, String[] subPackages) {
        String modulePackage = moduleName.toLowerCase(Locale.ENGLISH);
        String moduleClass = moduleName + "Module";
        String fullName = pkg + "." + modulePackage + "." + moduleClass;
        Class<T> c = this.findClass(fullName);
        if (c != null) {
            return c;
        }
        for (String subPkg : subPackages) {
            subPkg = subPkg.trim();
            fullName = pkg + "." + modulePackage + "." + subPkg + "." + moduleClass;
            c = this.findClass(fullName);
            if (c == null) continue;
            return c;
        }
        LogSupport.log((String)("Unable to find/load the [" + moduleName + "] Module in [" + pkg + "]"));
        return null;
    }

    private Class<T> findClass(String fullName) {
        try {
            return Class.forName(fullName);
        }
        catch (Exception notFound) {
            return null;
        }
    }

    @Override
    public void noteNotloadedModules(String[] notLoadedModules) {
        this.notLoadedModules = notLoadedModules;
    }

    @Override
    public List<Class<T>> locateModuleClasses() {
        if (this.props == null) {
            throw new IllegalStateException("A module list has not been provided");
        }
        String[] basePackages = this.props.getProperty(MODULE_PACKAGES).split(",");
        String[] modules = this.props.getProperty(MODULE_LIST).split(",");
        String[] subPackages = new String[]{};
        try {
            subPackages = this.props.getProperty(MODULE_SUBPACKAGES).split(",");
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        return this.findModuleClasses(basePackages, subPackages, modules);
    }
}

