/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.moduleloading;

import com.elluminate.framework.moduleloading.ProgressEvent;
import com.elluminate.framework.moduleloading.ProgressListener;
import com.elluminate.framework.moduleloading.ProgressSrc;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionMonitor {
    private ListenerRegistry<ProgressListener> progressListeners;
    private AtomicInteger progress = new AtomicInteger();
    private ProgressSrc src;

    @Inject
    public void initPorgressListeners(ListenerRegistry<ProgressListener> progressListeners) {
        this.progressListeners = progressListeners;
    }

    public void setProgressSrc(ProgressSrc src) {
        this.src = src;
    }

    public List<Runnable> instrument(List<Runnable> runnables) {
        ArrayList<Runnable> wrappedRunnables = new ArrayList<Runnable>(runnables.size());
        for (Runnable r : runnables) {
            wrappedRunnables.add(this.wrap(r));
        }
        return wrappedRunnables;
    }

    private Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                r.run();
                ExecutionMonitor.this.ran();
            }
        };
    }

    private void ran() {
        final ProgressEvent event = new ProgressEvent(this.progress.addAndGet(1), this.src);
        this.progressListeners.fire((FiringFunctor)new FiringFunctor<ProgressListener>(){

            public void fire(ProgressListener listener) {
                listener.progressUpdated(event);
            }
        });
    }

    public void addProgressListener(ProgressListener pl) {
        this.progressListeners.add((Object)pl);
    }
}

