/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.SimulatedKeyStroke;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@Singleton
public class SimulatedKeysPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private SimulatedKeyModel keyModel;
    private JTable keyTable;
    private JScrollPane keyScroller;
    private JButton addBtn;
    private JButton changeBtn;
    private JButton removeBtn;
    private ArrayList simulatedKeys = new ArrayList();

    @Inject
    public SimulatedKeysPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout(0, 6));
        this.add(p, "North");
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn(0);
        column.setResizable(true);
        column.setHeaderValue(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_KEYSTROKECOLUMN));
        columnModel.addColumn(column);
        column = new TableColumn(1, 100);
        column.setResizable(true);
        column.setMinWidth(60);
        column.setMaxWidth(300);
        column.setPreferredWidth(150);
        column.setHeaderValue(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_TRIGGERCOLUMN));
        columnModel.addColumn(column);
        column = new TableColumn(2, 32);
        column.setResizable(false);
        column.setMinWidth(60);
        column.setMaxWidth(120);
        column.setPreferredWidth(80);
        column.setHeaderValue(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_TARGETCOLUMN));
        columnModel.addColumn(column);
        this.keyModel = new SimulatedKeyModel();
        this.keyTable = new CTable((TableModel)this.keyModel, (TableColumnModel)columnModel);
        this.keyTable.setSelectionMode(0);
        this.keyTable.setShowGrid(false);
        this.keyTable.setIntercellSpacing(new Dimension(0, 1));
        this.keyTable.setFocusTraversalKeys(0, null);
        this.keyTable.setFocusTraversalKeys(1, null);
        this.keyScroller = new JScrollPane(this.keyTable, 22, 31);
        this.keyScroller.setPreferredSize(new Dimension(300, 200));
        this.keyScroller.getViewport().setBackground(this.keyTable.getBackground());
        this.keyScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SimulatedKeysPrefsPanel.this.keyTable.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SimulatedKeysPrefsPanel.this.keyTable.clearSelection();
            }
        });
        this.keyTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getClickCount() == 2 && SimulatedKeysPrefsPanel.this.changeBtn.isEnabled()) {
                    SimulatedKeysPrefsPanel.this.changeBtn.doClick();
                }
            }
        });
        this.keyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SimulatedKeysPrefsPanel.this.enableButtons();
            }
        });
        this.addBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_ADDBTN));
        this.addBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_ADDBTNTIP));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulatedKeysPrefsPanel.this.doAddButton();
            }
        });
        this.changeBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_CHANGEBTN));
        this.changeBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_CHANGEBTNTIP));
        this.changeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulatedKeysPrefsPanel.this.doModifyButton();
            }
        });
        this.removeBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_REMOVEBTN));
        this.removeBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_REMOVEBTNTIP));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulatedKeysPrefsPanel.this.doRemoveButton();
            }
        });
        JPanel bottomPanel = new JPanel(new FlowLayout(2, 0, 0));
        bottomPanel.add(this.addBtn);
        bottomPanel.add(Box.createHorizontalStrut(6));
        bottomPanel.add(this.changeBtn);
        bottomPanel.add(Box.createHorizontalStrut(6));
        bottomPanel.add(this.removeBtn);
        MultilineLabel exposition = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_EXPOSITORYTEXT));
        p.add((Component)exposition, "North");
        p.add((Component)this.keyScroller, "Center");
        p.add((Component)bottomPanel, "South");
        this.enableButtons();
    }

    private void enableButtons() {
        boolean en = this.keyTable.getSelectedRowCount() > 0;
        this.changeBtn.setEnabled(en);
        this.removeBtn.setEnabled(en);
    }

    private void doAddButton() {
        SimulatedKeyStroke newKey = new SimulatedKeyStroke();
        if (!newKey.showConfigureDialog(this.keyTable) || !newKey.isValid()) {
            return;
        }
        this.simulatedKeys.add(newKey);
        int row = this.simulatedKeys.size() - 1;
        this.keyModel.fireTableRowsInserted(row, row);
        try {
            this.keyTable.setRowSelectionInterval(row, row);
        }
        catch (IndexOutOfBoundsException ex) {
            LogSupport.exception((Object)((Object)this), (String)"doAddButton", (Throwable)ex, (boolean)false);
        }
        this.setModified(true);
    }

    private void doModifyButton() {
        int row = this.keyTable.getSelectedRow();
        if (row == -1 || row >= this.simulatedKeys.size()) {
            return;
        }
        SimulatedKeyStroke key = (SimulatedKeyStroke)this.simulatedKeys.get(row);
        if (!key.showConfigureDialog(this.keyTable) || !key.isValid()) {
            return;
        }
        this.keyModel.fireTableRowsUpdated(row, row);
        this.setModified(true);
    }

    private void doRemoveButton() {
        int row = this.keyTable.getSelectedRow();
        if (row == -1 || row >= this.simulatedKeys.size()) {
            return;
        }
        this.simulatedKeys.remove(row);
        this.keyModel.fireTableRowsDeleted(row, row);
        this.setModified(true);
    }

    protected void populate(Preferences preferences) {
        int oldKeyCount = this.simulatedKeys.size();
        this.simulatedKeys.clear();
        String data = preferences.getSetting(this.getOwnerPrefix() + ".keystrokes");
        if (data != null) {
            this.simulatedKeys.addAll(SimulatedKeyStroke.parseSet(data));
        } else {
            this.simulatedKeys.addAll(SimulatedKeyStroke.makeDefaultSet());
        }
        int keyCount = this.simulatedKeys.size();
        if (oldKeyCount > keyCount) {
            this.keyModel.fireTableRowsDeleted(keyCount, oldKeyCount - 1);
        }
        this.keyModel.fireTableRowsUpdated(0, Math.min(keyCount, oldKeyCount) - 1);
        if (oldKeyCount < keyCount) {
            this.keyModel.fireTableRowsInserted(oldKeyCount, keyCount - 1);
        }
    }

    protected void apply(Preferences preferences) {
        String data = SimulatedKeyStroke.formatSet(this.simulatedKeys);
        preferences.setSetting(this.getOwnerPrefix() + ".keystrokes", data);
    }

    protected void reset(Preferences preferences) {
        ArrayList keys = SimulatedKeyStroke.makeDefaultSet();
        String data = SimulatedKeyStroke.formatSet(keys);
        preferences.setSetting(this.getOwnerPrefix() + ".keystrokes", data);
    }

    private class SimulatedKeyModel
    extends AbstractTableModel {
        private SimulatedKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SimulatedKeysPrefsPanel.this.simulatedKeys.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                SimulatedKeyStroke key = (SimulatedKeyStroke)SimulatedKeysPrefsPanel.this.simulatedKeys.get(row);
                switch (column) {
                    case 0: {
                        return key.getKeystroke();
                    }
                    case 1: {
                        return key.getTriggerKeyText();
                    }
                    case 2: {
                        String target = key.getLocalizedHostName();
                        if (target == null || target.length() == 0) {
                            target = SimulatedKeysPrefsPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_ALLTARGET);
                        }
                        return target;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

