/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.AppShareController;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.DisabledIcon;
import com.elluminate.gui.component.DropShadowBorder;
import com.elluminate.gui.swing.CTree;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ShareSelectPanel
extends JPanel {
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private static I18n i18n = I18n.create(ShareSelectPanel.class);
    private static Rectangle prevBounds = null;
    private static final String emptyListBkgText = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EMPTYLISTTEXT);
    private static final String expandAllName = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXPANDALLBTN);
    private static final String expandAllTip = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXPANDALLTIP);
    private static final String collapseAllName = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_COLLAPSEALLBTN);
    private static final String collapseAllTip = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_COLLAPSEALLTIP);
    JButton okBtn = new JButton();
    JButton cancelBtn = new JButton();
    JCheckBox desktop = new JCheckBox();
    Rectangle returnRegion = null;
    Object[] returnApps = null;
    DefaultMutableTreeNode desktopRoot = new DefaultMutableTreeNode();
    DefaultTreeModel desktopTreeModel = new DefaultTreeModel(this.desktopRoot);
    DesktopTreeCellRenderer desktopRenderer = new DesktopTreeCellRenderer();
    AppTree desktopTree = new AppTree(this.desktopTreeModel);
    JScrollPane desktopScroller = new JScrollPane();
    DefaultMutableTreeNode appRoot = new DefaultMutableTreeNode();
    DefaultTreeModel appTreeModel = new DefaultTreeModel(this.appRoot);
    AppTreeCellRenderer appRenderer = new AppTreeCellRenderer();
    AppTree appTree = new AppTree(this.appTreeModel);
    JScrollPane appScroller = new JScrollPane();
    JPanel appPanel = new JPanel();
    JCheckBox excludeMenus = new JCheckBox();
    JButton appExpander = null;
    AppSharingHost host = null;
    AppShareController ctl = null;
    ApplicationInformation[] prevApps = null;
    Frame top = null;
    String appName = null;
    Icon appIcon = null;
    boolean isHosting = false;
    UpdaterTask timerTask = new UpdaterTask();
    LightweightTimer timer = new UpdateTimer(this.timerTask);

    public ShareSelectPanel(Frame top, String appName, Icon appIcon, AppSharingHost host, AppShareController ctl) {
        Rectangle dt;
        Rectangle r;
        this.top = top;
        this.appName = appName;
        this.appIcon = appIcon;
        this.host = host;
        this.ctl = ctl;
        try {
            this.jbInit();
            this.excludeMenus.setVisible(host.isExcludeMenuBarSupported());
            this.excludeMenus.setSelected(host.getExcludeMenuBar());
            this.setupDesktopTreeListeners();
            this.setupAppTreeListeners();
            this.desktop.setSelected(false);
            this.okBtn.setEnabled(false);
            this.appTree.clearSelection();
            this.desktopTree.clearSelection();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"ShareSelectDialog", (Throwable)ex, (boolean)true);
        }
        if (prevBounds != null && !(r = (dt = GuiUtils.getDesktopBounds()).intersection(prevBounds)).isEmpty()) {
            this.setBounds(r);
        }
    }

    private void setupAppTreeListeners() {
        this.appTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (!ShareSelectPanel.this.appTree.isEnabled()) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    ShareSelectPanel.this.doOk();
                    me.consume();
                }
            }
        });
        this.appTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!ShareSelectPanel.this.appTree.isEnabled()) {
                    return;
                }
                if (e.getNewLeadSelectionPath() == null) {
                    ShareSelectPanel.this.updateShareBtnStatus();
                } else {
                    ShareSelectPanel.this.updateAppTree();
                }
            }
        });
        this.setupSelectionActivateKeyMap((JComponent)((Object)this.appTree));
    }

    private void setupDesktopTreeListeners() {
        this.desktopTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (!ShareSelectPanel.this.desktopTree.isEnabled()) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    ShareSelectPanel.this.doOk();
                    me.consume();
                }
            }
        });
        this.desktopTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!ShareSelectPanel.this.desktopTree.isEnabled()) {
                    return;
                }
                if (e.getNewLeadSelectionPath() == null) {
                    ShareSelectPanel.this.updateShareBtnStatus();
                } else {
                    ShareSelectPanel.this.updateDesktopTree();
                }
            }
        });
        this.setupSelectionActivateKeyMap((JComponent)((Object)this.desktopTree));
    }

    private void setupSelectionActivateKeyMap(JComponent comp) {
        KeyStroke space = KeyStroke.getKeyStroke(32, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        String key = "action-appshare";
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectPanel.this.doOk();
            }
        };
        comp.getInputMap(2).put(space, key);
        comp.getInputMap(2).put(enter, key);
        comp.getActionMap().put(key, action);
    }

    private void updateShareBtnStatus() {
        if (this.desktopTree.getSelectionCount() == 0 && this.appTree.getSelectionCount() == 0) {
            this.okBtn.setEnabled(false);
        } else {
            this.okBtn.setEnabled(true);
        }
        this.desktop.setSelected(this.desktopTree.getSelectionCount() != 0);
    }

    private void updateDesktopTree() {
        this.appTree.clearSelection();
        this.updateShareBtnStatus();
    }

    private void updateAppTree() {
        this.desktopTree.clearSelection();
        this.normalizeAppSelection();
        this.updateShareBtnStatus();
    }

    void start() {
        this.setHosting(false);
        this.desktop.setSelected(false);
        this.setContainerEnabled(true, true, true);
        this.prevApps = null;
        this.timer.scheduleIn(250L);
    }

    void jbInit() throws Exception {
        this.desktop.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SHAREDESKTOP));
        this.desktop.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SHAREDESKTOPTIP));
        this.desktop.setIcon(i18n.getIcon((PropertiesEnum)StringsProperties.APPSHAREMODULE_DESKTOPICON));
        this.desktop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ShareSelectPanel.this.okBtn.setEnabled(e.getStateChange() == 1);
            }
        });
        this.cancelBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_CANCEL));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectPanel.this.cancelBtn_actionPerformed(e);
            }
        });
        this.okBtn.setEnabled(false);
        this.okBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_OK));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectPanel.this.okBtn_actionPerformed(e);
            }
        });
        int dtRowHt = Math.max(16, this.desktopTree.getFont().getSize() * 5 / 4) + 2;
        this.desktopTree.getSelectionModel().setSelectionMode(4);
        this.desktopTree.setRootVisible(false);
        this.desktopTree.setShowsRootHandles(true);
        this.desktopTree.setCellRenderer(this.desktopRenderer);
        this.desktopTree.setRenderersHaveToolTips(false);
        this.desktopTree.setRowHeight(dtRowHt);
        this.desktopTree.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        int appRowHt = Math.max(16, this.appTree.getFont().getSize() * 5 / 4) + 4;
        this.appTree.getSelectionModel().setSelectionMode(4);
        this.appTree.setRootVisible(false);
        this.appTree.setShowsRootHandles(true);
        this.appTree.emptyText = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_GETAPPLISTTEXT);
        this.appTree.setCellRenderer(this.appRenderer);
        this.appTree.setRenderersHaveToolTips(true);
        this.appTree.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREETIP));
        this.appTree.setRowHeight(appRowHt);
        this.appTree.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.appExpander = new JButton(expandAllName);
        this.appExpander.setToolTipText(expandAllTip);
        this.appExpander.addActionListener(new ActionListener(){
            boolean doExpand = true;

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (this.doExpand) {
                    ShareSelectPanel.this.appExpander.setText(collapseAllName);
                    ShareSelectPanel.this.appExpander.setToolTipText(collapseAllTip);
                    this.doExpand = false;
                    ShareSelectPanel.this.appTree.expandAll();
                } else {
                    ShareSelectPanel.this.appExpander.setText(expandAllName);
                    ShareSelectPanel.this.appExpander.setToolTipText(expandAllTip);
                    this.doExpand = true;
                    ShareSelectPanel.this.appTree.collapseAll();
                }
            }
        });
        this.desktopScroller.setViewportView((Component)((Object)this.desktopTree));
        this.desktopScroller.setHorizontalScrollBarPolicy(31);
        this.desktopScroller.setVerticalScrollBarPolicy(20);
        this.desktopScroller.getViewport().setPreferredSize(new Dimension(400, dtRowHt + 8));
        this.desktopScroller.getViewport().setMinimumSize(new Dimension(256, dtRowHt + 8));
        this.desktopScroller.getViewport().setMaximumSize(new Dimension(32768, dtRowHt + 8));
        this.desktopScroller.getViewport().setBackground(this.desktopTree.getBackground());
        this.desktopScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ShareSelectPanel.this.desktopTree.clearSelection();
                ShareSelectPanel.this.desktopTree.requestFocus();
            }
        });
        this.appScroller.setViewportView((Component)((Object)this.appTree));
        this.appScroller.setHorizontalScrollBarPolicy(30);
        this.appScroller.setVerticalScrollBarPolicy(20);
        this.appScroller.getViewport().setPreferredSize(new Dimension(400, appRowHt * 3));
        this.appScroller.getViewport().setMinimumSize(new Dimension(256, appRowHt * 3));
        this.appScroller.getViewport().setBackground(this.appTree.getBackground());
        this.appScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ShareSelectPanel.this.appTree.clearSelection();
                ShareSelectPanel.this.appTree.requestFocus();
            }
        });
        this.excludeMenus.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXCLUDEMENUBAR));
        this.excludeMenus.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXCLUDEMENUBARTIP));
        if (this.host.isExcludeMenuBarSupported()) {
            this.excludeMenus.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    if (ShareSelectPanel.this.excludeMenus.isVisible()) {
                        ShareSelectPanel.this.host.setExcludeMenuBar(ShareSelectPanel.this.excludeMenus.isSelected());
                    }
                }
            });
        }
        JPanel appBtnPaneContainer = new JPanel(new BorderLayout());
        JPanel appBtnPane = new JPanel(new FlowLayout());
        JPanel appOptionPane = new JPanel(new FlowLayout());
        if (this.host.isExcludeMenuBarSupported()) {
            appOptionPane.add(this.excludeMenus);
        }
        appBtnPaneContainer.add((Component)appBtnPane, "East");
        appBtnPaneContainer.add((Component)appOptionPane, "West");
        String description = i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_SELECTSHARESCREENTEXT);
        JLabel descLabel = new JLabel(description);
        String availableSharingSelections = i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_AVAILABLESHARINGSELECTIONSTEXT);
        JLabel titleLabel = new JLabel(availableSharingSelections);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.appPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 21;
        gbc.insets.top = 12;
        gbc.insets.bottom = 0;
        gbc.insets.left = 12;
        gbc.insets.right = 12;
        this.appPanel.add((Component)descLabel, gbc);
        this.appPanel.add((Component)titleLabel, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        this.appPanel.add((Component)this.desktopScroller, gbc);
        gbc.insets.top = 12;
        gbc.weighty = 0.8;
        this.appPanel.add((Component)this.appScroller, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 8;
        gbc.weighty = 0.0;
        this.appPanel.add((Component)appBtnPaneContainer, gbc);
        this.appPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel shadowDropper = new JPanel(new BorderLayout());
        shadowDropper.setOpaque(false);
        shadowDropper.add((Component)this.appPanel, "Center");
        shadowDropper.setBorder((Border)new DropShadowBorder(Color.BLACK, 0.6f, 60.0, 7));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 16, 24, 16));
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        this.add(Box.createHorizontalStrut(8), gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)shadowDropper, gbc);
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        this.add(Box.createHorizontalStrut(8), gbc);
        if (this.ctl != null) {
            appBtnPane.add(this.cancelBtn);
            appBtnPane.add(this.okBtn);
        }
    }

    void setApplications(ApplicationInformation[] curApps) {
        if (this.appTree.emptyText != emptyListBkgText) {
            this.appTree.emptyText = emptyListBkgText;
        }
        if (curApps == this.prevApps) {
            return;
        }
        Object[] expanded = this.getExpandedApps();
        Object[] selected = this.getSelectedApps();
        this.repopulateDesktopTree();
        this.repopulateAppTree(curApps);
        this.setSelectedApps(selected);
        this.expandApps(expanded);
        this.prevApps = curApps;
    }

    private void repopulateAppTree(ApplicationInformation[] curApps) {
        this.appRoot.removeAllChildren();
        for (int ix = 0; ix < curApps.length; ++ix) {
            this.appRoot.add(this.createAppNode(curApps[ix]));
        }
        this.appTreeModel.nodeStructureChanged(this.appRoot);
    }

    private void repopulateDesktopTree() {
        this.desktopRoot.removeAllChildren();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.desktop, false);
        this.desktopRoot.add(node);
        this.desktopTreeModel.nodeStructureChanged(this.desktopRoot);
    }

    private MutableTreeNode createAppNode(ApplicationInformation app) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(app, true);
        int nWins = app.getWindowCount();
        if (nWins > 1) {
            for (int ix = 0; ix < nWins; ++ix) {
                node.add(new WindowTreeNode(app.getWindowTitle(ix), app.getAppName(), app.getWindowIcon(ix)));
            }
        }
        return node;
    }

    private void normalizeAppSelection() {
        int[] indices = this.appTree.getSelectionRows();
        if (indices == null || indices.length == 0) {
            return;
        }
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>(indices.length);
        for (int ix = 0; ix < indices.length; ++ix) {
            TreePath path = this.appTree.getPathForRow(indices[ix]);
            if (path.getPathCount() < 2) continue;
            while (path.getPathCount() > 2) {
                path = path.getParentPath();
            }
            if (selectedPaths.contains(path)) continue;
            selectedPaths.add(path);
        }
        if (selectedPaths.isEmpty()) {
            this.appTree.clearSelection();
        } else {
            TreePath[] paths = new TreePath[selectedPaths.size()];
            paths = selectedPaths.toArray(paths);
            this.appTree.setSelectionPaths(paths);
        }
    }

    private Object[] getSelectedApps() {
        int[] indices = this.appTree.getSelectionRows();
        if (indices == null || indices.length == 0) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            TreePath path = this.appTree.getPathForRow(indices[i]);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!this.appRoot.isNodeChild(node)) continue;
            items.add(node.getUserObject());
        }
        if (items.size() == 0) {
            return null;
        }
        return items.toArray();
    }

    private void setSelectedApps(Object[] selected) {
        this.appTree.clearSelection();
        if (selected == null) {
            return;
        }
        if (selected.length == 0) {
            return;
        }
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>(selected.length);
        for (int ix = 0; ix < selected.length; ++ix) {
            TreePath path = this.getPathToApp(selected[ix]);
            if (path == null) continue;
            selectedPaths.add(path);
        }
        if (selectedPaths.size() == 0) {
            return;
        }
        TreePath[] paths = new TreePath[selectedPaths.size()];
        paths = selectedPaths.toArray(paths);
        this.appTree.setSelectionPaths(paths);
    }

    private Object[] getExpandedApps() {
        ArrayList<Object> expandedApps = new ArrayList<Object>();
        TreePath path = new TreePath(new Object[]{this.appRoot});
        Enumeration e = this.appTree.getExpandedDescendants(path);
        if (e == null) {
            return null;
        }
        while (e.hasMoreElements()) {
            Object app;
            path = (TreePath)e.nextElement();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!this.appRoot.isNodeChild(node) || (app = node.getUserObject()) == null || expandedApps.contains(app)) continue;
            expandedApps.add(app);
        }
        if (expandedApps.isEmpty()) {
            return null;
        }
        return expandedApps.toArray();
    }

    private void expandApps(Object[] toExpand) {
        if (toExpand == null) {
            return;
        }
        for (int ix = 0; ix < toExpand.length; ++ix) {
            TreePath path = this.getPathToApp(toExpand[ix]);
            if (path == null) continue;
            this.appTree.expandPath(path);
        }
    }

    private TreePath getPathToApp(Object app) {
        if (app == null) {
            return null;
        }
        Object appKey = null;
        if (app instanceof ApplicationInformation) {
            appKey = ((ApplicationInformation)app).getKey();
        }
        for (int ix = 0; ix < this.appRoot.getChildCount(); ++ix) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.appRoot.getChildAt(ix);
            Object user = node.getUserObject();
            if (user == null) continue;
            boolean mustAdd = false;
            if (appKey != null && user instanceof ApplicationInformation) {
                Object userKey = ((ApplicationInformation)user).getKey();
                mustAdd = appKey.equals(userKey);
            } else {
                mustAdd = app.equals(user);
            }
            if (!mustAdd) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    Rectangle getRegion() {
        return this.returnRegion;
    }

    Rectangle getScreenRect() {
        Insets ins;
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        if (Platform.getPlatform() == 3) {
            ins = GuiUtils.getScreenInsets(null);
            ins.top += 3;
            ins.left += 3;
            ins.bottom += 3;
            ins.right += 3;
        } else {
            ins = NO_INSETS;
        }
        return new Rectangle(ins.left, ins.top, size.width - ins.left - ins.right, size.height - ins.top - ins.bottom);
    }

    Object[] getApplications() {
        return this.returnApps;
    }

    boolean isHosting() {
        return this.isHosting;
    }

    void setHosting(boolean isHosting) {
        this.isHosting = isHosting;
        this.appPanel.setVisible(!isHosting);
    }

    private void setContainerEnabled(boolean toAll, boolean status, boolean clearSelection) {
        this.okBtn.setEnabled(false);
        this.appTree.setEnabled(status);
        this.appExpander.setEnabled(status);
        this.excludeMenus.setEnabled(status);
        if (clearSelection) {
            this.appTree.clearSelection();
        }
        if (toAll) {
            this.desktopScroller.setEnabled(status);
            this.desktopTree.setEnabled(status);
            this.appScroller.setEnabled(status);
        }
    }

    void cancelBtn_actionPerformed(ActionEvent e) {
        this.doCancel();
    }

    void doCancel() {
        this.returnRegion = null;
        this.timer.cancel();
        if (this.ctl != null) {
            this.ctl.cancel();
        }
    }

    void okBtn_actionPerformed(ActionEvent e) {
        this.doOk();
    }

    void doOk() {
        try {
            if (this.desktop.isSelected()) {
                Rectangle tmpRegion = this.getScreenRect();
                if (tmpRegion == null || tmpRegion.isEmpty()) {
                    return;
                }
                this.returnRegion = tmpRegion;
                if (this.ctl != null) {
                    this.ctl.selectRegion(this.returnRegion);
                }
                this.setContainerEnabled(true, false, false);
                this.setHosting(true);
            } else {
                this.normalizeAppSelection();
                this.returnApps = this.getSelectedApps();
                if (this.returnApps == null || this.returnApps.length == 0) {
                    return;
                }
                if (this.ctl != null) {
                    this.ctl.selectApps(this.returnApps);
                }
                this.setContainerEnabled(true, false, false);
                this.setHosting(true);
            }
            this.timer.cancel();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doOk", (Throwable)t, (boolean)true);
        }
    }

    int getValue(JTextField fld, int dft) {
        String text = fld.getText();
        int value = -1;
        if (text == null || text.equals("")) {
            return 0;
        }
        try {
            value = Integer.parseInt(text, 10);
        }
        catch (Exception ex) {
            value = -1;
        }
        if (value < 0) {
            fld.setText(Integer.toString(dft));
        }
        return value;
    }

    private class AppTree
    extends CTree {
        String emptyText;

        AppTree(TreeModel model) {
            super(model);
            this.emptyText = null;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.emptyText != null && this.emptyText.length() > 0 && ShareSelectPanel.this.appRoot.getChildCount() == 0) {
                Insets insets = this.getInsets();
                Dimension dim = new Dimension(this.getWidth(), this.getHeight());
                dim.width -= insets.left + insets.right;
                dim.height -= insets.top + insets.bottom;
                Graphics gc = g.create();
                gc.setColor(Color.GRAY);
                Font f = this.getFont();
                gc.setFont(f);
                FontMetrics fm = gc.getFontMetrics();
                int w = fm.stringWidth(this.emptyText);
                int x = insets.left + (dim.width - w) / 2;
                int y = insets.top + fm.getLeading() + fm.getAscent();
                gc.drawString(this.emptyText, x, y);
            }
        }
    }

    private class AppTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private AppTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp;
            ApplicationInformation app = null;
            WindowTreeNode winInfo = null;
            String name = null;
            boolean isApp = false;
            if (val instanceof WindowTreeNode) {
                winInfo = (WindowTreeNode)val;
                name = winInfo.getAppName();
                if (name == null) {
                    name = val.toString();
                }
            } else if (val instanceof DefaultMutableTreeNode) {
                Object userObj = ((DefaultMutableTreeNode)val).getUserObject();
                if (userObj instanceof ApplicationInformation) {
                    isApp = true;
                    app = (ApplicationInformation)userObj;
                    name = app.getAppName();
                    if (name == null) {
                        name = app.getWindowCount() > 0 ? app.getWindowTitle(0) : app.toString();
                    }
                } else {
                    name = val.toString();
                }
            } else {
                name = val != null ? val.toString() : "???";
            }
            if ((comp = super.getTreeCellRendererComponent(tree, val, selected, expanded, leaf, row, hasFocus)) instanceof JLabel) {
                JLabel lbl = (JLabel)comp;
                Icon icon = null;
                Icon disabled = null;
                if (isApp) {
                    icon = name == ShareSelectPanel.this.appName ? ShareSelectPanel.this.appIcon : app.getAppIcon();
                } else if (winInfo != null) {
                    icon = winInfo.getWindowIcon();
                    comp.setForeground(Color.GRAY);
                }
                if (icon != null && comp instanceof JComponent) {
                    disabled = DisabledIcon.getDisabledIcon((Icon)icon, (JComponent)((JComponent)comp));
                }
                lbl.setIcon(icon);
                lbl.setDisabledIcon(disabled);
            }
            if (comp instanceof JComponent) {
                String tip = leaf ? i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREEAPPTIP, new Object[]{name}) : (expanded ? i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREEAPPOPENTIP, new Object[]{name}) : i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREEAPPCLOSEDTIP, new Object[]{name}));
                ((JComponent)comp).setToolTipText(tip);
            }
            return comp;
        }
    }

    private class DesktopTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private DesktopTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp;
            Object userObj;
            JCheckBox app = null;
            String name = null;
            if (val instanceof DefaultMutableTreeNode && (userObj = ((DefaultMutableTreeNode)val).getUserObject()) instanceof JCheckBox) {
                app = (JCheckBox)userObj;
                name = app.getText();
            }
            if ((comp = super.getTreeCellRendererComponent(tree, val, selected, expanded, leaf, row, hasFocus)) instanceof JLabel) {
                JLabel lbl = (JLabel)comp;
                Icon icon = null;
                Icon disabled = null;
                if (app != null) {
                    icon = app.getIcon();
                }
                if (icon != null && comp instanceof JComponent) {
                    disabled = DisabledIcon.getDisabledIcon((Icon)icon, (JComponent)((JComponent)comp));
                }
                lbl.setText(name);
                lbl.setIcon(icon);
                lbl.setDisabledIcon(disabled);
            }
            return comp;
        }
    }

    private class UpdateTimer
    extends LightweightTimer {
        UpdateTimer(Runnable task) {
            super(task);
        }

        public boolean cancel() {
            ShareSelectPanel.this.timerTask.stop();
            return super.cancel();
        }

        public void run() {
            ShareSelectPanel.this.timerTask.start();
            super.run();
        }
    }

    private class UpdaterTask
    implements Runnable {
        private boolean failed = false;
        private volatile boolean running = false;

        private UpdaterTask() {
        }

        void stop() {
            this.running = false;
        }

        void start() {
            this.running = true;
        }

        @Override
        public void run() {
            try {
                this.updateApps();
                this.failed = false;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                if (this.failed) {
                    ShareSelectPanel.this.timer.cancel();
                }
                this.failed = true;
            }
        }

        private void updateRegion() {
        }

        private void updateApps() {
            final ApplicationInformation[] curApps = ShareSelectPanel.this.host.getApplicationList(ShareSelectPanel.this.prevApps, ShareSelectPanel.this.appName);
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ShareSelectPanel.this.setApplications(curApps);
                    if (UpdaterTask.this.running) {
                        ShareSelectPanel.this.timer.scheduleIn(1000L);
                    }
                }
            });
        }
    }

    private static class WindowTreeNode
    extends DefaultMutableTreeNode {
        String app = null;
        Icon icon = null;

        WindowTreeNode(String title, String appName, Icon winIcon) {
            super(title, false);
            this.app = appName;
            this.icon = winIcon;
        }

        String getAppName() {
            return this.app;
        }

        Icon getWindowIcon() {
            return this.icon;
        }
    }
}

