/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.MonitorEvent;
import com.elluminate.groupware.appshare.module.MonitorListener;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class MonitorPane
extends JPanel
implements MonitorListener {
    public static final int SHOW_FULL_SIZE = 0;
    public static final int SHOW_LARGE_THUMBNAIL = 1;
    public static final int SHOW_SMALL_THUMBNAIL = 2;
    private static final int MAX_WIDTH = 384;
    private static final int MAX_HEIGHT = 256;
    private int background = 0;
    private int maxWidth = 192;
    private int maxHeight = 128;
    private Rectangle areaBounds = new Rectangle();
    private Rectangle pending = new Rectangle();
    private int[] raster = null;
    private MemoryImageSource producer = null;
    private Image image = null;
    private Object synchromesh = new Object();
    private LightweightTimer animationTimer = null;
    private Runnable resizer = null;
    private Runnable deferredResize = null;

    public MonitorPane(short bg) {
        this.background = this.fromRGB15(bg);
        this.setBackground(new Color(this.background & 0xFFFFFF));
        this.animationTimer = new LightweightTimer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean needsPaint = false;
                Object object = MonitorPane.this.synchromesh;
                synchronized (object) {
                    if (MonitorPane.this.producer != null && !MonitorPane.this.pending.isEmpty()) {
                        needsPaint = true;
                        MonitorPane.this.producer.newPixels(((MonitorPane)MonitorPane.this).pending.x, ((MonitorPane)MonitorPane.this).pending.y, ((MonitorPane)MonitorPane.this).pending.width, ((MonitorPane)MonitorPane.this).pending.height);
                        MonitorPane.this.pending.setBounds(0, 0, 0, 0);
                    }
                }
                if (needsPaint) {
                    MonitorPane.this.repaint();
                }
            }
        });
        this.deferredResize = new Runnable(){

            @Override
            public void run() {
                MonitorPane.this.revalidate();
                Runnable resizeAction = MonitorPane.this.resizer;
                if (resizeAction != null) {
                    resizeAction.run();
                }
                MonitorPane.this.repaint();
            }
        };
    }

    public void setResizeAction(Runnable resizeAction) {
        this.resizer = resizeAction;
        this.doResizeAction();
    }

    public void doResizeAction() {
        Runnable r = this.resizer;
        if (r != null) {
            SwingRunnerSupport.invokeLater((Runnable)r);
        }
    }

    public void setDisplayMode(int displayMode) {
        int w = -1;
        int h = -1;
        switch (displayMode) {
            case 0: {
                w = Integer.MAX_VALUE;
                h = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                w = 384;
                h = 256;
                break;
            }
            default: {
                w = 192;
                h = 128;
            }
        }
        if (w < 1 || h < 1) {
            return;
        }
        if (w == this.maxWidth && h == this.maxHeight) {
            return;
        }
        this.maxWidth = w;
        this.maxHeight = h;
        this.doResizeAction();
    }

    public void setMaxExtents(int wMax, int hMax) {
        if (wMax < 1 || hMax < 1) {
            return;
        }
        if (wMax == this.maxWidth && hMax == this.maxHeight) {
            return;
        }
        this.maxWidth = wMax;
        this.maxHeight = hMax;
        this.doResizeAction();
    }

    public void start(Rectangle area) {
        int[] newRaster = null;
        if (!area.isEmpty()) {
            newRaster = new int[area.width * area.height];
            for (int ix = 0; ix < newRaster.length; ++ix) {
                newRaster[ix] = this.background;
            }
        }
        this.setArea(area, newRaster);
        this.animationTimer.scheduleEvery(500L);
    }

    public void stop() {
        this.animationTimer.cancel();
        this.setArea(new Rectangle(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        BufferedImage result = null;
        Object object = this.synchromesh;
        synchronized (object) {
            if (this.image != null && !this.areaBounds.isEmpty()) {
                Graphics2D g2 = null;
                int w = this.image.getWidth(null);
                int h = this.image.getHeight(null);
                BufferedImage bufImage = new BufferedImage(w, h, 1);
                try {
                    g2 = bufImage.createGraphics();
                    g2.drawImage(this.image, null, null);
                }
                finally {
                    if (g2 != null) {
                        g2.dispose();
                    }
                }
                result = bufImage;
            }
        }
        return result;
    }

    @Override
    public void sharedBoundsChanged(MonitorEvent ev) {
        Rectangle newBounds = ev.getBounds();
        if (newBounds == null) {
            return;
        }
        if (this.areaBounds.equals(newBounds)) {
            return;
        }
        if (newBounds.isEmpty()) {
            this.setArea(newBounds, null);
            this.doResizeAction();
            return;
        }
        int x = newBounds.x;
        int y = newBounds.y;
        int w = newBounds.width;
        int h = newBounds.height;
        int[] oldRaster = this.raster;
        int[] newRaster = new int[w * h];
        if (this.areaBounds.isEmpty() || oldRaster == null) {
            for (int ix = 0; ix < newRaster.length; ++ix) {
                newRaster[ix] = this.background;
            }
        } else {
            for (int ix = 0; ix < newRaster.length; ++ix) {
                int from;
                int col = this.background;
                int x1 = x + ix % w;
                int y1 = y + ix / w;
                if (this.areaBounds.contains(x1, y1) && (from = (y1 - this.areaBounds.y) * this.areaBounds.width + (x1 - this.areaBounds.x)) >= 0 && from < oldRaster.length) {
                    col = oldRaster[from];
                }
                newRaster[ix] = col;
            }
        }
        this.setArea(newBounds, newRaster);
        this.producer.newPixels();
        this.doResizeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageChanged(MonitorEvent ev) {
        if (this.raster == null) {
            return;
        }
        if (this.producer == null) {
            return;
        }
        Object object = this.synchromesh;
        synchronized (object) {
            Rectangle updtBounds = ev.getBounds();
            short[] pixels = ev.getPixels();
            for (int y = 0; y < updtBounds.height; ++y) {
                int y1 = y + updtBounds.y;
                for (int x = 0; x < updtBounds.width; ++x) {
                    int x1 = x + updtBounds.x;
                    if (!this.areaBounds.contains(x1, y1)) continue;
                    int col = this.background;
                    if (pixels != null) {
                        col = this.fromRGB15(pixels[y * updtBounds.width + x]);
                    }
                    this.raster[(y1 - this.areaBounds.y) * this.areaBounds.width + (x1 - this.areaBounds.x)] = col;
                }
            }
            this.pending.add(updtBounds);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.areaBounds.width;
        int h = this.areaBounds.height;
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        if (w > this.maxWidth || h > this.maxHeight) {
            double scale = Math.min((double)this.maxWidth / (double)w, (double)this.maxHeight / (double)h);
            w = (int)(scale * (double)w);
            h = (int)(scale * (double)h);
        }
        return new Dimension(w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Object object = this.synchromesh;
        synchronized (object) {
            if (this.image != null) {
                Insets ins = this.getInsets();
                int x = ins.left;
                int y = ins.top;
                int iw = this.areaBounds.width;
                int ih = this.areaBounds.height;
                int vw = this.getWidth() - ins.left - ins.right;
                int vh = this.getHeight() - ins.top - ins.bottom;
                if (iw <= 0 || ih <= 0) {
                    return;
                }
                double scale = Math.min((double)vw / (double)iw, (double)vh / (double)ih);
                if (scale > 1.0) {
                    scale = 1.0;
                }
                int w = (int)((double)iw * scale + 0.5);
                int h = (int)((double)ih * scale + 0.5);
                g.drawImage(this.image, x, y, w, h, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setArea(Rectangle area, int[] newRaster) {
        Object object = this.synchromesh;
        synchronized (object) {
            this.areaBounds.setBounds(area);
            this.pending.setBounds(0, 0, 0, 0);
            if (this.image != null) {
                this.image.flush();
            }
            if (area.isEmpty() || newRaster == null) {
                this.raster = null;
                this.producer = null;
                this.image = null;
            } else {
                this.raster = newRaster;
                this.producer = new MemoryImageSource(area.width, area.height, this.raster, 0, area.width);
                this.producer.setAnimated(true);
                this.image = this.createImage(this.producer);
            }
        }
    }

    private int fromRGB15(short c) {
        int r = c >> 10 & 0x1F;
        int g = c >> 5 & 0x1F;
        int b = c & 0x1F;
        r = (r * 255 + 15) / 31 & 0xFF;
        g = (g * 255 + 15) / 31 & 0xFF;
        b = (b * 255 + 15) / 31 & 0xFF;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

