/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.FilteredKeyStroke;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@Singleton
public class FilteredKeysPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private FilteredKeyModel keyModel;
    private JTable keyTable;
    private JScrollPane keyScroller;
    private JButton addBtn;
    private JButton changeBtn;
    private JButton removeBtn;
    private JCheckBox enableFilteringBox;
    private ArrayList filteredKeys = new ArrayList();

    @Inject
    public FilteredKeysPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout(0, 6));
        this.add(p, "North");
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn(0);
        column.setResizable(true);
        column.setHeaderValue(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_KEYSTROKECOLUMN));
        columnModel.addColumn(column);
        this.keyModel = new FilteredKeyModel();
        this.keyTable = new CTable((TableModel)this.keyModel, (TableColumnModel)columnModel);
        this.keyTable.setSelectionMode(0);
        this.keyTable.setShowGrid(false);
        this.keyTable.setIntercellSpacing(new Dimension(0, 1));
        this.keyTable.setFocusTraversalKeys(0, null);
        this.keyTable.setFocusTraversalKeys(1, null);
        this.keyScroller = new JScrollPane(this.keyTable, 22, 31);
        this.keyScroller.setPreferredSize(new Dimension(300, 200));
        this.keyScroller.getViewport().setBackground(this.keyTable.getBackground());
        this.keyScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FilteredKeysPrefsPanel.this.keyTable.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FilteredKeysPrefsPanel.this.keyTable.clearSelection();
            }
        });
        this.keyTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getClickCount() == 2 && FilteredKeysPrefsPanel.this.changeBtn.isEnabled()) {
                    FilteredKeysPrefsPanel.this.changeBtn.doClick();
                }
            }
        });
        this.keyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FilteredKeysPrefsPanel.this.enableButtons();
            }
        });
        this.addBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_ADDBTN));
        this.addBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_ADDBTNTIP));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredKeysPrefsPanel.this.doAddButton();
            }
        });
        this.changeBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_CHANGEBTN));
        this.changeBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_CHANGEBTNTIP));
        this.changeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredKeysPrefsPanel.this.doModifyButton();
            }
        });
        this.removeBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_REMOVEBTN));
        this.removeBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_REMOVEBTNTIP));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredKeysPrefsPanel.this.doRemoveButton();
            }
        });
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 6));
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        bottomPanel.add((Component)buttonPanel, "Center");
        buttonPanel.add(this.addBtn);
        buttonPanel.add(Box.createHorizontalStrut(6));
        buttonPanel.add(this.changeBtn);
        buttonPanel.add(Box.createHorizontalStrut(6));
        buttonPanel.add(this.removeBtn);
        JPanel checkboxPanel = new JPanel(new FlowLayout(0, 0, 0));
        bottomPanel.add((Component)checkboxPanel, "South");
        this.enableFilteringBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_ENABLEDBTN));
        this.enableFilteringBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_ENABLEDBTNTIP));
        this.enableFilteringBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredKeysPrefsPanel.this.doEnableFilteringBox();
            }
        });
        checkboxPanel.add(this.enableFilteringBox);
        MultilineLabel exposition = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_EXPOSITORYTEXT));
        p.add((Component)exposition, "North");
        p.add((Component)this.keyScroller, "Center");
        p.add((Component)bottomPanel, "South");
        this.enableButtons();
    }

    private void enableButtons() {
        boolean en = this.keyTable.getSelectedRowCount() > 0;
        this.changeBtn.setEnabled(en);
        this.removeBtn.setEnabled(en);
    }

    private void doAddButton() {
        FilteredKeyStroke newKey = new FilteredKeyStroke();
        if (!newKey.showConfigureDialog(this.keyTable) || !newKey.isValid()) {
            return;
        }
        this.filteredKeys.add(newKey);
        int row = this.filteredKeys.size() - 1;
        this.keyModel.fireTableRowsInserted(row, row);
        try {
            this.keyTable.setRowSelectionInterval(row, row);
        }
        catch (IndexOutOfBoundsException ex) {
            LogSupport.exception((Object)((Object)this), (String)"doAddButton", (Throwable)ex, (boolean)false);
        }
        this.setModified(true);
    }

    private void doModifyButton() {
        int row = this.keyTable.getSelectedRow();
        if (row == -1 || row >= this.filteredKeys.size()) {
            return;
        }
        FilteredKeyStroke key = (FilteredKeyStroke)this.filteredKeys.get(row);
        if (!key.showConfigureDialog(this.keyTable) || !key.isValid()) {
            return;
        }
        this.keyModel.fireTableRowsUpdated(row, row);
        this.setModified(true);
    }

    private void doRemoveButton() {
        int row = this.keyTable.getSelectedRow();
        if (row == -1 || row >= this.filteredKeys.size()) {
            return;
        }
        this.filteredKeys.remove(row);
        this.keyModel.fireTableRowsDeleted(row, row);
        this.setModified(true);
    }

    private void doEnableFilteringBox() {
        this.setModified(true);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        int oldKeyCount = this.filteredKeys.size();
        this.filteredKeys.clear();
        String data = preferences.getSetting(prefix + ".keyfilter");
        if (data != null) {
            this.filteredKeys.addAll(FilteredKeyStroke.parseSet(data));
        } else {
            this.filteredKeys.addAll(FilteredKeyStroke.makeDefaultSet());
        }
        int keyCount = this.filteredKeys.size();
        if (oldKeyCount > keyCount) {
            this.keyModel.fireTableRowsDeleted(keyCount, oldKeyCount - 1);
        }
        this.keyModel.fireTableRowsUpdated(0, Math.min(keyCount, oldKeyCount) - 1);
        if (oldKeyCount < keyCount) {
            this.keyModel.fireTableRowsInserted(oldKeyCount, keyCount - 1);
        }
        boolean en = preferences.getBooleanSetting(prefix + ".keyfilterEnabled", true);
        this.enableFilteringBox.setSelected(en);
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String data = FilteredKeyStroke.formatSet(this.filteredKeys);
        preferences.setSetting(prefix + ".keyfilter", data);
        boolean en = this.enableFilteringBox.isSelected();
        preferences.setSetting(prefix + ".keyfilterEnabled", en);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        ArrayList keys = FilteredKeyStroke.makeDefaultSet();
        String data = FilteredKeyStroke.formatSet(keys);
        preferences.setSetting(prefix + ".keyfilter", data);
        preferences.setSetting(prefix + ".keyfilterEnabled", true);
    }

    private class FilteredKeyModel
    extends AbstractTableModel {
        private FilteredKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return FilteredKeysPrefsPanel.this.filteredKeys.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                FilteredKeyStroke key = (FilteredKeyStroke)FilteredKeysPrefsPanel.this.filteredKeys.get(row);
                switch (column) {
                    case 0: {
                        return key.getKeystroke();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

