/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.KeyConfigPanel;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.IntKeyedCollection;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.StringTokenizer;

class FilteredKeyStroke
implements IntKeyedCollection.Element,
Cloneable {
    private static I18n i18n = I18n.create(FilteredKeyStroke.class);
    private int keycode = 0;
    private int keymods = 0;

    public FilteredKeyStroke() {
    }

    public FilteredKeyStroke(int code, int mods) {
        this.keycode = code;
        this.keymods = mods;
    }

    public Object clone() {
        return new FilteredKeyStroke(this.keycode, this.keymods);
    }

    public int getKey() {
        return this.keymods << 16 | this.keycode;
    }

    public String getKeystroke() {
        return GuiUtils.getKeystrokeText((int)this.keycode, (int)this.keymods);
    }

    public String toString() {
        return GuiUtils.getKeystrokeText((int)this.keycode, (int)this.keymods);
    }

    public boolean isValid() {
        return this.keycode != 0;
    }

    public String encodeProperty() {
        return this.keycode + "|" + this.keymods;
    }

    public void decodeProperty(String prop) {
        this.keycode = 0;
        this.keymods = 0;
        int pos = prop.indexOf("|");
        if (pos > 0) {
            this.keycode = Integer.parseInt(prop.substring(0, pos));
            this.keymods = Integer.parseInt(prop.substring(pos + 1));
        }
    }

    public boolean showConfigureDialog(Component parent) {
        KeyConfigPanel content = new KeyConfigPanel(this.keycode, this.keymods);
        int which = ModalDialog.showOptionDialog((Component)parent, (Object)content, (String)i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_FILTERKEY_CONFIGTITLE), (int)2, (int)-1, null, null, null, (Object)content.getPrimaryComponent());
        if (which != 0) {
            return false;
        }
        this.keycode = content.getKeyCode();
        this.keymods = content.getKeyModifiers();
        return true;
    }

    public static String formatSet(ArrayList keys) {
        StringBuffer b = new StringBuffer(256);
        for (FilteredKeyStroke key : keys) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(key.encodeProperty());
        }
        return b.toString();
    }

    public static ArrayList parseSet(String data) {
        ArrayList<FilteredKeyStroke> keys = new ArrayList<FilteredKeyStroke>();
        StringTokenizer parser = new StringTokenizer(data, ",");
        while (parser.hasMoreTokens()) {
            String encoded = parser.nextToken();
            try {
                FilteredKeyStroke key = new FilteredKeyStroke();
                key.decodeProperty(encoded);
                keys.add(key);
            }
            catch (Throwable t) {
                LogSupport.exception(FilteredKeyStroke.class, (String)"parseSet", (Throwable)t, (boolean)true, (String)("KeyStroke=" + encoded));
            }
        }
        return keys;
    }

    public static ArrayList makeDefaultSet() {
        ArrayList<FilteredKeyStroke> keys = new ArrayList<FilteredKeyStroke>();
        switch (Platform.getPlatform()) {
            case 1: {
                keys.add(new FilteredKeyStroke(127, 10));
                break;
            }
            case 2: {
                keys.add(new FilteredKeyStroke(27, 12));
                keys.add(new FilteredKeyStroke(81, 5));
                keys.add(new FilteredKeyStroke(81, 13));
                break;
            }
            case 3: {
                keys.add(new FilteredKeyStroke(127, 10));
                keys.add(new FilteredKeyStroke(8, 10));
            }
        }
        return keys;
    }
}

