/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.imps.HideContentAPI;
import com.elluminate.util.Preferences;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.Frame;

public class AppShareHostActions {
    private static final int ACTION_NONE = 0;
    private static final int ACTION_HIDE_CONTENT = 1;
    private static final int ACTION_RAISE = 2;
    private static final int ACTION_NOTIFY = 4;
    private static final int ACTION_ADORN_CURSOR = 8;
    private static final int DEFAULT_ACTIONS = 7;
    private static final String HOST_ACTIONS_PREFIX = ".hostActions";
    private static final String ACTION_PREF = ".action";
    private Imps imps;

    @Inject
    public AppShareHostActions(Imps imps) {
        this.imps = imps;
    }

    private String actionsToString(int actions) {
        StringBuffer b = new StringBuffer(256);
        if (actions == 0) {
            b.append("None");
        }
        if (AppShareHostActions.isHideContentActionEnabled(actions)) {
            b.append((b.length() > 0 ? "+" : "") + "Hide");
        }
        if (AppShareHostActions.isRaiseActionEnabled(actions)) {
            b.append((b.length() > 0 ? "+" : "") + "RaiseApps");
        }
        if (AppShareHostActions.isNotifyActionEnabled(actions)) {
            b.append((b.length() > 0 ? "+" : "") + "Notify");
        }
        if (AppShareHostActions.isAdornCursorActionEnabled(actions)) {
            b.append((b.length() > 0 ? "+" : "") + "AdornCursor");
        }
        return b.toString();
    }

    public Object apply(Frame top, String prefix, Preferences preferences) {
        HideContentAPI hider;
        int actions = AppShareHostActions.getActions(prefix, preferences);
        if (AppShareDebug.HOST_ACTION.show()) {
            LogSupport.message((Object)this, (String)"apply", (String)("Applying actions: " + this.actionsToString(actions)));
        }
        SavedState savedState = new SavedState(0, top);
        if (actions == 0) {
            return savedState;
        }
        if (AppShareHostActions.isHideContentActionEnabled(actions) && this.imps != null && (hider = (HideContentAPI)this.imps.findBest(HideContentAPI.class)) != null) {
            hider.hideContentArea();
            savedState.actions = AppShareHostActions.setHideContentActionEnabled(savedState.actions, hider.isContentAreaHidden());
        }
        return savedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert(Object state) {
        HideContentAPI hider;
        SavedState savedState;
        if (state == null) {
            return;
        }
        if (!(state instanceof SavedState)) {
            return;
        }
        SavedState savedState2 = savedState = (SavedState)state;
        synchronized (savedState2) {
            if (savedState.reverted) {
                return;
            }
            savedState.reverted = true;
        }
        if (AppShareDebug.HOST_ACTION.show()) {
            LogSupport.message((Object)this, (String)"revert", (String)savedState.toString());
        }
        if (savedState.actions == 0) {
            savedState.clear();
            return;
        }
        if (AppShareHostActions.isHideContentActionEnabled(savedState.actions) && this.imps != null && (hider = (HideContentAPI)this.imps.findBest(HideContentAPI.class)) != null) {
            hider.restoreContentArea();
        }
        if (AppShareDebug.HOST_ACTION.show()) {
            LogSupport.message((Object)this, (String)"revert", (String)("Raising main window: " + savedState.main.getTitle()));
        }
        savedState.main.toFront();
        savedState.clear();
    }

    public void savePreferences(String prefix, Preferences preferences) {
    }

    public void loadPreferences(String prefix, Preferences preferences) {
    }

    static int getDefaultActions() {
        return 7;
    }

    static int getDefaultQuality() {
        return 2;
    }

    private static int parseActions(String property) {
        try {
            return Integer.parseInt(property.trim(), 16);
        }
        catch (NumberFormatException ex) {
            return AppShareHostActions.getDefaultActions();
        }
    }

    private static String formatActions(int actions) {
        return Integer.toHexString(actions);
    }

    private static int setActionEnabled(int actions, int action, boolean enabled) {
        int acts = actions;
        acts = enabled ? (acts |= action) : (acts &= ~action);
        return acts;
    }

    private static boolean isActionEnabled(int actions, int action) {
        return (actions & action) != 0;
    }

    static int setNotifyActionEnabled(int actions, boolean enabled) {
        return AppShareHostActions.setActionEnabled(actions, 4, enabled);
    }

    static boolean isNotifyActionEnabled(int actions) {
        return AppShareHostActions.isActionEnabled(actions, 4);
    }

    static int setRaiseActionEnabled(int actions, boolean enabled) {
        return AppShareHostActions.setActionEnabled(actions, 2, enabled);
    }

    static boolean isRaiseActionEnabled(int actions) {
        return AppShareHostActions.isActionEnabled(actions, 2);
    }

    static int setAdornCursorActionEnabled(int actions, boolean enabled) {
        return AppShareHostActions.setActionEnabled(actions, 8, enabled);
    }

    static boolean isAdornCursorActionEnabled(int actions) {
        return AppShareHostActions.isActionEnabled(actions, 8);
    }

    static boolean isHideContentActionEnabled(int actions) {
        return AppShareHostActions.isActionEnabled(actions, 1);
    }

    static int setHideContentActionEnabled(int actions, boolean enabled) {
        return AppShareHostActions.setActionEnabled(actions, 1, enabled);
    }

    static int getActions(String prefix, Preferences preferences) {
        String prop = prefix + HOST_ACTIONS_PREFIX + ACTION_PREF;
        String value = preferences.getSetting(prop);
        if (value != null) {
            return AppShareHostActions.parseActions(value);
        }
        return AppShareHostActions.getDefaultActions();
    }

    static void setActions(String prefix, Preferences preferences, int actions) {
        String prop = prefix + HOST_ACTIONS_PREFIX + ACTION_PREF;
        preferences.setSetting(prop, AppShareHostActions.formatActions(actions));
    }

    static int getQuality(String prefix, Preferences preferences) {
        String prop = prefix + ".colorCompression";
        int q = preferences.getIntegerSetting(prop, AppShareHostActions.getDefaultQuality());
        q = Math.min(q, 4);
        q = Math.max(q, 0);
        return q;
    }

    static void setQuality(String prefix, Preferences preferences, int quality) {
        String prop = prefix + ".colorCompression";
        int q = quality;
        q = Math.min(q, 4);
        q = Math.max(q, 0);
        preferences.setSetting(prop, q);
    }

    private class SavedState {
        boolean reverted = false;
        int actions;
        Frame main;

        SavedState(int actions, Frame main) {
            this.actions = actions;
            this.main = main;
        }

        void clear() {
            this.actions = 0;
        }

        public String toString() {
            return "SavedState: reverted=" + this.reverted + ",main=" + this.main.getTitle() + ",actions={" + AppShareHostActions.this.actionsToString(this.actions) + "}";
        }
    }
}

