/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video;

import com.elluminate.groupware.video.VideoResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.DebugFlag;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.DataInputStream;

public class VideoProtocol
extends JinxProtocolAdapter {
    public static final DebugFlag LOGGING = DebugFlag.get((String)"video");
    public static final DebugFlag LOGGING_RECEIVE_TRACE = DebugFlag.get((String)"videoReceiveTrace");
    public static final String CHANNEL = "video";
    public static final byte PRIORITY = 2;
    public static final byte FLOOR_REQUEST = 1;
    public static final byte FLOOR_RELEASE = 2;
    public static final byte FLOOR_GRANT = 3;
    public static final byte FLOOR_REVOKE = 4;
    public static final byte QUALITY_CC = 5;
    public static final byte QUALITY_CG = 6;
    public static final byte QUALITY_FC = 7;
    public static final byte QUALITY_FG = 8;
    public static final byte QUALITY_MC = 9;
    public static final byte QUALITY_MG = 10;
    public static final byte QUERY_STATE = 11;
    public static final byte RESUME = 12;
    public static final byte SUSPEND = 13;
    public static final byte USER_OKAY = 14;
    public static final byte USER_SLOW = 15;
    public static final byte USER_VERY_SLOW = 16;
    public static final byte USER_SUSPENDED = 17;
    public static final byte VIDEO_DATA_ACK = 18;
    public static final byte FRAME_RATE = 19;
    public static final byte MAIN_FILMER = 20;
    public static final byte MAIN_FILMER_ALL = 21;
    public static final byte FOLLOW_MODERATOR_FOCUS = 22;
    public static final byte FRAME_SYNC = 23;
    public static final byte FRAME_END_FLAG = 1;
    public static final byte FRAME_START_FLAG = 2;
    public static final byte FRAME_START_AND_END_MASK = 3;
    public static final byte COMPLETE_FRAME_CODE = 3;
    public static final byte FRAME_END_CODE = 1;
    public static final byte FRAME_MIDDLE_CODE = 0;
    public static final byte FRAME_START_CODE = 2;
    public static final byte IS_KEYFRAME_FLAG = 4;
    public static final byte NEED_ACK_FLAG = 8;
    public static final byte HAS_CRC_FLAG = 16;
    public static final int VIDEO_FLAGS_CNT = 5;
    public static final byte VIDEO_DATA = 32;
    public static final String ACTIVE_PROPERTY = "videoActive";
    public static final String DEBUG_STATE_MACHINE_PROPERTY = "videoStateMachine";
    public static final String ENABLE_PROPERTY = "videoEnable";
    public static final String FLOOR_PROPERTY = "videoFloor";
    public static final String MAX_FILMERS_PROPERTY = "videoMaxTalkers";
    public static final String MAX_FILMERS_LIMIT_PROPERTY = "videoMaxFilmersLimit";
    public static final String WATCH_DOG_DELAY_PROPERTY = "videoWatchdogDelay";
    public static final String MODE_PROPERTY = "encodingMode";
    public static final int MODE_UNDEFINED = 0;
    public static final int MODE_CLASSIC = 1;
    public static final int MODE_HQ_THUMBNAIL = 2;
    public static final int MODE_HQ_SMALL = 3;
    public static final int MODE_HQ_MEDIUM = 4;
    public static final int MODE_HQ_LARGE = 5;
    public static final String STATUS_PROPERTY = "videoStatus";
    public static final int STATUS_CLEAR = 0;
    public static final int STATUS_RED = 1;
    public static final int STATUS_YELLOW = 2;
    public static final int STATUS_YELLOW_RED = 3;
    private Provider<VideoResponder> provider;

    public VideoProtocol() {
        this(false);
    }

    public VideoProtocol(boolean defaultAccess) {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(ACTIVE_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(DEBUG_STATE_MACHINE_PROPERTY, (byte)1, Boolean.FALSE);
        this.defineProperty(ENABLE_PROPERTY, (byte)1, new Boolean(defaultAccess));
        this.defineProperty(FLOOR_PROPERTY, (byte)0, new Boolean(defaultAccess));
        this.defineProperty(MAX_FILMERS_PROPERTY, (byte)1, new Integer(1));
        this.defineProperty(MAX_FILMERS_LIMIT_PROPERTY, (byte)1, new Integer(6));
        this.defineProperty(MODE_PROPERTY, (byte)1, new Integer(1));
        this.defineProperty(WATCH_DOG_DELAY_PROPERTY, (byte)1, new Integer(5000));
    }

    @Inject
    protected void initResponder(Provider<VideoResponder> prov) {
        this.provider = prov;
    }

    public static String commandName(byte cmd) {
        String desc;
        if ((cmd & 0xFF) < 32) {
            switch (cmd) {
                case 1: {
                    return "FLOOR_REQUEST";
                }
                case 2: {
                    return "FLOOR_RELEASE";
                }
                case 3: {
                    return "FLOOR_GRANT";
                }
                case 4: {
                    return "FLOOR_REVOKE";
                }
                case 5: {
                    return "QUALITY_CC";
                }
                case 6: {
                    return "QUALITY_CG";
                }
                case 7: {
                    return "QUALITY_FC";
                }
                case 8: {
                    return "QUALITY_FG";
                }
                case 9: {
                    return "QUALITY_MC";
                }
                case 10: {
                    return "QUALITY_MG";
                }
                case 11: {
                    return "QUERY_STATE";
                }
                case 12: {
                    return "RESUME";
                }
                case 13: {
                    return "SUSPEND";
                }
                case 14: {
                    return "USER_OKAY";
                }
                case 15: {
                    return "USER_SLOW";
                }
                case 16: {
                    return "USER_VERY_SLOW";
                }
                case 17: {
                    return "USER_SUSPENDED";
                }
                case 18: {
                    return "VIDEO_DATA_ACK";
                }
                case 19: {
                    return "FRAME_RATE";
                }
                case 20: {
                    return "MAIN_FILMER";
                }
                case 21: {
                    return "MAIN_FILMER_ALL";
                }
                case 22: {
                    return "FOLLOW_MODERATOR_FOCUS";
                }
                case 23: {
                    return "FRAME_SYNC";
                }
            }
            return "[Unknown video command: 0x" + Integer.toHexString(cmd) + "]";
        }
        int mode = (cmd & 0xFF) >> 5;
        switch (mode) {
            case 1: {
                desc = "CLASSIC_VIDEO_DATA";
                break;
            }
            case 2: {
                desc = "HQ_THUMBNAIL_VIDEO_DATA";
                break;
            }
            case 3: {
                desc = "HQ_SMALL_VIDEO_DATA";
                break;
            }
            case 4: {
                desc = "HQ_MEDIUM_VIDEO_DATA";
                break;
            }
            case 5: {
                desc = "HQ_LARGE_VIDEO_DATA";
                break;
            }
            default: {
                desc = "[Unknown video mode: 0x" + mode + "]";
            }
        }
        if ((cmd & 2) != 0) {
            desc = desc + "+FRAME_START_FLAG";
        }
        if ((cmd & 1) != 0) {
            desc = desc + "+FRAME_END_FLAG";
        }
        if ((cmd & 4) != 0) {
            desc = desc + "+IS_KEYFRAME_FLAG";
        }
        if ((cmd & 8) != 0) {
            desc = desc + "+NEED_ACK_FLAG";
        }
        if ((cmd & 0x10) != 0) {
            desc = desc + "+HAS_CRC_FLAG";
        }
        return desc;
    }

    public String commandToString(byte cmd) {
        return VideoProtocol.commandName(cmd);
    }

    public ProtocolResponder getResponder() {
        return (ProtocolResponder)this.provider.get();
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String msg = this.commandToString(cmd);
        try {
            switch (cmd) {
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    short who = str.readShort();
                    msg = msg + " - " + who;
                    break;
                }
                case 19: {
                    int frameRate = str.readByte() & 0xFF;
                    msg = msg + " = " + frameRate;
                    break;
                }
                case 22: {
                    boolean follow = str.readBoolean();
                    msg = msg + " = " + follow;
                    break;
                }
            }
        }
        catch (Exception ex) {
            msg = msg + " - [Exception while decoding message - " + ex + "]";
        }
        return msg;
    }

    public static String modeName(int mode) {
        switch (mode) {
            case 1: {
                return "CLASSIC";
            }
            case 2: {
                return "HQ_THUMBNAIL";
            }
            case 3: {
                return "HQ_SMALL";
            }
            case 4: {
                return "HQ_MEDIUM";
            }
            case 5: {
                return "HQ_LARGE";
            }
            case 0: {
                return "UNDEFINED";
            }
        }
        return "[Unknown video mode: 0x" + Integer.toHexString(mode) + "]";
    }
}

