/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.participant.module;

import com.elluminate.groupware.participant.module.PrintWriterFactory;
import com.elluminate.groupware.participant.module.StringsProperties;
import com.elluminate.gui.ModalDialogFactory;
import com.elluminate.gui.component.FileSaveDialog;
import com.elluminate.gui.component.FileSaveDialogFactory;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.Component;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.filechooser.FileFilter;

public class SaveClerk {
    private File prevSaveFile;
    private I18n i18n;
    private FileSaveDialogFactory saveDialogFactory;
    private PrintWriterFactory printWriterFactory;
    private Logger log;
    private ModalDialogFactory msgDialogFactory;
    private DialogParentProvider parentProvider;

    @Inject
    public SaveClerk(FileSaveDialogFactory dialogFactory, I18n i18n) {
        this.saveDialogFactory = dialogFactory;
        this.i18n = i18n;
    }

    @Inject
    public void initPrintWriterFactory(PrintWriterFactory pwf) {
        this.printWriterFactory = pwf;
    }

    @Inject
    public void initLogger(Logger log) {
        this.log = log;
    }

    @Inject
    public void intiModalDialogFactory(ModalDialogFactory mdf) {
        this.msgDialogFactory = mdf;
    }

    @Inject
    public void initParentProvider(DialogParentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveAs(String sessionName, String[] participantInfo) {
        FileSaveDialog dlg = this.saveDialogFactory.makeFileSaveDialog(this.prevSaveFile);
        FileFilter txtFilter = new FileFilter(){

            @Override
            public String getDescription() {
                return SaveClerk.this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_SAVETEXTFILTERDESC);
            }

            @Override
            public boolean accept(File file) {
                if (FileSysUtils.isTraversableDirectory((File)file)) {
                    return true;
                }
                return file.getName().endsWith(".txt");
            }
        };
        dlg.removeChoosableFileFilter(dlg.getAcceptAllFileFilter());
        dlg.addChoosableFileFilter(txtFilter);
        dlg.setRequiredSuffix(txtFilter, "txt");
        String title = this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_SAVEDIALOGTITLE);
        dlg.setDialogTitle(title);
        int which = dlg.showSaveDialog((Component)this.parentProvider.getDialogParent());
        if (which != 0) {
            return;
        }
        File saveFile = dlg.getSelectedFile();
        if (saveFile == null) {
            return;
        }
        this.prevSaveFile = saveFile;
        PrintWriter pw = null;
        try {
            pw = this.printWriterFactory.create(saveFile);
            if (sessionName != null) {
                pw.println(sessionName);
                pw.println();
            }
            for (int ix = 0; ix < participantInfo.length; ++ix) {
                pw.println(participantInfo[ix]);
            }
        }
        catch (Throwable t) {
            this.log.message((Object)this, "doSaveAs", "Error saving participants list to " + saveFile + "\n" + Debug.getStackTrace((Throwable)t));
            String msg = saveFile.getName() + ": " + t;
            String title2 = "File Error";
            this.msgDialogFactory.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)msg, title2, 0);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }
}

