/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.participant.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.participant.module.ParticipantPublisher;
import com.elluminate.groupware.participant.module.PrintClerk;
import com.elluminate.groupware.participant.module.SaveClerk;
import com.elluminate.groupware.participant.module.SetStatusCmd;
import com.elluminate.groupware.participant.module.StringsProperties;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;

public class ParticipantModule
extends AbstractClientModule
implements PropertyChangeListener,
ModulePublisherInfo,
ClientListener {
    private static final String MODULE_NAME = "Participant";
    private static final String JOIN_NOTICE = "/participant/notice/join";
    private static final String LEFT_NOTICE = "/participant/notice/left";
    private boolean recursive = false;
    private boolean away = false;
    private I18n i18n = I18n.create((Object)this);
    private ClientProvider clientProvider = null;
    private Client client = null;
    private ClientList clients = null;
    private boolean doNotify = false;
    private FeatureBroker broker = null;
    private BooleanFeature setAwayFeature = null;
    private CRSession session = null;
    private ActionFeature printFeature = null;
    private ActionFeature saveFeature = null;
    private PrintClerk printClerk = null;
    private SaveClerk saveClerk = null;
    private ParticipantPublisher msgPublisher;
    private ConferencingEngine confEngine;
    private Provider<SetStatusCmd> setStatusCmdProvider;
    private ShutdownHook hook = null;

    @Inject
    public ParticipantModule(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine confEngine) {
        this.confEngine = confEngine;
    }

    @Inject
    public void initSetStatusCmdProvider(Provider<SetStatusCmd> setStatusCmdProvider) {
        this.setStatusCmdProvider = setStatusCmdProvider;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("ParticipantModule.moduleIcon");
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initPrintClerk(PrintClerk pc) {
        this.printClerk = pc;
    }

    @Inject
    public void initSaveClerk(SaveClerk sc) {
        this.saveClerk = sc;
    }

    @Inject
    public void initParticipantPublisher(ParticipantPublisher participantPublisher) {
        this.msgPublisher = participantPublisher;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String redirectURL;
        String name = event.getPropertyName();
        if (event.getOldValue() != null && event.getNewValue() != null) {
            if (name.equals("participant.steppedAway")) {
                Integer val;
                boolean isMe;
                if (this.clients == null) {
                    return;
                }
                short me = this.clients.getMyAddress();
                short addr = this.clients.getPropertyOwner(event.getSource());
                ClientInfo ci = this.clients.get(addr);
                if (ci == null) {
                    return;
                }
                boolean participantAway = ci.getProperty("participant.steppedAway", false);
                String sessionLabel = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.session");
                boolean bl = isMe = addr == me;
                if (participantAway) {
                    val = 1;
                    this.msgPublisher.sendUserAwayMessage(ci.getDisplayName(), sessionLabel, isMe);
                } else {
                    val = 0;
                    this.msgPublisher.sendUserReturnedMessage(ci.getDisplayName(), sessionLabel, isMe);
                }
                this.session.setAnnotationValue(ci.getAddress(), "AwayAnnotation", (Object)val);
            }
        } else if (name.equals("participant.onExitRedirectURL") && !this.client.isPlayback() && (redirectURL = this.clients.getProperty(name, (String)null)) != null) {
            if (redirectURL.trim().length() > 0) {
                if (this.hook == null) {
                    this.hook = new ShutdownHook();
                    try {
                        Runtime.getRuntime().addShutdownHook((Thread)((Object)this.hook));
                    }
                    catch (Throwable t) {
                        this.hook = null;
                    }
                }
                if (this.hook != null) {
                    this.hook.setTarget(redirectURL);
                }
            } else if (this.hook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook((Thread)((Object)this.hook));
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.hook = null;
            }
        }
        if (this.setAwayFeature == null) {
            this.createAwayFeature();
        }
    }

    private void createAwayFeature() {
        this.setAwayFeature = this.broker.createBooleanFeature((Object)this, "/participant/awayStatus", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYMENU), this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYTIP, new Object[]{JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.session")}));
        this.setAwayFeature.setFalseIcon(this.i18n.getImage("ParticipantModule.awayIcon"));
        this.setAwayFeature.setTrueIcon(this.i18n.getImage("ParticipantModule.awayIcon"));
        this.setAwayFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYMENU));
        this.setAwayFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYMENU));
        this.setAwayFeature.addHint("JAWSTrue", (Object)this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYMSG_SELF_JAWS));
        this.setAwayFeature.addHint("JAWSFalse", (Object)this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_RETURNMSG_SELF_JAWS));
        this.setAwayFeature.setValue((Object)this.away);
        this.setAwayFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                ParticipantModule.this.setAway((Boolean)ParticipantModule.this.setAwayFeature.getValue());
            }
        });
        this.broker.setFeaturePublished((Feature)this.setAwayFeature, true);
        this.setAwayFeature.setValue((Object)this.away);
        this.setAway(this.away);
        this.setAwayFeature.setEnabled(true);
    }

    private void createPrintFeature() {
        if (PrinterJob.getPrinterJob() != null) {
            this.printFeature = this.broker.createActionFeature((Object)this, "/participant/printMenu", this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_PRINTMENUITEM), null);
            this.printFeature.setInteractive(true);
            this.printFeature.addActionFeatureListener(new ActionFeatureListener(){

                public void actionPerformed(ActionFeatureEvent event) {
                    String sessionName = ParticipantModule.this.session.getSessionName();
                    String[] participantInfo = ParticipantModule.this.getParticpantsAsText();
                    ParticipantModule.this.printClerk.print(sessionName, participantInfo);
                }
            });
            this.broker.addFeature((Feature)this.printFeature);
            this.broker.setFeaturePublished((Feature)this.printFeature, true);
            this.printFeature.setEnabled(true);
        }
    }

    private void createSaveFeature() {
        this.saveFeature = this.broker.createActionFeature((Object)this, "/participant/saveMenu", this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_SAVEMENUITEM), null);
        this.saveFeature.setInteractive(true);
        this.saveFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                String sessionName = ParticipantModule.this.session.getSessionName();
                String[] participantInfo = ParticipantModule.this.getParticpantsAsText();
                ParticipantModule.this.saveClerk.doSaveAs(sessionName, participantInfo);
            }
        });
        this.broker.addFeature((Feature)this.saveFeature);
        this.broker.setFeaturePublished((Feature)this.saveFeature, true);
        this.saveFeature.setEnabled(true);
    }

    public void cleanupUI() {
        this.clients.removeClientListener((ClientListener)this);
    }

    public void setupUI() {
        this.broker.announceNotification((Object)this, JOIN_NOTICE);
        this.broker.announceNotification((Object)this, LEFT_NOTICE);
        this.clients.addClientListener((ClientListener)this);
        this.createPrintFeature();
        this.createSaveFeature();
    }

    void setAway(boolean awayState) {
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        this.away = awayState;
        this.setAwayFeature.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYTIP, new Object[]{JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.session")}));
        ClientInfo ci = this.clients.getMyClient();
        if (ci != null && ci.getProperty("participant.steppedAway") != null) {
            ci.setProperty("participant.steppedAway", this.away);
        }
        this.recursive = false;
    }

    public void attach() {
        this.session.registerAnnotation("AwayAnnotation", (Object)0);
        this.clients = this.clientProvider.get().getClientList();
        this.client = this.clientProvider.get();
        this.clients.addClientPropertyChangeListener("participant.steppedAway", (PropertyChangeListener)this);
        this.session.addParticipantListener(this.createParticipantListener());
        if (!this.client.isPlayback()) {
            this.clients.addPropertyChangeListener("participant.onExitRedirectURL", (PropertyChangeListener)this);
        }
    }

    public void detach() {
        this.session.deRegisterAnnotation("AwayAnnotation");
        this.clients.removeClientPropertyChangeListener("participant.steppedAway", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("participant.onExitRedirectURL", (PropertyChangeListener)this);
        this.clients = null;
        this.client = null;
    }

    public void start() {
        this.confEngine.registerCommand(this.setStatusCmdProvider);
    }

    public void stop() {
    }

    public void onAddClient(ClientEvent e) {
        String name;
        ClientInfo ci = this.clients.get(e.getAddress());
        if (ci == null) {
            return;
        }
        if (ci.isMe()) {
            this.doNotify = true;
            return;
        }
        if (!this.doNotify) {
            return;
        }
        if (!ci.isVisible()) {
            return;
        }
        try {
            name = ci.getDisplayName();
        }
        catch (Throwable t) {
            name = e.getName();
        }
        this.broker.sendNotification((Object)this, JOIN_NOTICE, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_JOINALERTTEXT, new Object[]{name, LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.session")}), this.client.getSessionTime());
    }

    public void onRemoveClient(ClientEvent e) {
        String name;
        ClientInfo ci = this.clients.get(e.getAddress());
        if (ci == null) {
            return;
        }
        if (ci.isMe()) {
            this.doNotify = false;
            return;
        }
        if (!this.doNotify) {
            return;
        }
        if (!ci.isVisible()) {
            return;
        }
        try {
            name = ci.getDisplayName();
        }
        catch (Throwable t) {
            name = e.getName();
        }
        this.broker.sendNotification((Object)this, LEFT_NOTICE, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_LEFTALERTTEXT, new Object[]{name, LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.session")}), this.client.getSessionTime());
    }

    private String[] getParticpantsAsText() {
        ArrayList<String> text = new ArrayList<String>();
        if (this.clients != null) {
            String modDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
            String partDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant");
            Iterator participantI = this.session.getParticipantIterator();
            while (participantI.hasNext()) {
                CRParticipant participant = (CRParticipant)participantI.next();
                if (participant == null || !participant.isVisible()) continue;
                String role = participant.isChair() ? modDesc : partDesc;
                String name = this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_USERTEXTFORMAT, new Object[]{participant.getDisplayName(), role});
                text.add(name);
            }
        }
        return text.toArray(new String[text.size()]);
    }

    public CRParticipantListener createParticipantListener() {
        return new CRParticipantAdapter(){

            public void onParticipantJoinedRoom(CRParticipantEvent event) {
                if (ParticipantModule.this.clients == null) {
                    return;
                }
                CRParticipant p = event.getParticipant();
                if (p == null) {
                    return;
                }
                if (p.getName().startsWith(" ")) {
                    return;
                }
                CRRoom room = event.getRoom();
                String roomName = room.getName();
                if (room.isMain()) {
                    roomName = ParticipantModule.this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_DEFAULTGROUPNAME);
                } else if (roomName == null || roomName.length() == 0) {
                    roomName = LabelProps.get((PropertyAccessAPI)ParticipantModule.this.clients, (String)"Label.session");
                }
                String msg = ParticipantModule.this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_JOINALERTTEXT, new Object[]{p.getDisplayName(), roomName});
                ParticipantModule.this.msgPublisher.sendUserJoinedMessage(msg, p.isMe());
            }

            public void onParticipantLeftRoom(CRParticipantEvent event) {
                if (ParticipantModule.this.clients == null) {
                    return;
                }
                CRParticipant p = event.getParticipant();
                if (p == null) {
                    return;
                }
                if (p.getName().startsWith(" ")) {
                    return;
                }
                CRRoom room = event.getRoom();
                String roomName = room.getName();
                if (room.isMain()) {
                    roomName = ParticipantModule.this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_DEFAULTGROUPNAME);
                } else if (roomName == null) {
                    roomName = LabelProps.get((PropertyAccessAPI)ParticipantModule.this.clients, (String)"Label.session");
                }
                String msg = ParticipantModule.this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_LEFTALERTTEXT, new Object[]{p.getDisplayName(), roomName});
                ParticipantModule.this.msgPublisher.sendUserLeftMessage(msg, p.isMe());
            }
        };
    }

    private static class ShutdownHook
    extends WorkerThread {
        private String target = null;

        private ShutdownHook() {
        }

        private void setTarget(String s) {
            this.target = s;
        }

        public void run() {
            if (this.target != null && this.target.trim().length() > 0) {
                try {
                    BrowserUtil.gotoURL((String)this.target);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)((Object)this), (String)"run", (Throwable)t, (boolean)true, (String)("target='" + this.target + "'"));
                }
            }
        }
    }
}

