/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator.module;

import com.elluminate.groupware.calculator.Function;
import com.elluminate.groupware.calculator.module.HistoryInputField;
import com.elluminate.groupware.calculator.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ValueInputDialog
extends EasyDialog
implements ActionListener {
    public static final int HISTORY_LIMIT = 10;
    I18n i18n = I18n.create((Object)this);
    HistoryInputField expression = new HistoryInputField();
    JPanel dialog = new JPanel();
    JPanel buttons = new JPanel();
    BorderLayout dialogLayout = new BorderLayout();
    JButton okButton = null;
    JButton cancelButton = null;
    JPanel inputArea = new JPanel();
    JLabel promptLabel = new JLabel();
    JLabel iconLabel = new JLabel();
    JCheckBox markResult = new JCheckBox();
    GridBagLayout inputLayout = new GridBagLayout();
    ImageIcon icon = null;
    LinkedList history = new LinkedList();
    DefaultComboBoxModel model = new DefaultComboBoxModel();
    InputValue value = null;
    static final String[] vars = new String[]{"pi", "e"};
    static ValueInputDialog dlg = null;
    JPanel controls = new JPanel();
    GridLayout buttonGridLayout = new GridLayout();

    public ValueInputDialog(Frame parent, String prompt, String title, boolean modal) {
        super((Component)parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ValueInputDialog", (Throwable)e, (boolean)true);
        }
        if (prompt != null) {
            this.promptLabel.setText(prompt);
        }
    }

    public void setMarkEnabled(boolean canMark) {
        this.markResult.setEnabled(canMark);
        if (!canMark) {
            this.markResult.setSelected(false);
        }
    }

    public boolean isMarkEnabled() {
        return this.markResult.isEnabled();
    }

    public void setPrompt(String prompt) {
        this.promptLabel.setText(prompt);
    }

    public String getPrompt() {
        return this.promptLabel.getText();
    }

    private void jbInit() throws Exception {
        this.icon = this.i18n.getIcon("ValueInputDialog.icon");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ValueInputDialog.this.value = null;
                ValueInputDialog.this.expression.hidePopup();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ValueInputDialog.this.setVisible(false);
            }
        });
        this.okButton = this.makeButton(1);
        this.cancelButton = this.makeButton(0);
        this.inputArea.setLayout(this.inputLayout);
        this.promptLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_DEFAULTPROMPT));
        this.iconLabel.setIcon(this.icon);
        this.markResult.setText(this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_MARKOPTION));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttons.setLayout(this.buttonGridLayout);
        this.buttonGridLayout.setHgap(5);
        this.setContent(this.dialog);
        this.dialog.setLayout(this.dialogLayout);
        this.okButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_OK));
        this.cancelButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_CANCEL));
        this.inputArea.add((Component)this.expression, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(6, 0, 6, 15), 0, 0));
        this.inputArea.add((Component)this.markResult, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 0, 3, 0), 0, 0));
        this.inputArea.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 3, new Insets(0, 15, 0, 15), 0, 0));
        this.inputArea.add((Component)this.promptLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addActionButton(this.okButton, true);
        this.addCancelButton(this.cancelButton);
        this.dialog.add((Component)this.inputArea, "Center");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.evalExpression();
        } else if (e.getSource() == this.cancelButton) {
            this.cancelButton_actionPerformed(e);
        } else {
            LogSupport.error((Object)this, (String)"actionPerformed", (String)("Unexpected event - " + e));
        }
    }

    void evalExpression() {
        Function expr;
        String current = (String)this.expression.getSelectedItem();
        boolean found = false;
        if (current == null || current.trim().equals("")) {
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_BLANKINPUT), (String)this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_BADINPUTTITLE), (int)0);
            return;
        }
        try {
            expr = new Function(current, vars);
        }
        catch (ParseException ex) {
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)ex.getMessage(), (String)this.i18n.getString((PropertiesEnum)StringsProperties.VALUEINPUTDIALOG_BADINPUTTITLE), (int)0);
            return;
        }
        this.expression.addInputHistory(current);
        expr.setVariable("e", Math.E);
        this.value = new InputValue();
        this.value.setMark = this.markResult.isSelected();
        this.value.value = expr.setVariable("pi", Math.PI);
        this.expression.hidePopup();
        this.setVisible(false);
    }

    public InputValue getInputValue() {
        return this.value;
    }

    static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame) {
            return (Window)parentComponent;
        }
        return ValueInputDialog.getWindowForComponent(parentComponent.getParent());
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.value = null;
        this.expression.hidePopup();
        this.setVisible(false);
    }

    static InputValue showInputDialog(Component parent, String msg, String title, boolean canMark) {
        Window parentWindow = ValueInputDialog.getWindowForComponent(parent);
        if (dlg == null) {
            dlg = parentWindow instanceof Frame ? new ValueInputDialog((Frame)parentWindow, msg, title, true) : new ValueInputDialog(null, msg, title, true);
        } else {
            dlg.setTitle(title);
            dlg.setPrompt(msg);
        }
        dlg.setMarkEnabled(canMark);
        dlg.setLocationRelativeTo(parent);
        dlg.show();
        return dlg.getInputValue();
    }

    public class InputValue {
        public boolean setMark;
        public double value;
    }
}

