/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator.module;

import com.elluminate.util.Debug;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class HistoryInputField
extends JComboBox {
    private int maxHistory = 10;
    private LinkedList history = new LinkedList();
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private volatile boolean recursive = false;

    public HistoryInputField() {
        this.setEditable(true);
        this.setModel(this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryLimit(int limit) {
        Debug.lockEnter((Object)this, (String)"setHistory", null, (Object)this);
        HistoryInputField historyInputField = this;
        synchronized (historyInputField) {
            this.maxHistory = limit;
            this.trimHistory();
        }
        Debug.lockLeave((Object)this, (String)"setHistory", null, (Object)this);
    }

    public int getHistoryLimit() {
        return this.maxHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputHistory(String input) {
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        Debug.lockEnter((Object)this, (String)"addInputhistory", null, (Object)this);
        HistoryInputField historyInputField = this;
        synchronized (historyInputField) {
            if (input == null) {
                this.model.setSelectedItem(null);
            } else if (input.trim().equals("")) {
                this.model.setSelectedItem(null);
            } else {
                Iterator i = this.history.iterator();
                while (i.hasNext()) {
                    String cmp = (String)i.next();
                    if (!cmp.equals(input)) continue;
                    i.remove();
                    break;
                }
                this.history.addFirst(input);
                this.trimHistory();
                this.model.setSelectedItem(input);
            }
        }
        Debug.lockLeave((Object)this, (String)"addInputhistory", null, (Object)this);
        this.recursive = false;
    }

    private void trimHistory() {
        while (this.maxHistory < this.history.size()) {
            this.history.removeLast();
        }
        this.reloadModel();
    }

    private void reloadModel() {
        Iterator i = this.history.iterator();
        this.model.removeAllElements();
        while (i.hasNext()) {
            String item = (String)i.next();
            this.model.addElement(item);
        }
    }
}

