/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator.module;

import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.calculator.CalculatorContext;
import com.elluminate.groupware.calculator.CalculatorProtocol;
import com.elluminate.groupware.calculator.CoordPair;
import com.elluminate.groupware.calculator.CoordSpace;
import com.elluminate.groupware.calculator.Function;
import com.elluminate.groupware.calculator.GraphModel;
import com.elluminate.groupware.calculator.LocalCalculatorContext;
import com.elluminate.groupware.calculator.SharedCalculatorContext;
import com.elluminate.groupware.calculator.module.CalculatorPermissionDelegate;
import com.elluminate.groupware.calculator.module.Graph;
import com.elluminate.groupware.calculator.module.HistoryInputField;
import com.elluminate.groupware.calculator.module.StringsProperties;
import com.elluminate.groupware.calculator.module.ValueInputDialog;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CFrame;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CalculatorBean
extends JPanel
implements PropertyChangeListener,
ChannelListener {
    I18n i18n = I18n.create((Object)this);
    JPanel controlPanel = new JPanel();
    BorderLayout mainLayout = new BorderLayout();
    BorderLayout controlLayout = new BorderLayout();
    FlowLayout toolBarLayout = new FlowLayout();
    JPanel toolBar = new JPanel();
    JPanel rangeBar = new JPanel();
    GridLayout rangeLayout = new GridLayout();
    JPanel xRange = new JPanel();
    GridLayout xRangeLayout = new GridLayout();
    JPanel yRange = new JPanel();
    GridLayout yRangeLayout = new GridLayout();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    JTextField xMax = new JTextField();
    JTextField xMin = new JTextField();
    JTextField yMax = new JTextField();
    JTextField yMin = new JTextField();
    JToggleButton zoomOut = new JToggleButton();
    JToggleButton zoomIn = new JToggleButton();
    JToggleButton move = new JToggleButton();
    JToggleButton showPoint = new JToggleButton();
    ButtonGroup displayModeGroup = new ButtonGroup();
    Border border3;
    JPanel formulaPanel = new JPanel();
    HistoryInputField f1 = new HistoryInputField();
    HistoryInputField f2 = new HistoryInputField();
    Graph graph = new Graph();
    boolean dragging = false;
    Point dragPoint = null;
    CoordPair dragCoords = null;
    JComboBox grid = new JComboBox();
    ImageIcon zoomInIcon = null;
    ImageIcon zoomOutIcon = null;
    ImageIcon crosshairIcon = null;
    ImageIcon moveIcon = null;
    ImageIcon menuIcon = null;
    JPanel f1panel = new JPanel();
    JPanel f2panel = new JPanel();
    JLabel f1Label = new JLabel();
    JLabel f2Label = new JLabel();
    GridBagLayout f1Layout = new GridBagLayout();
    GridBagLayout f2Layout = new GridBagLayout();
    JButton solve1 = new JButton();
    JButton solve2 = new JButton();
    GridLayout formulaLayout = new GridLayout();
    JComboBox selectContext = new JComboBox();
    Border border5;
    Cursor moveCursor = Cursor.getPredefinedCursor(13);
    Cursor pointCursor = Cursor.getPredefinedCursor(1);
    Cursor zoomInCursor;
    Cursor zoomOutCursor;
    Action action;
    JButton menuButton = new JButton();
    JPopupMenu menu = new CPopupMenu();
    JLabel lblLock = null;
    JCheckBox chkLock = new JCheckBox();
    JPanel pnlFollow = null;
    JMenuItem center = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_CENTERGRAPHMENU));
    JMenuItem stdLayout = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_DFTAREAMENU));
    boolean recursive = false;
    boolean field1Validated = false;
    boolean field2Validated = false;
    volatile boolean dontUpdateModel = false;
    LocalCalculatorContext lContext = new LocalCalculatorContext();
    SharedCalculatorContext sContext = null;
    CalculatorContext context = this.lContext;
    private JinxTerminal terminal;
    private ClientList clients;
    private ClientProvider clientProvider;
    private CRSession session;
    private CalculatorPermissionDelegate calculatorPermissionDelegate;

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initCalculatorPermissionDelegate(CalculatorPermissionDelegate calculatorPermissionDelegate) {
        this.calculatorPermissionDelegate = calculatorPermissionDelegate;
    }

    @Inject
    public CalculatorBean(JinxTerminal terminal) {
        this.terminal = terminal;
        this.clients = terminal.getClientList();
        try {
            this.jbInit();
            this.lContext.addPropertyChangeListener("coordSpace", (PropertyChangeListener)this);
            this.lContext.addPropertyChangeListener("function", (PropertyChangeListener)this);
            this.lContext.addPropertyChangeListener("gridSpacing", (PropertyChangeListener)this);
            this.lContext.addPropertyChangeListener("writable", (PropertyChangeListener)this);
            this.updateRanges();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"CalculatorBean", (Throwable)e, (boolean)true);
        }
    }

    public void setClient() {
        this.sContext = new SharedCalculatorContext();
        this.terminal.setProtocolAndListeners((JinxProtocol)new CalculatorProtocol(), (ChannelListener)this, (ChannelDataListener)this.sContext, (PropertyChangeListener)this);
        this.sContext.connect(this.terminal.getChannel(), this.clients);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Moderator", (PropertyChangeListener)this);
        try {
            this.sContext.addPropertyChangeListener("coordSpace", (PropertyChangeListener)this);
            this.sContext.addPropertyChangeListener("function", (PropertyChangeListener)this);
            this.sContext.addPropertyChangeListener("gridSpacing", (PropertyChangeListener)this);
            this.sContext.addPropertyChangeListener("writable", (PropertyChangeListener)this);
            this.updateRanges();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"setClient", (Throwable)e, (boolean)true);
        }
        if (this.calculatorPermissionDelegate != null) {
            this.calculatorPermissionDelegate.setClientProvider(this.clientProvider);
            this.calculatorPermissionDelegate.setSession(this.session);
            CRPermissionFactory permissionFactory = new CRPermissionFactory("CalculatorPermission", "CalculatorPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.calculatorPermissionDelegate);
            this.session.registerPermission(permissionFactory);
            this.clients.addPropertyChangeListener(this.calculatorPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.calculatorPermissionDelegate));
            this.clients.addDefaultPropertyChangeListener(this.calculatorPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.calculatorPermissionDelegate));
        }
    }

    private void jbInit() throws Exception {
        Dimension csize = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
        this.zoomInIcon = this.i18n.getIcon("CalculatorBean.zoomInIcon");
        this.zoomOutIcon = this.i18n.getIcon("CalculatorBean.zoomOutIcon");
        this.crosshairIcon = this.i18n.getIcon("CalculatorBean.crosshairIcon");
        this.moveIcon = this.i18n.getIcon("CalculatorBean.moveIcon");
        this.menuIcon = this.i18n.getIcon("CalculatorBean.menuIcon");
        if (csize.width == 32 && csize.height == 32) {
            Point hotspot = new Point(this.i18n.getInt((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMINCURSOR_X), this.i18n.getInt((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMINCURSOR_Y));
            ImageIcon cursorIcon = this.i18n.getIcon("CalculatorBean.zoomInCursorIcon");
            this.zoomInCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorIcon.getImage(), hotspot, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMIN));
            hotspot = new Point(this.i18n.getInt((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMOUTCURSOR_X), this.i18n.getInt((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMOUTCURSOR_Y));
            cursorIcon = this.i18n.getIcon("CalculatorBean.zoomOutCursorIcon");
            this.zoomOutCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorIcon.getImage(), hotspot, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMOUT));
        } else {
            this.zoomInCursor = this.pointCursor;
            this.zoomOutCursor = this.pointCursor;
        }
        this.graph.setCursor(this.pointCursor);
        this.graph.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.GRAPH_TOOLTIP, new Object[]{new Double(0.0), new Double(0.0)}));
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_XRANGE));
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border2, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_YRANGE));
        this.border3 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(178, 178, 178), new Color(124, 124, 124));
        this.mainLayout.setVgap(6);
        this.setLayout(this.mainLayout);
        this.controlLayout.setVgap(6);
        this.controlPanel.setLayout(this.controlLayout);
        this.rangeBar.setLayout(this.rangeLayout);
        this.rangeLayout.setColumns(2);
        this.rangeLayout.setHgap(6);
        this.xRangeLayout.setHgap(6);
        this.yRangeLayout.setHgap(6);
        this.xRange.setLayout(this.xRangeLayout);
        this.yRange.setLayout(this.yRangeLayout);
        this.xRange.setBorder(BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(0, 4, 4, 4)));
        this.yRange.setBorder(BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(0, 4, 4, 4)));
        this.xMax.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_MAXXTIP));
        this.xMax.setText(Graph.coordToString(5.0));
        this.xMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.range_actionPerformed(e);
            }
        });
        this.xRangeLayout.setColumns(2);
        this.xMin.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_MINXTIP));
        this.xMin.setText(Graph.coordToString(-5.0));
        this.xMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.range_actionPerformed(e);
            }
        });
        this.yMax.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_MAXYTIP));
        this.yMax.setText(Graph.coordToString(5.0));
        this.yMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.range_actionPerformed(e);
            }
        });
        this.yMin.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_MINYTIP));
        this.yMin.setText(Graph.coordToString(-5.0));
        this.yMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.range_actionPerformed(e);
            }
        });
        this.zoomOut.setIcon(this.zoomOutIcon);
        this.normalizeMargin(this.zoomOut);
        this.zoomOut.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMOUTTIP));
        this.zoomOut.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.zoomOut_itemStateChanged(e);
            }
        });
        this.zoomIn.setIcon(this.zoomInIcon);
        this.normalizeMargin(this.zoomIn);
        this.zoomIn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_ZOOMINTIP));
        this.zoomIn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.zoomIn_itemStateChanged(e);
            }
        });
        this.move.setIcon(this.moveIcon);
        this.normalizeMargin(this.move);
        this.move.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_MOVETIP));
        this.move.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.move_itemStateChanged(e);
            }
        });
        this.showPoint.setIcon(this.crosshairIcon);
        this.normalizeMargin(this.showPoint);
        this.showPoint.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SELECTTIP));
        this.showPoint.setSelected(true);
        this.showPoint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.showPoint_itemStateChanged(e);
            }
        });
        this.menuButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_MENUTIP));
        this.menuButton.setIcon(this.menuIcon);
        this.normalizeMargin(this.menuButton);
        this.menuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.menu.show(CalculatorBean.this.menuButton, 0, CalculatorBean.this.menuButton.getHeight());
            }
        });
        this.lblLock = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}));
        this.lblLock.setEnabled(false);
        this.lblLock.setLabelFor(this.chkLock);
        this.chkLock.setEnabled(false);
        this.chkLock.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}));
        this.chkLock.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}));
        this.chkLock.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.lock_itemStateChanged(e);
            }
        });
        this.pnlFollow = new JPanel(new FlowLayout(2));
        this.pnlFollow.add(this.chkLock);
        this.pnlFollow.add(this.lblLock);
        this.add((Component)this.pnlFollow, "First");
        this.center.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordSpace spc = CalculatorBean.this.context.getCoordSpace();
                spc = new CoordSpace(-(spc.getXRange() / 2.0), spc.getXRange() / 2.0, -(spc.getYRange() / 2.0), spc.getYRange() / 2.0);
                CalculatorBean.this.context.setCoordSpace(spc);
            }
        });
        this.stdLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.context.setCoordSpace(new CoordSpace(-5.0, 5.0, -5.0, 5.0));
            }
        });
        this.grid.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_GRIDTIP));
        this.selectContext.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_CONTEXTTIP));
        this.solve1.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SOLVETIP));
        this.solve2.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SOLVETIP));
        this.f2.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FORMULATIP));
        this.f1.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FORMULATIP));
        this.f2Label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.f1Label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.menu.add(this.center);
        this.menu.add(this.stdLayout);
        this.f1Label.setForeground(Color.blue);
        this.f1Label.setLabelFor(this.f1);
        this.f1Label.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_YLABEL));
        this.formulaPanel.setLayout(this.formulaLayout);
        this.graph.setModel((GraphModel)this.lContext);
        this.graph.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.graph.setPreferredSize(new Dimension(250, 250));
        if (this.context.isWritable()) {
            this.graph.setClickAction(3);
            this.graph.setDragAction(3);
        }
        this.graph.setTracing(true);
        this.lContext.setFunctionColor(0, Color.blue);
        this.lContext.setFunctionColor(1, Color.red);
        this.f1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.formula_actionPerformed(e);
            }
        });
        ((JTextField)this.f1.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalculatorBean.this.field1Validated = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalculatorBean.this.field1Validated = false;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalculatorBean.this.field1Validated = false;
            }
        });
        this.f1panel.setLayout(this.f1Layout);
        this.formulaLayout.setVgap(4);
        this.formulaLayout.setRows(2);
        this.f2Label.setForeground(Color.red);
        this.f2Label.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_YLABEL));
        this.f2panel.setLayout(this.f2Layout);
        this.f2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.formula_actionPerformed(e);
            }
        });
        ((JTextField)this.f2.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalculatorBean.this.field2Validated = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalculatorBean.this.field2Validated = false;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalculatorBean.this.field2Validated = false;
            }
        });
        Insets ins = this.solve1.getMargin();
        this.solve1.setMargin(new Insets(ins.top, 6, ins.bottom, 6));
        this.solve1.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_XLABEL));
        this.solve1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.solve_actionPerformed(e);
            }
        });
        ins = this.solve2.getMargin();
        this.solve2.setMargin(new Insets(ins.top, 6, ins.bottom, 6));
        this.solve2.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_XLABEL));
        this.solve2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorBean.this.solve_actionPerformed(e);
            }
        });
        this.selectContext.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.selectContext_itemStateChanged(e);
            }
        });
        this.yRangeLayout.setColumns(2);
        this.add((Component)this.graph, "Center");
        this.add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.rangeBar, "South");
        this.rangeBar.add((Component)this.xRange, null);
        this.xRange.add((Component)this.xMin, null);
        this.xRange.add((Component)this.xMax, null);
        this.rangeBar.add((Component)this.yRange, null);
        this.yRange.add((Component)this.yMin, null);
        this.yRange.add((Component)this.yMax, null);
        this.toolBarLayout.setVgap(0);
        this.toolBarLayout.setHgap(2);
        this.toolBar.setLayout(this.toolBarLayout);
        this.controlPanel.add((Component)this.toolBar, "North");
        this.toolBar.add((Component)this.zoomIn, null);
        this.toolBar.add((Component)this.zoomOut, null);
        this.toolBar.add((Component)this.move, null);
        this.toolBar.add((Component)this.showPoint, null);
        this.toolBar.add((Component)this.grid, null);
        this.toolBar.add((Component)this.selectContext, null);
        this.toolBar.add((Component)this.menuButton, null);
        this.controlPanel.add((Component)this.formulaPanel, "Center");
        this.formulaPanel.add((Component)this.f1panel, null);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.f1panel.add((Component)this.f1Label, gbc);
        gbc.gridx = 1;
        gbc.weightx = 100.0;
        gbc.insets.left = 4;
        this.f1panel.add((Component)this.f1, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 4;
        this.f1panel.add((Component)this.solve1, gbc);
        this.formulaPanel.add((Component)this.f2panel, null);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.f2panel.add((Component)this.f2Label, gbc);
        gbc.gridx = 1;
        gbc.weightx = 100.0;
        gbc.insets.left = 4;
        this.f2panel.add((Component)this.f2, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 4;
        this.f2panel.add((Component)this.solve2, gbc);
        this.displayModeGroup.add(this.zoomIn);
        this.displayModeGroup.add(this.zoomOut);
        this.displayModeGroup.add(this.move);
        this.displayModeGroup.add(this.showPoint);
        this.grid.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_GRIDNONE));
        this.grid.addItem(this.encodeGrid(0.01));
        this.grid.addItem(this.encodeGrid(0.05));
        this.grid.addItem(this.encodeGrid(0.1));
        this.grid.addItem(this.encodeGrid(0.5));
        this.grid.addItem(this.encodeGrid(1.0));
        this.grid.addItem(this.encodeGrid(5.0));
        this.grid.addItem(this.encodeGrid(10.0));
        this.grid.addItem(this.encodeGrid(50.0));
        this.grid.addItem(this.encodeGrid(100.0));
        this.setGridFromModel();
        this.grid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CalculatorBean.this.grid_itemStateChanged(e);
            }
        });
        this.selectContext.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_PRIVATE));
        this.selectContext.setSelectedItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_PRIVATE));
    }

    public void channelStateChanged(ChannelEvent event) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        final String name = e.getPropertyName();
        if (name.equals("Label.Moderator")) {
            this.lblLock.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}));
            return;
        }
        final Object source = e.getSource();
        final Object oldVal = e.getOldValue();
        final Object newVal = e.getNewValue();
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CalculatorBean.this.processPropertyChange(source, name, oldVal, newVal);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyChange(Object source, String name, Object oldVal, Object newVal) {
        Debug.lockEnter((Object)this, (String)"propertyChange", null, (Object)this);
        CalculatorBean calculatorBean = this;
        synchronized (calculatorBean) {
            if (source == this.context) {
                if (name.equals("coordSpace")) {
                    this.updateRanges();
                } else if (name.equals("gridSpacing")) {
                    this.setGridFromModel();
                } else if (name.equals("writable")) {
                    this.updateAccessControl();
                } else if (name.equals("function")) {
                    this.recursive = true;
                    this.f1.addInputHistory(this.context.getFunctionName(0));
                    this.f2.addInputHistory(this.context.getFunctionName(1));
                    this.recursive = false;
                }
            } else if (name.equals("calculatorLocked")) {
                if (oldVal == null) {
                    this.selectContext.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SHARED));
                    this.selectContext.setSelectedItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SHARED));
                }
                if (newVal == null) {
                    this.selectContext.setSelectedItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_PRIVATE));
                    this.selectContext.removeItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SHARED));
                } else if (this.clients.getProperty("calculatorLocked", false)) {
                    this.selectContext.setSelectedItem(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SHARED));
                }
                this.updateAccessControl();
            } else if (name.equals("calculatorAccess")) {
                if (this.clients.getPropertyOwner(source) == this.terminal.getClient().getAddress()) {
                    this.updateAccessControl();
                }
            } else if (name.equals("chair")) {
                this.updateAccessControl();
            }
        }
        Debug.lockLeave((Object)this, (String)"propertyChange", null, (Object)this);
    }

    private void setGridFromModel() {
        class SetGridUI
        implements Runnable {
            String item;

            public SetGridUI(String which) {
                this.item = which;
            }

            @Override
            public void run() {
                CalculatorBean.this.dontUpdateModel = true;
                CalculatorBean.this.grid.setSelectedItem(this.item);
                CalculatorBean.this.dontUpdateModel = false;
            }
        }
        double spacing = this.context.getGridSpacing();
        NumberFormat fmt = NumberFormat.getNumberInstance();
        if (spacing <= 0.0) {
            SwingRunnerSupport.invokeLater((Runnable)new SetGridUI(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_GRIDNONE)));
        } else {
            for (int i = 1; i < this.grid.getItemCount(); ++i) {
                double value;
                String item = (String)this.grid.getItemAt(i);
                try {
                    value = fmt.parse(item).doubleValue();
                }
                catch (ParseException ex) {
                    value = 1.0E-6;
                }
                double delta = Math.abs(spacing - value);
                if (!(delta / value < 0.01)) continue;
                SwingRunnerSupport.invokeLater((Runnable)new SetGridUI(item));
                return;
            }
        }
    }

    private void updateRanges() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CoordSpace space = CalculatorBean.this.context.getCoordSpace();
                CalculatorBean.this.dontUpdateModel = true;
                CalculatorBean.this.xMin.setText(Graph.coordToString(space.getMinX()));
                CalculatorBean.this.xMax.setText(Graph.coordToString(space.getMaxX()));
                CalculatorBean.this.yMin.setText(Graph.coordToString(space.getMinY()));
                CalculatorBean.this.yMax.setText(Graph.coordToString(space.getMaxY()));
                CalculatorBean.this.dontUpdateModel = false;
            }
        });
    }

    void updateAccessControl() {
        if (this.terminal != null) {
            boolean write = this.context.isWritable();
            boolean isChair = false;
            boolean locked = false;
            if (this.terminal.getClient() != null) {
                Chair chair = ChairProtocol.getChair((Connection)this.terminal.getClient());
                isChair = chair.isMe();
                locked = this.clients.getProperty("calculatorLocked", false);
            }
            class AccessUI
            implements Runnable {
                boolean write;
                boolean chair;
                boolean locked;

                public AccessUI(boolean write, boolean chair, boolean locked) {
                    this.write = write;
                    this.chair = chair;
                    this.locked = locked;
                }

                @Override
                public void run() {
                    if (!this.write) {
                        CalculatorBean.this.showPoint.setSelected(true);
                        CalculatorBean.this.graph.setClickAction(0);
                        CalculatorBean.this.graph.setDragAction(0);
                    } else if (CalculatorBean.this.showPoint.isSelected()) {
                        CalculatorBean.this.graph.setClickAction(3);
                        CalculatorBean.this.graph.setDragAction(3);
                    }
                    CalculatorBean.this.chkLock.setEnabled(this.chair && CalculatorBean.this.terminal.getChannel().isUp());
                    CalculatorBean.this.chkLock.setSelected(this.locked);
                    CalculatorBean.this.lblLock.setEnabled(this.chair && CalculatorBean.this.terminal.getChannel().isUp());
                    CalculatorBean.this.zoomIn.setEnabled(this.write);
                    CalculatorBean.this.zoomOut.setEnabled(this.write);
                    CalculatorBean.this.move.setEnabled(this.write);
                    CalculatorBean.this.showPoint.setEnabled(this.write);
                    CalculatorBean.this.f1.setEnabled(this.write);
                    CalculatorBean.this.f2.setEnabled(this.write);
                    CalculatorBean.this.grid.setEnabled(this.write);
                    CalculatorBean.this.xMin.setEnabled(this.write);
                    CalculatorBean.this.xMax.setEnabled(this.write);
                    CalculatorBean.this.yMin.setEnabled(this.write);
                    CalculatorBean.this.yMax.setEnabled(this.write);
                    CalculatorBean.this.center.setEnabled(this.write);
                    CalculatorBean.this.stdLayout.setEnabled(this.write);
                    CalculatorBean.this.selectContext.setEnabled(!this.locked || this.chair);
                }
            }
            SwingRunnerSupport.invokeLater((Runnable)new AccessUI(write, isChair, locked));
        }
    }

    private double parseValue(JTextField field, double dft) {
        String txt = field.getText();
        double value = dft;
        try {
            value = new Double(txt);
        }
        catch (Exception ex) {
            field.setText(Double.toString(dft));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void formula_actionPerformed(ActionEvent e) {
        int index;
        HistoryInputField field;
        block18: {
            block16: {
                block17: {
                    field = (HistoryInputField)e.getSource();
                    if (this.recursive) {
                        return;
                    }
                    this.recursive = true;
                    Debug.lockEnter((Object)this, (String)"formula_actionPerformed", null, (Object)this);
                    CalculatorBean calculatorBean = this;
                    // MONITORENTER : calculatorBean
                    if (field != this.f1) break block16;
                    if (!this.field1Validated) break block17;
                    // MONITOREXIT : calculatorBean
                    Debug.lockLeave((Object)this, (String)"formula_actionPerformed", null, (Object)this);
                    this.recursive = false;
                    return;
                }
                index = 0;
                break block18;
            }
            if (field != this.f2) {
                // MONITOREXIT : calculatorBean
                Debug.lockLeave((Object)this, (String)"formula_actionPerformed", null, (Object)this);
                this.recursive = false;
                return;
            }
            if (this.field2Validated) {
                // MONITOREXIT : calculatorBean
                Debug.lockLeave((Object)this, (String)"formula_actionPerformed", null, (Object)this);
                this.recursive = false;
                return;
            }
            index = 1;
        }
        try {
            try {
                String str = (String)field.getSelectedItem();
                this.context.setFunctionName(index, str);
                field.setForeground(Color.black);
                field.repaint();
                field.addInputHistory(str);
            }
            catch (Exception ex) {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)ex.getMessage(), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_INVALIDFUNCTION), (int)0);
                field.setForeground(Color.red);
                field.repaint();
            }
            if (field == this.f1) {
                this.field1Validated = true;
                return;
            }
            if (field == this.f2) {
                this.field2Validated = true;
            }
            // MONITOREXIT : calculatorBean
            return;
        }
        finally {
            Debug.lockLeave((Object)this, (String)"formula_actionPerformed", null, (Object)this);
            this.recursive = false;
        }
    }

    void range_actionPerformed(ActionEvent e) {
        CoordSpace space = this.context.getCoordSpace();
        double minX = this.parseValue(this.xMin, space.getMinX());
        double maxX = this.parseValue(this.xMax, space.getMaxX());
        double minY = this.parseValue(this.yMin, space.getMinY());
        double maxY = this.parseValue(this.yMax, space.getMaxY());
        space = new CoordSpace(minX, maxX, minY, maxY);
        this.context.setCoordSpace(space);
        this.updateRanges();
    }

    void grid_itemStateChanged(ItemEvent e) {
        if (this.dontUpdateModel) {
            return;
        }
        if (e.getStateChange() == 1) {
            String item = (String)e.getItem();
            NumberFormat fmt = NumberFormat.getNumberInstance();
            try {
                double grid = fmt.parse(item).doubleValue();
                this.context.setGridSpacing(grid);
            }
            catch (ParseException ex) {
                this.context.setGridSpacing(-1.0);
            }
        }
    }

    void showPoint_itemStateChanged(ItemEvent e) {
        if (this.showPoint.isSelected()) {
            this.graph.setTracing(true);
            if (this.context.isWritable()) {
                this.graph.setClickAction(3);
                this.graph.setDragAction(3);
            }
            this.graph.setCursor(this.pointCursor);
        } else {
            this.graph.setTracing(false);
            this.graph.setClickAction(0);
            this.graph.setDragAction(0);
            this.graph.setToolTipText(null);
        }
    }

    void move_itemStateChanged(ItemEvent e) {
        if (this.move.isSelected()) {
            this.graph.setDragAction(2);
            this.graph.setCursor(this.moveCursor);
        } else {
            this.graph.setDragAction(0);
        }
    }

    void zoomOut_itemStateChanged(ItemEvent e) {
        if (this.zoomOut.isSelected()) {
            this.graph.setClickAction(2);
            this.graph.setCursor(this.zoomOutCursor);
        } else {
            this.graph.setClickAction(0);
        }
    }

    void zoomIn_itemStateChanged(ItemEvent e) {
        if (this.zoomIn.isSelected()) {
            this.graph.setClickAction(1);
            this.graph.setDragAction(1);
            this.graph.setCursor(this.zoomInCursor);
        } else {
            this.graph.setClickAction(0);
            this.graph.setDragAction(0);
        }
    }

    void solve_actionPerformed(ActionEvent e) {
        int i;
        if (e.getSource() == this.solve1) {
            i = 0;
        } else if (e.getSource() == this.solve2) {
            i = 1;
        } else {
            return;
        }
        String nm = this.context.getFunctionName(i);
        Function f = this.context.getFunction(i);
        if (f != null) {
            String msg;
            ValueInputDialog.InputValue reply = ValueInputDialog.showInputDialog(this, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SOLVEFORY), this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SOLVETITLE, new Object[]{nm}), this.context.isWritable());
            if (reply == null) {
                return;
            }
            double x = reply.value;
            double y = f.setVariable("x", x);
            if (Double.isInfinite(y)) {
                msg = this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_INFINITE, new Object[]{new Double(x)});
            } else if (Double.isNaN(y)) {
                msg = this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_NOTANUMBER, new Object[]{new Double(x)});
            } else {
                msg = this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SOLUTION, new Object[]{new Double(y), new Double(x)});
                if (reply.setMark) {
                    this.context.setMark(new CoordPair(x, y));
                }
            }
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)msg, (String)this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SOLVETITLE, new Object[]{nm}), (int)1);
        }
    }

    void selectContext_itemStateChanged(ItemEvent e) {
        String item = (String)e.getItem();
        if (item.equals(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_PRIVATE))) {
            this.context = this.lContext;
        } else if (item.equals(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_SHARED))) {
            this.context = this.sContext;
        }
        this.graph.setModel((GraphModel)this.context);
        this.f1.addInputHistory(this.context.getFunctionName(0));
        this.f2.addInputHistory(this.context.getFunctionName(1));
        this.setGridFromModel();
        this.updateRanges();
        this.updateAccessControl();
    }

    public void lock_itemStateChanged(boolean isLockedChecked) {
        if (this.terminal.getClient() == null) {
            return;
        }
        Chair chair = ChairProtocol.getChair((Connection)this.terminal.getClient());
        if (!this.terminal.getClient().isConnected()) {
            if (isLockedChecked) {
                boolean selected = false;
                this.chkLock.setSelected(selected);
            }
            return;
        }
        if (!chair.isMe()) {
            return;
        }
        if (isLockedChecked) {
            this.clients.setProperty("calculatorLocked", true);
        } else {
            this.clients.setProperty("calculatorLocked", false);
        }
    }

    public void lock_itemStateChanged(ItemEvent e) {
        switch (e.getStateChange()) {
            case 1: {
                this.lock_itemStateChanged(true);
                break;
            }
            case 2: {
                this.lock_itemStateChanged(false);
            }
        }
    }

    private String encodeGrid(double value) {
        return this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_GRIDFORMAT, new Object[]{new Double(value)});
    }

    private void normalizeMargin(AbstractButton button) {
        Insets ins = button.getMargin();
        int val = Math.min(ins.left, ins.top) - 2;
        val = Math.max(0, val);
        button.setMargin(new Insets(val, val, val, val));
    }

    public static void main(String[] args) {
        CalculatorBean b = new CalculatorBean(new JinxTerminal());
        CFrame f = new CFrame(){

            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }
        };
        f.getContentPane().add(b);
        f.pack();
        f.setVisible(true);
    }
}

