/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.telephony;

import com.elluminate.groupware.audio.telephony.ReceiveListener;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.log.LogSupport;
import java.util.TooManyListenersException;

public class ReceiveQueue {
    private ReceiveListener listener = null;
    private MTPriorityQueue queue = new MTPriorityQueue("Audio receive queue", (QueuedProcessor)new QueuedProcessorAdapter(){

        public void process(Object object, Object context) {
            ReceiveQueue.this.doProcess(object);
        }
    });

    public ReceiveQueue() {
        this.queue.setThreadPriority(10);
    }

    public void abort(boolean drain) {
        this.queue.stop(drain);
    }

    public void addReceiveListener(ReceiveListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("Too many receive queue listeners.");
        }
        this.listener = l;
    }

    private void doProcess(Object event) {
        try {
            ChannelDataEvent cde = (ChannelDataEvent)event;
            if (this.listener == null) {
                LogSupport.error((Object)this, (String)"doProcess", (String)"No listener.");
            } else {
                try {
                    this.listener.onReceive(cde);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
                }
            }
            cde.dispose();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
        }
    }

    public void queueEvent(ChannelDataEvent cde) {
        this.queue.process(cde.clone());
    }

    public void removeReceiveListener(ReceiveListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }
}

