/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.windows;

import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.AudioSupport;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.windows.NativeWorker;
import com.elluminate.groupware.audio.module.windows.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CList;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CoreAudio
implements AudioSupport {
    private static final String DEFAULT = null;
    private static final int INPUT_BUFFER_MILLIS = 4000;
    private static final String LIB_NAME = "CoreAudio";
    private static final int OUTPUT_BUFFER_MILLIS = 1000;
    private static final int INPUT_MUTE = 1;
    private static final int INPUT_VOLUME = 2;
    private static final int INPUT_BOOST = 3;
    private static final int OUTPUT_MUTE = 4;
    private static final int OUTPUT_VOLUME = 5;
    private I18n i18n = I18n.create((Object)this);
    private String inputDeviceHnd = null;
    private String[] inputDeviceHnds = null;
    private String[] inputDeviceNames = null;
    private String inputSourceName = null;
    private Thread monitorThread = null;
    private String outputDeviceHnd = null;
    private String[] outputDeviceHnds = null;
    private String[] outputDeviceNames = null;
    private Component owner = null;
    private boolean stopMonitoring = false;
    private String[] inputEnumeration = null;
    private String inputDevice = null;
    private String inputDeviceDisplayName = null;
    private int inputVolume = -1;
    private boolean inputMuteFlag = false;
    private int openInputDevice = -1;
    private String[] outputEnumeration = null;
    private String outputDevice = null;
    private String outputDeviceDisplayName = null;
    private int outputVolume = -1;
    private boolean outputMuteFlag = false;
    private int openOutputDevice = -1;
    private static String nativeVersion = null;
    private NativeWorker nativeWorker = null;
    private Object workerLock = new Object();
    private int oldInputVolume = -1;
    private int oldOutputVolume = -1;
    private boolean inputMuteDialogPosted = false;
    private boolean outputMuteDialogPosted = false;
    private JButton refreshBtn;
    private int refreshRefCount = 0;
    private volatile boolean inputDeviceProblem = false;
    private volatile boolean outputDeviceProblem = false;
    private volatile int inputBoostLevel = -1;
    private volatile boolean boostInitialized = false;

    private native void nativeMonitorControls();

    private static native int nativeGetLatentInputSamplesCount();

    private static native int nativeGetLatentOutputSamplesCount();

    private static native void nativeCloseInputDevice();

    private static native void nativeCloseOutputDevice();

    private static native String[] nativeEnumerateInputDevices();

    private static native String[] nativeEnumerateOutputDevices();

    private static native void nativeFlushInputDevice();

    private static native void nativeFlushOutputDevice();

    private static native int nativeGetInputBoost();

    private static native String nativeGetInputDevice();

    private static native String nativeGetInputDeviceDisplayName(String var0);

    private static native int nativeGetInputVolume();

    private static native String nativeGetOutputDevice();

    private static native String nativeGetOutputDeviceDisplayName(String var0);

    private static native int nativeGetOutputVolume();

    private static native String nativeGetVersion();

    private static native boolean nativeIsInputMuted();

    private static native boolean nativeIsOutputMuted();

    private static native void nativeMuteInput(boolean var0);

    private static native void nativeMuteOutput(boolean var0);

    private static native int nativeOpenInputDevice(int var0, int var1);

    private static native int nativeOpenOutputDevice(int var0, int var1);

    private static native void nativeReadInputDevice(short[] var0, int var1, int var2);

    private static native void nativeSetDebug(boolean var0);

    private static native void nativeSetInputDevice(String var0);

    private static native void nativeSetInputVolume(int var0);

    private static native void nativeSetOutputDevice(String var0);

    private static native void nativeSetOutputVolume(int var0);

    private static native void nativeTerminate();

    private static native void nativeWriteOutputDevice(short[] var0, int var1, int var2);

    public CoreAudio() {
        this.setDebug(AudioDebug.NATIVE.isEnabled());
        AudioDebug.NATIVE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                CoreAudio.this.setDebug(AudioDebug.NATIVE.isEnabled());
            }
        });
    }

    private void setDebug(final boolean debug) {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                CoreAudio.nativeSetDebug(debug);
            }
        }, "setDebug");
    }

    private void controlChanged(int controlHnd) {
        switch (controlHnd) {
            case 1: {
                this.inputMuteFlag = CoreAudio.nativeIsInputMuted();
                if (!this.inputMuteFlag || this.inputMuteDialogPosted) break;
                this.inputMuteDialogPosted = true;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int response = ModalDialog.showConfirmDialog((Component)CoreAudio.this.owner, (Object)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MIC_MUTE_QUERY), (String)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2);
                        if (response == 0) {
                            CoreAudio.this.nativeRequest(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (CoreAudio.nativeIsInputMuted()) {
                                            CoreAudio.nativeMuteInput(false);
                                        }
                                    }
                                    catch (Throwable t) {
                                        LogSupport.message((Object)this, (String)"controlChanged", (String)("Failed handling INPUT_MUTE: " + t));
                                    }
                                }
                            }, "controlChanged - mute input");
                        }
                        CoreAudio.this.inputMuteDialogPosted = false;
                    }
                });
                break;
            }
            case 2: {
                this.oldInputVolume = CoreAudio.nativeGetInputVolume();
                if (this.oldInputVolume == this.inputVolume) break;
                this.inputVolume = this.oldInputVolume;
                AudioEngine.controlChanged(1);
                break;
            }
            case 3: {
                int newInputBoostLevel = CoreAudio.nativeGetInputBoost();
                this.boostInitialized = true;
                if (newInputBoostLevel == this.inputBoostLevel) break;
                this.inputBoostLevel = newInputBoostLevel;
                AudioEngine.controlChanged(1);
                break;
            }
            case 4: {
                this.outputMuteFlag = CoreAudio.nativeIsOutputMuted();
                if (!this.outputMuteFlag || this.outputMuteDialogPosted) break;
                this.outputMuteDialogPosted = true;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int response;
                        if (CoreAudio.this.outputMuteFlag && (response = ModalDialog.showConfirmDialog((Component)CoreAudio.this.owner, (Object)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_MASTER_MUTE_QUERY), (String)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_WARNING_TITLE), (int)0, (int)2)) == 0) {
                            CoreAudio.this.nativeRequest(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (CoreAudio.nativeIsOutputMuted()) {
                                            CoreAudio.nativeMuteOutput(false);
                                        }
                                    }
                                    catch (Throwable t) {
                                        LogSupport.message((Object)this, (String)"controlChanged", (String)("Failed handling OUTPUT_MUTE: " + t));
                                    }
                                }
                            }, "controlChanged - mute output");
                        }
                        CoreAudio.this.outputMuteDialogPosted = false;
                    }
                });
                break;
            }
            case 5: {
                this.oldOutputVolume = CoreAudio.nativeGetOutputVolume();
                if (this.oldOutputVolume == this.outputVolume) break;
                this.outputVolume = this.oldOutputVolume;
                AudioEngine.controlChanged(2);
            }
        }
    }

    @Override
    public int getLatentInputSamplesCount() {
        try {
            return CoreAudio.nativeGetLatentInputSamplesCount();
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"getLatentInputSamplesCount", (String)("Failed getting count: " + t));
            return -1;
        }
    }

    @Override
    public int getLatentOutputSamplesCount() {
        try {
            return CoreAudio.nativeGetLatentOutputSamplesCount();
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"getLatentOutputSamplesCount", (String)("Failed getting count: " + t));
            return -1;
        }
    }

    @Override
    public void closeMike() {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeCloseInputDevice();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"closeMike", (String)("Failed closing microphone: " + t));
                }
            }
        }, "closeMike");
    }

    @Override
    public void closeSpkr() {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeCloseOutputDevice();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"closeSpkr", (String)("Failed closing speaker: " + t));
                }
            }
        }, "closeSpkr");
    }

    private void connectInputDevice(String deviceHnd) {
        if (deviceHnd == null || deviceHnd.trim().equals("")) {
            deviceHnd = DEFAULT;
        }
        this.setInputDevice(deviceHnd);
        AudioEngine.controlChanged(1);
    }

    private void connectOutputDevice(String deviceHnd) {
        if (deviceHnd == null || deviceHnd.trim().equals("")) {
            deviceHnd = DEFAULT;
        }
        this.setOutputDevice(deviceHnd);
        AudioEngine.controlChanged(2);
    }

    private JComponent createDeviceSelectionPanel(final JButton okBtn, final CList list, ActionListener refreshBtnAL, final ActionListener selectionAL, boolean input) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okBtn.setEnabled(list.getSelectedIndex() >= 0);
                if (CoreAudio.this.refreshRefCount == 0) {
                    selectionAL.actionPerformed(null);
                }
            }
        };
        return this.createDeviceSelectionPanel(okBtn, list, refreshBtnAL, listSelectionListener, input);
    }

    private JComponent createDeviceSelectionPanel(final JButton okBtn, final CList list, final ActionListener refreshBtnAL, final ListSelectionListener listSelectionListener, boolean input) {
        list.setSelectionMode(0);
        list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    okBtn.doClick();
                }
            }
        });
        list.addListSelectionListener(listSelectionListener);
        JScrollPane scrollPane = new JScrollPane((Component)list, 20, 30);
        this.refreshBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_REFRESH_BTN_NAME));
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                list.removeListSelectionListener(listSelectionListener);
                refreshBtnAL.actionPerformed(e);
                list.addListSelectionListener(listSelectionListener);
            }
        });
        JPanel refreshPanel = new JPanel(new FlowLayout(1, 12, 12));
        refreshPanel.add(this.refreshBtn);
        final JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new BorderLayout());
        String selectionText = input ? "WinAudio.inputSelectionText" : "WinAudio.outputSelectionText";
        selectionPanel.add((Component)this.createTextPanel(selectionText), "North");
        selectionPanel.add((Component)refreshPanel, "Center");
        selectionPanel.add((Component)scrollPane, "South");
        selectionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                list.requestFocus();
            }
        });
        selectionPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent he) {
                long flags = he.getChangeFlags();
                if ((flags & 4L) != 0L && selectionPanel.isShowing()) {
                    refreshBtnAL.actionPerformed(null);
                }
            }
        });
        return selectionPanel;
    }

    private JPanel createTextPanel(String textI18nTag) {
        MultilineLabel label = new MultilineLabel(this.i18n.getStringLegacy(textI18nTag));
        if (Platform.usingScreenReader() == 1 || Platform.usingScreenReader() == -1) {
            label.setFocusable(true);
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new FlowLayout(1, 0, 0));
        innerPanel.add((Component)label);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.add(Box.createGlue());
        outerPanel.add(innerPanel);
        outerPanel.add(Box.createGlue());
        return outerPanel;
    }

    @Override
    public void flushMike() {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeFlushInputDevice();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"flushMike", (String)("Failed flushing microphone: " + t));
                }
            }
        }, "flushMike");
    }

    @Override
    public void flushSpkr() {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeFlushOutputDevice();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"flushSpkr", (String)("Failed flushing speaker: " + t));
                }
            }
        }, "flushSpkr");
    }

    @Override
    public String getInputDevice() {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.inputDevice = CoreAudio.nativeGetInputDevice();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getInputDevice", (String)("Can't get audio device: " + t));
                }
            }
        }, "getInputDevice");
        return this.inputDevice;
    }

    @Override
    public String[] getInputDeviceList() {
        return CoreAudio.nativeEnumerateInputDevices();
    }

    @Override
    public String getInputDeviceDisplayName(final String deviceHnd) {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.inputDeviceDisplayName = CoreAudio.nativeGetInputDeviceDisplayName(deviceHnd);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getInputDeviceDisplayName", (String)("Can't get audio device display name: " + t));
                }
            }
        }, "getInputDeviceDisplayName");
        return this.inputDeviceDisplayName;
    }

    @Override
    public DeviceSelectionPanel getInputDeviceSelectionPanel(final JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){
            CList list;

            @Override
            public void apply() {
                int selectedIdx = this.list.getSelectedIndex();
                if (selectedIdx >= 0) {
                    try {
                        CoreAudio.this.connectInputDevice(CoreAudio.this.inputDeviceHnds[selectedIdx]);
                    }
                    catch (Throwable t) {
                        LogSupport.message((Object)this, (String)"inputDeviceSelectionOkBtn", (String)("Cant connect to selected audio device: " + t));
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)okBtn, (Object)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_CANT_CONNECT_AUDIO_DEVICE), (String)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_ERROR_TITLE), (int)0);
                    }
                }
            }

            @Override
            public void setup(final JButton okBtn2, final ActionListener selectionAL) {
                this.list = new CList();
                ActionListener refreshBtnAL = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CoreAudio.this.refreshRefCount++;
                        int curDevIdx = -1;
                        CoreAudio.this.nativeRequestAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CoreAudio.access$2102(CoreAudio.this, CoreAudio.nativeEnumerateInputDevices());
                                }
                                catch (Throwable t) {
                                    LogSupport.message((Object)this, (String)"setup", (String)("Can't enumerate input devices: " + t));
                                    return;
                                }
                            }
                        }, "nativeEnumerateInputDevices");
                        CoreAudio.access$2502(CoreAudio.this, new String[CoreAudio.this.inputDeviceHnds.length]);
                        for (int i = 0; i < CoreAudio.this.inputDeviceHnds.length; ++i) {
                            ((CoreAudio)CoreAudio.this).inputDeviceNames[i] = CoreAudio.this.getInputDeviceDisplayName(CoreAudio.this.inputDeviceHnds[i]);
                            if (!CoreAudio.this.inputDeviceHnds[i].equals(CoreAudio.this.inputDeviceHnd)) continue;
                            curDevIdx = i;
                        }
                        list.setListData((Object[])CoreAudio.this.inputDeviceNames);
                        okBtn2.setEnabled(false);
                        selectionAL.actionPerformed(null);
                        if (curDevIdx >= 0) {
                            list.setSelectedIndex(curDevIdx);
                            okBtn2.setEnabled(true);
                        } else {
                            okBtn2.setEnabled(false);
                        }
                        CoreAudio.this.refreshRefCount--;
                    }
                };
                this.selectionPanel = CoreAudio.this.createDeviceSelectionPanel(okBtn2, this.list, refreshBtnAL, selectionAL, true);
            }
        };
        return panel;
    }

    @Override
    public int getMikeBoost() {
        if (!this.boostInitialized) {
            this.getNativeInputBoost();
            this.boostInitialized = true;
        }
        return this.inputBoostLevel;
    }

    private void getNativeInputBoost() {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.inputBoostLevel = CoreAudio.nativeGetInputBoost();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getMikeBoost", (String)("Can't get boost on current audio device: " + t));
                    CoreAudio.this.inputBoostLevel = -1;
                }
            }
        }, "getMikeBoost");
    }

    @Override
    public int getMikeGain() {
        if (this.inputVolume < 0) {
            this.getNativeInputVolume();
        }
        return this.inputVolume;
    }

    private int getNativeInputVolume() {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.inputVolume = CoreAudio.nativeGetInputVolume();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getNativeInputVolume", (String)("Can't get volume of current audio device: " + t));
                }
            }
        }, "getNativeInputVolume");
        return this.inputVolume;
    }

    @Override
    public String getOutputDevice() {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.outputDevice = CoreAudio.nativeGetOutputDevice();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getOutputDevice", (String)("Can't get audio device: " + t));
                }
            }
        }, "getOutputDevice");
        return this.outputDevice;
    }

    private int getOpenInputDevice(final int rate, final int millis) {
        this.inputDeviceProblem = false;
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.openInputDevice = CoreAudio.nativeOpenInputDevice(rate, millis);
                }
                catch (Throwable t) {
                    CoreAudio.this.inputDeviceProblem = true;
                }
            }
        }, "getOpenInputDevice");
        if (this.inputDeviceProblem) {
            throw new RuntimeException("Failed opening input device");
        }
        return this.openInputDevice;
    }

    private int getOpenOutputDevice(final int rate, final int millis) {
        this.outputDeviceProblem = false;
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.openOutputDevice = CoreAudio.nativeOpenOutputDevice(rate, millis);
                }
                catch (Throwable t) {
                    CoreAudio.this.outputDeviceProblem = true;
                }
            }
        }, "getOpenOutputDevice");
        if (this.outputDeviceProblem) {
            throw new RuntimeException("Failed opening output device");
        }
        return this.openOutputDevice;
    }

    @Override
    public String[] getOutputDeviceList() {
        return CoreAudio.nativeEnumerateOutputDevices();
    }

    @Override
    public String getOutputDeviceDisplayName(final String deviceHnd) {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.outputDeviceDisplayName = CoreAudio.nativeGetOutputDeviceDisplayName(deviceHnd);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getOutputDeviceDisplayName", (String)("Can't get audio device display name: " + t));
                }
            }
        }, "getOutputDeviceDisplayName");
        return this.outputDeviceDisplayName;
    }

    @Override
    public DeviceSelectionPanel getOutputDeviceSelectionPanel(final JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel = new DeviceSelectionPanel(okBtn, selectionAL){
            CList list;

            @Override
            public void apply() {
                int selectedIdx = this.list.getSelectedIndex();
                if (selectedIdx >= 0) {
                    try {
                        CoreAudio.this.connectOutputDevice(CoreAudio.this.outputDeviceHnds[selectedIdx]);
                    }
                    catch (Throwable t) {
                        LogSupport.message((Object)this, (String)"outputDeviceSelectionOkBtn", (String)("Cant connect to selected audio device: " + t));
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)okBtn, (Object)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_CANT_CONNECT_AUDIO_DEVICE), (String)CoreAudio.this.i18n.getString((PropertiesEnum)StringsProperties.WINAUDIO_ERROR_TITLE), (int)0);
                    }
                }
            }

            @Override
            public void setup(final JButton okBtn2, final ActionListener selectionAL) {
                this.list = new CList();
                ActionListener refreshBtnAL = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CoreAudio.this.refreshRefCount++;
                        int curDevIdx = -1;
                        CoreAudio.this.nativeRequestAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CoreAudio.access$4202(CoreAudio.this, CoreAudio.nativeEnumerateOutputDevices());
                                }
                                catch (Throwable t) {
                                    LogSupport.message((Object)this, (String)"setup", (String)("Can't enumerate output devices: " + t));
                                    return;
                                }
                            }
                        }, "nativeEnumerateOutputDevices");
                        CoreAudio.access$4502(CoreAudio.this, new String[CoreAudio.this.outputDeviceHnds.length]);
                        for (int i = 0; i < CoreAudio.this.outputDeviceHnds.length; ++i) {
                            ((CoreAudio)CoreAudio.this).outputDeviceNames[i] = CoreAudio.this.getOutputDeviceDisplayName(CoreAudio.this.outputDeviceHnds[i]);
                            if (!CoreAudio.this.outputDeviceHnds[i].equals(CoreAudio.this.outputDeviceHnd)) continue;
                            curDevIdx = i;
                        }
                        list.setListData((Object[])CoreAudio.this.outputDeviceNames);
                        okBtn2.setEnabled(false);
                        selectionAL.actionPerformed(null);
                        if (curDevIdx >= 0) {
                            list.setSelectedIndex(curDevIdx);
                            okBtn2.setEnabled(true);
                        } else {
                            okBtn2.setEnabled(false);
                        }
                        CoreAudio.this.refreshRefCount--;
                    }
                };
                this.selectionPanel = CoreAudio.this.createDeviceSelectionPanel(okBtn2, this.list, refreshBtnAL, selectionAL, false);
            }
        };
        return panel;
    }

    @Override
    public int getSpkrVolume() {
        if (this.outputVolume < 0) {
            this.getNativeOutputVolume();
        }
        return this.outputVolume;
    }

    private int getNativeOutputVolume() {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.outputVolume = CoreAudio.nativeGetOutputVolume();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"getNativeOutputVolume", (String)("Can't get volume of current audio device: " + t));
                }
            }
        }, "getNativeOutputVolume");
        return this.outputVolume;
    }

    @Override
    public void initialize() {
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
        }
        this.monitorThread = new WorkerThread(new Runnable(){

            @Override
            public void run() {
                CoreAudio.this.stopMonitoring = false;
                CoreAudio.this.nativeMonitorControls();
                CoreAudio.this.monitorThread = null;
            }
        }, "AudioControlsMonitor");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    @Override
    public boolean isInputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public boolean isOutputDeviceSelectionSupported() {
        return true;
    }

    @Override
    public int openMike(int desiredRate) {
        int actualRate = this.getOpenInputDevice(desiredRate, 4000);
        if (this.inputDeviceHnd == null) {
            this.inputDeviceHnd = this.getInputDevice();
            AudioEngine.controlChanged(1);
        }
        return actualRate;
    }

    @Override
    public int openSpkr(int desiredRate) {
        int actualRate = this.getOpenOutputDevice(desiredRate, 1000);
        if (this.outputDeviceHnd == null) {
            this.outputDeviceHnd = this.getOutputDevice();
            AudioEngine.controlChanged(2);
        }
        return actualRate;
    }

    @Override
    public void readMike(short[] samples, int samplesOff, int samplesCnt) {
        CoreAudio.nativeReadInputDevice(samples, samplesOff, samplesCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nativeRequest(Runnable runnable, String reason) {
        Object object = this.workerLock;
        synchronized (object) {
            if (AudioDebug.NATIVE.isEnabled()) {
                LogSupport.message((String)("set: " + reason));
            }
            if (this.nativeWorker == null) {
                this.startWorker();
            }
            this.nativeWorker.invoke(runnable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nativeRequestAndWait(Runnable runnable, String reason) {
        Object object = this.workerLock;
        synchronized (object) {
            if (AudioDebug.NATIVE.isEnabled()) {
                LogSupport.message((String)("setAndWait: " + reason));
            }
            if (this.nativeWorker != null) {
                this.startWorker();
            }
            this.nativeWorker.invoke(runnable, true);
        }
    }

    @Override
    public void setInputDevice(final String deviceHnd) {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.this.boostInitialized = false;
                    CoreAudio.nativeSetInputDevice(deviceHnd);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"setInputDevice", (String)("Can't set device: " + t));
                }
            }
        }, "setInputDevice");
        this.inputDeviceHnd = this.getInputDevice();
        LogSupport.message((Object)this, (String)"setInputDevice", (String)("input device = " + (this.inputDeviceHnd == null ? "DEFAULT (null)" : this.getInputDeviceDisplayName(this.inputDeviceHnd) + " (" + this.inputDeviceHnd + ")")));
    }

    @Override
    public void setMikeBoost(int percent) {
    }

    @Override
    public void setMikeGain(final int percent) {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeSetInputVolume(percent);
                    CoreAudio.this.inputVolume = -1;
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"setMikeGain", (String)("Can't set volume on current audio device: " + t));
                }
            }
        }, "setMikeGain");
    }

    @Override
    public void setOutputDevice(final String deviceHnd) {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeSetOutputDevice(deviceHnd);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"setOutputDevice", (String)("Can't set device: " + t));
                }
            }
        }, "setOuptutDevice");
        this.outputDeviceHnd = this.getOutputDevice();
        LogSupport.message((Object)this, (String)"setOutputDevice", (String)("output device = " + (this.outputDeviceHnd == null ? "DEFAULT (null)" : this.getOutputDeviceDisplayName(this.outputDeviceHnd) + " (" + this.outputDeviceHnd + ")")));
    }

    @Override
    public void setOwner(Component owner) {
        this.owner = owner;
    }

    @Override
    public void setSpkrVolume(final int percent) {
        this.nativeRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreAudio.nativeSetOutputVolume(percent);
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"setSpkrVolume", (String)("Can't set volume on current audio device: " + t));
                }
            }
        }, "setSpkrVolume");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker() {
        Object object = this.workerLock;
        synchronized (object) {
            if (this.nativeWorker == null) {
                this.nativeWorker = new NativeWorker();
                this.nativeWorker.start();
            }
        }
    }

    @Override
    public boolean supportsFullDuplex() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorker() {
        Object object = this.workerLock;
        synchronized (object) {
            this.nativeWorker.interrupt();
            this.nativeWorker = null;
        }
    }

    @Override
    public void terminate() {
        this.nativeRequestAndWait(new Runnable(){

            @Override
            public void run() {
                CoreAudio.this.stopMonitoring = true;
                try {
                    CoreAudio.nativeTerminate();
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"terminate", (String)("Failed in nativeTerminate: " + t));
                }
            }
        }, "nativeTerminate");
        this.stopWorker();
    }

    @Override
    public void writeSpkr(short[] samples, int samplesOff, int samplesCnt) {
        CoreAudio.nativeWriteOutputDevice(samples, samplesOff, samplesCnt);
    }

    static /* synthetic */ String[] access$2102(CoreAudio x0, String[] x1) {
        x0.inputDeviceHnds = x1;
        return x1;
    }

    static /* synthetic */ String[] access$2502(CoreAudio x0, String[] x1) {
        x0.inputDeviceNames = x1;
        return x1;
    }

    static /* synthetic */ String[] access$4202(CoreAudio x0, String[] x1) {
        x0.outputDeviceHnds = x1;
        return x1;
    }

    static /* synthetic */ String[] access$4502(CoreAudio x0, String[] x1) {
        x0.outputDeviceNames = x1;
        return x1;
    }

    static {
        System.loadLibrary(LIB_NAME);
        nativeVersion = CoreAudio.nativeGetVersion();
        LogSupport.message((String)("Loaded native library CoreAudio, version " + nativeVersion));
    }
}

