/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.macosx;

import com.elluminate.groupware.audio.module.macosx.CoreAudioDevice;
import com.elluminate.groupware.audio.module.macosx.CoreAudioUnit;
import com.elluminate.groupware.audio.module.macosx.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CList;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AudioInputSelectionPanel
extends JPanel {
    static final int MOD_KEYS_MASK = 15;
    private static I18n i18n = I18n.create(AudioInputSelectionPanel.class);
    private CoreAudioDevice[] choices = null;
    private JList list = null;
    private CellRenderer renderer = null;
    private JScrollPane scrollPane = null;
    private JCheckBox useDefaultBtn = null;
    private JButton okBtn = null;
    private ActionListener okBtnListener = null;
    private LightweightTimer refreshTimer = null;
    private boolean supressDuringRefresh = false;
    private Icon firewireIcon = AudioInputSelectionPanel.checkAndLoadIcon("AudioInputSelectionPanel.firewireIcon");
    private Icon usbIcon = AudioInputSelectionPanel.checkAndLoadIcon("AudioInputSelectionPanel.USBIcon");
    private Icon wirelessIcon = AudioInputSelectionPanel.checkAndLoadIcon("AudioInputSelectionPanel.bluetoothIcon");
    private CoreAudioUnit inUnit;

    private static Icon checkAndLoadIcon(String key) {
        ImageIcon result = null;
        try {
            result = i18n.getIcon(key);
        }
        catch (Throwable t) {
            LogSupport.message(AudioInputSelectionPanel.class, (String)"checkAndLoadIcon", (String)("Error loading " + key + ": " + Debug.getStackTrace((Throwable)t)));
            result = null;
        }
        return result;
    }

    public AudioInputSelectionPanel(CoreAudioUnit inUnit, JButton parentBtn, final ActionListener selectionAL) {
        this.okBtn = parentBtn;
        this.inUnit = inUnit;
        CoreAudioDevice curDev = inUnit.getDevice();
        this.choices = CoreAudioDevice.enumerateInputDevices();
        this.list = new CList((Object[])this.choices);
        this.scrollPane = new JScrollPane(this.list, 20, 30);
        this.useDefaultBtn = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.AUDIOINPUTSELECTIONPANEL_USEDEFAULTBTNNAME));
        this.useDefaultBtn.setSelected(curDev == null);
        int nRows = Math.max(this.list.getVisibleRowCount(), this.choices.length);
        this.scrollPane.setPreferredSize(new Dimension(275, nRows * 18 + 5));
        this.renderer = new CellRenderer();
        this.list.setCellRenderer(this.renderer);
        Runnable refresher = new Runnable(){

            @Override
            public void run() {
                AudioInputSelectionPanel.this.updateDeviceList();
            }
        };
        this.refreshTimer = new LightweightTimer(2, refresher);
        this.list.clearSelection();
        this.list.setSelectionMode(0);
        this.selectDevice(curDev);
        this.okBtn.setEnabled(this.useDefaultBtn.isSelected() || this.list.getSelectedIndex() >= 0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lev) {
                if (AudioInputSelectionPanel.this.list.getSelectedIndex() >= 0) {
                    AudioInputSelectionPanel.this.useDefaultBtn.setSelected(false);
                    AudioInputSelectionPanel.this.okBtn.setEnabled(true);
                } else {
                    AudioInputSelectionPanel.this.okBtn.setEnabled(AudioInputSelectionPanel.this.useDefaultBtn.isSelected());
                }
                if (!AudioInputSelectionPanel.this.supressDuringRefresh) {
                    selectionAL.actionPerformed(null);
                }
            }
        });
        this.useDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aev) {
                if (AudioInputSelectionPanel.this.useDefaultBtn.isSelected()) {
                    if (AudioInputSelectionPanel.this.list.getSelectedIndex() >= 0) {
                        AudioInputSelectionPanel.this.list.clearSelection();
                    }
                    AudioInputSelectionPanel.this.okBtn.setEnabled(true);
                } else {
                    if (AudioInputSelectionPanel.this.list.getSelectedIndex() < 0) {
                        AudioInputSelectionPanel.this.selectDevice(CoreAudioDevice.getDefaultInputDevice());
                    }
                    AudioInputSelectionPanel.this.okBtn.setEnabled(AudioInputSelectionPanel.this.list.getSelectedIndex() >= 0);
                }
            }
        });
        this.okBtnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent he) {
                long flags = he.getChangeFlags();
                if ((flags & 4L) != 0L) {
                    if (AudioInputSelectionPanel.this.isShowing()) {
                        AudioInputSelectionPanel.this.shownHandler();
                    } else {
                        AudioInputSelectionPanel.this.hiddenHandler();
                    }
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mev) {
                if (mev.isConsumed()) {
                    return;
                }
                if ((mev.getModifiers() & 0xF) != 0) {
                    return;
                }
                if (AudioInputSelectionPanel.this.list.getSelectedIndex() < 0) {
                    return;
                }
                if (mev.getClickCount() == 2) {
                    AudioInputSelectionPanel.this.okBtn.doClick();
                }
            }
        });
        String msgText = i18n.getString((PropertiesEnum)StringsProperties.MACOSXAUDIOSUPPORT_INPUTSELECTMESSAGE);
        MultilineLabel message = new MultilineLabel(msgText);
        message.setOpaque(true);
        message.setLineWrap(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)message, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 10, 4, 10), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.useDefaultBtn, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void apply() {
        CoreAudioDevice dev = this.getSelectedDevice();
        try {
            this.inUnit.setDevice(dev);
        }
        catch (Throwable t) {
            String devInfo = dev == null ? "" : dev.toString();
            String msg = i18n.getString((PropertiesEnum)StringsProperties.AUDIOINPUTSELECTIONPANEL_SELECTFAILEDMSG, new Object[]{devInfo});
            String title = i18n.getString((PropertiesEnum)StringsProperties.AUDIOINPUTSELECTIONPANEL_SELECTFAILEDTITLE);
            LogSupport.message((Object)this, (String)"actionPerformed", (String)(msg + "\n" + t));
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)msg, (String)title, (int)0);
        }
    }

    private void shownHandler() {
        this.refreshTimer.scheduleEvery(2000L);
    }

    private void hiddenHandler() {
        this.refreshTimer.cancel();
    }

    private void updateDeviceList() {
        Object[] curChoices = CoreAudioDevice.enumerateInputDevices();
        if (Arrays.equals(this.choices, curChoices)) {
            return;
        }
        CoreAudioDevice curDev = (CoreAudioDevice)this.list.getSelectedValue();
        this.supressDuringRefresh = true;
        this.choices = curChoices;
        this.list.clearSelection();
        this.list.setListData(this.choices);
        this.selectDevice(curDev);
        this.supressDuringRefresh = false;
    }

    private void selectDevice(CoreAudioDevice dev) {
        if (this.choices == null) {
            return;
        }
        if (dev == null) {
            return;
        }
        for (int ix = 0; ix < this.choices.length; ++ix) {
            if (this.choices[ix] == null || this.choices[ix].getDeviceID() != dev.getDeviceID()) continue;
            this.list.setSelectedValue(this.choices[ix], true);
            break;
        }
    }

    private CoreAudioDevice getSelectedDevice() {
        if (this.useDefaultBtn.isSelected()) {
            return null;
        }
        return (CoreAudioDevice)this.list.getSelectedValue();
    }

    private static void revealSoundInputPrefs() {
        String asTell = "tell application \"System Preferences\" to ";
        String[] command = new String[]{"osascript", "-e", null, "-e", asTell + "activate"};
        command[2] = Platform.checkOSVersion((int)202, (String)"10.4+") ? asTell + "tell pane id \"com.apple.preference.sound\" to reveal anchor \"input\"" : asTell + "set current pane to pane id \"com.apple.preference.sound\"";
        try {
            ProcessUtils.exec((String[])command);
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    class CellRenderer
    extends DefaultListCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (result instanceof JLabel && value instanceof CoreAudioDevice) {
                JLabel label = (JLabel)result;
                CoreAudioDevice dev = (CoreAudioDevice)value;
                label.setHorizontalTextPosition(10);
                switch (dev.getDeviceType()) {
                    case 4: {
                        label.setIcon(AudioInputSelectionPanel.this.firewireIcon);
                        break;
                    }
                    case 3: {
                        label.setIcon(AudioInputSelectionPanel.this.usbIcon);
                        break;
                    }
                    case 5: {
                        label.setIcon(AudioInputSelectionPanel.this.wirelessIcon);
                        break;
                    }
                    default: {
                        label.setIcon(null);
                    }
                }
            }
            return result;
        }
    }
}

