/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandNoPermissionException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.TransmitAudioCommand;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class TransmitAudioCmd
extends AbstractCommand
implements TransmitAudioCommand {
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<AudioBean> beanProvider;

    @Inject
    public void initAudioBeanProvider(Provider<AudioBean> bp) {
        this.beanProvider = bp;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnline();
        AudioBean bean = (AudioBean)this.beanProvider.get();
        CRSession session = bean.getSession();
        CRParticipant me = session.getMe();
        if (me != null) {
            if (!session.getPermissionValue("AudioPermission", me.getID())) {
                throw new CommandNoPermissionException("You have no Audio permission.");
            }
        } else {
            throw new CommandNoPermissionException("No Me Participant.");
        }
        if (!bean.startTransmitAudioCmd()) {
            throw new CommandContextException("Transmit audio cannot be started right now", this.i18n.getString((PropertiesEnum)StringsProperties.TRANSMITAUDIOCMD_BADCONTEXTCANNOTTRANSMIT));
        }
    }
}

