/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.VUMeter;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JSlider;

public class SpkrVUMeter
extends VUMeter {
    private static final long SAMPS_PER_MILLI = 8L;
    private static final long TIMER_INTERVAL = 240L;
    private int chanCnt;
    private int curLevel = 0;
    private TreeMap levelMap;
    private long[] playDoneTime;
    private int prevLevel = 0;
    private LightweightTimer timer;
    private long timerStartTime;

    public SpkrVUMeter(int chanCnt) {
        this(chanCnt, null);
    }

    public SpkrVUMeter(int chanCnt, JSlider level) {
        super(level);
        if (chanCnt < 1) {
            throw new IllegalArgumentException("chanCnt < 1");
        }
        this.chanCnt = chanCnt;
        this.levelMap = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                int iv1 = (Integer)o1;
                int iv2 = (Integer)o2;
                return iv1 - iv2;
            }
        });
        this.playDoneTime = new long[chanCnt];
        this.timer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                SpkrVUMeter.this.update();
            }
        });
        this.timerStartTime = Platform.currentTimeMillis();
        this.timer.scheduleEvery(240L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSamples(int chan, short[] samples) {
        if (chan < 0) {
            throw new IllegalArgumentException("chan < 0");
        }
        if (chan >= this.chanCnt) {
            throw new IllegalArgumentException("chan >= " + this.chanCnt);
        }
        if (samples == null) {
            throw new IllegalArgumentException("samples = null");
        }
        int level = AudioBean.volumeLevel(samples);
        long now = Platform.currentTimeMillis();
        long playStartTime = this.playDoneTime[chan] < now ? now : this.playDoneTime[chan];
        int trimPct = AudioEngine.getSpkrBacklogTrimPct(playStartTime - now);
        int trimmedLength = samples.length * (100 - trimPct) / 100;
        this.playDoneTime[chan] = playStartTime + (long)trimmedLength / 8L;
        int intervalIdx = this.timerIntervalIndex(playStartTime);
        Debug.lockEnter((Object)this, (String)"addSamples", (String)"levelMap", (Object)this.levelMap);
        TreeMap treeMap = this.levelMap;
        synchronized (treeMap) {
            Integer curLevel = (Integer)this.levelMap.get(new Integer(intervalIdx));
            if (curLevel == null || curLevel < level) {
                this.levelMap.put(new Integer(intervalIdx), new Integer(level));
            }
        }
        Debug.lockLeave((Object)this, (String)"addSamples", (String)"levelMap", (Object)this.levelMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Debug.lockEnter((Object)this, (String)"reset", (String)"levelMap", (Object)this.levelMap);
        TreeMap treeMap = this.levelMap;
        synchronized (treeMap) {
            this.levelMap.clear();
        }
        Debug.lockLeave((Object)this, (String)"reset", (String)"levelMap", (Object)this.levelMap);
        for (int i = 0; i < this.chanCnt; ++i) {
            this.playDoneTime[i] = 0L;
        }
    }

    private int timerIntervalIndex(long time) {
        return (int)((time - this.timerStartTime) / 240L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.curLevel = 0;
        int intervalIdx = this.timerIntervalIndex(Platform.currentTimeMillis());
        Debug.lockEnter((Object)this, (String)"update", (String)"levelMap", (Object)this.levelMap);
        TreeMap treeMap = this.levelMap;
        synchronized (treeMap) {
            Integer firstKey;
            int firstKeyValue;
            while (this.levelMap.size() > 0 && (firstKeyValue = (firstKey = (Integer)this.levelMap.firstKey()).intValue()) <= intervalIdx) {
                this.curLevel = (Integer)this.levelMap.remove(firstKey);
            }
        }
        Debug.lockEnter((Object)this, (String)"update", (String)"levelMap", (Object)this.levelMap);
        if (this.curLevel != this.prevLevel) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SpkrVUMeter.this.setValue(SpkrVUMeter.this.curLevel);
                    SpkrVUMeter.this.prevLevel = SpkrVUMeter.this.curLevel;
                }
            });
        }
    }
}

