/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.classroom.client.AudioVideoPrefsOwner;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.AudioModule;
import com.elluminate.groupware.audio.module.AudioSupport;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CList;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

@Singleton
public class SpeakerSettingsPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private AudioModule module;
    private JCheckBox muteBox;
    private JComboBox sampleRatePopup;
    private AudioEngine engine;
    private CList list = new CList();
    private boolean outputSelectionSupported = false;
    private DeviceSelectionPanel selectionPanel = null;
    private boolean outputDeviceSelected = false;
    private JButton outputOkBtn;

    @Inject
    public SpeakerSettingsPrefsPanel(AudioVideoPrefsOwner owner, I18n i18n, DialogParentProvider parentProv, AudioModule module) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_TITLE));
        this.i18n = i18n;
        this.module = module;
        this.list.setSelectionMode(0);
        this.engine = AudioEngine.getInstance(parentProv.getDialogParent());
    }

    protected void createContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 4;
        gbc.insets.left = 0;
        new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_REFRESH_BTN_NAME));
        this.outputSelectionSupported = this.engine.isOutputDeviceSelectionSupported();
        if (this.outputSelectionSupported) {
            this.outputOkBtn = new JButton("Ok");
            this.outputOkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeakerSettingsPrefsPanel.this.setModified(true);
                    SpeakerSettingsPrefsPanel.this.outputDeviceSelected = true;
                }
            });
            this.selectionPanel = this.engine.getOutputDeviceSelectionPanel(this.outputOkBtn, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeakerSettingsPrefsPanel.this.outputDeviceSelected = SpeakerSettingsPrefsPanel.this.outputOkBtn.isEnabled();
                    SpeakerSettingsPrefsPanel.this.setModified(SpeakerSettingsPrefsPanel.this.outputDeviceSelected);
                }
            });
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add(this.selectionPanel.getSelectionPanel(), gbc);
            gbc.weighty = 0.0;
            ++gbc.gridy;
        }
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        this.muteBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_MUTESPEAKERSBOX));
        this.muteBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeakerSettingsPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.muteBox, gbc);
        String[] rates = new String[AudioBean.SAMP_RATES.length];
        for (int i = 0; i < AudioBean.SAMP_RATES.length; ++i) {
            rates[i] = AudioBean.SAMP_RATES[i] + " Hz";
        }
        ++gbc.gridy;
        gbc.insets.top = 12;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        JLabel l = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_SAMPLERATELABEL));
        this.add(l, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.sampleRatePopup = new JComboBox<String>(rates);
        this.sampleRatePopup.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_SAMPLERATETEXT));
        this.sampleRatePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeakerSettingsPrefsPanel.this.setModified(true);
            }
        });
        l.setLabelFor(this.sampleRatePopup);
        this.add(this.sampleRatePopup, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.top = 4;
        gbc.insets.left = 0;
        gbc.fill = 2;
        MultilineLabel sampleRateText = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_SAMPLERATETEXT));
        Font sampleRateFont = sampleRateText.getFont();
        sampleRateText.setFont(sampleRateFont.deriveFont((float)(sampleRateFont.getSize() * 11 / 12)));
        this.add((Component)sampleRateText, gbc);
        gbc.fill = 0;
    }

    private boolean isJavaSound() {
        LogSupport.message((String)"isJavaSound");
        try {
            Class<?> supportClass = Class.forName("com.elluminate.groupware.audio.module.javasound.JavaSoundAudioSupport");
            AudioSupport audioSupport = (AudioSupport)supportClass.newInstance();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected void populate(Preferences preferences) {
        String prefix = this.module.getPrefix();
        if (!this.engine.supportsFullDuplex()) {
            this.muteBox.setSelected(true);
            this.muteBox.setEnabled(false);
        } else {
            boolean mute = AudioBean.getPreferredSpeakerMute(prefix, preferences);
            this.muteBox.setSelected(mute);
            this.muteBox.setEnabled(true);
        }
        int rate = AudioBean.getPreferredSpeakerSampleRate(prefix, preferences);
        this.sampleRatePopup.setSelectedItem(rate + " Hz");
        this.outputDeviceSelected = false;
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
        String prefix = this.module.getPrefix();
        AudioBean.setPreferredSpeakerMute(prefix, preferences, this.muteBox.isSelected());
        int rate = AudioBean.SAMP_RATE_DEFAULT_FOR_SPKR;
        String item = (String)this.sampleRatePopup.getSelectedItem();
        if (item != null) {
            try {
                rate = Integer.parseInt(item.substring(0, item.length() - " Hz".length()));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        AudioBean.setPreferredSpeakerSampleRate(prefix, preferences, rate);
        if (this.outputSelectionSupported && this.outputDeviceSelected) {
            this.engine.suspendSpkr();
            this.engine.flushOutput();
            this.engine.waitForSpeakerSuspend();
            this.selectionPanel.apply();
            this.engine.resumeSpkr();
        }
    }

    protected void reset(Preferences preferences) {
        String prefix = this.module.getPrefix();
        AudioBean.setPreferredSpeakerMute(prefix, preferences, false);
        AudioBean.setPreferredSpeakerSampleRate(prefix, preferences, AudioBean.SAMP_RATE_DEFAULT_FOR_SPKR);
    }
}

