/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.groupware.audio.LoadTestResponderInterface;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;

public class LoadTestResponder
implements LoadTestResponderInterface,
PropertyChangeListener {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static final int MAX_MILLIS_PER_PACKET = 240;
    private static final int NULL_TALKER_INDEX = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_GRANTED = 1;
    private static final int STATE_REVOKED = 2;
    private static final int STATE_REQUESTED = 3;
    private byte[] audioPacket = new byte[216];
    private LinkedList channels = null;
    private Channel chnl = null;
    private ClientList clients = new ClientList(null);
    private LightweightTimer emitTimer = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            LoadTestResponder.this.sendECELP();
        }
    });
    private long emitTimerDesiredStart = 0L;
    private volatile int minMillisPerPacket = 20;
    private volatile int myTalkerIdx = -1;
    private boolean requested = false;
    private boolean sending = false;
    private LinkedList setupAudio = null;
    private int state = 0;

    public void onChannelData(ChannelDataEvent cde) {
        if (this.channels == null || this.channels.size() < 1) {
            this.stopSending();
            return;
        }
        this.chnl = (Channel)this.channels.get(0);
        switch (cde.getCommand()) {
            case 7: {
                ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)6);
                this.chnl.onChannelData(event, (byte)2);
                break;
            }
            case 2: 
            case 3: {
                byte[] contents = cde.getContents();
                short address = this.loadShortField(contents, 0);
                ClientInfo ci = this.clients.get(address);
                if (ci == null || !ci.isMe()) break;
                if (cde.getCommand() == 3) {
                    this.myTalkerIdx = contents[2] & 0xFF;
                    this.floorGrant();
                    break;
                }
                this.floorRelease();
                this.myTalkerIdx = -1;
                break;
            }
            case 11: {
                byte reply = this.getMaxXmitSpeed() < 300000 ? (byte)9 : 10;
                ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)reply);
                this.chnl.onChannelData(event, (byte)0);
                break;
            }
            default: {
                if ((cde.getCommand() & 0xFF) < 64) break;
                this.receiveAudio(cde);
            }
        }
    }

    private void floorGrant() {
        this.setState(1);
    }

    private void floorRelease() {
        this.setState(2);
    }

    public void floorRequest() {
        this.setState(3);
    }

    private int getMaxXmitSpeed() {
        Connection connection = this.clients == null ? null : this.clients.getConnection();
        int xmitSpeed = 0;
        if (connection != null && (xmitSpeed = connection.getMaxXmitSpeed()) < 0) {
            xmitSpeed = 10000000;
        }
        return xmitSpeed;
    }

    private void loadSetupAudio() {
        if (this.setupAudio == null) {
            this.setupAudio = new LinkedList();
            try {
                byte[] ecelpData = new Resource((Object)this, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_SETUPAUDIO)).load();
                if (ecelpData == null) {
                    ecelpData = new Resource((Object)this, i18n.getString((PropertiesEnum)StringsProperties.AUDIOSETUPWIZARD_SETUPAUDIOBACKUP)).load();
                }
                if (ecelpData == null) {
                    throw new RuntimeException("Cannot find setup prerecorded audio");
                }
                int encodedFrameSize = 18;
                int off = 0;
                while (off + encodedFrameSize <= ecelpData.length) {
                    byte[] encodedFrame = new byte[encodedFrameSize];
                    System.arraycopy(ecelpData, off, encodedFrame, 0, encodedFrameSize);
                    this.setupAudio.add(encodedFrame);
                    off += encodedFrameSize;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                LogSupport.exception((Object)this, (String)"loadSetupAudio", (Throwable)t, (boolean)false);
            }
        }
    }

    private short loadShortField(byte[] buffer, int fieldOff) {
        return (short)((buffer[fieldOff] << 8) + (buffer[fieldOff + 1] & 0xFF));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        short addr = this.clients.getPropertyOwner(event.getSource());
        String pName = event.getPropertyName();
        if (pName.equals("audioFloor") && addr == this.clients.getMyAddress()) {
            ClientInfo me = this.clients.getMyClient();
            if (me.getProperty("audioFloor", false)) {
                this.floorRequest();
            } else {
                this.setState(0);
            }
        } else if (pName.equals("audioMinMillisPerPacket")) {
            this.setMinMillisPerPacket();
        } else if (pName.equals("audioTesters") && event.getNewValue() instanceof Boolean) {
            if (((Boolean)event.getNewValue()).booleanValue()) {
                this.floorRequest();
            } else {
                this.setState(0);
            }
        }
    }

    private void setMinMillisPerPacket() {
        this.minMillisPerPacket = this.clients.getProperty("audioMinMillisPerPacket", 20);
        this.minMillisPerPacket = this.minMillisPerPacket <= 20 ? 20 : (this.minMillisPerPacket >= 240 ? 240 : (this.minMillisPerPacket + 20 - 1) / 20 * 20);
    }

    private void receiveAudio(ChannelDataEvent cde) {
    }

    public void setClientList(ClientList clients) {
        this.clients = clients;
        this.setMinMillisPerPacket();
        clients.addClientPropertyChangeListener("audioFloor", (PropertyChangeListener)this);
        clients.addPropertyChangeListener("audioMinMillisPerPacket", (PropertyChangeListener)this);
        clients.addPropertyChangeListener("audioTesters", (PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        LoadTestResponder loadTestResponder = this;
        synchronized (loadTestResponder) {
            if (this.channels == null || this.channels.size() < 1) {
                this.stopSending();
                return;
            }
            this.chnl = (Channel)this.channels.get(0);
        }
        int oldState = this.state;
        this.state = newState;
        block2 : switch (oldState) {
            case 0: {
                switch (newState) {
                    case 3: {
                        if (this.requested || this.chnl == null) break block2;
                        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
                        this.chnl.onChannelData(event, (byte)0);
                        this.requested = true;
                        break;
                    }
                    default: {
                        this.stopSending();
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (newState) {
                    case 1: {
                        if (this.sending) break block2;
                        this.loadSetupAudio();
                        this.sending = true;
                        this.startSending();
                        break;
                    }
                    default: {
                        this.stopSending();
                        this.state = 0;
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.stopSending();
                break;
            }
            case 2: {
                this.stopSending();
                this.state = 0;
                break;
            }
            default: {
                this.stopSending();
                this.state = 0;
            }
        }
    }

    private void sendECELP() {
        int packetMillis = 0;
        if (this.chnl == null || this.setupAudio.isEmpty()) {
            this.stopSending();
            return;
        }
        try {
            if (this.myTalkerIdx < 0 || 64 + this.myTalkerIdx > 255) {
                throw new RuntimeException("myTalkerIdx invalid: " + this.myTalkerIdx);
            }
            int maxPacketSize = this.getMaxXmitSpeed() < 300000 ? this.audioPacket.length : this.minMillisPerPacket * 18 / 20;
            int packetSize = 0;
            while (packetSize + 18 <= maxPacketSize) {
                byte[] encodedFrame = (byte[])this.setupAudio.removeFirst();
                System.arraycopy(encodedFrame, 0, this.audioPacket, packetSize, encodedFrame.length);
                packetMillis += 20;
                packetSize += encodedFrame.length;
                this.setupAudio.addLast(encodedFrame);
            }
            ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)((byte)(64 + this.myTalkerIdx)), (byte[])this.audioPacket, (int)0, (int)packetSize);
            this.chnl.onChannelData(event, (byte)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.emitTimerDesiredStart += (long)packetMillis;
        if (this.emitTimerDesiredStart <= Platform.currentTimeMillis()) {
            this.emitTimer.scheduleIn(1L);
        } else {
            this.emitTimer.scheduleAt(this.emitTimerDesiredStart);
        }
    }

    public void setChannels(LinkedList channels) {
        this.channels = channels;
    }

    private void startSending() {
        try {
            this.emitTimerDesiredStart = Platform.currentTimeMillis() + 1L;
            this.emitTimer.scheduleAt(this.emitTimerDesiredStart);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void stopSending() {
        this.state = 0;
        this.emitTimer.cancel();
        if (this.chnl != null && this.sending && this.requested) {
            try {
                ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)2);
                this.chnl.onChannelData(event, (byte)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.requested = false;
        this.sending = false;
    }
}

