/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.audio.module.AudioAPIImpl;
import com.elluminate.groupware.audio.module.AudioBean;
import com.elluminate.groupware.audio.module.AudioEngine;
import com.elluminate.groupware.audio.module.AudioPublisher;
import com.elluminate.groupware.audio.module.FollowTheSpeakerAPIImpl;
import com.elluminate.groupware.audio.module.MicrophoneSettingsPrefsPanel;
import com.elluminate.groupware.audio.module.SetMaximumTalkersCmd;
import com.elluminate.groupware.audio.module.SpeakerSettingsPrefsPanel;
import com.elluminate.groupware.audio.module.StopAudioCmd;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.groupware.audio.module.TransmitAudioCmd;
import com.elluminate.groupware.imps.FollowTheSpeakerAPI;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.PreferencesDialogAPI;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.imps.module.AudioAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.VersionManager;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Singleton
public class AudioModule
extends AbstractClientModule
implements ActionListener,
ItemListener,
PropertyChangeListener,
PreferencesPanelOwner,
ConnectionListener,
ModulePublisherInfo,
PlaybackTimeListener {
    private Logger log = null;
    private static I18n i18n = I18n.create(AudioModule.class);
    private static final String MODULE_NAME = "Audio";
    private static final String AEC = ".webrtc.aec";
    private static final String AGC = ".webrtc.agc";
    private Imps imps;
    private ImageIcon tool = null;
    private TelephonyAPI telephony = null;
    private boolean recursive = false;
    private AudioBean audioBean = null;
    private ClientList clients = null;
    private boolean exposingMaxTalkersUI = false;
    private boolean exposingMikeBoostUI = false;
    private int maxTalkersLimit = 6;
    private Provider<AudioBean> beanProvider;
    private AudioAPI audioAPI;
    private AudioPublisher msgPublisher;
    private ClientProvider clientProvider;
    private Preferences preferences;
    private FeatureBroker broker;
    private ComponentFeature audioPanelFeature;
    private ComponentFeature speakerPrefsFeature;
    private ComponentFeature microphonePrefsFeature;
    private ActionFeature audioSetupFeature;
    private ActionFeature audioSetupIconFeature;
    private ActionFeature adjustMicLevelUpFeature;
    private ActionFeature adjustMicLevelDownFeature;
    private ActionFeature adjustSpeakerLevelUpFeature;
    private ActionFeature adjustSpeakerLevelDownFeature;
    private ActionFeature selectInputDeviceFeature;
    private ActionFeature selectOutputDeviceFeature;
    private ActionFeature maxTalkersFeature;
    private CRSession session;
    private PermissionFeatureFactory permissionFeatureFactory;
    private Provider<SpeakerSettingsPrefsPanel> speakerSettingsPrefsProvider;
    private Provider<MicrophoneSettingsPrefsPanel> micSettingsPrefsProvider;
    private boolean updating = false;
    private FollowTheSpeakerAPIImpl followTheSpeakerAPIImpl;
    private ConferencingEngine confEngine;
    private Provider<TransmitAudioCmd> transmitAudioCmdProvider;
    private Provider<StopAudioCmd> stopAudioCmdProvider;
    private Provider<SetMaximumTalkersCmd> setMaximumTalkersCmdProvider;

    @Inject
    public void intiFollowTheSpeakerAPI(FollowTheSpeakerAPIImpl ftsAPI) {
        ftsAPI.initModuleName(this.getNameOfModule());
        this.followTheSpeakerAPIImpl = ftsAPI;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initAudioBeanProvider(Provider<AudioBean> ab) {
        this.beanProvider = ab;
    }

    @Inject
    public void initAudioPublisher(AudioPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    protected void initVersionManager(VersionManager versionManager) {
        versionManager.registerComponent((Object)this);
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public void initSpeakerPrefsPanel(Provider<SpeakerSettingsPrefsPanel> prefsProv) {
        this.speakerSettingsPrefsProvider = prefsProv;
    }

    @Inject
    public void initMicrophonePrefsPanel(Provider<MicrophoneSettingsPrefsPanel> prefsProv) {
        this.micSettingsPrefsProvider = prefsProv;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine confEngine) {
        this.confEngine = confEngine;
    }

    @Inject
    public void initTransmitAudioCmdProvider(Provider<TransmitAudioCmd> transmitAudioCmdProvider) {
        this.transmitAudioCmdProvider = transmitAudioCmdProvider;
    }

    @Inject
    public void initStopAudioCmdProvider(Provider<StopAudioCmd> stopAudioCmdProvider) {
        this.stopAudioCmdProvider = stopAudioCmdProvider;
    }

    @Inject
    public void initSetMaximumTalkersCmdProvider(Provider<SetMaximumTalkersCmd> setMaximumTalkersCmdProvider) {
        this.setMaximumTalkersCmdProvider = setMaximumTalkersCmdProvider;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.getTitle();
    }

    public Icon getModuleIcon() {
        return this.getIcon();
    }

    public void configure(Client client) {
        this.audioBean.setClient(client);
        client.addConnectionListener((ConnectionListener)this);
        this.clients = client.getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("audioMaxVOIPTalkersLimit", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.clients.addClientPropertyChangeListener("audioSettingUpAudio", (PropertyChangeListener)this);
        if (this.audioAPI == null) {
            this.audioAPI = new AudioAPIImpl(this.audioBean);
        }
        this.imps.provideAPI(AudioAPI.class, (ImpsAPI)this.audioAPI);
        this.clients.addClientListener(new ClientListener(){

            public void onRemoveClient(ClientEvent e) {
            }

            public void onAddClient(ClientEvent e) {
                if (e.isMe()) {
                    AudioModule.this.clients.getMyClient().addPropertyChangeListener("audioFloor", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            AudioModule.this.sendAudioEnabledStatusUpdateMessage((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                        }
                    });
                }
            }
        });
        this.audioBean.start();
    }

    protected void sendAudioEnabledStatusUpdateMessage(Boolean oldValue, Boolean newValue) {
        if (oldValue != newValue && newValue != null) {
            if (newValue.booleanValue()) {
                this.msgPublisher.sendTalkEnabledMessage();
            } else {
                this.msgPublisher.sendTalkDisabledMessage();
            }
        }
    }

    public void connectionStatusChanged(ConnectionEvent e) {
        boolean connected = e.getAction() == 2;
        boolean playback = this.audioBean.isPlayback();
        if (!connected) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioModule.this.exposeMaxTalkersUI(false);
                }
            });
        }
        if (this.adjustMicLevelUpFeature != null) {
            if (playback) {
                this.adjustMicLevelUpFeature.setEnabled(false);
            } else {
                this.adjustMicLevelUpFeature.setEnabled(true);
            }
        }
        this.audioBean.publishTalkButton(connected);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioModule.this.updateTelephonyUI();
            }
        });
    }

    private void exposeMaxTalkersUI(boolean expose) {
        if (expose == this.exposingMaxTalkersUI) {
            return;
        }
        if (this.maxTalkersFeature != null) {
            if (expose) {
                this.maxTalkersFeature.setEnabled(true);
            } else {
                this.maxTalkersFeature.setEnabled(false);
            }
        } else {
            this.log.log("audio: maxTalkersFeature is null -> disabling maxTalkersFeature");
        }
        this.exposingMaxTalkersUI = expose;
    }

    public void exposeMikeBoostUI(boolean expose) {
        if (expose == this.exposingMikeBoostUI) {
            return;
        }
        ((MicrophoneSettingsPrefsPanel)((Object)this.micSettingsPrefsProvider.get())).setMicrophoneBoostSettingVisible(expose);
        this.exposingMikeBoostUI = expose;
    }

    protected int getAudioMode(short address) {
        int mode = 0;
        if (this.telephony == null) {
            return mode;
        }
        if (this.clients == null) {
            return mode;
        }
        if (address != -32767) {
            mode = this.telephony.getAudioMode(address);
        }
        return mode;
    }

    protected ClientList getClients() {
        return this.clients;
    }

    public TelephonyAPI getTelephonyAPI() {
        return this.telephony;
    }

    public void setupUI() {
        this.audioBean.moduleInstalled(this);
        this.loadPreferences();
        this.registerPrefsListeners();
        this.audioBean.loadPreferences(this.getPrefix(), this.preferences);
    }

    private void loadPreferences() {
        AudioEngine.getInstance(this.audioBean.getAppFrame()).setAecWebrtcEnabled(this.preferences.getBooleanSetting(this.getPrefix() + AEC, true));
        AudioEngine.getInstance(this.audioBean.getAppFrame()).setAgcWebrtcEnabled(this.preferences.getBooleanSetting(this.getPrefix() + AGC, true));
    }

    private void registerPrefsListeners() {
        this.preferences.addSettingChangeListener(this.getPrefix() + AEC, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    AudioEngine.getInstance(AudioModule.this.audioBean.getAppFrame()).setAecWebrtcEnabled(Boolean.parseBoolean(evt.getNewValue().toString()));
                }
            }
        });
        this.preferences.addSettingChangeListener(this.getPrefix() + AGC, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    AudioEngine.getInstance(AudioModule.this.audioBean.getAppFrame()).setAgcWebrtcEnabled(Boolean.parseBoolean(evt.getNewValue().toString()));
                }
            }
        });
    }

    public boolean isNonLinear() {
        return this.audioBean.isMuted();
    }

    protected boolean isTelephoneMode() {
        if (this.clients == null) {
            return false;
        }
        short myAddr = this.clients.getMyAddress();
        return 2 == this.getAudioMode(myAddr);
    }

    protected boolean isTelephonyConfigured() {
        if (this.telephony == null) {
            return false;
        }
        String phone = this.telephony.getParticipantTelephone();
        if (phone == null) {
            return false;
        }
        return phone.trim().length() > 0;
    }

    protected boolean isTelephonyConnected() {
        if (this.telephony == null) {
            return false;
        }
        return this.telephony.isConnected();
    }

    protected boolean isTelephonyEnabled() {
        if (this.telephony == null) {
            return false;
        }
        return this.telephony.isEnabled();
    }

    protected boolean isVoIPMode() {
        if (this.clients == null) {
            return false;
        }
        short myAddr = this.clients.getMyAddress();
        return 1 == this.getAudioMode(myAddr);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        this.recursive = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("chair")) {
            Chair chair = ChairProtocol.getChair((ClientList)this.clients);
            this.exposeMaxTalkersUI(chair.isMe() && this.maxTalkersLimit > 1);
        } else if (prop.equals("audioMaxVOIPTalkersLimit")) {
            this.maxTalkersLimit = this.clients.getProperty("audioMaxVOIPTalkersLimit", 6);
            Chair chair = ChairProtocol.getChair((ClientList)this.clients);
            this.exposeMaxTalkersUI(chair.isMe() && this.maxTalkersLimit > 1);
        } else if (prop.equals("audioSettingUpAudio")) {
            if (this.clients == null) {
                return;
            }
            short addr = this.clients.getPropertyOwner(e.getSource());
            ClientInfo ci = this.clients.get(addr);
            if (ci == null) {
                return;
            }
            boolean participantSettingUpAudio = ci.getProperty("audioSettingUpAudio", false);
            Integer val = participantSettingUpAudio ? Integer.valueOf(1) : Integer.valueOf(0);
            this.session.setAnnotationValue(ci.getAddress(), "AudioSetupAnnotation", (Object)val);
        } else if (prop.startsWith("TelephonyAPI.")) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioModule.this.updateTelephonyUI();
                }
            });
        } else if (prop.equals("Label.session")) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioModule.this.updateTelephonyUI();
                }
            });
        }
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
        if (this.audioBean != null) {
            switch (linearity) {
                case REALTIME: {
                    this.audioBean.setMuted(false);
                    break;
                }
                case FAST_FORWARD: 
                case SEEKING: {
                    this.audioBean.setMuted(true);
                }
            }
        }
    }

    public void resetSession() {
    }

    public void start() {
        this.imps.provideAPI(FollowTheSpeakerAPI.class, (ImpsAPI)this.followTheSpeakerAPIImpl);
        this.confEngine.registerCommand(this.transmitAudioCmdProvider);
        this.confEngine.registerCommand(this.stopAudioCmdProvider);
        this.confEngine.registerCommand(this.setMaximumTalkersCmdProvider);
    }

    public void stop() {
        if (this.telephony != null) {
            this.telephony.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.audioBean.savePreferences(this.getPrefix(), this.preferences);
        if (this.audioAPI != null) {
            this.imps.revokeAPI(AudioAPI.class, (ImpsAPI)this.audioAPI);
        }
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("audioMaxVOIPTalkersLimit", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.clients.removeClientPropertyChangeListener("audioSettingUpAudio", (PropertyChangeListener)this);
        this.audioBean.close();
        this.audioBean = null;
    }

    public void unconfigure() {
    }

    private void updateTelephonyUI() {
        boolean enabled = this.isTelephonyEnabled();
        boolean isTelephoneMode = this.isTelephoneMode();
        if (this.audioBean != null) {
            this.audioBean.updateTelephonyUI();
        }
    }

    public void attach() {
        this.telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (this.telephony != null) {
            this.telephony.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.audioBean = (AudioBean)this.beanProvider.get();
        this.audioBean.registerProvider();
        this.audioBean.setModule(this);
        this.createFeatures();
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
    }

    public void detach() {
        if (AudioEngine.getInstance(this.audioBean.getAppFrame()) != null) {
            this.exposeMaxTalkersUI(false);
            this.exposeMikeBoostUI(false);
        }
        this.audioBean.moduleUninstalled(this);
    }

    public Icon getIcon() {
        return i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOMODULE_AUDIOTOOLICON);
    }

    public String getPrefix() {
        return AudioModule.class.getName();
    }

    public String getTitle() {
        return i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_COLUMNNAME);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    private boolean createFeatures() {
        this.configure(this.clientProvider.get());
        this.audioPanelFeature = this.broker.createComponentFeature((Object)this, "/audio/audioPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                AudioModule.this.log.message("FeatureBroker: returning audioBean");
                return AudioModule.this.audioBean;
            }
        }, i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TITLE), i18n.getString((PropertiesEnum)StringsProperties.AUDIOBEAN_TITLE));
        this.audioSetupFeature = this.broker.createActionFeature((Object)this, "/audio/audioSetup", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_SETUPAUDIO), i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_SETUPAUDIOTIP));
        this.audioSetupFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioModule.this.log.message("audio: audioSetupFeature clicked <====");
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.audioBean.setUpAudio();
                }
            }
        });
        this.audioSetupIconFeature = this.broker.createActionFeature((Object)this, "/audio/audioSetupIcon", null, i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_SETUPAUDIOTIP));
        this.audioSetupIconFeature.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_SETUPAUDIOICON));
        this.audioSetupIconFeature.setPressedIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_SETUPAUDIO_PRESSED_ICON));
        this.audioSetupIconFeature.setRolloverIcon(i18n.getImage((PropertiesEnum)StringsProperties.AUDIOMODULE_SETUPAUDIO_ROLLOVER_ICON));
        this.audioSetupIconFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioModule.this.log.message("audio: audioSetupIconFeature clicked <====");
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.audioBean.setUpAudio();
                }
            }
        });
        this.adjustMicLevelUpFeature = this.broker.createActionFeature((Object)this, "/audio/adjustMicLevelUp", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_ADJUSTMIKEGAINUP), null);
        this.adjustMicLevelUpFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.log.message("audio: adjustMicLevelUp clicked.");
                    if (AudioModule.this.audioBean != null) {
                        AudioModule.this.audioBean.adjustLocalMikeGain(1.1f, false, false);
                    }
                }
            }
        });
        this.adjustMicLevelDownFeature = this.broker.createActionFeature((Object)this, "/audio/adjustMicLevelDown", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_ADJUSTMIKEGAINDOWN), null);
        this.adjustMicLevelDownFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.log.message("audio: adjustMicLevelDown clicked.");
                    if (AudioModule.this.audioBean != null) {
                        AudioModule.this.audioBean.adjustLocalMikeGain(0.9f, false, false);
                    }
                }
            }
        });
        this.adjustSpeakerLevelUpFeature = this.broker.createActionFeature((Object)this, "/audio/adjustSpeakerLevelUp", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_ADJUSTSPKRVOLUMEUP), null);
        this.adjustSpeakerLevelUpFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.log.message("audio: adjustSpeakerLevelUp clicked.");
                    if (AudioModule.this.audioBean != null) {
                        AudioModule.this.audioBean.adjustLocalSpkrVolume(1.1f);
                    }
                }
            }
        });
        this.adjustSpeakerLevelDownFeature = this.broker.createActionFeature((Object)this, "/audio/adjustSpeakerLevelDown", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_ADJUSTSPKRVOLUMEDOWN), null);
        this.adjustSpeakerLevelDownFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.log.message("audio: adjustSpeakerLevelDown clicked.");
                    if (AudioModule.this.audioBean != null) {
                        AudioModule.this.audioBean.adjustLocalSpkrVolume(0.9f);
                    }
                }
            }
        });
        this.selectInputDeviceFeature = this.broker.createActionFeature((Object)this, "/audio/selectInputDevice", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_INPUTSELECT), null);
        this.selectInputDeviceFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PreferencesDialogAPI preferencesDialogAPI;
                if (AudioModule.this.imps != null && (preferencesDialogAPI = (PreferencesDialogAPI)AudioModule.this.imps.findBest(PreferencesDialogAPI.class)) != null) {
                    preferencesDialogAPI.showFeaturePreferencesPanelByPath(AudioModule.this.microphonePrefsFeature.getPath());
                }
            }
        });
        this.selectOutputDeviceFeature = this.broker.createActionFeature((Object)this, "/audio/selectOutputDevice", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_OUTPUTSELECT), null);
        this.selectOutputDeviceFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PreferencesDialogAPI preferencesDialogAPI;
                if (AudioModule.this.imps != null && (preferencesDialogAPI = (PreferencesDialogAPI)AudioModule.this.imps.findBest(PreferencesDialogAPI.class)) != null) {
                    preferencesDialogAPI.showFeaturePreferencesPanelByPath(AudioModule.this.speakerPrefsFeature.getPath());
                }
            }
        });
        this.maxTalkersFeature = this.broker.createActionFeature((Object)this, "/audio/maxTalkers", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_SETMAXTALKERS), null);
        this.maxTalkersFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                AudioModule.this.log.message("audio: maxTalkers clicked <====");
                if (AudioModule.this.audioBean != null) {
                    AudioModule.this.audioBean.showMaxTalkersDialog();
                }
            }
        });
        this.speakerPrefsFeature = this.broker.createComponentFeature((Object)this, "/audio/speakerPrefs", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AudioModule.this.speakerSettingsPrefsProvider.get();
            }
        }, i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_TITLE), i18n.getString((PropertiesEnum)StringsProperties.SPEAKERSETTINGS_TITLE));
        this.speakerPrefsFeature.setEnabled(true);
        this.microphonePrefsFeature = this.broker.createComponentFeature((Object)this, "/audio/microphonePrefs", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AudioModule.this.micSettingsPrefsProvider.get();
            }
        }, i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_TITLE), i18n.getString((PropertiesEnum)StringsProperties.MICROPHONESETTINGS_TITLE));
        this.microphonePrefsFeature.setEnabled(true);
        BooleanFeature bf = this.permissionFeatureFactory.createBridgeFriendlyPermissionFeature((Object)this, "AudioPermission", "/audio/audioPermission", i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_MENUTEXT), MODULE_NAME, i18n);
        bf.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.AUDIOMODULE_MENUTEXT_ACCESSIBLENAME));
        this.session.registerAnnotation("AudioActivityAnnotation", (Object)0);
        this.session.registerAnnotation("AudioLagAnnotation", (Object)0);
        this.session.registerAnnotation("AudioSetupAnnotation", (Object)0);
        this.audioPanelFeature.setEnabled(true);
        this.speakerPrefsFeature.setEnabled(true);
        this.microphonePrefsFeature.setEnabled(true);
        this.audioSetupFeature.setEnabled(true);
        this.audioSetupIconFeature.setEnabled(true);
        this.adjustMicLevelUpFeature.setEnabled(true);
        this.adjustMicLevelDownFeature.setEnabled(true);
        this.adjustSpeakerLevelUpFeature.setEnabled(true);
        this.adjustSpeakerLevelDownFeature.setEnabled(true);
        if (this.audioBean.isInputDeviceSelectionSupported()) {
            this.selectInputDeviceFeature.setEnabled(true);
        }
        if (this.audioBean.isOutputDeviceSelectionSupported()) {
            this.selectOutputDeviceFeature.setEnabled(true);
        }
        this.maxTalkersFeature.setEnabled(false);
        this.broker.addFeature((Feature)this.audioPanelFeature);
        this.broker.addFeature((Feature)this.speakerPrefsFeature);
        this.broker.addFeature((Feature)this.microphonePrefsFeature);
        this.broker.addFeature((Feature)this.audioSetupFeature);
        this.broker.addFeature((Feature)this.audioSetupIconFeature);
        this.broker.addFeature((Feature)this.adjustMicLevelUpFeature);
        this.broker.addFeature((Feature)this.adjustMicLevelDownFeature);
        this.broker.addFeature((Feature)this.adjustSpeakerLevelUpFeature);
        this.broker.addFeature((Feature)this.adjustSpeakerLevelDownFeature);
        this.broker.addFeature((Feature)this.selectInputDeviceFeature);
        this.broker.addFeature((Feature)this.selectOutputDeviceFeature);
        this.broker.addFeature((Feature)this.maxTalkersFeature);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFeatures() {
        this.log.message("Updating Audio UI");
        AudioModule audioModule = this;
        synchronized (audioModule) {
            if (this.updating) {
                return;
            }
            this.updating = true;
        }
        audioModule = this;
        synchronized (audioModule) {
            this.updating = false;
        }
    }

    protected void disableAdjustSpeakerLevelUpMenuItem() {
        if (this.adjustSpeakerLevelUpFeature != null) {
            this.adjustSpeakerLevelUpFeature.setEnabled(false);
        }
    }

    protected void enableAdjustSpeakerLevelUpMenuItem() {
        if (this.adjustSpeakerLevelUpFeature != null && !this.adjustSpeakerLevelUpFeature.isEnabled()) {
            this.adjustSpeakerLevelUpFeature.setEnabled(true);
        }
    }

    protected void disableAdjustSpeakerLevelDownMenuItem() {
        if (this.adjustSpeakerLevelDownFeature != null && this.adjustSpeakerLevelDownFeature.isEnabled()) {
            this.adjustSpeakerLevelDownFeature.setEnabled(false);
        }
    }

    protected void enableAdjustSpeakerLevelDownMenuItem() {
        if (this.adjustSpeakerLevelDownFeature != null && !this.adjustSpeakerLevelDownFeature.isEnabled()) {
            this.adjustSpeakerLevelDownFeature.setEnabled(true);
        }
    }

    protected void disableAdjustMicLevelUpMenuItem() {
        if (this.adjustMicLevelUpFeature != null && this.adjustMicLevelUpFeature.isEnabled()) {
            this.adjustMicLevelUpFeature.setEnabled(false);
        }
    }

    protected void enableAdjustMicLevelUpMenuItem() {
        if (this.adjustMicLevelUpFeature != null && !this.adjustMicLevelUpFeature.isEnabled()) {
            this.adjustMicLevelUpFeature.setEnabled(true);
        }
    }

    protected void disableAdjustMicLevelDownMenuItem() {
        if (this.adjustMicLevelDownFeature != null && this.adjustMicLevelDownFeature.isEnabled()) {
            this.adjustMicLevelDownFeature.setEnabled(false);
        }
    }

    protected void enableAdjustMicLevelDownMenuItem() {
        if (this.adjustMicLevelDownFeature != null && !this.adjustMicLevelDownFeature.isEnabled()) {
            this.adjustMicLevelDownFeature.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LogSupport.message((String)"actionPerformed: Audio");
    }

    public void cleanupUI() {
    }
}

