/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.ecelp;

import com.elluminate.groupware.audio.ecelp.Base;
import com.elluminate.groupware.audio.ecelp.PF;
import com.elluminate.groupware.audio.ecelp.ZF;
import com.elluminate.groupware.audio.ecelp.ZF1;

public class Decoder
extends Base {
    static final float SPEECH_MAX = 32767.0f;
    static final float SPEECH_MIN = -32768.0f;
    float[] decode_acBuf = new float[187];
    PF decode_predictor;
    PF postFilter_pf;
    float postFilter_powerin;
    float postFilter_powerout;
    ZF postFilter_zf;
    ZF1 postFilter_zf1;
    float[] decode_excitation = new float[40];
    float[] decode_lspFreq = new float[10];
    float[] decode_prevLSPFreq;
    float[] decode_scaledLSPFreq;
    float[] postFilter_ast;
    float[] postFilter_newpowerin;
    float[] postFilter_newpowerout;
    float[] postFilter_rcexp2;

    Decoder() {
        this.decode_predictor = new PF();
        this.decode_prevLSPFreq = new float[10];
        this.decode_scaledLSPFreq = new float[10];
        this.postFilter_ast = new float[2];
        this.postFilter_newpowerin = new float[41];
        this.postFilter_newpowerout = new float[41];
        this.postFilter_pf = new PF();
        this.postFilter_rcexp2 = new float[10];
        this.postFilter_zf = new ZF();
        this.postFilter_zf1 = new ZF1();
        this.reset();
    }

    void decode(byte[] encodingBuf, int encodingOff, short[] speechBuf, int speechOff) {
        int i;
        float[] acBuf = this.decode_acBuf;
        float[] excitation = this.decode_excitation;
        float[] lspFreq = this.decode_lspFreq;
        PF predictor = this.decode_predictor;
        float[] prevLSPFreq = this.decode_prevLSPFreq;
        float[] scaledLSPFreq = this.decode_scaledLSPFreq;
        this.unpack(encodingBuf, encodingOff);
        for (i = 0; i < 10; ++i) {
            prevLSPFreq[i] = scaledLSPFreq[i];
            scaledLSPFreq[i] = (float)LspFreqTbl[this.lspi[i]][i] / 8000.0f;
        }
        for (int subframeIdx = 0; subframeIdx < 4; ++subframeIdx) {
            int sCodeOff = 2 * (511 - this.sci[subframeIdx]);
            float sGain = SGainTbl[this.sgi[subframeIdx]];
            for (i = 0; i < 40; ++i) {
                excitation[i] = sGain * (float)SCodebook[i + sCodeOff];
            }
            float aDelay = ADelayTbl[this.adi[subframeIdx]];
            float aGain = AGainTbl[this.agi[subframeIdx]];
            this.updateACB(aDelay, aGain, acBuf, excitation);
            for (i = 0; i < 10; ++i) {
                lspFreq[i] = ((float)(7 - 2 * subframeIdx) * prevLSPFreq[i] + (float)(1 + 2 * subframeIdx) * scaledLSPFreq[i]) / 8.0f;
            }
            this.lsptopc(lspFreq, predictor.getCoeffs());
            predictor.filter(40, excitation);
            this.postFilter(predictor.getCoeffs(), excitation);
            for (i = 0; i < 40; ++i) {
                if (excitation[i] < -32768.0f) {
                    excitation[i] = -32768.0f;
                } else if (excitation[i] > 32767.0f) {
                    excitation[i] = 32767.0f;
                }
                speechBuf[40 * subframeIdx + i + speechOff] = (short)((double)excitation[i] + (excitation[i] < 0.0f ? -0.5 : 0.5));
            }
        }
    }

    void postFilter(float[] fci, float[] speech) {
        int i;
        float Alpha = 0.8f;
        float Beta = 0.5f;
        double TC = 0.01;
        float[] ast = this.postFilter_ast;
        float[] newpowerin = this.postFilter_newpowerin;
        float[] newpowerout = this.postFilter_newpowerout;
        PF pf = this.postFilter_pf;
        float[] rcexp2 = this.postFilter_rcexp2;
        ZF zf = this.postFilter_zf;
        ZF1 zf1 = this.postFilter_zf1;
        newpowerin[0] = this.postFilter_powerin;
        for (i = 0; i < 40; ++i) {
            float sample = speech[i];
            if (sample < -32768.0f) {
                speech[i] = -32768.0f;
                sample = -32768.0f;
            } else if (sample > 32767.0f) {
                speech[i] = 32767.0f;
                sample = 32767.0f;
            }
            newpowerin[i + 1] = (float)(0.99 * (double)newpowerin[i] + 0.01 * (double)sample * (double)sample);
        }
        this.postFilter_powerin = newpowerin[40];
        Decoder.expandBandwidth(0.5f, fci, zf.getCoeffs());
        Decoder.expandBandwidth(0.8f, fci, pf.getCoeffs());
        zf.filter(40, speech);
        pf.filter(40, speech);
        this.pctorc(pf.getCoeffs(), rcexp2);
        ast[0] = 1.0f;
        ast[1] = (float)(rcexp2[0] > 0.0f ? -0.5 * (double)rcexp2[0] : 0.0);
        zf1.setCoeffs(ast);
        zf1.filter(40, speech);
        newpowerout[0] = this.postFilter_powerout;
        for (i = 0; i < 40; ++i) {
            newpowerout[i + 1] = (float)(0.99 * (double)newpowerout[i] + 0.01 * (double)speech[i] * (double)speech[i]);
        }
        this.postFilter_powerout = newpowerout[40];
        for (i = 0; i < 40; ++i) {
            if (!((double)newpowerout[i + 1] > 0.0)) continue;
            int n = i;
            speech[n] = speech[n] * (float)Math.sqrt(newpowerin[i + 1] / newpowerout[i + 1]);
        }
    }

    void reset() {
        this.resetBase();
        Decoder.zeroArray(this.decode_acBuf);
        this.decode_predictor.zeroMemory();
        System.arraycopy(InitLSPFreq, 0, this.decode_scaledLSPFreq, 0, InitLSPFreq.length);
        this.postFilter_pf.zeroMemory();
        this.postFilter_powerin = 0.0f;
        this.postFilter_powerout = 0.0f;
        this.postFilter_zf1.zeroMemory();
        this.postFilter_zf.zeroMemory();
    }
}

