/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.ecelp;

class Base {
    public static final int ADI_ABS_BITS = 8;
    public static final int ADI_REL_BITS = 6;
    public static final int AGI_BITS = 5;
    public static final int LP_ORDER = 10;
    public static final int LSPI_BITS = 4;
    public static final int MAX_SUBFRAME_LEN = 60;
    public static final int SAMP_FREQ = 8000;
    public static final int SCI_BITS = 9;
    public static final int SGI_BITS = 5;
    public static final int SUBFRAME_CNT = 4;
    public static final int SUBFRAME_LEN = 40;
    public static final int FRAME_LEN = 160;
    public static final int PFP_BITS = 144;
    public static final int PFP_SIZE = 18;
    static final int ADELAY_MAX = 147;
    static final int ACODE_CNT = 147;
    static final int ACBUF_LEN = 187;
    static final int ADELAY_CNT = 256;
    static final int AGAIN_CNT = 32;
    static final int LSP_FREQ_CNT = 16;
    static final int SCODE_CNT = 512;
    static final int SGAIN_CNT = 32;
    static final float[] ADelayTbl = new float[]{20.0f, 20.33333f, 20.66667f, 21.0f, 21.33333f, 21.66667f, 22.0f, 22.33333f, 22.66667f, 23.0f, 23.33333f, 23.66667f, 24.0f, 24.33333f, 24.66667f, 25.0f, 25.33333f, 25.66667f, 26.0f, 26.25f, 26.5f, 26.75f, 27.0f, 27.25f, 27.5f, 27.75f, 28.0f, 28.25f, 28.5f, 28.75f, 29.0f, 29.25f, 29.5f, 29.75f, 30.0f, 30.25f, 30.5f, 30.75f, 31.0f, 31.25f, 31.5f, 31.75f, 32.0f, 32.25f, 32.5f, 32.75f, 33.0f, 33.25f, 33.5f, 33.75f, 34.0f, 34.33333f, 34.66667f, 35.0f, 35.33333f, 35.66667f, 36.0f, 36.33333f, 36.66667f, 37.0f, 37.33333f, 37.66667f, 38.0f, 38.33333f, 38.66667f, 39.0f, 39.33333f, 39.66667f, 40.0f, 40.33333f, 40.66667f, 41.0f, 41.33333f, 41.66667f, 42.0f, 42.33333f, 42.66667f, 43.0f, 43.33333f, 43.66667f, 44.0f, 44.33333f, 44.66667f, 45.0f, 45.33333f, 45.66667f, 46.0f, 46.33333f, 46.66667f, 47.0f, 47.33333f, 47.66667f, 48.0f, 48.33333f, 48.66667f, 49.0f, 49.33333f, 49.66667f, 50.0f, 50.33333f, 50.66667f, 51.0f, 51.33333f, 51.66667f, 52.0f, 52.33333f, 52.66667f, 53.0f, 53.33333f, 53.66667f, 54.0f, 54.33333f, 54.66667f, 55.0f, 55.33333f, 55.66667f, 56.0f, 56.33333f, 56.66667f, 57.0f, 57.33333f, 57.66667f, 58.0f, 58.33333f, 58.66667f, 59.0f, 59.33333f, 59.66667f, 60.0f, 60.33333f, 60.66667f, 61.0f, 61.33333f, 61.66667f, 62.0f, 62.33333f, 62.66667f, 63.0f, 63.33333f, 63.66667f, 64.0f, 64.33333f, 64.66667f, 65.0f, 65.33333f, 65.66667f, 66.0f, 66.33333f, 66.66667f, 67.0f, 67.33333f, 67.66667f, 68.0f, 68.33333f, 68.66667f, 69.0f, 69.33333f, 69.66667f, 70.0f, 70.33333f, 70.66667f, 71.0f, 71.33333f, 71.66667f, 72.0f, 72.33333f, 72.66667f, 73.0f, 73.33333f, 73.66667f, 74.0f, 74.33333f, 74.66667f, 75.0f, 75.33333f, 75.66667f, 76.0f, 76.33333f, 76.66667f, 77.0f, 77.33333f, 77.66667f, 78.0f, 78.33333f, 78.66667f, 79.0f, 79.33333f, 79.66667f, 80.0f, 81.0f, 82.0f, 83.0f, 84.0f, 85.0f, 86.0f, 87.0f, 88.0f, 89.0f, 90.0f, 91.0f, 92.0f, 93.0f, 94.0f, 95.0f, 96.0f, 97.0f, 98.0f, 99.0f, 100.0f, 101.0f, 102.0f, 103.0f, 104.0f, 105.0f, 106.0f, 107.0f, 108.0f, 109.0f, 110.0f, 111.0f, 112.0f, 113.0f, 114.0f, 115.0f, 116.0f, 117.0f, 118.0f, 119.0f, 120.0f, 121.0f, 122.0f, 123.0f, 124.0f, 125.0f, 126.0f, 127.0f, 128.0f, 129.0f, 130.0f, 131.0f, 132.0f, 133.0f, 134.0f, 135.0f, 136.0f, 137.0f, 138.0f, 139.0f, 140.0f, 141.0f, 142.0f, 143.0f, 144.0f, 145.0f, 146.0f, 147.0f};
    static final float[] ADFrac = new float[]{0.25f, 0.33333334f, 0.5f, 0.6666667f, 0.75f};
    static final int ADFRAC_CNT = ADFrac.length;
    static final float[] AGainTbl = new float[]{-0.993f, -0.831f, -0.693f, -0.555f, -0.414f, -0.229f, 0.0f, 0.139f, 0.255f, 0.368f, 0.457f, 0.531f, 0.601f, 0.653f, 0.702f, 0.745f, 0.78f, 0.816f, 0.85f, 0.881f, 0.915f, 0.948f, 0.983f, 1.02f, 1.062f, 1.117f, 1.193f, 1.289f, 1.394f, 1.54f, 1.765f, 1.991f};
    static final float[] InitLSPFreq = new float[]{0.03f, 0.05f, 0.09f, 0.13f, 0.19f, 0.23f, 0.29f, 0.33f, 0.39f, 0.44f};
    static final int[][] LspFreqTbl = new int[][]{{94, 189, 357, 618, 873, 1333, 1636, 1964, 2386, 2900}, {140, 272, 449, 753, 1043, 1471, 1819, 2118, 2577, 3011}, {183, 341, 529, 867, 1186, 1589, 1967, 2249, 2727, 3106}, {224, 398, 600, 964, 1307, 1690, 2086, 2360, 2843, 3188}, {262, 445, 662, 1045, 1408, 1776, 2182, 2454, 2935, 3258}, {298, 484, 717, 1114, 1493, 1850, 2260, 2534, 3006, 3318}, {334, 518, 765, 1172, 1564, 1914, 2322, 2602, 3062, 3369}, {371, 557, 808, 1222, 1624, 1968, 2372, 2660, 3106, 3414}, {414, 604, 848, 1266, 1680, 2018, 2418, 2708, 3140, 3452}, {462, 661, 894, 1317, 1739, 2073, 2466, 2754, 3170, 3486}, {518, 731, 953, 1379, 1808, 2138, 2524, 2804, 3205, 3524}, {581, 815, 1029, 1457, 1889, 2216, 2592, 2866, 3249, 3568}, {653, 917, 1128, 1553, 1983, 2308, 2671, 2943, 3308, 3620}, {735, 1040, 1255, 1672, 2092, 2418, 2765, 3037, 3384, 3679}, {828, 1191, 1420, 1820, 2219, 2549, 2875, 3154, 3483, 3748}, {934, 1373, 1632, 2003, 2367, 2705, 3005, 3299, 3612, 3829}};
    static final int[] SCodebook = new int[]{0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, -1, 0, 0, -1, 0, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 1, 0, 1, 0, -1, 1, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, 0, 0, -1, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, -1, 1, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, 1, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, -1, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, -1, -1, -1, 0, -1, -1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, -1, 0, -1, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, -1, -1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, -1, 0, 1, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, -1, -1, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, -1, -1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, 0, 0, 0, -1, 0, 0, -1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, -1, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, -1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, 1, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, -1, 0, -1, 1, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, 0, -1, 1, 1, -1, 0, 0, 0, 1, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 1, -1, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, -1, 1, -1, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, -1, 1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, -1, 0, 1, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1, 0, 0};
    static final float[] SGainTbl = new float[]{-1330.0f, -870.0f, -660.0f, -520.0f, -418.0f, -340.0f, -278.0f, -224.0f, -178.0f, -136.0f, -98.0f, -64.0f, -35.0f, -13.0f, -3.0f, -1.0f, 1.0f, 3.0f, 13.0f, 35.0f, 64.0f, 98.0f, 136.0f, 178.0f, 224.0f, 278.0f, 340.0f, 418.0f, 520.0f, 660.0f, 870.0f, 1330.0f};
    static float[] midpointsAGT = new float[31];
    static float[] midpointsSGT;
    static int[] twelfthsADFracIdx;
    static float[][] wsinc8;
    static float[][] wsinc40;
    int[] adi = new int[4];
    int[] agi = new int[4];
    int[] lspi = new int[10];
    int[] sci = new int[4];
    int[] sgi = new int[4];
    float[] pctolsp_lastFreq;
    float[] analAutocor_c = new float[11];
    float[] analAutocor_rc = new float[11];
    float[] analAutocor_s = new float[160];
    float[] durbin_rc = new float[10];
    float[] durbin_tmp = new float[10];
    float[] lsptopc_a = new float[6];
    float[] lsptopc_a1 = new float[6];
    float[] lsptopc_a2 = new float[6];
    float[] lsptopc_b = new float[6];
    float[] lsptopc_b1 = new float[6];
    float[] lsptopc_b2 = new float[6];
    float[] lsptopc_p = new float[5];
    float[] lsptopc_q = new float[5];
    float[] pctolsp_p;
    float[] pctolsp_q;
    float[] pctorc_a;
    float[] pctorc_t;

    Base() {
        this.pctolsp_lastFreq = new float[10];
        this.pctolsp_p = new float[10];
        this.pctolsp_q = new float[10];
        this.pctorc_a = new float[11];
        this.pctorc_t = new float[11];
        this.resetBase();
    }

    static int adiAbsToRel(int prevAbsADI, int absADI) {
        int RelLim = 64;
        int relBase = prevAbsADI - 31;
        if (relBase < 0) {
            relBase = 0;
        } else if (relBase + 64 > 256) {
            relBase = 192;
        }
        int relADI = absADI - relBase;
        if (relADI < 0) {
            relADI = 0;
        } else if (relADI >= 64) {
            relADI = 63;
        }
        return relADI;
    }

    static int adiRelToAbs(int prevAbsADI, int relADI) {
        int RelLim = 64;
        int relBase = prevAbsADI - 31;
        if (relBase < 0) {
            relBase = 0;
        } else if (relBase + 64 > 256) {
            relBase = 192;
        }
        return relADI + relBase;
    }

    boolean analAutocor(float omega, float[] si, float[] w, float[] a) {
        int i;
        float[] c = this.analAutocor_c;
        float[] rc = this.analAutocor_rc;
        float[] s = this.analAutocor_s;
        for (i = 0; i < 160; ++i) {
            s[i] = si[i] * w[i];
        }
        Base.autocorrelate(160, s, 10, c);
        if (!this.durbin(c, a)) {
            return false;
        }
        Base.expandBandwidth(omega, a, a);
        this.pctorc(a, rc);
        for (i = 0; i < 10; ++i) {
            if (!(Math.abs(rc[i]) > 1.0f)) continue;
            return false;
        }
        return true;
    }

    static void autocorrelate(int sLen, float[] s, int n, float[] c) {
        int i;
        float sum = 0.0f;
        for (i = 0; i < sLen; ++i) {
            float sSubI = s[i];
            sum += sSubI * sSubI;
        }
        c[0] = sum;
        for (i = 1; i <= n; ++i) {
            sum = 0.0f;
            for (int j = i; j < sLen; ++j) {
                sum += s[j] * s[j - i];
            }
            c[i] = sum;
        }
    }

    boolean durbin(float[] c, float[] a) {
        float Epsilon = 1.0E-20f;
        float[] rc = this.durbin_rc;
        float[] tmp = this.durbin_tmp;
        float alpha = c[0];
        float beta = c[1];
        if (alpha <= Math.abs(beta) * 1.0E-20f) {
            return false;
        }
        a[0] = 1.0f;
        a[1] = rc[0] = -beta / alpha;
        for (int i = 1; i < 10; ++i) {
            int j;
            alpha += beta * rc[i - 1];
            beta = c[i + 1];
            if (Math.abs(alpha) <= Math.abs(beta) * 1.0E-20f) {
                return false;
            }
            for (j = 1; j <= i; ++j) {
                beta += c[j] * a[i - j + 1];
            }
            rc[i] = -beta / alpha;
            for (j = 0; j <= i - 1; ++j) {
                tmp[j] = rc[i] * a[i - j];
            }
            for (j = 0; j <= i - 1; ++j) {
                int n = j + 1;
                a[n] = a[n] + tmp[j];
            }
            a[i + 1] = rc[i];
        }
        return true;
    }

    static void expandBandwidth(float alpha, float[] pc, float[] pcExp) {
        double power = alpha;
        pcExp[0] = pc[0];
        pcExp[1] = pc[1] * alpha;
        for (int i = 2; i <= 10; ++i) {
            pcExp[i] = (float)((double)pc[i] * (power *= (double)alpha));
        }
    }

    static int extract(int fieldOff, int fieldSize, byte[] buffer) {
        int value = 0;
        int valueShf = 0;
        while (--fieldSize >= 0) {
            int byteIdx = fieldOff / 8;
            int byteShf = fieldOff % 8;
            value |= (buffer[byteIdx] >> byteShf & 1) << valueShf;
            ++valueShf;
            ++fieldOff;
        }
        return value;
    }

    static void findMidpoints(int tableLen, float[] table, float[] midpoints) {
        for (int i = 0; i < tableLen - 1; ++i) {
            midpoints[i] = 0.5f * (table[i] + table[i + 1]);
        }
    }

    static void getACodeVec(int pointCnt, float[][] wsinc, float delay, float[] acBuf) {
        int delayInt = (int)delay;
        float delayFrac = delay - (float)delayInt;
        if ((double)delayFrac < 1.0E-4) {
            for (int i = 0; i < 40; ++i) {
                acBuf[147 + i] = acBuf[147 + i - delayInt];
            }
        } else {
            int index = twelfthsADFracIdx[(int)(12.0f * delayFrac + 0.5f)];
            int acBufOff = 147 - delayInt - pointCnt / 2;
            for (int i = 0; i < 40; ++i) {
                int j;
                float interpVal = 0.0f;
                int jLim = pointCnt - 7;
                for (j = 0; j < jLim; j += 8) {
                    int k = acBufOff + j;
                    interpVal += acBuf[k] * wsinc[index][j] + acBuf[k + 1] * wsinc[index][j + 1] + acBuf[k + 2] * wsinc[index][j + 2] + acBuf[k + 3] * wsinc[index][j + 3] + acBuf[k + 4] * wsinc[index][j + 4] + acBuf[k + 5] * wsinc[index][j + 5] + acBuf[k + 6] * wsinc[index][j + 6] + acBuf[k + 7] * wsinc[index][j + 7];
                }
                while (j < pointCnt) {
                    interpVal += acBuf[acBufOff + j] * wsinc[index][j];
                    ++j;
                }
                acBuf[147 + i] = interpVal;
                ++acBufOff;
            }
        }
    }

    static void getACodeVec8(float delay, float[] acBuf) {
        Base.getACodeVec(8, wsinc8, delay, acBuf);
    }

    static void getACodeVec40(float delay, float[] acBuf) {
        Base.getACodeVec(40, wsinc40, delay, acBuf);
    }

    static void initHammingWindow(int n, float[] win) {
        double TwoPi = Math.PI * 2;
        for (int i = 0; i < n; ++i) {
            win[i] = (float)(0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)(n - 1)));
        }
    }

    static void initInterpCoeffs(int pointCnt, float[][] wsinc) {
        double TwoPi = Math.PI * 2;
        for (int i = 0; i < ADFRAC_CNT; ++i) {
            int j = 0;
            int k = -pointCnt / 2;
            while (j < pointCnt) {
                int twelfths = (int)(12.0f * ADFrac[i] + 0.5f);
                float hamming = (float)(0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)(12 * j + twelfths) / (double)(12 * pointCnt)));
                wsinc[i][j] = Base.sinc(ADFrac[i] + (float)k) * hamming;
                ++j;
                ++k;
            }
        }
    }

    static void insert(int value, int fieldOff, int fieldSize, byte[] buffer) {
        while (--fieldSize >= 0) {
            int byteIdx = fieldOff / 8;
            int byteShf = fieldOff % 8;
            int n = byteIdx;
            buffer[n] = (byte)(buffer[n] & (char)(~(1 << byteShf)));
            int n2 = byteIdx;
            buffer[n2] = (byte)(buffer[n2] | (char)((value & 1) << byteShf));
            value >>= 1;
            ++fieldOff;
        }
    }

    void lsptopc(float[] freq, float[] pc) {
        int i;
        int HalfOrder = 5;
        double TwoPi = Math.PI * 2;
        float[] a = this.lsptopc_a;
        float[] a1 = this.lsptopc_a1;
        float[] a2 = this.lsptopc_a2;
        float[] b = this.lsptopc_b;
        float[] b1 = this.lsptopc_b1;
        float[] b2 = this.lsptopc_b2;
        float[] p = this.lsptopc_p;
        float[] q = this.lsptopc_q;
        for (i = 0; i < 6; ++i) {
            a[i] = 0.0f;
            a1[i] = 0.0f;
            a2[i] = 0.0f;
            b[i] = 0.0f;
            b1[i] = 0.0f;
            b2[i] = 0.0f;
        }
        for (i = 0; i < 5; ++i) {
            p[i] = (float)(-2.0 * Math.cos(Math.PI * 2 * (double)freq[2 * i]));
            q[i] = (float)(-2.0 * Math.cos(Math.PI * 2 * (double)freq[2 * i + 1]));
        }
        float xf = 0.0f;
        for (int j = 0; j < 11; ++j) {
            float xx = 0.0f;
            if (j == 0) {
                xx = 1.0f;
            }
            a[0] = xx + xf;
            b[0] = xx - xf;
            xf = xx;
            for (i = 0; i < 5; ++i) {
                a[i + 1] = a[i] + p[i] * a1[i] + a2[i];
                b[i + 1] = b[i] + q[i] * b1[i] + b2[i];
                a2[i] = a1[i];
                a1[i] = a[i];
                b2[i] = b1[i];
                b1[i] = b[i];
            }
            if (j == 0) continue;
            pc[j - 1] = -0.5f * (a[5] + b[5]);
        }
        for (i = 9; i >= 0; --i) {
            pc[i + 1] = -pc[i];
        }
        pc[0] = 1.0f;
    }

    void pack(byte[] pfpBuf, int pfpOff) {
        int i;
        int fieldBitOff = 8 * pfpOff;
        for (i = 0; i < 10; ++i) {
            Base.insert(this.lspi[i], fieldBitOff, 4, pfpBuf);
            fieldBitOff += 4;
        }
        for (i = 0; i < 4; ++i) {
            if (i % 2 == 0) {
                Base.insert(this.adi[i], fieldBitOff, 8, pfpBuf);
                fieldBitOff += 8;
            } else {
                Base.insert(Base.adiAbsToRel(this.adi[i - 1], this.adi[i]), fieldBitOff, 6, pfpBuf);
                fieldBitOff += 6;
            }
            Base.insert(this.agi[i], fieldBitOff, 5, pfpBuf);
            Base.insert(this.sci[i], fieldBitOff += 5, 9, pfpBuf);
            Base.insert(this.sgi[i], fieldBitOff += 9, 5, pfpBuf);
            fieldBitOff += 5;
        }
    }

    void pctolsp(float[] a, float[] freq) {
        float fm;
        float tfr;
        float ang;
        int jc;
        float fr;
        int mb;
        int j;
        int i;
        float EPS = 1.0E-6f;
        int N = 128;
        int NB = 15;
        float Pi = (float)Math.PI;
        float[] lastfreq = this.pctolsp_lastFreq;
        float[] p = this.pctolsp_p;
        float[] q = this.pctolsp_q;
        int mp = 11;
        int mh = 5;
        for (i = 0; i < mh; ++i) {
            p[i] = a[i + 1] + a[10 - i];
            q[i] = a[i + 1] - a[10 - i];
        }
        float fl = 0.0f;
        float pxl = 1.0f;
        for (j = 0; j < mh; ++j) {
            pxl += p[j];
        }
        int nf = 0;
        for (i = 1; i <= 128; ++i) {
            mb = 0;
            fr = (float)i * 0.00390625f;
            float pxr = (float)Math.cos((float)mp * (float)Math.PI * fr);
            for (j = 0; j < mh; ++j) {
                jc = mp - (j + 1) * 2;
                ang = (float)jc * (float)Math.PI * fr;
                pxr += (float)(Math.cos(ang) * (double)p[j]);
            }
            float tpxr = pxr;
            tfr = fr;
            if (!(pxl * pxr > 0.0f)) {
                float pxm;
                do {
                    ++mb;
                    fm = fl + (fr - fl) / (pxl - pxr) * pxl;
                    pxm = (float)Math.cos((float)mp * (float)Math.PI * fm);
                    for (j = 0; j < mh; ++j) {
                        jc = mp - (j + 1) * 2;
                        ang = (float)jc * (float)Math.PI * fm;
                        pxm += (float)(Math.cos(ang) * (double)p[j]);
                    }
                    if (pxm * pxl > 0.0f) {
                        pxl = pxm;
                        fl = fm;
                        continue;
                    }
                    pxr = pxm;
                    fr = fm;
                } while (Math.abs(pxm) > 1.0E-6f && mb < 4);
                if ((pxl - pxr) * pxl == 0.0f) {
                    for (j = 0; j < 10; ++j) {
                        freq[j] = (float)(j + 1) * 0.04545f;
                    }
                    return;
                }
                freq[nf] = fl + (fr - fl) / (pxl - pxr) * pxl;
                if ((nf += 2) > 8) break;
            }
            pxl = tpxr;
            fl = tfr;
        }
        freq[10] = 0.5f;
        fl = freq[0];
        float qxl = (float)Math.sin((float)mp * (float)Math.PI * fl);
        for (j = 0; j < mh; ++j) {
            jc = mp - (j + 1) * 2;
            ang = (float)jc * (float)Math.PI * fl;
            qxl += (float)(Math.sin(ang) * (double)q[j]);
        }
        for (i = 2; i < mp; i += 2) {
            float qxm;
            mb = 0;
            fr = freq[i];
            float qxr = (float)Math.sin((float)mp * (float)Math.PI * fr);
            for (j = 0; j < mh; ++j) {
                jc = mp - (j + 1) * 2;
                ang = (float)jc * (float)Math.PI * fr;
                qxr += (float)(Math.sin(ang) * (double)q[j]);
            }
            float tqxl = qxl;
            tfr = fr;
            float tqxr = qxr;
            do {
                ++mb;
                fm = (fl + fr) * 0.5f;
                qxm = (float)Math.sin((float)mp * (float)Math.PI * fm);
                for (j = 0; j < mh; ++j) {
                    jc = mp - (j + 1) * 2;
                    ang = (float)jc * (float)Math.PI * fm;
                    qxm += (float)(Math.sin(ang) * (double)q[j]);
                }
                if (qxm * qxl > 0.0f) {
                    qxl = qxm;
                    fl = fm;
                    continue;
                }
                qxr = qxm;
                fr = fm;
            } while (Math.abs(qxm) > 1.0E-6f * tqxl && mb < 15);
            if ((qxl - qxr) * qxl == 0.0f) {
                for (j = 0; j < 10; ++j) {
                    freq[j] = lastfreq[j];
                }
                return;
            }
            freq[i - 1] = fl + (fr - fl) / (qxl - qxr) * qxl;
            qxl = tqxr;
            fl = tfr;
        }
        boolean nonMono = false;
        for (i = 0; i < 10; ++i) {
            if (freq[i] <= 0.0f) {
                freq[i] = 1.25E-4f;
            } else if (freq[0] >= 0.5f) {
                freq[i] = 0.499875f;
            }
            if (i <= 0 || !(freq[i - 1] > freq[i])) continue;
            nonMono = true;
        }
        if (nonMono) {
            for (i = 0; i < 10; ++i) {
                for (j = i + 1; j < 10; ++j) {
                    if (!(freq[i] > freq[j])) continue;
                    float tempFreq = freq[i];
                    freq[i] = freq[j];
                    freq[j] = tempFreq;
                }
            }
        }
        for (i = 0; i < 10; ++i) {
            lastfreq[i] = freq[i];
        }
    }

    void pctorc(float[] lpc, float[] rc) {
        float[] a = this.pctorc_a;
        float[] t = this.pctorc_t;
        System.arraycopy(lpc, 0, a, 0, 11);
        for (int i = 10; i > 1; --i) {
            int j;
            rc[i - 1] = -a[i];
            for (j = 1; j < i; ++j) {
                t[i - j] = (a[i - j] + rc[i - 1] * a[j]) / (1.0f - rc[i - 1] * rc[i - 1]);
            }
            for (j = 1; j < i; ++j) {
                a[j] = t[j];
            }
        }
        rc[0] = -a[1];
    }

    static int quantizeAGain(float input) {
        int aGainIdx = 15;
        for (int i = (aGainIdx + 1) / 2; i >= 1; i >>= 1) {
            if (input > midpointsAGT[aGainIdx]) {
                aGainIdx += i;
                continue;
            }
            aGainIdx -= i;
        }
        if (input > midpointsAGT[aGainIdx]) {
            ++aGainIdx;
        }
        return aGainIdx;
    }

    static int quantizeFractionalPitch(float fp) {
        int index = 0;
        float leastDist = Math.abs(fp - ADFrac[0]);
        for (int i = 1; i < ADFRAC_CNT; ++i) {
            float dist = Math.abs(fp - ADFrac[i]);
            if (!(dist < leastDist)) continue;
            index = i;
            leastDist = dist;
        }
        return index;
    }

    void quantizeLSPFreqs(float[] freq, int[] index) {
        int i;
        int MINSEP = 40;
        for (i = 0; i < 10; ++i) {
            int dist;
            int uFreq = (int)(8000.0f * freq[i] + 0.5f);
            int leastDist = Math.abs(uFreq - LspFreqTbl[15][i]);
            index[i] = 15;
            for (int j = 14; j >= 0 && (dist = Math.abs(uFreq - LspFreqTbl[j][i])) < leastDist; --j) {
                if (i >= 1 && LspFreqTbl[index[i - 1]][i - 1] > LspFreqTbl[j][i] - 40) continue;
                leastDist = dist;
                index[i] = j;
            }
        }
        for (i = 0; i < 10; ++i) {
            freq[i] = (float)LspFreqTbl[index[i]][i] / 8000.0f;
        }
    }

    static int quantizeSGain(float input) {
        int sGainIdx = 15;
        for (int i = (sGainIdx + 1) / 2; i >= 1; i >>= 1) {
            if (input > midpointsSGT[sGainIdx]) {
                sGainIdx += i;
                continue;
            }
            sGainIdx -= i;
        }
        if (input > midpointsSGT[sGainIdx]) {
            ++sGainIdx;
        }
        return sGainIdx;
    }

    void resetBase() {
        Base.zeroArray(this.adi);
        Base.zeroArray(this.agi);
        Base.zeroArray(this.lspi);
        Base.zeroArray(this.sci);
        Base.zeroArray(this.sgi);
        Base.zeroArray(this.pctolsp_lastFreq);
    }

    static float sinc(float x) {
        if (x == 0.0f) {
            return 1.0f;
        }
        double piX = Math.PI * (double)x;
        return (float)(Math.sin(piX) / piX);
    }

    void unpack(byte[] pfpBuf, int pfpOff) {
        int i;
        int fieldBitOff = 8 * pfpOff;
        for (i = 0; i < 10; ++i) {
            this.lspi[i] = Base.extract(fieldBitOff, 4, pfpBuf);
            fieldBitOff += 4;
        }
        for (i = 0; i < 4; ++i) {
            if (i % 2 == 0) {
                this.adi[i] = Base.extract(fieldBitOff, 8, pfpBuf);
                fieldBitOff += 8;
            } else {
                this.adi[i] = Base.adiRelToAbs(this.adi[i - 1], Base.extract(fieldBitOff, 6, pfpBuf));
                fieldBitOff += 6;
            }
            this.agi[i] = Base.extract(fieldBitOff, 5, pfpBuf);
            this.sci[i] = Base.extract(fieldBitOff += 5, 9, pfpBuf);
            this.sgi[i] = Base.extract(fieldBitOff += 9, 5, pfpBuf);
            fieldBitOff += 5;
        }
    }

    void updateACB(float aDelay, float aGain, float[] acBuf, float[] excitation) {
        int i;
        Base.getACodeVec40(aDelay, acBuf);
        for (i = 0; i < 40; ++i) {
            int n = i;
            float f = excitation[n] + aGain * acBuf[i + 147];
            excitation[n] = f;
            acBuf[i + 147] = f;
        }
        for (i = 0; i < 147; ++i) {
            acBuf[i] = acBuf[i + 40];
        }
    }

    static void zeroArray(float[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            array[i] = 0.0f;
        }
    }

    static void zeroArray(int[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            array[i] = 0;
        }
    }

    static {
        Base.findMidpoints(32, AGainTbl, midpointsAGT);
        midpointsSGT = new float[31];
        Base.findMidpoints(32, SGainTbl, midpointsSGT);
        wsinc8 = new float[ADFRAC_CNT][8];
        Base.initInterpCoeffs(8, wsinc8);
        wsinc40 = new float[ADFRAC_CNT][40];
        Base.initInterpCoeffs(40, wsinc40);
        twelfthsADFracIdx = new int[13];
        for (int i = 0; i <= 12; ++i) {
            Base.twelfthsADFracIdx[i] = Base.quantizeFractionalPitch((float)i / 12.0f);
        }
    }
}

