/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.Response;
import com.elluminate.groupware.quiz.Responses;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class QuizStats {
    private short total = 0;
    private short[][] count = null;

    QuizStats(Quiz quiz) {
        this.count = new short[quiz.getQuestionCount()][];
        for (short i = 0; i < quiz.getQuestionCount(); i = (short)(i + 1)) {
            Question q = quiz.getQuestion(i);
            this.count[i] = new short[q.getAnswerCount()];
        }
        Iterator iter = quiz.participantIterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Responses resp = quiz.getResponsesFor(name);
            if (resp != null) {
                for (short i = 0; i < quiz.getQuestionCount(); i = (short)(i + 1)) {
                    Response r = resp.getResponse(i);
                    if (r == null) continue;
                    if (r.hasSelection()) {
                        short[] sArray = this.count[i];
                        short s = r.getSelection();
                        sArray[s] = (short)(sArray[s] + 1);
                        continue;
                    }
                    short[] sArray = this.count[i];
                    sArray[0] = (short)(sArray[0] + 1);
                }
            }
            this.total = (short)(this.total + 1);
        }
    }

    public QuizStats(DataInputStream str) throws IOException {
        this.total = str.readShort();
        short nQuestions = str.readShort();
        this.count = new short[nQuestions][];
        for (short i = 0; i < nQuestions; i = (short)(i + 1)) {
            short nAnswers = str.readShort();
            this.count[i] = new short[nAnswers];
            for (short j = 0; j < nAnswers; j = (short)(j + 1)) {
                this.count[i][j] = str.readShort();
            }
        }
    }

    public short getTotal() {
        return this.total;
    }

    public short getCount(short q, short a) {
        return this.count[q][a];
    }

    public short getCount(short q) {
        short sum = 0;
        short[] aCount = this.count[q];
        for (int i = 0; i < aCount.length; i = (int)((short)(i + 1))) {
            sum = (short)(sum + aCount[i]);
        }
        return sum;
    }

    public void encode(DataOutputStream str) throws IOException {
        str.writeShort(this.total);
        str.writeShort(this.count.length);
        for (int i = 0; i < this.count.length; i = (int)((short)(i + 1))) {
            short[] aCount = this.count[i];
            str.writeShort(aCount.length);
            for (int j = 0; j < aCount.length; j = (int)((short)(j + 1))) {
                str.writeShort(aCount[j]);
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append("Stats out of ");
        buf.append(this.total);
        buf.append(":\n");
        for (int q = 0; q < this.count.length; ++q) {
            buf.append(prefix);
            buf.append("    question ");
            buf.append(q);
            buf.append(":");
            for (int a = 0; a < this.count[q].length; ++a) {
                buf.append("  ");
                buf.append(this.count[q][a]);
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

