/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizLibEvent;
import com.elluminate.groupware.quiz.QuizLibListener;
import com.elluminate.groupware.quiz.QuizRequestException;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class QuizLib {
    protected static final byte SRC_LOCAL = 1;
    protected static final byte SRC_NETWORK = 2;
    private HashMap entries = new HashMap();
    protected long nextID = 1L;
    protected long deltaID = 1L;
    private Object lock = new Object();
    private ArrayList listeners = new ArrayList();
    private boolean modified = false;

    public QuizLib(long delta) {
        this.nextID = delta;
        this.deltaID = delta;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean contains(long id) {
        return this.entries.containsKey(new Long(id));
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap copy;
        Object object = this.lock;
        synchronized (object) {
            copy = (HashMap)this.entries.clone();
            this.entries.clear();
        }
        this.modified = true;
        for (QuizLibEntry ent : copy.values()) {
            Quiz q = ent.getQuiz();
            this.fireLibChanged((byte)2, q.getID(), q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quiz get(long id) throws QuizException {
        Quiz quiz = null;
        Object object = this.lock;
        synchronized (object) {
            QuizLibEntry entry = (QuizLibEntry)this.entries.get(new Long(id));
            if (entry == null) {
                throw new QuizRequestException(99, id);
            }
            quiz = entry.getQuiz();
        }
        return quiz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuizLibListener(QuizLibListener l) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<QuizLibListener> newList = new ArrayList<QuizLibListener>(this.listeners);
            newList.add(l);
            this.listeners = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuizLibListener(QuizLibListener l) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList newList = new ArrayList(this.listeners);
            newList.remove(l);
            this.listeners = newList;
        }
    }

    private void fireLibChanged(byte action, long id, Quiz q) {
        QuizLibEvent e = new QuizLibEvent(this, action, id, q);
        for (QuizLibListener l : this.listeners) {
            try {
                l.libraryChanged(e);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireLibChange", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextID() {
        long id;
        Object object = this.lock;
        synchronized (object) {
            id = this.nextID;
            this.nextID += this.deltaID;
        }
        return id;
    }

    public long add(Quiz q) {
        return this.add(q, this.getNextID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(Quiz q, long id) {
        byte notify = 1;
        Object object = this.lock;
        synchronized (object) {
            Long key = new Long(id);
            q.setID(id);
            if (this.entries.containsKey(key)) {
                notify = 3;
            }
            this.entries.put(key, new QuizLibEntry(q));
        }
        this.modified = true;
        this.fireLibChanged(notify, id, q);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeID(long from, long to) throws QuizException {
        Quiz q = null;
        Object object = this.lock;
        synchronized (object) {
            QuizLibEntry e = (QuizLibEntry)this.entries.remove(new Long(from));
            if (e == null) {
                throw new QuizRequestException(99, from);
            }
            q = e.getQuiz();
            q.setID(to);
            this.entries.put(new Long(to), e);
        }
        this.modified = true;
        this.fireLibChanged((byte)3, to, q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long id, short who) throws QuizException {
        Quiz q = null;
        Object object = this.lock;
        synchronized (object) {
            Long key = new Long(id);
            QuizLibEntry e = (QuizLibEntry)this.entries.get(key);
            if (e == null) {
                throw new QuizRequestException(99, id);
            }
            if (!e.lock(who)) {
                throw new QuizRequestException(97, id, e.getLockedBy());
            }
            q = e.getQuiz();
            this.entries.remove(key);
            if (q != null) {
                q.setState((byte)3);
            }
        }
        this.modified = true;
        this.fireLibChanged((byte)2, id, q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(long id, short who) throws QuizException {
        Object object = this.lock;
        synchronized (object) {
            QuizLibEntry e = (QuizLibEntry)this.entries.get(new Long(id));
            if (e == null) {
                throw new QuizRequestException(99, id);
            }
            if (!e.lock(who)) {
                throw new QuizRequestException(97, id, e.getLockedBy());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long id, short who, Quiz q) throws QuizException {
        Object object = this.lock;
        synchronized (object) {
            QuizLibEntry e = (QuizLibEntry)this.entries.get(new Long(id));
            if (e == null) {
                throw new QuizRequestException(99, id);
            }
            if (!e.unlock(who)) {
                throw new QuizRequestException(98, id);
            }
            e.setQuiz(q);
            q.setState((byte)3);
        }
        this.modified = true;
        this.fireLibChanged((byte)3, id, q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long id, short who) throws QuizException {
        Object object = this.lock;
        synchronized (object) {
            QuizLibEntry e = (QuizLibEntry)this.entries.get(new Long(id));
            if (e == null) {
                throw new QuizRequestException(99, id);
            }
            if (!e.unlock(who)) {
                throw new QuizRequestException(98, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLockedBy(short addr) {
        Object object = this.lock;
        synchronized (object) {
            for (QuizLibEntry entry : this.entries.values()) {
                if (!entry.isLockedBy(addr)) continue;
                entry.unlock(addr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getQuizzes() {
        ArrayList<Quiz> list = null;
        Object object = this.lock;
        synchronized (object) {
            list = new ArrayList<Quiz>(this.entries.size());
            for (QuizLibEntry entry : this.entries.values()) {
                list.add(entry.getQuiz());
            }
        }
        return list;
    }

    public boolean isModified() {
        return this.modified;
    }

    private class QuizLibEntry {
        private Quiz quiz = null;
        private short lockedBy = (short)-32767;

        public QuizLibEntry(Quiz q) {
            this.quiz = q;
        }

        public boolean lock(short addr) {
            if (this.lockedBy == -32767) {
                this.lockedBy = addr;
                return true;
            }
            return false;
        }

        public boolean unlock(short addr) {
            if (this.lockedBy == addr) {
                this.lockedBy = (short)-32767;
                return true;
            }
            return false;
        }

        public boolean isLocked() {
            return this.lockedBy != -32767;
        }

        public boolean isLockedBy(short who) {
            return this.lockedBy == who;
        }

        public short getLockedBy() {
            return this.lockedBy;
        }

        public Quiz getQuiz() {
            return this.quiz;
        }

        public void setQuiz(Quiz q) {
            this.quiz = q;
        }
    }
}

