/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class QuizInvalidException
extends QuizException {
    private static I18n i18n = I18n.create(QuizInvalidException.class);
    private String msg;
    private String arg;

    public QuizInvalidException(String msg, String arg) {
        this.msg = msg == null ? "" : msg;
        this.arg = arg == null ? "" : arg;
        this.reason = (byte)103;
    }

    public QuizInvalidException(byte cmd, DataInputStream in, boolean close) throws IOException {
        this.reason = cmd;
        this.request = in.readByte();
        this.id = in.readLong();
        this.msg = in.readUTF();
        this.arg = in.readUTF();
        if (close) {
            in.close();
        }
    }

    @Override
    public void encode(DataOutputStream out, boolean close) {
        try {
            out.writeByte(this.request);
            out.writeLong(this.id);
            out.writeUTF(this.msg);
            out.writeUTF(this.arg);
            if (close) {
                out.close();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"encode", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        return i18n.getStringLegacy("QuizInvalidException." + this.msg, new Object[]{this.arg});
    }
}

