/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class Distributor
extends EasyDialog {
    public static final int MAX_ROOM_COUNT = 1000;
    public static final int MAX_ROOM_SIZE = 1000;
    public static final int DISTRIBUTE_NOT = 0;
    public static final int DISTRIBUTE_IN_COUNTED_ROOM = 1;
    public static final int DISTRIBUTE_IN_SIZED_ROOMS = 2;
    private static I18n i18n = I18n.create(Distributor.class);
    private static final int[] PRESETS = new int[]{1, 2, 3, 4, 5, 8, 10};
    private static String lastRoomName = i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_DEFAULTROOMNAME);
    private static int lastRoomCount = PRESETS[3];
    private static int lastDistributeOption = 1;
    private static int lastRoomSize = PRESETS[3];
    private static boolean lastIncludeModerators = false;
    private JTextField roomNameField;
    private JTextField roomCountField;
    private AbstractDocument roomCountDocument;
    private DocumentListener roomCountListener;
    private JLabel distributeLabel;
    private JRadioButton dontMoveBox;
    private JRadioButton distributeBox;
    private JRadioButton divideBox;
    private ItemListener divideListener1;
    private ItemListener divideListener2;
    private JComboBox roomSizeField;
    private AbstractDocument roomSizeDocument;
    private DocumentListener roomSizeListener;
    private JCheckBox includeModeratorsBox;
    private JButton createButton;

    public Distributor(Frame owner, ClientList clients) {
        super((Component)owner, i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_TITLE, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Groups")}));
        JPanel c = new JPanel(new BorderLayout(0, 20));
        this.setContent(c);
        JPanel p = new JPanel(new GridBagLayout());
        c.add((Component)p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.insets.top = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        JLabel l = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_ROOMNAMELABEL));
        p.add((Component)l, gbc);
        ++gbc.gridy;
        gbc.insets.top = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        this.roomNameField = new JTextField(20);
        l.setLabelFor(this.roomNameField);
        ((AbstractDocument)this.roomNameField.getDocument()).setDocumentFilter(new DocumentLengthFilter(126));
        p.add((Component)this.roomNameField, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        l = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_ROOMCOUNTLABEL));
        p.add((Component)l, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.roomCountField = new JTextField(4);
        l.setLabelFor(this.roomCountField);
        this.roomCountListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleUpdate();
            }

            private void handleUpdate() {
                if (Distributor.this.divideBox.isSelected()) {
                    Distributor.this.divideBox.removeItemListener(Distributor.this.divideListener1);
                    Distributor.this.distributeBox.setSelected(true);
                    Distributor.this.divideBox.addItemListener(Distributor.this.divideListener1);
                }
            }
        };
        this.roomCountDocument = (AbstractDocument)this.roomCountField.getDocument();
        this.roomCountDocument.setDocumentFilter(new IntegerDocumentFilter(1, 1000));
        this.roomCountDocument.addDocumentListener(this.roomCountListener);
        this.roomCountDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Distributor.this.updateCreateButtonEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Distributor.this.updateCreateButtonEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Distributor.this.updateCreateButtonEnabled();
            }
        });
        p.add((Component)this.roomCountField, gbc);
        p = new JPanel(new GridBagLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension s = this.getSize();
                Rectangle b = Distributor.this.distributeLabel.getBounds();
                FontMetrics fm = g.getFontMetrics(Distributor.this.distributeLabel.getFont());
                g.setColor(Color.GRAY);
                int y = b.y + b.height - 1 - fm.getDescent();
                g.drawLine(b.x + b.width + 6, y, s.width, y);
            }
        };
        c.add((Component)p, "Center");
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.insets.top = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.distributeLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_DISTRIBUTE_OPTIONS));
        this.distributeLabel.setFont(this.distributeLabel.getFont().deriveFont(1));
        p.add((Component)this.distributeLabel, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.dontMoveBox = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_DONTMOVE, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.participants")}));
        this.dontMoveBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Distributor.this.includeModeratorsBox.setEnabled(false);
                    Distributor.this.includeModeratorsBox.setSelected(false);
                } else {
                    Distributor.this.includeModeratorsBox.setEnabled(true);
                    Distributor.this.includeModeratorsBox.setSelected(lastIncludeModerators);
                }
            }
        });
        p.add((Component)this.dontMoveBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.distributeBox = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_DISTRIBUTE, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.participants")}), true);
        p.add((Component)this.distributeBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.divideBox = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_DIVIDE));
        this.divideListener1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Distributor.this.roomCountDocument.removeDocumentListener(Distributor.this.roomCountListener);
                if (e.getStateChange() == 1) {
                    Distributor.this.roomCountField.setText("");
                } else {
                    Distributor.this.roomCountField.setText(Integer.toString(lastRoomCount));
                }
                Distributor.this.roomCountDocument.addDocumentListener(Distributor.this.roomCountListener);
            }
        };
        this.divideBox.addItemListener(this.divideListener1);
        this.divideListener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Distributor.this.roomSizeDocument.removeDocumentListener(Distributor.this.roomSizeListener);
                if (e.getStateChange() == 1) {
                    Distributor.this.roomSizeField.setSelectedItem(lastRoomSize);
                } else {
                    Distributor.this.roomSizeField.setSelectedItem(null);
                }
                Distributor.this.roomSizeDocument.addDocumentListener(Distributor.this.roomSizeListener);
            }
        };
        this.divideBox.addItemListener(this.divideListener2);
        p.add((Component)this.divideBox, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.roomSizeField = new JComboBox();
        this.roomSizeField.setEditable(true);
        for (int preset : PRESETS) {
            this.roomSizeField.addItem(String.valueOf(preset));
        }
        this.roomSizeListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleUpdate();
            }

            private void handleUpdate() {
                if (!Distributor.this.divideBox.isSelected()) {
                    Distributor.this.divideBox.removeItemListener(Distributor.this.divideListener2);
                    Distributor.this.divideBox.setSelected(true);
                    Distributor.this.divideBox.addItemListener(Distributor.this.divideListener2);
                }
            }
        };
        JTextField tf = (JTextField)this.roomSizeField.getEditor().getEditorComponent();
        this.roomSizeDocument = (AbstractDocument)tf.getDocument();
        this.roomSizeDocument.setDocumentFilter(new IntegerDocumentFilter(1, 1000));
        this.roomSizeDocument.addDocumentListener(this.roomSizeListener);
        this.roomSizeDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Distributor.this.updateCreateButtonEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Distributor.this.updateCreateButtonEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Distributor.this.updateCreateButtonEnabled();
            }
        });
        p.add((Component)this.roomSizeField, gbc);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.dontMoveBox);
        grp.add(this.distributeBox);
        grp.add(this.divideBox);
        ++gbc.gridy;
        gbc.insets.top = 20;
        gbc.insets.bottom = 10;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.includeModeratorsBox = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_INCLUDEMODERATORS, new Object[]{LabelProps.get((PropertyAccessAPI)clients, (String)"Label.moderators")}));
        p.add((Component)this.includeModeratorsBox, gbc);
        this.createButton = new JButton(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_CREATE));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Distributor.this.saveSelections();
                Distributor.this.performDefaultCloseOperation();
            }
        });
        this.addActionButton(this.createButton, true);
        this.addCancelButton(this.makeButton(i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_CANCEL)));
        this.setInitialFocus(this.roomCountField);
        this.restoreSelections();
    }

    private void restoreSelections() {
        this.roomCountDocument.removeDocumentListener(this.roomCountListener);
        this.roomSizeDocument.removeDocumentListener(this.roomSizeListener);
        this.roomNameField.setText(lastRoomName);
        this.roomCountField.setText(String.valueOf(lastRoomCount));
        this.dontMoveBox.setSelected(lastDistributeOption == 0);
        this.distributeBox.setSelected(lastDistributeOption == 1);
        this.divideBox.setSelected(lastDistributeOption == 2);
        if (this.divideBox.isSelected()) {
            this.roomSizeField.setSelectedItem(String.valueOf(lastRoomSize));
        } else {
            this.roomSizeField.setSelectedItem(null);
        }
        this.includeModeratorsBox.setSelected(lastIncludeModerators);
        this.roomCountDocument.addDocumentListener(this.roomCountListener);
        this.roomSizeDocument.addDocumentListener(this.roomSizeListener);
    }

    private void saveSelections() {
        String text = this.roomNameField.getText();
        if (text.trim().length() == 0) {
            text = i18n.getString((PropertiesEnum)StringsProperties.DISTRIBUTOR_DEFAULTROOMNAME);
        }
        lastRoomName = text;
        try {
            String rc = this.roomCountField.getText();
            lastRoomCount = Integer.parseInt(rc);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (this.dontMoveBox.isSelected()) {
            lastDistributeOption = 0;
        } else if (this.distributeBox.isSelected()) {
            lastDistributeOption = 1;
        } else if (this.divideBox.isSelected()) {
            lastDistributeOption = 2;
        }
        try {
            Object it = this.roomSizeField.getSelectedItem();
            if (it != null) {
                lastRoomSize = Integer.parseInt(String.valueOf(it));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        lastIncludeModerators = this.includeModeratorsBox.isSelected();
    }

    public String getRoomName() {
        return lastRoomName;
    }

    public int getRoomCount() {
        return lastRoomCount;
    }

    public int getDistributeOption() {
        return lastDistributeOption;
    }

    public int getRoomSize() {
        return lastRoomSize;
    }

    public boolean isIncludingModerators() {
        return lastIncludeModerators;
    }

    private void updateCreateButtonEnabled() {
        if (this.dontMoveBox.isSelected() || this.distributeBox.isSelected()) {
            String text = null;
            try {
                text = this.roomCountDocument.getText(0, this.roomCountDocument.getLength());
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            this.createButton.setEnabled(text != null && text.length() != 0);
        } else if (this.divideBox.isSelected()) {
            String text = null;
            try {
                text = this.roomSizeDocument.getText(0, this.roomSizeDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.createButton.setEnabled(text != null && text.length() != 0);
        }
    }

    private static class DocumentLengthFilter
    extends DocumentFilter {
        private int maxLength;

        public DocumentLengthFilter(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            if (fb.getDocument().getLength() + str.length() <= this.maxLength) {
                super.insertString(fb, offs, str, a);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
            if (fb.getDocument().getLength() + str.length() - length <= this.maxLength) {
                super.replace(fb, offs, length, str, a);
            }
        }
    }

    private static class IntegerDocumentFilter
    extends DocumentFilter {
        private int min;
        private int max;

        public IntegerDocumentFilter(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            StringBuilder b = new StringBuilder();
            Document doc = fb.getDocument();
            b.append(doc.getText(0, doc.getLength()));
            b.insert(offs, str);
            if (this.isValid(b.toString())) {
                super.insertString(fb, offs, str, a);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
            StringBuilder b = new StringBuilder();
            Document doc = fb.getDocument();
            b.append(doc.getText(0, doc.getLength()));
            b.replace(offs, offs + length, str);
            if (this.isValid(b.toString())) {
                super.replace(fb, offs, length, str, a);
            }
        }

        private boolean isValid(String string) {
            if (string.length() != 0) {
                try {
                    int n = Integer.parseInt(string);
                    if (n < this.min || n > this.max) {
                        return false;
                    }
                }
                catch (NumberFormatException ex) {
                    return false;
                }
            }
            return true;
        }
    }
}

