/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.CloseAllRoomsCommand;
import com.elluminate.groupware.breakout.module.BreakoutBean;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;

public class CloseAllRoomsCmd
extends AbstractCommand
implements CloseAllRoomsCommand {
    private static final long serialVersionUID = 1L;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<BreakoutBean> beanProvider;

    @Inject
    public void initBreakoutBeanProvider(Provider<BreakoutBean> bp) {
        this.beanProvider = bp;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        BreakoutBean bean = (BreakoutBean)this.beanProvider.get();
        Object[] groupsAsObjects = bean.getAllRooms();
        if (groupsAsObjects.length < 2) {
            throw new CommandContextException("No breakout rooms to close", this.i18n.getString((PropertiesEnum)StringsProperties.CLOSEALLROOMSCMD_BADCONTEXTNOROOMS));
        }
        ArrayList<ClientGroup> groups = new ArrayList<ClientGroup>();
        ClientGroup cg2 = null;
        for (int i = 0; i < groupsAsObjects.length; ++i) {
            cg2 = (ClientGroup)groupsAsObjects[i];
            if (cg2.getName().trim().length() == 0) continue;
            groups.add(cg2);
        }
        for (ClientGroup cg2 : groups) {
            bean.delete(new ClientGroup[]{bean.getRoom(cg2.getName())});
        }
    }
}

