/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.classroom.client.app.Application;
import com.elluminate.contentcapture.CaptureBacklogCallback;
import com.elluminate.contentcapture.CaptureClientConnection;
import com.elluminate.contentcapture.CaptureFeedSubscription;
import com.elluminate.contentcapture.CaptureLogicalImageRoot;
import com.elluminate.contentcapture.CaptureTextInput;
import com.elluminate.contentcapture.CaptureTile;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureIOPacketUtils;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.elluminate.groupware.module.contentcapture.CaptureFeedSubscriptionImpl;
import com.elluminate.groupware.module.contentcapture.ComponentRepaintManager;
import com.elluminate.groupware.module.contentcapture.ContentCaptureIO;
import com.elluminate.groupware.module.contentcapture.ImageFeedSpec;
import com.elluminate.groupware.module.contentcapture.MRFClientThread;
import com.elluminate.groupware.module.contentcapture.StringsProperties;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.VCRFile;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.mediastream.MRFile;
import com.elluminate.util.ApplicationProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;

public class ContentCaptureImpl
extends ContentCapture
implements CaptureBacklogCallback,
ClientGroupListener,
ClientListener {
    static I18n i18n = I18n.create((Object)new Object(){});
    public static final boolean DEBUG_CONTENT_CAPTURE = System.getProperty("debugcontentcapture", null) != null;
    private static final String ALLOW_UPSCALE_ARG = "allowupscale";
    private static final String DISPLAY_SERVER_ARG = "displayserver";
    private static final boolean ENABLE_ENCODING = true;
    private static final String FEEDS_ARG = "feeds";
    private static final String IMAGE_SIZE_ARG = "imagesize";
    private static final String LOSSLESS_ENCODING = "lossless";
    private static final String LOSSY_ENCODING = "lossy";
    private static final int MAX_DELAY = 1000;
    private static final int MIN_DELAY = 0;
    private static final String RECORDING_ON_ARG = "recordingon";
    private static final String PREVENT_UPSCALE_ARG = "preventupscale";
    private static final String RECORDING_OFF_ARG = "recordingoff";
    private static final String MULTIMEDIA_FILE_ARG = "multimedia";
    private static final String NO_SERVER_ECHO_ARG = "noserverecho";
    private static final String NOT_SERVER_ARG = "notserver";
    private static final String PROGRESS_ADDRESS_ARG = "progress";
    private static final long PROGRESS_PERIOD = 1000L;
    private static final String SEND_DELAY_ARG = "imagemsec";
    public static final long SEND_DELAY_DEFAULT = 66L;
    private static final String SERVER_ECHO_ARG = "serverecho";
    private static final String SERVER_PORT_ARG = "serverport";
    private static final String SERVER_PORT_AUTO_ARG = "portsearchlimit";
    private static final boolean USE_PLAYBACK_TIME = true;
    public static final int CONNECT_RETRY_DELAY_SECONDS = 10;
    private static final boolean DEFAULT_RECORDING_SETTING = true;
    private static final int DEFAULT_WIDTH = 320;
    private static final int DEFAULT_HEIGHT = 240;
    private static Client vclassClient = null;
    private static PlaybackTimeAPI playbackTimeAPI = null;
    private static boolean playbackChangeListenerSet = false;
    private static SessionTimeAPI sessionTimeAPI = null;
    private static boolean allowUpscale = true;
    private static boolean ContentCaptureEnabled;
    private static int capturePort;
    private static int capturePortSearchLimit;
    private static long baseTime;
    private CaptureBacklogCallback callback = null;
    private static boolean captureData;
    private static boolean captureDataSet;
    private static HashSet<CaptureClientConnection> clientSet;
    private byte[] conditionData = null;
    private Container container = null;
    private static int indexEntryIndex;
    private DataChangeListener indexListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent ev) {
            Object entryObject = ev.getProvider().getData();
            if (entryObject instanceof VCRFile.IndexEntry[]) {
                VCRFile.IndexEntry[] entries = (VCRFile.IndexEntry[])entryObject;
                ContentCaptureImpl.this.sendIndexMark(entries[indexEntryIndex].getModule(), entries[indexEntryIndex].getKind(), entries[indexEntryIndex].getDetail(), entries[indexEntryIndex].getTime());
                indexEntryIndex++;
            }
        }
    };
    private static byte defaultEncoding;
    private static boolean echoData;
    private static boolean echoDataSet;
    private Short feedIndex;
    private static HashMap<String, Short> feedIndexByNameMap;
    private String feedName;
    private static HashMap<Short, String> feedNameByIndexMap;
    private static String feeds;
    private HashMap<CaptureClientConnection, CaptureFeedSubscription> feedSubscribersMap = new HashMap();
    private byte feedType;
    private ImageIcon icon = null;
    private static Dimension thisImageSize;
    private static boolean imageSizeSet;
    private byte layer;
    private CaptureLogicalImageRoot logicalRoot = null;
    private Short moduleIndex;
    private static HashMap<String, Short> moduleIndexByNameMap;
    private String moduleName;
    private static HashMap<Short, String> moduleNameByIndexMap;
    private static MRFClientThread mrfClientThread;
    private static MRFile mrFile;
    private static boolean NotEvaluated;
    private Dimension outputSize = null;
    private static HashMap<String, ImageFeedSpec> outputSizeMap;
    private byte panelMode;
    private static String phaseString;
    private static PrintStream progressStream;
    private static LightweightTimer progressTimer;
    private static JToggleButton recordingButton;
    private static boolean recordingOn;
    private static ImageIcon RecordingPressedIcon;
    private static ImageIcon RecordingReleasedIcon;
    private static TreeMap<String, ContentCaptureImpl> registeredFeedMap;
    static long sendDelay;
    private static String sessionName;
    private static long sessionTime;
    private static short staticFeedIndex;
    private static short staticModuleIndex;
    private CaptureTextInput textInput = null;
    private String title = null;
    private boolean visible = true;
    private static HashMap<FeedBinding, ComponentBinding> componentBindMap;
    private Imps imps;
    private int startedCount = 0;
    private ClientProvider clientProvider;
    private Injector injector;
    private Application application;

    @Inject
    ContentCaptureImpl(ApplicationProperties props, ClientProvider clientProvider, Imps imps, Injector injector, Application application) {
        this.imps = imps;
        this.clientProvider = clientProvider;
        this.injector = injector;
        this.application = application;
    }

    private ContentCaptureImpl(ContentCaptureImpl master, String moduleName, String feedName, byte type, ImageIcon icon, byte panelMode, byte layer, Container container) throws IOException {
        this.moduleName = moduleName;
        this.feedName = feedName;
        this.title = feedName;
        this.feedType = type;
        this.icon = icon;
        this.panelMode = panelMode;
        this.layer = layer;
        this.container = container;
        this.imps = master.imps;
        this.clientProvider = master.clientProvider;
        this.injector = master.injector;
        this.application = master.application;
        this.setupClient();
    }

    private ContentCaptureImpl(ContentCaptureImpl thisImpl, String moduleName, String feedName, Container container, ImageIcon icon, byte panelMode, byte layer) throws IOException {
        this(thisImpl, moduleName, feedName, 0, icon, panelMode, layer, container);
        this.callback = this;
    }

    private ContentCaptureImpl(ContentCaptureImpl thisImpl, String moduleName, String feedName, ImageIcon icon, byte panelMode, byte layer) throws IOException {
        this(thisImpl, moduleName, feedName, 1, icon, panelMode, layer, null);
    }

    private ContentCaptureImpl(ContentCaptureImpl thisImpl, String moduleName, String feedName, CaptureBacklogCallback callback, CaptureTextInput textInput, ImageIcon icon, byte panelMode, byte layer) throws IOException {
        this(thisImpl, moduleName, feedName, textInput == null ? (byte)3 : 2, icon, panelMode, layer, null);
        this.callback = callback;
        this.textInput = textInput;
    }

    public ContentCapture registerImageModule(String moduleName, String feedName, Container container, ImageIcon icon, byte panelMode, byte layer) {
        try {
            ContentCaptureImpl imageFeed = new ContentCaptureImpl(this, moduleName, feedName, container, icon, panelMode, layer);
            this.bindImageComponent(moduleName, feedName, container, imageFeed);
            return imageFeed;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public boolean bindImageComponent(String moduleName, String feedName, Container container) {
        FeedBinding fBinding = new FeedBinding(feedName, moduleName, null);
        ComponentBinding cBinding = componentBindMap.get(fBinding);
        if (componentBindMap.containsKey(fBinding) && cBinding.impl != null) {
            return this.bindImageComponent(moduleName, feedName, container, cBinding.impl);
        }
        componentBindMap.put(fBinding, new ComponentBinding(null, container));
        return false;
    }

    private boolean bindImageComponent(String moduleName, String feedName, Container container, ContentCaptureImpl imageFeed) {
        FeedBinding fBinding = new FeedBinding(feedName, moduleName, null);
        ComponentBinding cBinding = componentBindMap.get(fBinding);
        boolean boundPreRegistered = false;
        if (cBinding == null) {
            cBinding = new ComponentBinding(imageFeed, container);
            componentBindMap.put(fBinding, cBinding);
        } else {
            boundPreRegistered = true;
            if (cBinding.container != null) {
                ComponentRepaintManager.getInstance().unregisterContainer(container);
            }
        }
        ComponentRepaintManager.getInstance().registerContainer(container, imageFeed);
        return boundPreRegistered;
    }

    public ContentCapture registerTextModule(String moduleName, String feedName, CaptureBacklogCallback callback, CaptureTextInput textInput, ImageIcon icon, byte panelMode, byte layer) {
        try {
            ContentCaptureImpl textFeed = new ContentCaptureImpl(this, moduleName, feedName, callback, textInput, icon, panelMode, layer);
            return textFeed;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public ContentCapture registerAudioModule(String moduleName, String feedName, ImageIcon icon, byte panelMode, byte layer) {
        try {
            ContentCaptureImpl audioFeed = new ContentCaptureImpl(this, moduleName, feedName, icon, panelMode, layer);
            return audioFeed;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public AbstractButton getContentCaptureRecordingButton() {
        return recordingButton;
    }

    public Client clients() {
        return this.clientProvider.get();
    }

    public boolean allowUpscale() {
        return allowUpscale;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public Short getFeedIndex() {
        return this.feedIndex;
    }

    public byte getFeedType() {
        return this.feedType;
    }

    public ImageIcon getFeedIcon() {
        return this.icon;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Short getModuleIndex() {
        return this.moduleIndex;
    }

    public Dimension getOutputSize() {
        return this.outputSize;
    }

    public byte getPanelMode() {
        return this.panelMode;
    }

    public byte getFeedLayer() {
        return this.layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getFeedIndex(String feedName) {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            Short feedIndex = feedIndexByNameMap.get(feedName);
            if (feedIndex != null) {
                return feedIndex;
            }
            System.err.println("ContentCapture.getFeedIndex: cannot find index for: " + feedName);
            return -1;
        }
    }

    public ContentCapture getFeed(short feedIndex) {
        return this.getFeed(this.getFeedName(feedIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentCapture getFeed(String feedName) {
        TreeMap<String, ContentCaptureImpl> treeMap = registeredFeedMap;
        synchronized (treeMap) {
            return registeredFeedMap.get(feedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFeedName(short feedIndex) {
        TreeMap<String, ContentCaptureImpl> treeMap = registeredFeedMap;
        synchronized (treeMap) {
            return feedNameByIndexMap.get(ShortList.get((short)feedIndex));
        }
    }

    public boolean isContentCaptureEnabled() {
        if (NotEvaluated) {
            try {
                try {
                    RecordingReleasedIcon = i18n.getIcon("ContentCapture.recordingReleasedIcon");
                    RecordingPressedIcon = i18n.getIcon("ContentCapture.recordingPressedIcon");
                    ContentCaptureEnabled = RecordingReleasedIcon != null;
                }
                catch (Exception ex) {
                    ContentCaptureEnabled = false;
                }
                defaultEncoding = 0;
            }
            catch (Exception ex) {
                ContentCaptureEnabled = false;
                defaultEncoding = 0;
                ex.printStackTrace();
            }
            NotEvaluated = false;
        }
        return ContentCaptureEnabled;
    }

    public boolean isCapturingData() {
        return captureData;
    }

    public boolean isEchoingData() {
        return echoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeed() throws IOException {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            Iterator<CaptureClientConnection> iter = clientSet.iterator();
            while (iter.hasNext()) {
                this.addFeed(iter.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule() throws IOException {
        HashSet<CaptureClientConnection> hashSet = clientSet;
        synchronized (hashSet) {
            Iterator<CaptureClientConnection> iter = clientSet.iterator();
            while (iter.hasNext()) {
                this.addModule(iter.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeed(CaptureClientConnection connection) throws IOException {
        HashSet<CaptureClientConnection> hashSet = clientSet;
        synchronized (hashSet) {
            connection.addFeed(this.getFeedName(), this.getFeedType(), this.getFeedIcon(), this.getModuleIndex().shortValue(), this.getPanelMode(), this.getFeedLayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule(CaptureClientConnection connection) throws IOException {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            connection.addModule(this.getModuleName(), this.getModuleIndex().shortValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removedFeed() throws IOException {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            Iterator<CaptureClientConnection> iter = clientSet.iterator();
            while (iter.hasNext()) {
                iter.next().removeFeed(this.getFeedName(), this.getFeedType(), this.getPanelMode(), this.getFeedLayer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(CaptureClientConnection connection) {
        HashSet<CaptureClientConnection> hashSet = clientSet;
        synchronized (hashSet) {
            clientSet.add(connection);
            try {
                this.emitSessionName(connection);
                this.emitAllGroups(connection);
                this.emitAllParticipants(connection);
                this.emitAllModules(connection);
                this.emitAllFeeds(connection);
                if (recordingOn) {
                    this.emitRecordingControl(connection, (byte)0);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void setConditionData(byte[] conditionData) {
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.setConditionData: " + this.feedIndex + ", " + this.getFeedName(this.feedIndex));
        }
        this.conditionData = conditionData;
    }

    public void start() {
        ++this.startedCount;
        if (this.isCapturingData() && this.startedCount == 1) {
            if (sessionTimeAPI == null) {
                sessionTimeAPI = (SessionTimeAPI)this.imps.findBest(SessionTimeAPI.class);
            }
            if (playbackTimeAPI == null) {
                playbackTimeAPI = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
            }
            ContentCaptureIO.setCapturePort(capturePort, capturePortSearchLimit);
            if (progressStream != null) {
                progressTimer = new LightweightTimer(1, new Runnable(){

                    @Override
                    public void run() {
                        StringBuffer buf = new StringBuffer();
                        buf.append(phaseString);
                        if (playbackTimeAPI != null) {
                            if (playbackTimeAPI.getPlayingTime() < 0L) {
                                return;
                            }
                            buf.append(":\"Playback\":");
                            buf.append(playbackTimeAPI.getPlayingTime() + ":");
                            buf.append(playbackTimeAPI.getDuration());
                        } else if (sessionTimeAPI != null) {
                            if (sessionTimeAPI.getSessionTime() < 0L) {
                                return;
                            }
                            buf.append(":\"" + sessionName + "\":");
                            buf.append(sessionTimeAPI.getSessionTime() + ":0");
                        } else {
                            return;
                        }
                        if (progressStream != null) {
                            progressStream.println(buf.toString());
                            progressStream.flush();
                        }
                    }
                });
                progressTimer.scheduleEvery(1000L);
            }
        } else {
            return;
        }
        if (mrFile != null) {
            mrfClientThread = imageSizeSet ? new MRFClientThread(mrFile, feeds, ContentCaptureImpl.thisImageSize.width, ContentCaptureImpl.thisImageSize.height) : new MRFClientThread(mrFile, feeds, 0, 0);
            mrfClientThread.start();
        } else {
            captureData = false;
        }
    }

    public void shutdown() {
        --this.startedCount;
        if (this.startedCount > 0) {
            return;
        }
        if (playbackTimeAPI != null) {
            playbackTimeAPI.removeDataChangeListener(this.indexListener);
            playbackTimeAPI = null;
        }
        if (progressStream != null) {
            progressStream.close();
            progressStream = null;
        }
        try {
            ContentCaptureIO.getInstance().stopRun();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mrfClientThread != null) {
            mrfClientThread.shutdown();
            mrfClientThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeToFeed(CaptureClientConnection connection, boolean reconnect) {
        CaptureFeedSubscriptionImpl subscription = new CaptureFeedSubscriptionImpl(this.feedName, this.getFeedIndex(this.feedName), this.feedType, this, connection);
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            this.feedSubscribersMap.put(connection, subscription);
        }
        connection.addFeedSubscription((CaptureFeedSubscription)subscription);
        if (this.logicalRoot != null) {
            subscription.setSizeChanged(this.logicalRoot.getOutputSize());
            subscription.setEncoding(this.logicalRoot.getEncoding());
        }
        connection.setFeedVisible(this.feedIndex.shortValue(), this.visible);
        if (this.conditionData != null) {
            subscription.conditionFeed(this.feedIndex, this.conditionData);
        }
        try {
            subscription.emitTitle(this.title);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (!reconnect) {
            this.fireCallbacks(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeFromFeed(CaptureClientConnection connection) {
        CaptureFeedSubscription subscription = null;
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            subscription = this.feedSubscribersMap.get(connection);
            this.feedSubscribersMap.remove(connection);
        }
        if (subscription != null) {
            connection.removeFeedSubscription(subscription);
        }
    }

    public void fireCallbacks(CaptureFeedSubscription subscription) {
        if (this.callback != null) {
            this.callback.captureBacklogCallback(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitAllFeeds(CaptureClientConnection connection) throws IOException {
        TreeMap<String, ContentCaptureImpl> treeMap = registeredFeedMap;
        synchronized (treeMap) {
            ContentCaptureImpl[] services = new ContentCaptureImpl[registeredFeedMap.size()];
            services = registeredFeedMap.values().toArray(services);
            for (int i = 0; i < services.length; ++i) {
                connection.addFeed(services[i].getFeedName(), services[i].getFeedType(), services[i].getFeedIcon(), services[i].getModuleIndex().shortValue(), services[i].getPanelMode(), services[i].getFeedLayer());
            }
        }
    }

    private void emitAllGroups(CaptureClientConnection connection) throws IOException {
        Iterator iter = this.clients().getClientList().groupIterator();
        while (iter.hasNext()) {
            ClientGroup cg = (ClientGroup)iter.next();
            connection.sendCommand(ContentCaptureIOPacketUtils.encodeCreateGroup((String)cg.getName(), (short)cg.getGroupID(), (long)this.sessionTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitAllModules(CaptureClientConnection connection) throws IOException {
        HashMap<Short, String> hashMap = moduleNameByIndexMap;
        synchronized (hashMap) {
            for (Map.Entry<Short, String> entry : moduleNameByIndexMap.entrySet()) {
                connection.sendCommand(ContentCaptureIOPacketUtils.encodeAddModule((String)entry.getValue(), (short)entry.getKey()));
            }
        }
    }

    private void emitAllParticipants(CaptureClientConnection connection) throws IOException {
        for (ClientInfo ci : this.clients().getClientList()) {
            if (ci.getState() == 2) {
                connection.sendCommand(ContentCaptureIOPacketUtils.encodeAddParticipant((String)ci.getName(), (short)ci.getAddress(), (short)ci.getGroupID(), (String)ci.getDisplayName(), (long)this.sessionTime()));
                continue;
            }
            connection.sendCommand(ContentCaptureIOPacketUtils.encodeRemoveParticipant((short)ci.getAddress(), (long)this.sessionTime()));
        }
    }

    private void emitSessionName(CaptureClientConnection connection) {
        String name = sessionName;
        if (sessionName == null) {
            name = "";
        }
        connection.sendCommand(ContentCaptureIOPacketUtils.encodeSessionName((String)name, (long)sessionTime));
    }

    private void recordingButtonAction() {
        this.setRecordingOn(recordingButton.isSelected());
    }

    private void emitRecordingControl(CaptureClientConnection connection, byte controlType) {
        connection.sendCommand(ContentCaptureIOPacketUtils.encodeSessionRecord((byte)controlType, (long)this.sessionTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeFeed(String feedName, CaptureClientConnection connection, boolean reconnect) {
        TreeMap<String, ContentCaptureImpl> treeMap = registeredFeedMap;
        synchronized (treeMap) {
            ContentCaptureImpl service = registeredFeedMap.get(feedName);
            if (service != null) {
                service.subscribeToFeed(connection, reconnect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModule() {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            registeredFeedMap.remove(this.feedName);
            feedIndexByNameMap.remove(this.feedName);
            feedNameByIndexMap.remove(this.feedIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeFromFeed(String feedName, CaptureClientConnection connection) {
        TreeMap<String, ContentCaptureImpl> treeMap = registeredFeedMap;
        synchronized (treeMap) {
            ContentCaptureImpl service = registeredFeedMap.get(feedName);
            if (service != null) {
                service.unsubscribeFromFeed(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureBacklogCallback(CaptureFeedSubscription subscription) {
        CaptureFeedSubscription[] subscriptions;
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap2 = this.feedSubscribersMap;
            synchronized (hashMap2) {
                subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
                subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
            }
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            subscriptions[i].replayTiles();
        }
    }

    public void acceptSubscriberTextInput(String textInput) {
        if (this.textInput != null) {
            this.textInput.textInput(textInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudio(short talkerAddress, byte[] codedAudio) {
        CaptureFeedSubscription[] subscriptions;
        if (this.feedType != 1) {
            throw new RuntimeException("Cannot send audio contents to a feed: " + ContentCaptureIOPacketUtils.FEED_NAMES[this.feedType]);
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.sendAudio: " + this.feedIndex + ", packets: " + codedAudio.length + ", talker: " + talkerAddress);
        }
        long eventTime = this.sessionTime();
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            if (!this.isCapturingData() || this.feedSubscribersMap.isEmpty()) {
                return;
            }
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            try {
                subscriptions[i].sendAudio(talkerAddress, codedAudio, eventTime);
                continue;
            }
            catch (IOException ioe) {
                this.unsubscribeFromFeed(subscriptions[i].getConnection());
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudioGrant(short talkerAddress, boolean grant) {
        CaptureFeedSubscription[] subscriptions;
        if (this.feedType != 1) {
            throw new RuntimeException("Cannot send audio contents to a feed: " + ContentCaptureIOPacketUtils.FEED_NAMES[this.feedType]);
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.sendAudioGrant: " + this.feedIndex + ", talker: " + talkerAddress + ", grant: " + grant);
        }
        long eventTime = this.sessionTime();
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            if (!this.isCapturingData() || this.feedSubscribersMap.isEmpty()) {
                return;
            }
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            subscriptions[i].sendAudioControl(talkerAddress, grant, eventTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendImageTiles(CaptureTile[] tileArray) {
        CaptureFeedSubscription[] subscriptions;
        if (this.feedType != 0) {
            throw new RuntimeException("Cannot send image tiles contents to a feed: " + ContentCaptureIOPacketUtils.FEED_NAMES[this.feedType]);
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.sendImageTiles: " + this.feedIndex + ", " + this.getFeedName(this.feedIndex) + ", " + tileArray.length);
        }
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            if (!this.isCapturingData() || this.feedSubscribersMap.isEmpty()) {
                return;
            }
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            for (int j = 0; j < tileArray.length; ++j) {
                subscriptions[i].setTile(tileArray[j]);
            }
            subscriptions[i].startOutput();
        }
    }

    public void sendIndexMark(String modName, String kind, String detail, long time) {
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeIndexMark((String)modName, (String)kind, (String)detail, (long)time));
    }

    public long sessionTime(long timeIn) {
        if (timeIn != 0L) {
            return timeIn;
        }
        return this.sessionTime();
    }

    public long sessionTime() {
        long time;
        if (playbackTimeAPI != null) {
            if (!playbackChangeListenerSet) {
                playbackChangeListenerSet = playbackTimeAPI.addDataChangeListener(this.indexListener);
            }
            if (!playbackChangeListenerSet) {
                return -1L;
            }
            time = playbackTimeAPI.getPlayingTime();
        } else {
            time = sessionTimeAPI != null ? sessionTimeAPI.getSessionTime() : System.currentTimeMillis() - baseTime;
        }
        if (baseTime == 0L) {
            baseTime = time;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordingOn(boolean sense) {
        recordingOn = sense;
        if (recordingButton != null && recordingButton.isSelected() != sense) {
            recordingButton.setSelected(sense);
        }
        HashSet<CaptureClientConnection> hashSet = clientSet;
        synchronized (hashSet) {
            for (CaptureClientConnection connection : clientSet) {
                this.emitRecordingControl(connection, sense ? (byte)0 : 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionName(String title) {
        sessionName = title;
        HashSet<CaptureClientConnection> hashSet = clientSet;
        synchronized (hashSet) {
            for (CaptureClientConnection connection : clientSet) {
                this.emitSessionName(connection);
            }
        }
    }

    public void setText(String text) {
        this.setText((short)-1, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(short author, String text) {
        CaptureFeedSubscription[] subscriptions;
        if (this.feedType != 2 && this.feedType != 3) {
            throw new RuntimeException("Cannot send text contents to a feed: " + ContentCaptureIOPacketUtils.FEED_NAMES[this.feedType]);
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.setText: " + this.feedIndex + ", " + this.getFeedName(this.feedIndex) + " (" + text + ")");
        }
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            if (!this.isCapturingData() || this.feedSubscribersMap.isEmpty()) {
                return;
            }
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            try {
                subscriptions[i].setText(author, text, true);
                continue;
            }
            catch (IOException ioe) {
                this.unsubscribeFromFeed(subscriptions[i].getConnection());
                ioe.printStackTrace();
            }
        }
    }

    public void setTime(long time) {
        sessionTime = time;
        this.setSessionName(sessionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        CaptureFeedSubscription[] subscriptions;
        if (this.title == title || this.title != null && this.title.equals(title)) {
            return;
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.setTitle: " + this.feedIndex + ", " + this.getFeedName(this.feedIndex) + " (" + title + ")");
        }
        this.title = title;
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            if (!this.isCapturingData() || this.feedSubscribersMap.isEmpty()) {
                return;
            }
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            try {
                subscriptions[i].setTitle(title);
                continue;
            }
            catch (IOException ioe) {
                this.unsubscribeFromFeed(subscriptions[i].getConnection());
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupClient() {
        Iterator<CaptureClientConnection> connectionIterator;
        if (!moduleIndexByNameMap.containsKey(this.moduleName)) {
            short s = staticModuleIndex;
            staticModuleIndex = (short)(s + 1);
            this.moduleIndex = ShortList.get((short)s);
            moduleIndexByNameMap.put(this.moduleName, this.moduleIndex);
            HashMap<Short, String> hashMap = moduleNameByIndexMap;
            synchronized (hashMap) {
                moduleNameByIndexMap.put(this.moduleIndex, this.moduleName);
            }
            connectionIterator = clientSet.iterator();
            while (connectionIterator.hasNext()) {
                connectionIterator.next().sendCommand(ContentCaptureIOPacketUtils.encodeAddModule((String)this.moduleName, (short)this.moduleIndex));
            }
        }
        if (registeredFeedMap.containsKey(this.feedName)) {
            throw new RuntimeException("Duplicate feedname: " + this.feedName);
        }
        registeredFeedMap.put(this.feedName, this);
        short s = staticFeedIndex;
        staticFeedIndex = (short)(s + 1);
        this.feedIndex = ShortList.get((short)s);
        feedIndexByNameMap.put(this.feedName, this.feedIndex);
        feedNameByIndexMap.put(this.feedIndex, this.feedName);
        connectionIterator = clientSet.iterator();
        while (connectionIterator.hasNext()) {
            try {
                connectionIterator.next().addFeed(this.getFeedName(), this.getFeedType(), this.getFeedIcon(), this.getModuleIndex().shortValue(), this.getPanelMode(), this.getFeedLayer());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (vclassClient == null) {
            vclassClient = this.clients();
            this.clients().addClientGroupListener((ClientGroupListener)this);
            this.clients().getClientList().addClientListener((ClientListener)this);
        }
        if (recordingButton == null) {
            recordingButton = new JToggleButton();
            recordingButton.setPreferredSize(new Dimension(24, 24));
            recordingButton.setIcon(RecordingReleasedIcon);
            recordingButton.setSelectedIcon(RecordingPressedIcon);
            recordingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContentCaptureImpl.this.recordingButtonAction();
                }
            });
            this.setRecordingOn(recordingOn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptureLogicalImageRoot getImageRoot() {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            if (this.logicalRoot == null) {
                if (this.container == null) {
                    System.err.println("ContentCapture.getImageRoot: " + ((Object)((Object)this)).hashCode() + ", no container: " + this.container + ", for: " + this.feedName);
                }
                this.logicalRoot = ComponentRepaintManager.getInstance().getImageRoot(this.container);
            }
            return this.logicalRoot;
        }
    }

    public Dimension getImageSize() {
        return thisImageSize;
    }

    public boolean isImageSizeSet() {
        return imageSizeSet;
    }

    public boolean isRecording() {
        return recordingOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeChanged(Dimension imageSize) {
        CaptureFeedSubscription[] subscriptions;
        if (this.feedType != 0) {
            throw new RuntimeException("Cannot send image tiles contents to a feed: " + ContentCaptureIOPacketUtils.FEED_NAMES[this.feedType]);
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.setSizeChanged: " + this.feedIndex + ", " + this.getFeedName(this.feedIndex) + " (" + imageSize.width + ", " + imageSize.height + ")");
        }
        if (!this.isImageSizeSet()) {
            thisImageSize = imageSize;
        }
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            if (!this.isCapturingData() || this.feedSubscribersMap.isEmpty()) {
                return;
            }
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            subscriptions[i].setSizeChanged(imageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeedVisible(boolean visible) {
        CaptureFeedSubscription[] subscriptions;
        this.visible = visible;
        if (!this.isCapturingData()) {
            return;
        }
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.setFeedVisible: " + this.feedIndex + ", " + this.getFeedName(this.feedIndex) + " (" + visible + ")");
        }
        HashMap<CaptureClientConnection, CaptureFeedSubscription> hashMap = this.feedSubscribersMap;
        synchronized (hashMap) {
            subscriptions = new CaptureFeedSubscription[this.feedSubscribersMap.size()];
            subscriptions = this.feedSubscribersMap.values().toArray(subscriptions);
        }
        for (int i = 0; i < subscriptions.length; ++i) {
            subscriptions[i].getConnection().setFeedVisible(subscriptions[i].getFeedIndex(), visible);
        }
    }

    public boolean canQuit(Component component) {
        if (this.isCapturingData()) {
            return JOptionPane.showConfirmDialog(component, i18n.getString((PropertiesEnum)StringsProperties.CONTENTCAPTURE_CANCLOSESERVERTITLE), i18n.getString((PropertiesEnum)StringsProperties.CONTENTCAPTURE_CANCLOSESERVER), 0, 2) == 0;
        }
        return true;
    }

    public void iconifyIfNotEchoing(Frame frame) {
        if (!this.isEchoingData() && frame != null) {
            frame.setExtendedState(1);
        }
    }

    public void clientGroupChanged(ClientGroupEvent e) {
        ClientInfo ci = e.getClient();
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeAddParticipant((String)"", (short)ci.getAddress(), (short)ci.getGroupID(), (String)"", (long)this.sessionTime()));
    }

    public void clientGroupCreated(ClientGroupEvent e) {
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeCreateGroup((String)e.getGroupName(), (short)e.getGroupID(), (long)this.sessionTime()));
    }

    public void clientGroupDeleted(ClientGroupEvent e) {
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeDeleteGroup((short)e.getGroupID(), (long)this.sessionTime()));
    }

    public void clientGroupRenamed(ClientGroupEvent e) {
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeRenameGroup((String)e.getGroupName(), (short)e.getGroupID(), (String)e.getPreviousGroupName(), (short)e.getPreviousGroupID(), (long)this.sessionTime()));
    }

    public void onAddClient(ClientEvent e) {
        ClientInfo ci = this.clients().getClientList().get(e.getAddress());
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.onAddClient: " + ci.getName() + ", addr: " + ci.getAddress() + ", group: " + ci.getGroupID());
        }
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeAddParticipant((String)ci.getName(), (short)e.getAddress(), (short)ci.getGroupID(), (String)ci.getDisplayName(), (long)this.sessionTime()));
    }

    public void onRemoveClient(ClientEvent e) {
        if (DEBUG_CONTENT_CAPTURE) {
            System.out.println("ContentCapture.onAddClient: " + e.getAddress());
        }
        this.sendCommandToAll(ContentCaptureIOPacketUtils.encodeRemoveParticipant((short)e.getAddress(), (long)this.sessionTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommandToAll(byte[] packet) {
        HashMap<String, Short> hashMap = feedIndexByNameMap;
        synchronized (hashMap) {
            Iterator<CaptureClientConnection> iter = clientSet.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().sendCommand(packet);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getSendDelay() {
        return 0;
    }

    public void processArguments(ApplicationProperties props) {
        byte encoding = 1;
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        List args = props.get(MULTIMEDIA_FILE_ARG);
        if (args != null) {
            if (args.size() != 1) {
                LogSupport.error((String)"-multimedia: needs a single file specified.");
            }
            mrFile = new MRFile((String)args.get(0));
        }
        if ((args = props.get(IMAGE_SIZE_ARG)) != null) {
            String feedName;
            int height;
            int width;
            if (args.size() != 1) {
                LogSupport.error((String)"-imagesize: needs a single output size specified.");
            }
            StringTokenizer sizeTokens = new StringTokenizer((String)args.get(0), ",");
            try {
                width = Integer.parseInt(sizeTokens.nextToken());
                height = Integer.parseInt(sizeTokens.nextToken());
            }
            catch (NumberFormatException ex) {
                LogSupport.error((String)("Invalid -imagesize  argument (s/b: w,h): " + (String)args.get(0)));
                width = 320;
                height = 240;
            }
            if (sizeTokens.hasMoreTokens()) {
                feedName = sizeTokens.nextToken().toLowerCase(Locale.ENGLISH);
                if (sizeTokens.hasMoreTokens()) {
                    String enc = sizeTokens.nextToken().toLowerCase(Locale.ENGLISH);
                    if (enc.equals(LOSSY_ENCODING)) {
                        encoding = 0;
                    } else if (enc.equals(LOSSLESS_ENCODING)) {
                        encoding = 1;
                    }
                }
                outputSizeMap.put(feedName, new ImageFeedSpec(feedName, width, height, encoding));
            } else {
                feedName = "";
            }
            if (feedName.length() == 0) {
                thisImageSize = new Dimension(width, height);
                imageSizeSet = true;
                defaultEncoding = encoding;
            }
        }
        if ((args = props.get(DISPLAY_SERVER_ARG)) != null) {
            captureData = true;
            captureDataSet = true;
        }
        if ((args = props.get(NOT_SERVER_ARG)) != null && mrFile == null) {
            captureData = false;
            captureDataSet = true;
        }
        if ((args = props.get(SERVER_ECHO_ARG)) != null) {
            echoData = true;
            echoDataSet = true;
        }
        if ((args = props.get(NO_SERVER_ECHO_ARG)) != null) {
            echoData = false;
            echoDataSet = true;
        }
        if ((args = props.get(FEEDS_ARG)) != null) {
            if (args.size() != 1) {
                LogSupport.error((String)"-feeds: needs a single feed name specified.");
            }
            feeds = (String)args.get(0);
        }
        if ((args = props.get(SEND_DELAY_ARG)) != null) {
            int delay;
            if (args.size() != 1) {
                LogSupport.error((String)"-imagemsec: needs a single msec delay specified.");
            }
            sendDelay = (delay = Integer.parseInt((String)args.get(0))) < 0 ? 0L : (delay > 1000 ? 1000L : (long)delay);
        }
        if ((args = props.get(SERVER_PORT_ARG)) != null) {
            if (args.size() != 1) {
                LogSupport.error((String)"-serverport: needs a single server port specified.");
            }
            capturePort = Integer.parseInt((String)args.get(0));
            captureData = true;
        }
        if ((args = props.get(SERVER_PORT_AUTO_ARG)) != null) {
            if (args.size() != 1) {
                LogSupport.error((String)"-portsearchlimit: needs a single server port specified.");
            }
            capturePortSearchLimit = Integer.parseInt((String)args.get(0));
            captureData = true;
        }
        if ((args = props.get(RECORDING_ON_ARG)) != null) {
            if (args.size() != 0) {
                LogSupport.error((String)"-recordingon: takes no arguments.");
            }
            this.setRecordingOn(true);
        }
        if ((args = props.get(RECORDING_OFF_ARG)) != null) {
            if (args.size() != 0) {
                LogSupport.error((String)"-recordingoff: takes no arguments.");
            }
            this.setRecordingOn(false);
        }
        if ((args = props.get(ALLOW_UPSCALE_ARG)) != null) {
            allowUpscale = true;
        }
        if ((args = props.get(PREVENT_UPSCALE_ARG)) != null) {
            allowUpscale = false;
        }
        if ((args = props.get(PROGRESS_ADDRESS_ARG)) != null) {
            if (args.size() != 1) {
                LogSupport.error((String)"-progress: needs a single server port specified.");
            }
            String address = "";
            int port = 0;
            StringTokenizer addressTokens = new StringTokenizer((String)args.get(0), ":");
            try {
                if (addressTokens.hasMoreTokens()) {
                    address = addressTokens.nextToken();
                    if (addressTokens.hasMoreTokens()) {
                        port = Integer.parseInt(addressTokens.nextToken());
                        Socket progressSocket = new Socket(address, port);
                        progressStream = new PrintStream(new BufferedOutputStream(progressSocket.getOutputStream()));
                    }
                }
            }
            catch (Exception ex1) {
                LogSupport.error((String)("Cannot attach to Progress Stream: " + address + ":" + port));
                progressStream = null;
            }
        }
    }

    static {
        capturePort = 0;
        capturePortSearchLimit = 1;
        baseTime = 0L;
        captureData = true;
        captureDataSet = false;
        clientSet = new HashSet();
        indexEntryIndex = 0;
        echoData = true;
        echoDataSet = false;
        feedIndexByNameMap = new HashMap();
        feedNameByIndexMap = new HashMap();
        feeds = "";
        thisImageSize = null;
        imageSizeSet = false;
        moduleIndexByNameMap = new HashMap();
        moduleNameByIndexMap = new HashMap();
        mrfClientThread = null;
        mrFile = null;
        NotEvaluated = true;
        outputSizeMap = new HashMap();
        phaseString = "Creating MRF";
        progressStream = null;
        progressTimer = null;
        recordingButton = null;
        recordingOn = true;
        RecordingPressedIcon = null;
        RecordingReleasedIcon = null;
        registeredFeedMap = new TreeMap();
        sendDelay = 66L;
        sessionName = null;
        sessionTime = 0L;
        staticFeedIndex = 0;
        staticModuleIndex = 0;
        componentBindMap = new HashMap();
    }

    class ComponentBinding {
        ContentCaptureImpl impl;
        Container container;

        ComponentBinding(ContentCaptureImpl impl, Container container) {
            this.impl = impl;
            this.container = container;
        }
    }

    class FeedBinding
    implements Comparable<FeedBinding> {
        String feedName;
        String moduleName;
        Container container;

        FeedBinding(String feedName, String moduleName, Container container) {
            this.feedName = feedName;
            this.moduleName = moduleName;
        }

        public boolean equals(Object input) {
            if (input instanceof FeedBinding) {
                FeedBinding feedInput = (FeedBinding)input;
                if ((this.feedName == feedInput.feedName || this.feedName != null && this.feedName.equals(feedInput)) && (this.moduleName == feedInput.moduleName || this.moduleName != null && this.moduleName.equals(feedInput))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(FeedBinding input) {
            FeedBinding feedInput = input;
            int c = this.feedName.compareTo(feedInput.feedName);
            if (c == 0) {
                c = this.moduleName.compareTo(feedInput.moduleName);
            }
            return c;
        }
    }
}

