/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.CaptureLogicalImageRoot;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.groupware.module.contentcapture.CaptureLogicalImageRootImpl;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import java.awt.Container;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimerTask;
import javax.swing.JComponent;

public class ComponentRepaintManager {
    private Hashtable<Container, CaptureLogicalImageRoot> registeredContainer = new Hashtable();
    private LightweightTimer sendTimer = new LightweightTimer(2, (Runnable)new SendTimer());
    private boolean componentsDirty = false;
    private static ComponentRepaintManager instance = null;
    private static ContentCaptureProvider contentCaptureProvider;

    @Inject
    public static void initContentCaptureProvider(ContentCaptureProvider contentCaptureProviderArg) {
        contentCaptureProvider = contentCaptureProviderArg;
    }

    private ComponentRepaintManager() {
    }

    public static ComponentRepaintManager getInstance() {
        if (instance == null) {
            instance = new ComponentRepaintManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContainer(Container container, ContentCapture feed) {
        CaptureLogicalImageRootImpl logicalRoot = new CaptureLogicalImageRootImpl(container, feed);
        Hashtable<Container, CaptureLogicalImageRoot> hashtable = this.registeredContainer;
        synchronized (hashtable) {
            this.registeredContainer.put(container, logicalRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterContainer(Container container) {
        Hashtable<Container, CaptureLogicalImageRoot> hashtable = this.registeredContainer;
        synchronized (hashtable) {
            CaptureLogicalImageRoot root = this.registeredContainer.remove(container);
            if (root != null) {
                root.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        boolean isInferior = false;
        boolean isSuperior = false;
        if (w <= 0 || h <= 0 || c == null || c.getWidth() <= 0 || c.getHeight() <= 0) {
            return;
        }
        Hashtable<Container, CaptureLogicalImageRoot> hashtable = this.registeredContainer;
        synchronized (hashtable) {
            CaptureLogicalImageRoot imageRoot;
            int relativeLevel = 0;
            int dx = x;
            int dy = y;
            for (Container p = c; p != null; p = p.getParent()) {
                if (!p.isVisible() || p.getPeer() == null) {
                    return;
                }
                imageRoot = this.registeredContainer.get(p);
                if (imageRoot != null && imageRoot.getLogicalRoot() != null) {
                    isInferior = true;
                    imageRoot.setDirtyUnion(dx, dy, w, h, (Container)c, relativeLevel);
                }
                dx += p.getBounds().x;
                dy += p.getBounds().y;
                --relativeLevel;
            }
            if (!isInferior) {
                Iterator<CaptureLogicalImageRoot> iter = this.registeredContainer.values().iterator();
                while (iter.hasNext()) {
                    relativeLevel = 0;
                    imageRoot = iter.next();
                    for (Container p = imageRoot.getLogicalRoot(); p != null; p = p.getParent()) {
                        if (p != c) continue;
                        isSuperior = true;
                        break;
                    }
                    ++relativeLevel;
                    if (!isSuperior) continue;
                    imageRoot.setDirtyUnion(x, y, w, h, (Container)c, relativeLevel);
                }
            }
            this.componentsDirty |= isInferior || isSuperior;
            if (!this.sendTimer.isScheduled()) {
                if (contentCaptureProvider.get().getSendDelay() == 0) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ComponentRepaintManager.this.sendDirtyRegions();
                        }
                    });
                } else {
                    this.sendTimer.scheduleIn((long)contentCaptureProvider.get().getSendDelay());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDirtyRegions() {
        ComponentRepaintManager componentRepaintManager = this;
        synchronized (componentRepaintManager) {
            CaptureLogicalImageRoot[] roots = new CaptureLogicalImageRoot[this.registeredContainer.size()];
            roots = this.registeredContainer.values().toArray(roots);
            for (int i = 0; i < roots.length; ++i) {
                roots[i].paintDirtyComponents();
            }
            this.componentsDirty = false;
        }
    }

    public CaptureLogicalImageRoot getImageRoot(Container container) {
        return this.registeredContainer.get(container);
    }

    public Container displayComponentTree(JComponent c) {
        System.out.println("JComponent: " + (c.getName() == null ? c.getClass().getName() : c.getName()) + ", bounds: " + c.getBounds());
        if (c.getParent() instanceof JComponent) {
            return this.displayComponentTree((JComponent)c.getParent());
        }
        if (c.getParent() == null) {
            System.out.println("JComponent with null parent: " + c.getClass().getName());
            return c;
        }
        System.out.println("Component parent: " + c.getParent().getClass().getName());
        return c.getParent();
    }

    public static Container returnRoot(Container c) {
        if (c.getParent() instanceof JComponent) {
            return ComponentRepaintManager.returnRoot((JComponent)c.getParent());
        }
        if (c.getParent() == null) {
            return c;
        }
        return c.getParent();
    }

    class SendTimer
    extends TimerTask {
        SendTimer() {
        }

        @Override
        public void run() {
            if (contentCaptureProvider.get().isCapturingData() && ComponentRepaintManager.this.componentsDirty) {
                try {
                    ComponentRepaintManager.this.sendDirtyRegions();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

