/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.CaptureAudioEvent;
import com.elluminate.contentcapture.CaptureClientConnection;
import com.elluminate.contentcapture.CaptureFeedSubscription;
import com.elluminate.contentcapture.CaptureLogicalImageRoot;
import com.elluminate.contentcapture.CaptureTextSubscriber;
import com.elluminate.contentcapture.CaptureTile;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureIOPacketUtils;
import com.elluminate.groupware.module.contentcapture.ListMap;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public class CaptureFeedSubscriptionImpl
implements CaptureFeedSubscription,
CaptureTextSubscriber {
    public static final boolean DEBUG_FEED_SUBSCRIPTION = false;
    private static final byte[] NO_BYTES = new byte[0];
    private static final int TEXT_BLOCK_SIZE = 200;
    private boolean activityNoted = true;
    private ContentCapture contentCapture = null;
    private CaptureClientConnection connection;
    private HashSet<Short> currentTalkers = new HashSet();
    private String currentTitle = null;
    private String feedName;
    private short feedIndex;
    private boolean hasActivity = false;
    private CaptureLogicalImageRoot imageRoot = null;
    private Dimension imageSize = new Dimension(1, 1);
    private boolean notifyEndOfFrame = false;
    private boolean requestRepaint = false;
    private LinkedList<TextQueueElement> textQueue = null;
    private LinkedList<CaptureAudioEvent> audioEventQueue = null;
    private boolean receiveFeedMode = true;
    private boolean sizeChanged = false;
    private ListMap tileSet = new ListMap();
    private String title = null;
    private int type;

    @Inject
    public CaptureFeedSubscriptionImpl(String feedName, short feedIndex, int type, ContentCapture contentCapture, CaptureClientConnection connection) {
        this.feedName = feedName;
        this.feedIndex = feedIndex;
        this.type = type;
        this.contentCapture = contentCapture;
        this.connection = connection;
        switch (type) {
            case 1: {
                this.textQueue = new LinkedList();
                this.currentTalkers = new HashSet();
                this.audioEventQueue = new LinkedList();
                break;
            }
            case 0: {
                this.tileSet = new ListMap();
                this.imageRoot = contentCapture.getImageRoot();
                break;
            }
            case 2: 
            case 3: {
                this.textQueue = new LinkedList();
                break;
            }
            default: {
                throw new RuntimeException("Unknown feed type: " + type);
            }
        }
    }

    public CaptureClientConnection getConnection() {
        return this.connection;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public short getFeedIndex() {
        return this.feedIndex;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public String getNewTitle() {
        this.currentTitle = this.title;
        this.title = null;
        return this.currentTitle;
    }

    public String getCurrentTitle() {
        return this.currentTitle;
    }

    public void setTitle(String title) throws IOException {
        this.title = title;
        this.emitTitle(title);
    }

    public void emitTitle(String title) throws IOException {
        long time = this.contentCapture.sessionTime();
        if (title == null || title.length() == 0) {
            this.connection.sendCommand(ContentCaptureIOPacketUtils.encodeTitleData((String)"", (short)this.feedIndex, (long)time));
        } else {
            this.connection.sendCommand(ContentCaptureIOPacketUtils.encodeTitleData((String)title, (short)this.feedIndex, (long)time));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSubscription() {
        switch (this.type) {
            case 1: {
                HashSet<Short> hashSet = this.currentTalkers;
                synchronized (hashSet) {
                    Short[] talkers = new Short[this.currentTalkers.size()];
                    talkers = this.currentTalkers.toArray(talkers);
                    this.currentTalkers.clear();
                    for (int i = 0; i < talkers.length; ++i) {
                        this.sendAudioControl(talkers[i], false, this.contentCapture.sessionTime());
                    }
                    break;
                }
            }
            case 0: {
                Object object = this.contentCapture.getImageRoot().getLock();
                synchronized (object) {
                    this.tileSet = null;
                    this.imageRoot = null;
                    break;
                }
            }
            case 2: 
            case 3: {
                this.textQueue = null;
                break;
            }
            default: {
                throw new RuntimeException("Unknown feed type: " + this.type);
            }
        }
    }

    public void replayTiles() {
        if (this.imageRoot != null) {
            this.imageRoot.replayTiles((CaptureFeedSubscription)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasText() {
        if (this.textQueue == null) {
            return false;
        }
        LinkedList<TextQueueElement> linkedList = this.textQueue;
        synchronized (linkedList) {
            return (this.type == 2 || this.type == 3) && !this.textQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getText() {
        long time = this.contentCapture.sessionTime();
        LinkedList<TextQueueElement> linkedList = this.textQueue;
        synchronized (linkedList) {
            if (this.textQueue.isEmpty()) {
                return null;
            }
            TextQueueElement textElement = this.textQueue.removeFirst();
            return ContentCaptureIOPacketUtils.encodeTextData((String)textElement.getText(), (short)this.feedIndex, (long)time, (short)textElement.getAuthor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(short author, String text, boolean startOutput) throws IOException {
        if (this.type == 2 || this.type == 3) {
            LinkedList<TextQueueElement> linkedList = this.textQueue;
            synchronized (linkedList) {
                for (int i = 0; i < text.length(); i += 200) {
                    TextQueueElement textElement = new TextQueueElement(author, text.substring(i, Math.min(200 + i, text.length())));
                    this.textQueue.addLast(textElement);
                }
            }
        } else {
            throw new RuntimeException("Text data sent to a " + ContentCaptureIOPacketUtils.FEED_NAMES[this.type] + " feed.");
        }
        if (startOutput) {
            this.connection.startOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAudio() {
        if (this.audioEventQueue == null) {
            return false;
        }
        LinkedList<CaptureAudioEvent> linkedList = this.audioEventQueue;
        synchronized (linkedList) {
            return this.type == 1 && !this.audioEventQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAudio() {
        LinkedList<CaptureAudioEvent> linkedList = this.audioEventQueue;
        synchronized (linkedList) {
            if (this.audioEventQueue.isEmpty()) {
                return NO_BYTES;
            }
            return ContentCaptureIOPacketUtils.encodeCaptureAudioEvent((CaptureAudioEvent)this.audioEventQueue.removeFirst(), (short)this.feedIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudio(short talkerAddress, byte[] codedAudio, long eventTime) throws IOException {
        if (this.type == 1) {
            Short talker = talkerAddress;
            LinkedList<CaptureAudioEvent> linkedList = this.audioEventQueue;
            synchronized (linkedList) {
                if (!this.currentTalkers.contains(talker)) {
                    this.sendAudioControl(talkerAddress, true, eventTime);
                }
                this.audioEventQueue.addLast(new CaptureAudioEvent(talkerAddress, codedAudio, eventTime));
            }
        } else {
            throw new RuntimeException("Audio data sent to a " + ContentCaptureIOPacketUtils.FEED_NAMES[this.type] + " feed.");
        }
        this.connection.startOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudioControl(short talkerAddress, boolean grant, long eventTime) {
        if (this.type == 1) {
            LinkedList<CaptureAudioEvent> linkedList = this.audioEventQueue;
            synchronized (linkedList) {
                this.audioEventQueue.addLast(new CaptureAudioEvent(talkerAddress, grant, eventTime));
            }
        } else {
            throw new RuntimeException("Audio control sent to a " + ContentCaptureIOPacketUtils.FEED_NAMES[this.type] + " feed.");
        }
        Short talker = talkerAddress;
        HashSet<Short> hashSet = this.currentTalkers;
        synchronized (hashSet) {
            if (!grant && this.currentTalkers.contains(talker)) {
                this.currentTalkers.remove(talker);
            } else if (grant && !this.currentTalkers.contains(talker)) {
                this.currentTalkers.add(talker);
            }
        }
        this.connection.startOutput();
    }

    public boolean hasTile() {
        return this.type == 0 && !this.tileSet.isEmpty();
    }

    public boolean hasSizeChanged() {
        return this.sizeChanged;
    }

    public void setEncoding(byte encoding) {
        this.conditionFeed(this.feedIndex, new byte[]{1, encoding});
    }

    public void setNotifyEndOfFrame(long notifyEndOfFrame) {
        this.notifyEndOfFrame = notifyEndOfFrame != 0L;
    }

    public void setSizeChanged(Dimension imageSize) {
        if (!this.imageSize.equals(imageSize)) {
            this.sizeChanged = true;
            this.imageSize = imageSize;
        }
    }

    public void clearSizeChanged() {
        this.sizeChanged = false;
    }

    public boolean requestRepaint(boolean request) {
        boolean result = this.requestRepaint;
        this.requestRepaint = request;
        return result;
    }

    public boolean requestRepaint() {
        return this.requestRepaint;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public void conditionFeed(short feedIndex, byte[] conditionData) {
        this.connection.conditionFeed(feedIndex, conditionData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTileBytes(long space) throws IOException {
        Vector<Integer> duplicates = new Vector<Integer>();
        Integer duplicateTileNumber = null;
        long limit = space;
        byte[] result = null;
        byte[] tileData = null;
        Integer tileNumber = new Integer(0);
        try {
            Object object = this.contentCapture.getImageRoot().getLock();
            synchronized (object) {
                if (this.tileSet.isEmpty() || space < 1L) {
                    return null;
                }
                ListMap.ListElement element = this.tileSet.removeFirst();
                tileNumber = (Integer)element.getKey();
                CaptureTile tile = this.contentCapture.getImageRoot().getCaptureTile(tileNumber);
                if (tile == null) {
                    return new byte[0];
                }
                long frameTime = tile.getTileTime();
                result = tileData = ContentCaptureIOPacketUtils.encodeImageData((byte[])tile.getCompressedTile(), (int)tileNumber, (short)this.getFeedIndex(), (long)frameTime);
                limit -= (long)(tileData.length + 7);
                Set crcTileSet = this.contentCapture.getImageRoot().getCaptureTileSet(tile.getTileCRC());
                if (crcTileSet != null) {
                    Integer[] tileNumbers = new Integer[crcTileSet.size()];
                    tileNumbers = crcTileSet.toArray(tileNumbers);
                    for (int i = 0; i < tileNumbers.length; ++i) {
                        duplicateTileNumber = tileNumbers[i];
                        if (!this.tileSet.contains(duplicateTileNumber)) continue;
                        duplicates.add(duplicateTileNumber);
                        this.tileSet.remove(duplicateTileNumber);
                        limit -= 2L;
                    }
                }
                if (duplicates.size() > 0) {
                    byte[] duplicateTileDefinition = ContentCaptureIOPacketUtils.encodeDuplicateTileDefinition((short)this.feedIndex, (Integer)tileNumber, duplicates, (long)frameTime);
                    result = new byte[tileData.length + duplicateTileDefinition.length];
                    System.arraycopy(tileData, 0, result, 0, tileData.length);
                    System.arraycopy(duplicateTileDefinition, 0, result, tileData.length, duplicateTileDefinition.length);
                }
                if (this.tileSet.isEmpty()) {
                    this.requestRepaint(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTile(CaptureTile tile) {
        Object object = this.contentCapture.getImageRoot().getLock();
        synchronized (object) {
            this.tileSet.add(tile.getTileNumber(), tile);
        }
    }

    public void startOutput() {
        this.connection.startOutput();
    }

    public boolean hasActivity() {
        return this.hasActivity && !this.activityNoted;
    }

    public void activityNoted() {
        this.activityNoted = true;
        this.hasActivity = false;
    }

    public void activityAcknowledged() {
        this.activityNoted = false;
    }

    public boolean notifyEndOfFrame() {
        return this.notifyEndOfFrame;
    }

    public void receiveFeedMode() {
        this.receiveFeedMode = true;
    }

    public void monitorFeedMode() {
        this.receiveFeedMode = false;
        this.activityNoted = false;
    }

    public class TextQueueElement {
        private short author;
        private String text;

        public TextQueueElement(short author, String text) {
            this.author = author;
            this.text = text;
        }

        public short getAuthor() {
            return this.author;
        }

        public String getText() {
            return this.text;
        }
    }
}

