/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.CaptureClientConnection;
import com.elluminate.contentcapture.CaptureFeedSubscription;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureIOPacketUtils;
import com.elluminate.groupware.module.contentcapture.CaptureFeedSubscriptionImpl;
import com.elluminate.groupware.module.contentcapture.ContentCaptureIO;
import com.elluminate.mediastream.imageprocessing.CompressedTile;
import com.elluminate.mediastream.imageprocessing.ImageUtilities;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.ImageIcon;

public class CaptureClientConnectionImpl
implements CaptureClientConnection {
    private static final long ACK_PIPE_TIME = 250L;
    private static final int ACK_RANGE = 20;
    public final int DEFAULT_BANDWIDTH = 56000;
    private static final int BITS_PER_PACKET_BYTE = 8;
    private static final int MAX_ACK_COUNT = 2;
    private static final int TCIP_IP_PACKET_HEADER_LENGTH = 40;
    private long ackedBytes = 0L;
    private LinkedList<AckElement> ackList = new LinkedList();
    private int ackNumber = 0;
    private long bytesWritten = 0L;
    private int bytesPerSecond = 7000;
    private long bytesPerAck = CaptureClientConnectionImpl.bps(this.bytesPerSecond);
    private LinkedList<byte[]> commandQueue = new LinkedList();
    private HashMap<Short, CaptureFeedSubscription> feedSubscriptionByIndex = new HashMap();
    private int feedSubscriptionIndex = 0;
    private ByteBuffer inputBuffer;
    private ByteBuffer outputBuffer;
    private SocketChannel sc;
    private ArrayList<CaptureFeedSubscription> subscriptions = new ArrayList();
    private ContentCapture contentCapture;

    @Inject
    public CaptureClientConnectionImpl(SocketChannel sc, ContentCapture contentCapture) {
        this.sc = sc;
        this.contentCapture = contentCapture;
        this.inputBuffer = ByteBuffer.allocate(4096);
        this.inputBuffer.clear();
        this.outputBuffer = ByteBuffer.allocate(65536);
        this.outputBuffer.clear();
        this.outputBuffer.flip();
    }

    public CaptureClientConnectionImpl(ContentCapture contentCapture) {
        this(null, contentCapture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ackWindowClosed() {
        LinkedList<AckElement> linkedList = this.ackList;
        synchronized (linkedList) {
            return this.ackList.size() > 2;
        }
    }

    public void addFeed(String feedName, byte feedType, ImageIcon icon, short moduleIndex, byte panelMode, byte layer) throws IOException {
        CompressedTile tile = ImageUtilities.compressTileData((Image)icon.getImage());
        this.sendCommand(ContentCaptureIOPacketUtils.encodeAddFeed((String)feedName, (byte)feedType, (short)this.contentCapture.get().getFeedIndex(feedName), (short)moduleIndex, (byte[])tile.getCompressedTile(), (byte)panelMode, (byte)layer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeedSubscription(CaptureFeedSubscription subscription) {
        ArrayList<CaptureFeedSubscription> arrayList = this.subscriptions;
        synchronized (arrayList) {
            if (!this.subscriptions.contains(subscription)) {
                this.subscriptions.add(subscription);
                this.feedSubscriptionByIndex.put(subscription.getFeedIndex(), subscription);
            }
        }
    }

    public void addModule(String moduleName, short moduleIndex) throws IOException {
        this.sendCommand(ContentCaptureIOPacketUtils.encodeAddModule((String)moduleName, (short)moduleIndex));
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    public ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeedSubscription(CaptureFeedSubscription subscription) {
        ArrayList<CaptureFeedSubscription> arrayList = this.subscriptions;
        synchronized (arrayList) {
            this.subscriptions.remove(subscription);
            subscription.endSubscription();
            this.feedSubscriptionByIndex.remove(subscription.getFeedIndex());
        }
    }

    public void removeFeed(String feedName, byte feedType, byte panelMode, byte layer) throws IOException {
        this.sendCommand(ContentCaptureIOPacketUtils.encodeRemoveFeed((String)feedName, (byte)feedType, (short)this.contentCapture.get().getFeedIndex(feedName), (byte)panelMode, (byte)layer));
    }

    private void logBytes(byte[] bytes) {
        if (bytes[0] == 0 && bytes[1] == 0) {
            System.err.println("bad packet");
        }
        System.err.print(System.currentTimeMillis() + ": ");
        for (int i = 0; i < bytes.length; ++i) {
            System.err.print(Integer.toHexString(0xFF & bytes[i]) + " ");
        }
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accountBlockData() {
        CaptureClientConnectionImpl captureClientConnectionImpl = this;
        synchronized (captureClientConnectionImpl) {
            this.bytesWritten += 40L;
        }
    }

    private void close() {
        try {
            if (this.sc != null) {
                this.sc.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void addFeedActivity(ByteBuffer buffer) {
        for (int i = 0; i < this.subscriptions.size(); ++i) {
            CaptureFeedSubscription subscription;
            if ((subscription = this.subscriptions.get(this.feedSubscriptionIndex++)) == null || !subscription.hasActivity()) continue;
            buffer.put(ContentCaptureIOPacketUtils.encodeFeedActivity((short)subscription.getFeedIndex()));
            subscription.activityNoted();
        }
    }

    public void processChannelInput(byte[] packet) {
        byte command = ContentCaptureIOPacketUtils.getPacketCommand((byte[])packet);
        switch (command) {
            case 5: {
                this.bandwidthAck(ContentCaptureIOPacketUtils.getAckNumber((byte[])packet));
                break;
            }
            case 18: {
                short feedIndex = ContentCaptureIOPacketUtils.getActivityFeedIndex((byte[])packet);
                CaptureFeedSubscription subscription = this.feedSubscriptionByIndex.get(feedIndex);
                subscription.activityAcknowledged();
                break;
            }
            case 19: {
                short feedIndex = ContentCaptureIOPacketUtils.getActivityFeedIndex((byte[])packet);
                CaptureFeedSubscription subscription = this.feedSubscriptionByIndex.get(feedIndex);
                subscription.monitorFeedMode();
                break;
            }
            case 20: {
                short feedIndex = ContentCaptureIOPacketUtils.getActivityFeedIndex((byte[])packet);
                CaptureFeedSubscription subscription = this.feedSubscriptionByIndex.get(feedIndex);
                subscription.receiveFeedMode();
                break;
            }
            case 15: {
                this.contentCapture.get().subscribeFeed(ContentCaptureIOPacketUtils.getFeedNameFromSubscription((byte[])packet), (CaptureClientConnection)this, true);
                break;
            }
            case 12: {
                this.setBandwidth(ContentCaptureIOPacketUtils.getBandwidth((byte[])packet));
                break;
            }
            case 2: {
                this.contentCapture.get().subscribeFeed(ContentCaptureIOPacketUtils.getFeedNameFromSubscription((byte[])packet), (CaptureClientConnection)this, false);
                break;
            }
            case 7: {
                short feedIndex = ContentCaptureIOPacketUtils.getTextFeedIndex((byte[])packet);
                String text = ContentCaptureIOPacketUtils.getText((byte[])packet);
                this.contentCapture.get().getFeed(feedIndex).acceptSubscriberTextInput(text);
                break;
            }
            case 3: {
                this.contentCapture.get().unsubscribeFromFeed(ContentCaptureIOPacketUtils.getFeedNameFromSubscription((byte[])packet), (CaptureClientConnection)this);
                break;
            }
            case 13: {
                short feedIndex = ContentCaptureIOPacketUtils.getRepaintFeedIndex((byte[])packet);
                long flag = ContentCaptureIOPacketUtils.getRepaintTime((byte[])packet);
                CaptureFeedSubscription subscription = this.feedSubscriptionByIndex.get(feedIndex);
                subscription.setNotifyEndOfFrame(flag);
                break;
            }
            default: {
                System.err.println("CaptureClientConnection: received unknown command: " + command);
            }
        }
    }

    public void setFeedVisible(short feedIndex, boolean visible) {
        this.sendCommand(ContentCaptureIOPacketUtils.encodeVisibleSetting((short)feedIndex, (boolean)visible, (long)this.contentCapture.get().sessionTime()));
    }

    public void conditionFeed(short feedIndex, byte[] conditionData) {
        this.sendCommand(ContentCaptureIOPacketUtils.encodeConditionFeed((short)feedIndex, (byte[])conditionData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(byte[] packet) {
        LinkedList<byte[]> linkedList = this.commandQueue;
        synchronized (linkedList) {
            this.commandQueue.addLast(packet);
        }
        this.startOutput();
    }

    public void startOutput() {
        if (this.sc != null && this.sc.isConnected()) {
            ContentCaptureIO.startOutput(this.sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        AbstractList abstractList = this.commandQueue;
        synchronized (abstractList) {
            if (!this.commandQueue.isEmpty()) {
                return true;
            }
        }
        abstractList = this.subscriptions;
        synchronized (abstractList) {
            for (int i = 0; i < this.subscriptions.size(); ++i) {
                CaptureFeedSubscription subscription = this.subscriptions.get(i);
                if (!subscription.hasAudio() && !subscription.hasText() && !subscription.hasTile() && !subscription.hasSizeChanged() && !subscription.requestRepaint() && !subscription.hasActivity()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(long limit) {
        long frameTime = this.contentCapture.get().sessionTime();
        if (limit < 0L) {
            return null;
        }
        LinkedList<byte[]> linkedList = this.commandQueue;
        synchronized (linkedList) {
            if (!this.commandQueue.isEmpty()) {
                byte[] packet = this.commandQueue.removeFirst();
                return packet;
            }
        }
        ArrayList<CaptureFeedSubscription> arrayList = this.subscriptions;
        synchronized (arrayList) {
            CaptureFeedSubscription subscription;
            int i;
            for (i = 0; i < this.subscriptions.size(); ++i) {
                if (this.feedSubscriptionIndex >= this.subscriptions.size()) {
                    this.feedSubscriptionIndex = 0;
                }
                if (!(subscription = this.subscriptions.get(this.feedSubscriptionIndex++)).hasAudio()) continue;
                byte[] packet = subscription.getAudio();
                return packet;
            }
            for (i = 0; i < this.subscriptions.size(); ++i) {
                if (this.feedSubscriptionIndex >= this.subscriptions.size()) {
                    this.feedSubscriptionIndex = 0;
                }
                if ((subscription = this.subscriptions.get(this.feedSubscriptionIndex++)).hasText()) {
                    byte[] packet = subscription.getText();
                    return packet;
                }
                if (subscription.hasSizeChanged()) {
                    Dimension imageSize = subscription.getImageSize();
                    subscription.clearSizeChanged();
                    return ContentCaptureIOPacketUtils.encodeSetImageSize((int)imageSize.width, (int)imageSize.height, (short)subscription.getFeedIndex(), (long)frameTime);
                }
                if (subscription.hasActivity()) {
                    byte[] packet = ContentCaptureIOPacketUtils.encodeFeedActivity((short)subscription.getFeedIndex());
                    subscription.activityNoted();
                    return packet;
                }
                if (subscription.hasTile()) {
                    try {
                        return subscription.getTileBytes(limit);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!subscription.requestRepaint() || !subscription.notifyEndOfFrame()) continue;
                subscription.requestRepaint(false);
                return ContentCaptureIOPacketUtils.encodeRequestRepaint((short)subscription.getFeedIndex(), (long)this.contentCapture.get().sessionTime());
            }
        }
        return null;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public void bytesWritten(long bytesWritten) {
        this.bytesWritten += bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsAck() {
        LinkedList<AckElement> linkedList = this.ackList;
        synchronized (linkedList) {
            if (this.ackList.isEmpty()) {
                return this.bytesWritten - this.ackedBytes > this.bytesPerAck;
            }
            AckElement element = this.ackList.getLast();
            return this.bytesWritten - element.bytesWritten > this.bytesPerAck;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscriptions() {
        CaptureFeedSubscriptionImpl[] subs = null;
        ArrayList<CaptureFeedSubscription> arrayList = this.subscriptions;
        synchronized (arrayList) {
            subs = new CaptureFeedSubscriptionImpl[this.subscriptions.size()];
            subs = this.subscriptions.toArray(subs);
        }
        for (int i = 0; i < subs.length; ++i) {
            this.contentCapture.get().unsubscribeFromFeed(subs[i].getFeedName(), (CaptureClientConnection)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setAckPoint() {
        LinkedList<AckElement> linkedList = this.ackList;
        synchronized (linkedList) {
            this.ackList.add(new AckElement(this.bytesWritten, ++this.ackNumber));
            return this.ackNumber;
        }
    }

    private void setBandwidth(int bandwidth) {
        this.bytesPerSecond = bandwidth / 8;
        this.bytesPerAck = CaptureClientConnectionImpl.bps(this.bytesPerSecond);
        this.startOutput();
    }

    private static long bps(int bytesPerSecond) {
        return (long)bytesPerSecond * 250L / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bandwidthAck(int ackNumber) {
        if (this.sc == null || !this.sc.isConnected()) {
            return;
        }
        SelectionKey key = ContentCaptureIO.getSelectionKey(this.sc);
        if (key != null) {
            AckElement element;
            LinkedList<AckElement> linkedList = this.ackList;
            synchronized (linkedList) {
                do {
                    element = this.ackList.getFirst();
                    if (element.ackNumber > ackNumber) break;
                    this.ackList.removeFirst();
                } while (!this.ackList.isEmpty());
            }
            this.ackedBytes = element.bytesWritten;
            this.startOutput();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.sc != null) {
            buf.append("CaptureClientConnection, channel: " + this.sc.hashCode() + ", isConnected: " + this.sc.isConnected());
        } else {
            buf.append("CaptureClientConnection, no channel");
        }
        buf.append(", InputBuffer: " + this.inputBuffer);
        buf.append(", bytesWritten: " + this.bytesWritten);
        buf.append(", bandwidth: " + this.bytesPerSecond);
        buf.append(", ack #: " + this.ackNumber);
        buf.append(", subscriptions: " + this.subscriptions.size());
        return buf.toString();
    }

    class AckElement {
        long bytesWritten;
        int ackNumber;

        public AckElement(long bytesWritten, int ackNumber) {
            this.bytesWritten = bytesWritten;
            this.ackNumber = ackNumber;
        }
    }
}

